/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.attachments.AttachmentUtils;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.SessionUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeader;
import org.apache.commons.logging.Log;

public class MimeUtils {
    protected static Log log = LogFactory.getLog(MimeUtils.class.getName());
    public static String[] filter = new String[]{"Message-ID", "Mime-Version", "Content-Type"};

    public static long getContentLength(Multipart multipart) throws MessagingException, IOException {
        MimeBodyPart mimeBodyPart;
        int n = multipart.getCount();
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            mimeBodyPart = (MimeBodyPart)multipart.getBodyPart(i);
            l += MimeUtils.getContentLength(mimeBodyPart);
        }
        String string = multipart.getContentType();
        mimeBodyPart = new ContentType(string);
        String string2 = mimeBodyPart.getParameter("boundary");
        int n2 = string2.length() + 4;
        return l + (long)(n2 * (n + 1)) + (long)(2 * n) + 4L;
    }

    protected static long getContentLength(MimeBodyPart mimeBodyPart) {
        long l = -1L;
        long l2 = -1L;
        try {
            l = MimeUtils.getHeaderLength(mimeBodyPart);
            DataHandler dataHandler = mimeBodyPart.getDataHandler();
            DataSource dataSource = dataHandler.getDataSource();
            if (dataSource instanceof FileDataSource) {
                FileDataSource fileDataSource = (FileDataSource)dataSource;
                File file = fileDataSource.getFile();
                if (!file.exists()) {
                    throw new RuntimeException(Messages.getMessage("noFile", file.getAbsolutePath()));
                }
                l2 = file.length();
            } else {
                l2 = mimeBodyPart.getSize();
                if (-1L == l2) {
                    int n;
                    l2 = 0L;
                    InputStream inputStream = null;
                    final DataSource dataSource2 = dataSource;
                    inputStream = (InputStream)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return dataSource2.getInputStream();
                        }
                    });
                    byte[] byArray = new byte[65536];
                    do {
                        if ((n = inputStream.read(byArray)) <= 0) continue;
                        l2 += (long)n;
                    } while (n > -1);
                    inputStream.close();
                }
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.webservices.engine.MimeUtils.getContentLength", (String)"201");
            log.error((Object)Messages.getMessage("exception00"), (Throwable)privilegedActionException.getException());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.attachments.MimeUtils.getContentLength", (String)"204");
            log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
        }
        return l2 + l;
    }

    private static long getHeaderLength(MimeBodyPart mimeBodyPart) throws MessagingException, IOException {
        MimeBodyPart mimeBodyPart2 = new MimeBodyPart(new InternetHeaders(), new byte[0]);
        Object object = mimeBodyPart.getAllHeaders();
        while (object.hasMoreElements()) {
            Header header2 = (Header)object.nextElement();
            mimeBodyPart2.addHeader(header2.getName(), header2.getValue());
        }
        object = new ByteArrayOutputStream(16384);
        mimeBodyPart2.writeTo((OutputStream)object);
        ((ByteArrayOutputStream)object).close();
        return ((ByteArrayOutputStream)object).size();
    }

    public static void writeToMultiPartStream(final OutputStream outputStream, final MimeMultipart mimeMultipart) {
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    Properties properties = WebServicesProperties.getProperties();
                    properties.setProperty("mail.smtp.host", "localhost");
                    Session session = Session.getInstance((Properties)properties, null);
                    MimeMessage mimeMessage = new MimeMessage(session);
                    mimeMessage.setContent((Multipart)mimeMultipart);
                    mimeMessage.saveChanges();
                    mimeMessage.writeTo(outputStream, filter);
                }
                catch (MessagingException messagingException) {
                    FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.webservices.engine.attachments.MimeUtils.writeToMultiPartStream", (String)"249");
                    log.error((Object)Messages.getMessage("javaxMailMessagingException00"), (Throwable)messagingException);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.attachments.MimeUtils.writeToMultiPartStream", (String)"252");
                    log.error((Object)Messages.getMessage("javaIOException00"), (Throwable)iOException);
                }
                return null;
            }
        });
    }

    public static String getContentType(MimeMultipart mimeMultipart) {
        StringBuffer stringBuffer = new StringBuffer(mimeMultipart.getContentType());
        int n = 0;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            if (c == '\r' || c == '\n') {
                stringBuffer.deleteCharAt(n);
                continue;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static MimeMultipart createMP(String string, Collection collection) throws WebServicesFault {
        MimeMultipart mimeMultipart = null;
        String string2 = "binary";
        try {
            String string3 = SessionUtils.generateSessionId();
            mimeMultipart = new MimeMultipart("related; type=\"text/xml\"; start=\"<" + string3 + ">\"");
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
            mimeBodyPart.setText(string);
            mimeBodyPart.setHeader("Content-Type", "text/xml; charset=UTF-8");
            mimeBodyPart.setHeader("Content-Id", "<" + string3 + ">");
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Part part = (Part)iterator.next();
                DataHandler dataHandler = AttachmentUtils.getActivationDataHandler(part);
                String string4 = part.getContentId();
                mimeBodyPart2 = new MimeBodyPart();
                mimeBodyPart2.setDataHandler(dataHandler);
                String string5 = dataHandler.getContentType();
                if (string5 == null || string5.trim().length() == 0) {
                    string5 = "application/octet-stream";
                }
                String[] stringArray = part.getMimeHeader("Content-Transfer-Encoding");
                if (log.isDebugEnabled()) {
                    log.debug((Object)"array from part.getMimeHeader() not empty!");
                }
                if (stringArray != null && stringArray.length > 0) {
                    string2 = stringArray[0];
                }
                mimeBodyPart2.setHeader("Content-Transfer-Encoding", string2);
                mimeBodyPart2.setHeader("Content-Type", string5);
                mimeBodyPart2.setHeader("Content-Id", "<" + string4 + ">");
                Iterator iterator2 = part.getNonMatchingMimeHeaders(new String[]{"Content-Type", "Content-Id", "Content-Transfer-Encoding"});
                while (iterator2.hasNext()) {
                    MimeHeader mimeHeader = (MimeHeader)iterator2.next();
                    mimeBodyPart2.setHeader(mimeHeader.getName(), mimeHeader.getValue());
                }
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
                mimeBodyPart.setHeader("Content-Transfer-Encoding", string2);
            }
        }
        catch (MessagingException messagingException) {
            FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.webservices.engine.attachments.MimeUtils.createMP", (String)"353");
            log.error((Object)Messages.getMessage("javaxMailMessagingException00"), (Throwable)messagingException);
        }
        return mimeMultipart;
    }

    public static QName getMIMETypeQName(String string) {
        if ("text/plain".equals(string)) {
            return Constants.MIME_PLAINTEXT;
        }
        if ("image/gif".equals(string) || "image/jpeg".equals(string)) {
            return Constants.MIME_IMAGE;
        }
        if ("text/xml".equals(string) || "applications/xml".equals(string)) {
            return Constants.MIME_SOURCE;
        }
        if ("application/octetstream".equals(string)) {
            return Constants.MIME_OCTETSTREAM;
        }
        if (string != null && string.startsWith("multipart/")) {
            return Constants.MIME_MULTIPART;
        }
        return Constants.MIME_DATA_HANDLER;
    }
}

