/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.image.ImageIOFactory;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.commons.logging.Log;

public class ImageDataSource
implements DataSource {
    protected static Log log = LogFactory.getLog(ImageDataSource.class.getName());
    public static final String CONTENT_TYPE = "image/jpeg";
    private final String name;
    private final String contentType;
    private byte[] data;
    private ByteArrayInputStream is;
    private ByteArrayOutputStream os;

    public ImageDataSource(String string, Image image) {
        this(string, CONTENT_TYPE, image);
    }

    public ImageDataSource(String string, String string2, Image image) {
        this.name = string;
        this.contentType = string2 == null ? CONTENT_TYPE : string2;
        this.os = new ByteArrayOutputStream();
        try {
            if (image != null) {
                ImageIOFactory.getImageIO().saveImage(this.contentType, image, this.os);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.attachments.ImageDataSource.ImageDataSource", (String)"97", (Object)this);
            log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        if (this.os.size() != 0) {
            this.data = this.os.toByteArray();
            this.os.reset();
        }
        return new ByteArrayInputStream(this.data == null ? new byte[]{} : this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.os.size() != 0) {
            this.data = this.os.toByteArray();
            this.os.reset();
        }
        return this.os;
    }
}

