/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl;
import com.ibm.ws.webservices.engine.encoding.SerializationContextImpl;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import com.ibm.ws.webservices.engine.xmlsoap.ext.XMLInputSourceAlternateContent;
import com.ibm.ws.webservices.engine.xmlsoap.saaj12.SAAJ12Part;
import com.ibm.ws.webservices.utils.BufferedWriter;
import com.ibm.ws.webservices.utils.LowFlushFilter;
import com.ibm.ws.webservices.utils.WebServicesInputSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SOAPPart
extends SAAJ12Part
implements Part {
    protected static Log log = LogFactory.getLog(SOAPPart.class.getName());
    private static final String[] formNames = new String[]{"**undefined-SOAPPart-form**", "FORM_WEBSERVICESINPUTSOURCE", "FORM_SOAP_FAULT", "FORM_WEBSERVICES_FAULT", "FORM_SOAPENVELOPE"};
    private static final int FORM_NONE = 0;
    private static final int FORM_WS_INPUTSOURCE = 1;
    private static final int FORM_SOAP_FAULT = 2;
    private static final int FORM_MUTABLES = 3;
    private static final int FORM_WEBSERVICES_FAULT = 3;
    private static final int FORM_SOAPENVELOPE = 4;
    private Object currentContent;
    private int currentForm;
    private int targetForm = 0;
    private WebServicesInputSource originalContent;
    private int originalParseLength = -1;
    private WebServicesInputSource cacheWebServicesInputSource = null;
    private SOAPEnvelope cacheSOAPEnvelope = null;
    private SOAPFaultException cacheSOAPFaultException = null;
    private WebServicesFault cacheWebServicesFault = null;
    private Message msg;
    private MimeHeaders mimeHeaders = new MimeHeaders();

    public SOAPPart(Object object) {
        int n = 1;
        if (object instanceof SOAPEnvelope) {
            n = 4;
        } else if (object instanceof WebServicesFault) {
            n = 3;
        } else if (object instanceof SOAPFaultException) {
            n = 2;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: SOAPPart ctor(" + formNames[n] + ")"));
        }
        this.setCurrentContent(object, n);
        this.setMimeHeader("Content-Type", "text/xml");
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: SOAPPart ctor()");
        }
    }

    public Message getMessage() {
        return this.msg;
    }

    public void setMessage(Message message) {
        if (this.currentForm == 1) {
            ((WebServicesInputSource)this.currentContent).setEncoding(message.getCharacterEncoding());
        }
        this.msg = message;
    }

    public String getContentType() {
        return "text/xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getContentLength() {
        int n;
        try {
            WebServicesInputSource webServicesInputSource = this._getWebServicesInputSource();
            n = webServicesInputSource.getContentLength();
        }
        catch (WebServicesFault webServicesFault) {
            n = 0;
        }
        finally {
            if (this.isCurrentFormMutable()) {
                this._clearCache();
            }
        }
        return n;
    }

    public String getOriginalMessage() {
        if (this.originalContent == null) {
            return null;
        }
        return this.originalContent.getString();
    }

    public byte[] getOriginalMessageAsBytes() {
        if (this.originalContent == null) {
            return null;
        }
        return this.originalContent.getBytes();
    }

    public long getOriginalContentLength() {
        return this.originalParseLength < 0 ? (long)this.getContentLength() : (long)this.originalParseLength;
    }

    public void setSOAPEnvelope(SOAPEnvelope sOAPEnvelope) {
        this.setCurrentContent(sOAPEnvelope, 4);
        this.originalContent = null;
    }

    public int getSize() {
        return this.getContentLength();
    }

    public Object getCurrentMessage() {
        return this.getCurrentContent();
    }

    public Object getCurrentContent() {
        return this.currentContent;
    }

    private void setCurrentContent(Object object, int n) {
        this._clearCache();
        this.setCurrentForm(object, n);
    }

    private void setCurrentForm(Object object, int n) {
        Object object2;
        if (log.isDebugEnabled()) {
            object2 = object instanceof String ? (String)object : object.getClass().getName();
            log.debug((Object)Messages.getMessage("setMsgForm", formNames[n], "" + (String)object2));
        }
        if (this.isFormMutable(n)) {
            this._clearCache();
        }
        this.currentContent = object;
        this.currentForm = n;
        switch (this.currentForm) {
            case 4: {
                this._setCacheSOAPEnvelope((SOAPEnvelope)this.currentContent);
                break;
            }
            case 3: {
                this._setCacheWebServicesFault((WebServicesFault)this.currentContent);
                break;
            }
            case 2: {
                this._setCacheSOAPFaultException((SOAPFaultException)this.currentContent);
                break;
            }
            case 1: {
                if (this.currentContent instanceof String) {
                    object2 = WebServicesInputSource.create((String)this.currentContent);
                } else if (this.currentContent instanceof InputStream) {
                    object2 = WebServicesInputSource.create((InputStream)this.currentContent);
                } else if (this.currentContent instanceof byte[]) {
                    object2 = WebServicesInputSource.create((byte[])this.currentContent);
                } else if (this.currentContent instanceof WebServicesInputSource) {
                    object2 = (WebServicesInputSource)this.currentContent;
                } else if (this.currentContent instanceof InputSource) {
                    object2 = WebServicesInputSource.create((InputSource)this.currentContent);
                } else if (this.currentContent instanceof Source) {
                    object2 = WebServicesInputSource.create((Source)this.currentContent);
                } else {
                    throw new InternalException(Messages.getMessage("unsupportedContent", this.currentContent == null ? "null" : this.currentContent.getClass().toString()));
                }
                if (this.getMessage() != null && ((WebServicesInputSource)object2).getEncoding() == null) {
                    ((WebServicesInputSource)object2).setEncoding(this.getMessage().getCharacterEncoding());
                }
                this.currentContent = object2;
                this._setCacheWebServicesInputSource((WebServicesInputSource)object2);
            }
        }
    }

    public byte[] getAsBytes() throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: SOAPPart::getAsBytes");
        }
        WebServicesInputSource webServicesInputSource = this.getAsWebServicesInputSource();
        byte[] byArray = webServicesInputSource.getBytes();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: SOAPPart::getAsBytes()");
        }
        return byArray;
    }

    public String getAsString() throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: SOAPPart::getAsString");
        }
        WebServicesInputSource webServicesInputSource = this.getAsWebServicesInputSource();
        String string = webServicesInputSource.getString();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: SOAPPart::getAsString()");
        }
        return string;
    }

    public String getString() throws WebServicesFault {
        WebServicesInputSource webServicesInputSource = this._getWebServicesInputSource();
        return webServicesInputSource.getString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebServicesInputSource getAsWebServicesInputSource() throws WebServicesFault {
        WebServicesInputSource webServicesInputSource;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: SOAPPart::getAsWebServicesInputSource");
        }
        try {
            this.targetForm = 1;
            WebServicesInputSource webServicesInputSource2 = this._getWebServicesInputSource();
            if (webServicesInputSource2 != this.getCurrentMessage()) {
                this.setCurrentForm(webServicesInputSource2, this.targetForm);
            }
            webServicesInputSource = webServicesInputSource2;
            Object var4_3 = null;
            this.targetForm = 0;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                this.targetForm = 0;
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)"Exit: SOAPPart::getWebServicesInputSource()");
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: SOAPPart::getWebServicesInputSource()");
        }
        return webServicesInputSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPEnvelope getAsSOAPEnvelope() throws WebServicesFault {
        SOAPEnvelope sOAPEnvelope;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: SOAPPart::getAsSOAPEnvelope()");
            log.debug((Object)Messages.getMessage("currForm", formNames[this.currentForm]));
        }
        try {
            this.targetForm = 4;
            SOAPEnvelope sOAPEnvelope2 = this._getSOAPEnvelope();
            if (sOAPEnvelope2 != this.getCurrentMessage()) {
                this.setCurrentForm(sOAPEnvelope2, 4);
            }
            sOAPEnvelope = sOAPEnvelope2;
            Object var4_3 = null;
            this.targetForm = 0;
            this._clearCache();
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                this.targetForm = 0;
                this._clearCache();
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)"Exit: SOAPPart::getAsSOAPEnvelope");
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: SOAPPart::getAsSOAPEnvelope");
        }
        return sOAPEnvelope;
    }

    public javax.xml.soap.SOAPEnvelope getEnvelope() throws SOAPException {
        try {
            return this.getAsSOAPEnvelope();
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.SOAPPart.getEnvelope", (String)"1122", (Object)this);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Caught Exception, wrapping in SOAPException: ", (Throwable)webServicesFault);
            }
            throw new SOAPException((Throwable)webServicesFault);
        }
    }

    public Document getDocument() {
        try {
            return this.getAsSOAPEnvelope().getOwnerDocument();
        }
        catch (WebServicesFault webServicesFault) {
            throw new DOMException(15, webServicesFault.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebServicesFault getFault() throws SOAPException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: SOAPPart::getFault()");
            log.debug((Object)("getMessageContext().isHighFidelity() == " + (this.getMessage() != null && this.getMessage().getMessageContext() != null && this.getMessage().getMessageContext().isHighFidelity() ? "true" : "false")));
        }
        WebServicesFault webServicesFault = null;
        try {
            if (this._getCachedWebServicesFault() != null) {
                webServicesFault = this._getCachedWebServicesFault();
            } else if (this.currentForm == 3) {
                webServicesFault = (WebServicesFault)this.getCurrentMessage();
            } else if (this._getCachedSOAPFaultException() != null) {
                SOAPFaultException sOAPFaultException = this._getCachedSOAPFaultException();
                if (sOAPFaultException != null) {
                    webServicesFault = WebServicesFault.makeFault((Throwable)sOAPFaultException);
                }
            } else if (this.currentForm == 2) {
                webServicesFault = WebServicesFault.makeFault((WebServicesFault)this.getCurrentMessage());
            } else {
                boolean bl = false;
                bl = this.currentForm == 1 ? ((WebServicesInputSource)this.currentContent).isPossiblyFault() : true;
                if (bl) {
                    Object object;
                    SOAPEnvelope sOAPEnvelope = this._getSOAPEnvelope();
                    SOAPBody sOAPBody = (SOAPBody)sOAPEnvelope.getBody();
                    Object object2 = object = sOAPBody == null ? null : sOAPBody.getAlternateContent();
                    if (sOAPBody == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"no body");
                        }
                    } else if (object instanceof RequestResponse) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"getSOAPEnvelope().getBody().getAlternateContent() instanceof RequestResponse");
                        }
                    } else {
                        if (object instanceof InputStream) {
                            WebServicesInputSource webServicesInputSource = WebServicesInputSource.create((InputStream)object);
                            String string = this.getMessage().getCharacterEncoding();
                            webServicesInputSource.setEncoding(string);
                            sOAPBody.setAlternateContent(null);
                            sOAPBody.setAlternateContent(XMLInputSourceAlternateContent.createContentOnly(webServicesInputSource));
                            object = webServicesInputSource;
                        }
                        if (object instanceof WebServicesInputSource) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"getSOAPEnvelope().getBody().getAlternateContent() instanceof WebServicesInputSource");
                            }
                            if (((WebServicesInputSource)object).isPossiblyFault()) {
                                webServicesFault = SOAPPart.getFault(sOAPBody);
                            }
                        } else {
                            webServicesFault = SOAPPart.getFault(sOAPBody);
                        }
                    }
                }
            }
            if (webServicesFault != null) {
                webServicesFault.setSOAPPartFault(true);
            }
            if (this.isCurrentFormMutable()) {
                this._clearCache();
            } else {
                this._setCacheWebServicesFault(webServicesFault);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exit: Message::getFault() == " + (webServicesFault == null ? "null" : "non-null")));
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: Message::getFault() == " + (webServicesFault == null ? "null" : "non-null")));
        }
        return webServicesFault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream, String string) throws IOException {
        if (this.currentForm == 1 || this._getCachedWebServicesInputSource() != null) {
            WebServicesInputSource webServicesInputSource = this._getWebServicesInputSource();
            webServicesInputSource.writeTo(outputStream, string);
        } else {
            outputStream = new LowFlushFilter(outputStream);
            Writer writer = null;
            writer = string != null ? new OutputStreamWriter(outputStream, string) : new OutputStreamWriter(outputStream);
            writer = new BufferedWriter(writer, outputStream, string);
            try {
                this.writeTo(writer);
            }
            finally {
                writer.flush();
                if (this.isCurrentFormMutable()) {
                    this._clearCache();
                }
            }
        }
    }

    private void writeTo(Writer writer) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: SOAPPart writeTo:" + writer.getClass()));
        }
        switch (this.currentForm) {
            case 3: {
                WebServicesFault webServicesFault = (WebServicesFault)this.getCurrentMessage();
                try {
                    SerializationContextImpl serializationContextImpl = new SerializationContextImpl(writer, this.getMessage().getMessageContext(), this.getMessage().shouldWriteXMLDecl(), this.getMessage().getCharacterEncoding());
                    webServicesFault.output(serializationContextImpl);
                    break;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.SOAPPart.writeTo", (String)"298", (Object)this);
                    log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
                    throw webServicesFault;
                }
            }
            case 2: {
                SOAPFaultException sOAPFaultException = (SOAPFaultException)this.getCurrentMessage();
                try {
                    SOAPFactory sOAPFactory = new SOAPFactory();
                    SOAPEnvelope sOAPEnvelope = sOAPFactory.createSOAPEnvelope(true);
                    SOAPFault sOAPFault = sOAPFactory.createSOAPFault();
                    sOAPFault.setFault(sOAPFaultException);
                    sOAPEnvelope.getBody().addChildElement((SOAPElement)sOAPFault);
                    SerializationContextImpl serializationContextImpl = new SerializationContextImpl(writer, this.getMessage().getMessageContext(), this.getMessage().shouldWriteXMLDecl(), this.getMessage().getCharacterEncoding());
                    sOAPEnvelope.output(serializationContextImpl);
                    break;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.SOAPPart.writeTo", (String)"327", (Object)this);
                    log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
                    throw sOAPFaultException;
                }
            }
            case 4: {
                SOAPEnvelope sOAPEnvelope = (SOAPEnvelope)this.getCurrentMessage();
                try {
                    SerializationContextImpl serializationContextImpl = new SerializationContextImpl(writer, this.getMessage().getMessageContext(), this.getMessage().shouldWriteXMLDecl(), this.getMessage().getCharacterEncoding());
                    sOAPEnvelope.output(serializationContextImpl);
                    break;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.SOAPPart.writeTo", (String)"347", (Object)this);
                    throw WebServicesFault.makeFault(exception);
                }
            }
            default: {
                WebServicesInputSource webServicesInputSource = this._getWebServicesInputSource();
                webServicesInputSource.writeTo(writer);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: SOAPPart writeTo " + formNames[this.currentForm]));
        }
    }

    /*
     * Loose catch block
     */
    private WebServicesInputSource _getWebServicesInputSource() throws WebServicesFault {
        WebServicesInputSource webServicesInputSource;
        block8: {
            block11: {
                block10: {
                    block9: {
                        webServicesInputSource = this._getCachedWebServicesInputSource();
                        if (webServicesInputSource != null) break block8;
                        if (this.currentForm != 1) break block9;
                        webServicesInputSource = (WebServicesInputSource)this.getCurrentContent();
                        break block8;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Converting " + formNames[this.currentForm] + " to " + formNames[1]));
                    }
                    if (this.currentForm != 3 && this.currentForm != 2 && this.currentForm != 4) break block10;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    this.writeTo(byteArrayOutputStream, this.getMessage().getCharacterEncoding());
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    webServicesInputSource = WebServicesInputSource.create(byArray);
                    webServicesInputSource.setEncoding(this.getMessage().getCharacterEncoding());
                    Object var5_5 = null;
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.SOAPPart.getString", (String)"777", (Object)this);
                        log.warn((Object)Messages.getMessage("exception00"), (Throwable)iOException);
                    }
                    break block11;
                    {
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.SOAPPart.getString", (String)"770", (Object)this);
                            log.error((Object)Messages.getMessage("exception00"), (Throwable)iOException);
                            throw WebServicesFault.makeFault(iOException);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.SOAPPart.getString", (String)"777", (Object)this);
                            log.warn((Object)Messages.getMessage("exception00"), (Throwable)iOException);
                        }
                        throw throwable;
                    }
                }
                throw new InternalException(Messages.getMessage("unsupportedContent", "null"));
            }
            this._setCacheWebServicesInputSource(webServicesInputSource);
        }
        return webServicesInputSource;
    }

    private SOAPEnvelope _getSOAPEnvelope() throws WebServicesFault {
        SOAPEnvelope sOAPEnvelope = this._getCachedSOAPEnvelope();
        if (sOAPEnvelope == null) {
            if (this.currentForm == 4) {
                sOAPEnvelope = (SOAPEnvelope)this.getCurrentMessage();
            } else {
                String string;
                MessageContext messageContext;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Converting " + formNames[this.currentForm] + " to " + formNames[4]));
                }
                if ((messageContext = this.getMessage().getMessageContext()) != null) {
                    if (messageContext.isHighFidelity()) {
                        if (this.originalContent == null) {
                            this.originalContent = this._getCachedWebServicesInputSource();
                        }
                    } else {
                        this.originalContent = null;
                    }
                }
                WebServicesInputSource webServicesInputSource = this._getWebServicesInputSource();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parsing inputSource " + webServicesInputSource.dumpStats()));
                }
                if ((string = this.getMessage().getCharacterEncoding()) != null) {
                    webServicesInputSource.setEncoding(string);
                }
                DeserializationContextImpl deserializationContextImpl = new DeserializationContextImpl(webServicesInputSource, this.getMessage().getMessageContext(), this.getMessage().getMessageType());
                try {
                    deserializationContextImpl.parse();
                }
                catch (SAXException sAXException) {
                    FFDCFilter.processException((Throwable)sAXException, (String)"com.ibm.ws.webservices.engine.SOAPPart.getSOAPEnvelope", (String)"964", (Object)this);
                    Exception exception = sAXException.getException();
                    webServicesInputSource.reset();
                    if (exception instanceof WebServicesFault) {
                        throw (WebServicesFault)exception;
                    }
                    if (this.originalContent == null) {
                        this.originalContent = webServicesInputSource;
                    }
                    if (this.originalContent == null) {
                        throw WebServicesFault.makeFault("To see the message containing the parsing error in the log, either enable web service engine tracing or set MessageContext.setHighFidelity(true).", exception != null ? exception : sAXException);
                    }
                    throw WebServicesFault.makeFault("Message being parsed: " + this.originalContent.getString(), exception != null ? exception : sAXException);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Done parsing inputSource.");
                }
                this.originalParseLength = webServicesInputSource.getContentLength();
                sOAPEnvelope = deserializationContextImpl.getEnvelope();
                this.setCurrentForm(sOAPEnvelope, 4);
            }
        }
        return sOAPEnvelope;
    }

    private static WebServicesFault getFault(SOAPBody sOAPBody) {
        SOAPBodyElement sOAPBodyElement;
        if (sOAPBody.getNumChildren() > 0 && (sOAPBodyElement = (SOAPBodyElement)sOAPBody.getChildElement(0)) instanceof SOAPFault) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getSOAPEnvelope().getBody().getChildElement(0) instanceof SOAPFault");
            }
            return ((SOAPFault)sOAPBodyElement).getFault();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"getSOAPEnvelope().getBody().getChildElement(0) NOT instanceof SOAPFault");
        }
        return null;
    }

    private void _setCacheWebServicesInputSource(WebServicesInputSource webServicesInputSource) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Caching " + formNames[1]));
        }
        this.cacheWebServicesInputSource = webServicesInputSource;
    }

    private WebServicesInputSource _getCachedWebServicesInputSource() {
        if (log.isDebugEnabled() && this.cacheWebServicesInputSource != null) {
            log.debug((Object)("Using Cached " + formNames[1]));
        }
        return this.cacheWebServicesInputSource;
    }

    private void _setCacheSOAPEnvelope(SOAPEnvelope sOAPEnvelope) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Caching " + formNames[4]));
        }
        this.cacheSOAPEnvelope = sOAPEnvelope;
    }

    private SOAPEnvelope _getCachedSOAPEnvelope() {
        if (log.isDebugEnabled() && this.cacheSOAPEnvelope != null) {
            log.debug((Object)("Using Cached " + formNames[4]));
        }
        return this.cacheSOAPEnvelope;
    }

    private void _setCacheSOAPFaultException(SOAPFaultException sOAPFaultException) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Caching " + formNames[2]));
        }
        this.cacheSOAPFaultException = sOAPFaultException;
    }

    private SOAPFaultException _getCachedSOAPFaultException() {
        if (log.isDebugEnabled() && this.cacheSOAPFaultException != null) {
            log.debug((Object)("Using Cached " + formNames[2]));
        }
        return this.cacheSOAPFaultException;
    }

    private void _setCacheWebServicesFault(WebServicesFault webServicesFault) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Caching " + formNames[3]));
        }
        this.cacheWebServicesFault = webServicesFault;
    }

    private WebServicesFault _getCachedWebServicesFault() {
        if (log.isDebugEnabled() && this.cacheWebServicesFault != null) {
            log.debug((Object)("Using Cached " + formNames[3]));
        }
        return this.cacheWebServicesFault;
    }

    private void _clearCache() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Clear SOAPPart Cache");
        }
        this.cacheWebServicesInputSource = null;
        this.cacheSOAPEnvelope = null;
        this.cacheSOAPFaultException = null;
        this.cacheWebServicesFault = null;
    }

    private boolean isCurrentFormMutable() {
        return this.isFormMutable(this.currentForm);
    }

    private boolean isFormMutable(int n) {
        return n >= 3;
    }

    public static String convertBytesToString(byte[] byArray, String string) {
        return JavaUtils.convertBytesToString(byArray, string);
    }

    public static byte[] convertStringToBytes(String string, String string2) {
        return JavaUtils.convertStringToBytes(string, string2);
    }

    public void addMimeHeader(String string, String string2) {
        this.mimeHeaders.addHeader(string, string2);
    }

    private String getFirstMimeHeader(String string) {
        String[] stringArray = this.mimeHeaders.getHeader(string);
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public String getContentLocation() {
        return this.getFirstMimeHeader("Content-Location");
    }

    public void setContentLocation(String string) {
        this.setMimeHeader("Content-Location", string);
    }

    public void setContentId(String string) {
        this.setMimeHeader("Content-Id", string);
    }

    public String getContentId() {
        return this.getFirstMimeHeader("Content-Id");
    }

    public String getContentIdRef() {
        return "cid:" + this.getContentId();
    }

    public Iterator getMatchingMimeHeaders(String[] stringArray) {
        return this.mimeHeaders.getMatchingHeaders(stringArray);
    }

    public Iterator getNonMatchingMimeHeaders(String[] stringArray) {
        return this.mimeHeaders.getNonMatchingHeaders(stringArray);
    }

    public Source getContent() throws SOAPException {
        Object var1_1 = null;
        try {
            WebServicesInputSource webServicesInputSource = this.getAsWebServicesInputSource();
            return webServicesInputSource.createTransformSource();
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.SOAPPart.getContent", (String)"1242", (Object)this);
            throw new SOAPException((Throwable)webServicesFault);
        }
    }

    public void setContent(Source source) throws SOAPException {
        if (source == null) {
            throw new SOAPException(Messages.getMessage("illegalArgumentException00"));
        }
        this.originalContent = null;
        this._clearCache();
        WebServicesInputSource webServicesInputSource = WebServicesInputSource.create(source);
        String string = webServicesInputSource.getEncoding();
        if (string != null) {
            this.msg.setCharacterEncoding(string);
            this.setCurrentContent(webServicesInputSource, 1);
        } else {
            webServicesInputSource.setEncoding(this.msg.getCharacterEncoding());
            this.setCurrentContent(webServicesInputSource, 1);
            try {
                this.getAsSOAPEnvelope();
            }
            catch (Exception exception) {
                this.setCurrentContent(webServicesInputSource, 1);
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.SOAPPart.setContent", (String)"1165", (Object)this);
            }
        }
    }

    public void setContent(String string) throws SOAPException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: SOAPPart::setContent");
        }
        if (string == null || string.length() == 0) {
            throw new SOAPException(Messages.getMessage("illegalArgumentException00"));
        }
        this.originalContent = null;
        WebServicesInputSource webServicesInputSource = WebServicesInputSource.create(string);
        this.setCurrentContent(webServicesInputSource, 1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: SOAPPart::setContent: " + this.getCurrentMessage()));
        }
    }

    public void setContent(byte[] byArray) throws SOAPException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: SOAPPart::setContent(byte[])");
        }
        if (byArray == null || byArray.length == 0) {
            throw new SOAPException(Messages.getMessage("illegalArgumentException00"));
        }
        this.originalContent = null;
        WebServicesInputSource webServicesInputSource = WebServicesInputSource.create(byArray);
        this.setCurrentContent(webServicesInputSource, 1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: SOAPPart::setContent(byte[]): " + this.getCurrentMessage()));
        }
    }

    public Iterator getAllMimeHeaders() {
        return this.mimeHeaders.getAllHeaders();
    }

    public void setMimeHeader(String string, String string2) {
        this.mimeHeaders.setHeader(string, string2);
    }

    public String[] getMimeHeader(String string) {
        return this.mimeHeaders.getHeader(string);
    }

    public void removeAllMimeHeaders() {
        this.mimeHeaders.removeAllHeaders();
    }

    public void removeMimeHeader(String string) {
        this.mimeHeaders.removeHeader(string);
    }
}

