/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.enabler;

import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.j2ee.commonarchivecore.strategy.LoadStrategy;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WsbndFactory;
import com.ibm.etools.webservice.wsdd.WebServices;
import com.ibm.ws.webservices.WSModels;
import com.ibm.ws.webservices.enabler.resources.Messages;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class Utils {
    private static WsbndFactory wsbndFactory = null;
    public static boolean verbose = false;

    public static File getFileFromName(String string) throws IOException {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (!file.exists()) {
            file = null;
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
            if (inputStream != null) {
                int n;
                File file2 = File.createTempFile(string, null);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                while ((n = inputStream.read()) != -1) {
                    fileOutputStream.write(n);
                }
                fileOutputStream.close();
                inputStream.close();
                file = file2;
            }
        }
        return file;
    }

    public static String getStringInputWithDefaults(BufferedReader bufferedReader, String string) throws IOException {
        String string2 = null;
        while (string2 == null) {
            System.out.print(string);
            string2 = bufferedReader.readLine();
        }
        return string2;
    }

    public static File getReadFileInput(BufferedReader bufferedReader, String string) throws IOException {
        String string2 = null;
        File file = null;
        while (file == null) {
            System.out.print(string);
            string2 = bufferedReader.readLine();
            if (string2 == null || (file = new File(string2)).exists() && file.isFile()) continue;
            System.err.println(Messages.getString("enabler.enterexistingfile", "Please enter the name of an existing file."));
            file = null;
        }
        return file;
    }

    public static String getSpaceSeparatedString(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        if (collection != null) {
            String[] stringArray = collection.toArray(new String[0]);
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append((i > 0 ? " " : "") + stringArray[i]);
            }
        }
        return stringBuffer.toString();
    }

    public static void backupEar(String string) throws IOException {
        int n;
        Object[] objectArray = new String[]{string};
        System.out.print("\n");
        System.out.println(Messages.getFormattedMessage("enabler.utils.backingupear", objectArray, "WSWS2003I: Backing up EAR file to: {0}~"));
        System.out.print("\n");
        File file = new File(string);
        File file2 = new File(file.getAbsolutePath() + "~");
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        byte[] byArray = new byte[1024];
        while ((n = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.close();
        bufferedInputStream.close();
    }

    public static WSBinding getWSBinding(EJBJarFile eJBJarFile) throws Exception {
        return WSModels.getWSBinding(eJBJarFile.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
    }

    public static WSBinding createWSBinding(EJBJarFile eJBJarFile) throws Exception {
        URI uRI;
        WSBinding wSBinding = null;
        LoadStrategy loadStrategy = eJBJarFile.getLoadStrategy();
        String string = "META-INF/ibm-webservices-bnd.xmi";
        ResourceSet resourceSet = loadStrategy.getResourceSet();
        Resource resource = resourceSet.getResource(uRI = URI.createURI((String)string), false);
        if (resource == null) {
            resource = resourceSet.createResource(uRI);
        }
        wSBinding = wsbndFactory.createWSBinding();
        resource.getContents().add(0, (Object)wSBinding);
        return wSBinding;
    }

    public static WebServices getWebServices(EJBJarFile eJBJarFile) throws Exception {
        return WSModels.getWebServices(eJBJarFile.getLoadStrategy(), "META-INF/webservices.xml");
    }

    public static void addRouterToWSBinding(WSBinding wSBinding, String string, String string2) {
        RouterModule routerModule = wsbndFactory.createRouterModule();
        routerModule.setName(string);
        routerModule.setTransport(string2);
        EList eList = wSBinding.getRouterModules();
        eList.add((Object)routerModule);
    }

    public static CommonarchiveFactory getArchiveFactory() {
        return CommonarchiveFactoryImpl.getActiveFactory();
    }

    static {
        WSModels.init();
        wsbndFactory = WsbndFactory.eINSTANCE;
    }
}

