/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.j2ee.commonarchivecore.ModuleFile;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.ws.management.application.client.MapModulesToServers;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.ws.webservices.deploy.WSBindingsFileAccessor;
import com.ibm.ws.webservices.deploy.WSDeploymentDescriptorAccessor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.emf.ecore.EObject;

class MapModulesToServersAccessor {
    private final int URI_COLUMN = 1;
    private final int SERVER_COLUMN = 2;
    private final String[][] taskData;
    private final Map moduleNameToServerNameMap = new HashMap();
    private AppDeploymentController appController;
    private static TraceComponent tc = Tr.register((Class)MapModulesToServersAccessor.class, (String)"WebServices", (String)"com.ibm.ws.webservices.deploy.resources.deployMessages");

    MapModulesToServersAccessor(AppDeploymentController appDeploymentController) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"Constructor");
        }
        this.appController = appDeploymentController;
        MapModulesToServers mapModulesToServers = (MapModulesToServers)appDeploymentController.getTaskByName("MapModulesToServers", false);
        this.taskData = mapModulesToServers.getTaskData();
        if (tc.isDebugEnabled()) {
            String string = "Constructor: MapModulesToservers' taskData is:\n" + DeployUtils.taskDataToString(this.taskData);
            Tr.debug((TraceComponent)tc, (String)string);
        }
        if (this.taskData != null) {
            for (int i = 1; i < this.taskData.length; ++i) {
                String string = this.taskData[i][1];
                String[] stringArray = util.separateUriString((String)string);
                this.moduleNameToServerNameMap.put(stringArray[0], this.taskData[i][2]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Constructor");
        }
    }

    void verifyThatAnEJBJARAndItsRouterAreInTheSameServer(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        Vector vector;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"verifyThatAnEJBJARAndItsRouterAreInTheSameServer");
        }
        if ((vector = appDeploymentInfo.getModuleConfig("JAR_DD")) != null) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                EObject eObject = (EObject)iterator.next();
                String string = util.formUriString((AppDeploymentInfo)appDeploymentInfo, (EObject)eObject);
                WSDeploymentDescriptorAccessor wSDeploymentDescriptorAccessor = new WSDeploymentDescriptorAccessor(eObject, appDeploymentInfo, appDeploymentTask);
                if (!wSDeploymentDescriptorAccessor.isModuleWebServiceEnabled(appDeploymentTask)) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("verifyThatAnEJBJARAndItsRouterAreInTheSameServer: the module " + string + " is not Web Services enabled"));
                    continue;
                }
                String[] stringArray = util.separateUriString((String)string);
                String string2 = stringArray[0];
                String string3 = (String)this.moduleNameToServerNameMap.get(string2);
                ModuleFile moduleFile = appDeploymentInfo.getModuleFileForDD(eObject);
                WSBindingsFileAccessor wSBindingsFileAccessor = new WSBindingsFileAccessor(moduleFile, appDeploymentTask);
                String[] stringArray2 = wSBindingsFileAccessor.getRouterModuleNames();
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (stringArray2[i] == null) continue;
                    String string4 = (String)this.moduleNameToServerNameMap.get(stringArray2[i]);
                    if (string4 == null) {
                        Object[] objectArray = new Object[]{stringArray2[i]};
                        String string5 = MessageFormat.format(util.getMessage((AppDeploymentTask)appDeploymentTask, (String)"WSWS0012E"), objectArray);
                        Tr.error((TraceComponent)tc, (String)"WSWS0012E", (Object)objectArray);
                        throw new AppDeploymentException(string5, null);
                    }
                    if (this.isTargetTheSame(string3.trim(), string4.trim())) continue;
                    Object[] objectArray = new Object[]{string, string3, stringArray2[i], string4};
                    String string6 = MessageFormat.format(util.getMessage((AppDeploymentTask)appDeploymentTask, (String)"WSWS0024E"), objectArray);
                    Tr.error((TraceComponent)tc, (String)"WSWS0024E", (Object)objectArray);
                    throw new AppDeploymentException(string6, null);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"verifyThatAnEJBJARAndItsRouterAreInTheSameServer");
        }
    }

    private boolean isTargetTheSame(String string, String string2) {
        boolean bl;
        block26: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"isTargetTheSame", (Object)new Object[]{string, string2});
            }
            bl = true;
            if (!string.equals(string2)) {
                String[] stringArray;
                String[] stringArray2 = string.split("\\+");
                if (stringArray2.length > (stringArray = string2.split("\\+")).length) {
                    bl = false;
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"!isSame, more targets in EJB");
                    }
                } else {
                    int n;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int i = 0; i < stringArray2.length; ++i) {
                        arrayList.add(this.sortTargetOrder(stringArray2[i]));
                    }
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    for (n = 0; n < stringArray.length; ++n) {
                        arrayList2.add(this.sortTargetOrder(stringArray[n]));
                    }
                    for (n = 0; n < arrayList.size(); ++n) {
                        if (arrayList2.contains(arrayList.get(n))) {
                            arrayList2.remove(arrayList.get(n));
                            if (!tc.isEntryEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("removed matching target:" + arrayList.get(n)));
                            continue;
                        }
                        bl = false;
                        if (!tc.isEntryEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)("!isSame, target:" + arrayList.get(n)));
                        break;
                    }
                    if (bl && arrayList2.size() > 0) {
                        try {
                            if (tc.isEntryEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("RouterWar has more targets: " + arrayList2.size()));
                            }
                            ConfigService configService = null;
                            configService = this.appController.getConfigService();
                            if (configService == null && tc.isEntryEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"cfgService is null...");
                            }
                            Session session = new Session();
                            if (tc.isEntryEnabled() && session == null) {
                                Tr.debug((TraceComponent)tc, (String)"session is null...");
                            }
                            Hashtable<String, String> hashtable = new Hashtable<String, String>();
                            hashtable.put("_Websphere_Config_Data_Type", "Server");
                            Hashtable hashtable2 = new Hashtable();
                            block5: for (int i = 0; i < arrayList2.size() && bl; ++i) {
                                ObjectName objectName = new ObjectName((String)arrayList2.get(i));
                                if (objectName.getKeyProperty("server") == null || objectName.getKeyProperty("node") == null || objectName.getKeyProperty("cell") == null) {
                                    bl = false;
                                    if (tc.isEntryEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("!isSame, missing server, node or cell:" + arrayList.get(i)));
                                    }
                                    break;
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("target in war: " + arrayList2.get(i)));
                                }
                                hashtable.put("_Websphere_Config_Data_Display_Name", objectName.getKeyProperty("server"));
                                ObjectName objectName2 = new ObjectName("WebSphere", hashtable);
                                ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName2, null);
                                if (objectNameArray.length == 0) {
                                    bl = false;
                                    if (tc.isEntryEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"!isSame, serverONs.length is 0");
                                    }
                                    break;
                                }
                                String string3 = "cells/" + objectName.getKeyProperty("cell") + "/nodes/" + objectName.getKeyProperty("node") + "/";
                                if (tc.isEntryEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("configId: " + string3));
                                }
                                for (int j = 0; j < objectNameArray.length; ++j) {
                                    if (tc.isEntryEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("keyProperty: " + objectNameArray[j].getKeyProperty("_Websphere_Config_Data_Id")));
                                    }
                                    if (objectNameArray[j].getKeyProperty("_Websphere_Config_Data_Id").indexOf(string3) <= 0) continue;
                                    String string4 = (String)configService.getAttribute(session, objectNameArray[j], "serverType");
                                    if (tc.isEntryEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("serverType: " + string4));
                                    }
                                    if (string4.equals("WEB_SERVER")) continue;
                                    bl = false;
                                    if (!tc.isEntryEnabled()) continue block5;
                                    Tr.debug((TraceComponent)tc, (String)("!isSame, serverType not WEB_SERVER:" + string4));
                                    continue block5;
                                }
                            }
                        }
                        catch (Exception exception) {
                            bl = false;
                            if (!tc.isEntryEnabled()) break block26;
                            Tr.debug((TraceComponent)tc, (String)("!isSame due to Exception:" + exception));
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isSame: " + bl));
        }
        return bl;
    }

    private String sortTargetOrder(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sortTargetOrder", (Object)new Object[]{string});
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            ObjectName objectName = new ObjectName(string);
            stringBuffer.append("WebSphere:");
            if (objectName.getKeyProperty("cell") != null) {
                stringBuffer.append("cell=" + objectName.getKeyProperty("cell"));
            }
            if (objectName.getKeyProperty("node") != null) {
                stringBuffer.append(",");
                stringBuffer.append("node=" + objectName.getKeyProperty("node"));
            }
            if (objectName.getKeyProperty("server") != null) {
                stringBuffer.append(",");
                stringBuffer.append("server=" + objectName.getKeyProperty("server"));
            }
            if (objectName.getKeyProperty("cluster") != null) {
                stringBuffer.append(",");
                stringBuffer.append("cluster=" + objectName.getKeyProperty("cluster"));
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sortTargetOrder", (Object)new Object[]{stringBuffer.toString()});
        }
        return stringBuffer.toString();
    }
}

