/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.j2ee.commonarchivecore.ModuleFile;
import com.ibm.etools.j2ee.commonarchivecore.strategy.LoadStrategy;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.etools.webservice.wsext.PcBinding;
import com.ibm.etools.webservice.wsext.ServerServiceConfig;
import com.ibm.etools.webservice.wsext.WsDescExt;
import com.ibm.etools.webservice.wsext.WsExtension;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.WSModels;
import com.ibm.ws.webservices.deploy.BindingChoicesHelper;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.ws.webservices.deploy.GetServerNameTask;
import com.ibm.ws.webservices.deploy.MapModulesToServersAccessor;
import com.ibm.ws.webservices.deploy.PortComponentInfo;
import com.ibm.ws.webservices.deploy.WSBindingsFileAccessor;
import com.ibm.ws.webservices.deploy.WSDeploymentDescriptorAccessor;
import com.ibm.ws.webservices.utils.PortInfo;
import com.ibm.ws.webservices.utils.WSDLParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class GetServerNameHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register((Class)GetServerNameHelper.class, (String)"WebServices", (String)"com.ibm.ws.webservices.deploy.resources.deployMessages");

    public AppDeploymentTask createTask(AppDeploymentController appDeploymentController, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createTask: taskName=" + string));
        }
        try {
            return new GetServerNameTask(appDeploymentController);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.GetServerNameHelper.createTask", (String)"76", (Object)this);
            Tr.error((TraceComponent)tc, (String)"WSWS0020E", (Object)exception);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"createTask: Error instantiating task", (Object)exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepareTask");
        }
        appDeploymentTask.setIsTaskDisabled(true);
        if (appDeploymentTask.getTaskData() != null) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        String[] stringArray = appDeploymentTask.getColumnNames();
        for (n = 0; n < stringArray.length; ++n) {
            vector.addElement(stringArray[n]);
        }
        for (n = 0; n < stringArray.length; ++n) {
            vector.addElement("");
        }
        String[][] stringArray2 = util.buildTaskData(vector, (int)stringArray.length);
        appDeploymentTask.setTaskData(stringArray2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("prepareTask:\n" + DeployUtils.taskDataToString(appDeploymentTask.getTaskData())));
        }
    }

    public void completeTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"completeTask");
        }
        if ((string = (String)appDeploymentInfo.getAppOptions().get("com.ibm.ws.webservices.validateEJBJAR")) == null) {
            string = "";
        }
        if (string.equalsIgnoreCase("FALSE") && (appDeploymentTask.getAppDeploymentController().getDeploymentMode() == 65536L || appDeploymentTask.getAppDeploymentController().getDeploymentMode() == 0x100000L)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"completeTask: skipping validation of web service enabled EJB JAR module");
            }
        } else {
            MapModulesToServersAccessor mapModulesToServersAccessor = new MapModulesToServersAccessor(appDeploymentTask.getAppDeploymentController());
            mapModulesToServersAccessor.verifyThatAnEJBJARAndItsRouterAreInTheSameServer(appDeploymentInfo, appDeploymentTask);
            boolean bl = false;
            Vector vector = appDeploymentInfo.getModuleConfig("JAR_DD");
            Vector vector2 = appDeploymentInfo.getModuleConfig("WAR_DD");
            Vector vector3 = new Vector();
            vector3.addAll(vector);
            vector3.addAll(vector2);
            Iterator iterator = vector3.iterator();
            while (iterator.hasNext()) {
                WSDeploymentDescriptorAccessor wSDeploymentDescriptorAccessor;
                EObject eObject = (EObject)iterator.next();
                HashSet<String> hashSet = new HashSet<String>();
                String string2 = util.formUriString((AppDeploymentInfo)appDeploymentInfo, (EObject)eObject);
                String[] stringArray = util.separateUriString((String)string2);
                String string3 = stringArray[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("completeTask: working on module " + string2));
                }
                if ((wSDeploymentDescriptorAccessor = new WSDeploymentDescriptorAccessor(eObject, appDeploymentInfo, appDeploymentTask)).isModuleWebServiceEnabled(appDeploymentTask)) {
                    Object object;
                    Object[] objectArray;
                    Object object2;
                    Object object3;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("completeTask: module " + string2 + " is Web Service enabled"));
                    }
                    String string4 = null;
                    string4 = eObject instanceof WebApp ? string3 : this.getNameOfRouterWarForEJBModule(appDeploymentInfo, appDeploymentTask, vector2, eObject);
                    ModuleFile moduleFile = appDeploymentInfo.getModuleFileForDD(eObject);
                    String string5 = DeployUtils.createWorkingDirectory(appDeploymentTask);
                    BindingChoicesHelper.extractModulesFilesToTmpDir(appDeploymentTask, string2, moduleFile, string5);
                    String[] stringArray2 = wSDeploymentDescriptorAccessor.getWebserviceDescriptionNames();
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    HashSet<Object> hashSet2 = new HashSet<Object>();
                    if (!bl) {
                        bl = this.checkWsSecurityEnabled(moduleFile, eObject);
                    }
                    boolean bl2 = false;
                    for (int i = 0; i < stringArray2.length; ++i) {
                        Object[] objectArray2;
                        String string6;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("completeTask: working on " + string3 + "'s webserviceDescriptionName " + stringArray2[i]));
                        }
                        object3 = wSDeploymentDescriptorAccessor.getWsdlFileForWebserviceDescriptionName(stringArray2[i]);
                        BindingChoicesHelper.verifyThatWebServicesDescriptionWsdlFileActuallyExistsInModule(appDeploymentTask, string2, moduleFile, (String)object3);
                        object2 = this.openWSDLParserForWSDLFile(appDeploymentTask, string2, string5, (String)object3);
                        objectArray = wSDeploymentDescriptorAccessor.getPortComponentDataForWebserviceDescriptionElement(stringArray2[i]);
                        if (!hashSet2.contains(object3)) {
                            object = ((WSDLParser)object2).getPortInfos();
                            for (int j = 0; j < ((Vector)object).size(); ++j) {
                                hashMap.put(((PortInfo)((Vector)object).get((int)j)).port.getName(), object3);
                            }
                        }
                        hashSet2.add(object3);
                        for (int j = 0; j < objectArray.length; ++j) {
                            Object object4 = objectArray[j];
                            boolean bl3 = bl2 = hashMap.remove(((PortComponentInfo)object4).getPortQnameLocalname()) != null || bl2;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("completeTask: working on " + string3 + "." + stringArray2[i] + "'s " + object4));
                            }
                            string6 = ((PortComponentInfo)object4).getPortQnameNamespace();
                            objectArray2 = ((PortComponentInfo)object4).getPortQnameLocalname();
                            boolean bl4 = false;
                            bl4 = ((WSDLParser)object2).portExists(string6, (String)objectArray2);
                            if (bl4) continue;
                            Object[] objectArray3 = new Object[]{string2, object3, string6, objectArray2};
                            String string7 = MessageFormat.format(util.getMessage((AppDeploymentTask)appDeploymentTask, (String)"WSWS0007E"), objectArray3);
                            Tr.error((TraceComponent)tc, (String)"WSWS0007E", (Object)objectArray3);
                            throw new AppDeploymentException(string7, null);
                        }
                        object = null;
                        object = eObject instanceof WebApp ? "WEB-INF/wsdl" : "META-INF/wsdl";
                        if (((String)object3).startsWith((String)object)) continue;
                        String string8 = string5 + File.separator + ((String)object3).replace('/', File.separatorChar);
                        string6 = new File(string8).getParent();
                        hashSet.add(string6);
                        objectArray2 = new Object[]{string3, object3};
                        String string9 = MessageFormat.format(util.getMessage((AppDeploymentTask)appDeploymentTask, (String)"WSWS0037W"), objectArray2);
                        Tr.warning((TraceComponent)tc, (String)string9);
                    }
                    if (hashMap.size() > 0) {
                        Iterator iterator2 = hashMap.keySet().iterator();
                        while (iterator2.hasNext()) {
                            object3 = (String)iterator2.next();
                            object2 = (String)hashMap.get(object3);
                            objectArray = new Object[]{string3, object2, object3};
                            object = MessageFormat.format(util.getMessage((AppDeploymentTask)appDeploymentTask, (String)"WSWS0034E"), objectArray);
                            if (bl2) {
                                Tr.info((TraceComponent)tc, (String)object);
                                continue;
                            }
                            Tr.error((TraceComponent)tc, (String)object);
                            throw new AppDeploymentException((String)object, null);
                        }
                    }
                    String string10 = eObject instanceof WebApp ? "WEB-INF/wsdl" : "META-INF/wsdl";
                    object3 = hashSet.iterator();
                    while (object3.hasNext()) {
                        object2 = (String)object3.next();
                        this.copyColocatedWsdlFilesToModule(string3, (String)object2, string10, appDeploymentTask);
                    }
                    if (!(eObject instanceof WebApp)) {
                        object3 = string5 + File.separator + "META-INF/wsdl".replace('/', File.separatorChar);
                        this.deepCopyDirToModule((String)object3, "WEB-INF/wsdl", string4, appDeploymentTask);
                    }
                    DeployUtils.deleteWorkingDirectory(string5);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("completeTask: module " + string2 + "is Web NOT Service enabled"));
            }
        }
    }

    private WSDLParser openWSDLParserForWSDLFile(AppDeploymentTask appDeploymentTask, String string, String string2, String string3) throws AppDeploymentException {
        int n;
        String string4 = "file:" + string2 + "/";
        WSDLParser wSDLParser = null;
        int n2 = string3.lastIndexOf(47);
        int n3 = n2 > (n = string3.lastIndexOf(92)) ? n2 : n;
        String string5 = string4;
        String string6 = string3;
        if (n3 >= 0 && string3.length() > n3) {
            String string7 = string3.substring(0, n3 + 1);
            string6 = string3.substring(n3 + 1);
            string5 = string4 + string7;
        }
        try {
            wSDLParser = new WSDLParser(string5, string6);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.GetServerNameHelper.completeTask", (String)"499", (Object)this);
            Object[] objectArray = new Object[]{string3, string, exception};
            String string8 = MessageFormat.format(util.getMessage((AppDeploymentTask)appDeploymentTask, (String)"WSWS0006E"), objectArray);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("openWSDLParserForWSDLFile: " + string8), (Object)exception);
            }
            Tr.error((TraceComponent)tc, (String)"WSWS0006E", (Object)objectArray);
            throw new AppDeploymentException(string8.toString(), (Throwable)exception);
        }
        return wSDLParser;
    }

    private String getNameOfRouterWarForEJBModule(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask, Vector vector, EObject eObject) throws AppDeploymentException {
        String string = util.formUriString((AppDeploymentInfo)appDeploymentInfo, (EObject)eObject);
        String[] stringArray = util.separateUriString((String)string);
        String string2 = stringArray[0];
        String string3 = null;
        Object object = null;
        String string4 = null;
        String string5 = null;
        ModuleFile moduleFile = appDeploymentInfo.getModuleFileForDD(eObject);
        WSBindingsFileAccessor wSBindingsFileAccessor = new WSBindingsFileAccessor(moduleFile, appDeploymentTask);
        String[] stringArray2 = wSBindingsFileAccessor.getRouterModuleNames();
        string3 = stringArray2[0];
        if (string3 != null) {
            Object object2;
            Object[] objectArray = vector.iterator();
            while (objectArray.hasNext()) {
                object2 = (String[])objectArray.next();
                String string6 = util.formUriString((AppDeploymentInfo)appDeploymentInfo, (EObject)object2);
                String[] stringArray3 = util.separateUriString((String)string6);
                String string7 = stringArray3[0];
                if (!string7.equals(string3)) continue;
                object = object2;
                break;
            }
            if (object == null) {
                objectArray = new Object[]{string2, string3};
                object2 = MessageFormat.format(util.getMessage((AppDeploymentTask)appDeploymentTask, (String)"WSWS0035E"), objectArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getNameOfRouterWarForEJBModule :getEBJRouterModuleName: " + (String)object2));
                }
                Tr.error((TraceComponent)tc, (String)"WSWS0035E", (Object)objectArray);
                throw new AppDeploymentException((String)object2, null);
            }
            objectArray = util.formUriString((AppDeploymentInfo)appDeploymentInfo, object);
            object2 = util.separateUriString((String)objectArray);
            string5 = object2[0];
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getNameOfRouterWarForEJBModule: for EJB module " + string2 + " the router WAR is " + string4));
            }
            return string5;
        }
        return null;
    }

    private void copyFileToModule(File file, String string, String string2, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("copyFileToModule: fileToBecopie=" + file + " targetModuleName=" + string + " pathInTargetModule=" + string2));
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.webservices.deploy.GetServerNameHelper.completeTask", (String)"706", (Object)this);
            Object[] objectArray = new Object[]{file, fileNotFoundException};
            String string3 = MessageFormat.format(util.getMessage((AppDeploymentTask)appDeploymentTask, (String)"WSWS0015E"), objectArray);
            Tr.error((TraceComponent)tc, (String)"WSWS0015E", (Object)objectArray);
            throw new AppDeploymentException(string3, (Throwable)fileNotFoundException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("completeTask: about to save the wsdl file \"" + string2 + "\" into module " + string));
        }
        appDeploymentTask.getAppDeploymentController().saveAsFile(string, string2, (InputStream)fileInputStream);
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.deploy.GetServerNameHelper.completeTask", (String)"738", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"WSWS0028W", (Object)fileInputStream);
        }
    }

    private void copyColocatedWsdlFilesToModule(String string, String string2, String string3, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("copyColocatedWSDLFilesToModule:  targetModuleName=" + string + " sourceDir=" + string2 + " targetDir=" + string3));
        }
        File[] fileArray = new File(string2).listFiles(new WsdlXsdFilter());
        for (int i = 0; i < fileArray.length; ++i) {
            String string4 = string3 + "/" + fileArray[i].getName();
            this.copyFileToModule(fileArray[i], string, string4, appDeploymentTask);
        }
    }

    private void deepCopyDirToModule(String string, String string2, String string3, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        File file;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("deepCopyDirToModule:  sourceDir=" + string + " targetDir=" + string2 + " targetModule=" + string3));
        }
        if (!(file = new File(string)).exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string4 = string2 + "/" + fileArray[i].getName();
            if (fileArray[i].isFile()) {
                this.copyFileToModule(fileArray[i], string3, string4, appDeploymentTask);
            }
            if (!fileArray[i].isDirectory()) continue;
            this.deepCopyDirToModule(fileArray[i].getPath(), string4, string3, appDeploymentTask);
        }
    }

    private WsExtension loadWebServicesExtXML(LoadStrategy loadStrategy, String string) {
        if (loadStrategy.getContainer().containsFile(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing IBM web services XML ext file: " + string));
            }
            try {
                return WSModels.getWsExtension(loadStrategy, string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.GetServerNameHelper.loadWebServicesExtXML", (String)"899");
            }
        }
        return null;
    }

    private boolean checkWsSecurityEnabled(ModuleFile moduleFile, EObject eObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkWsSecurityEnabled()");
        }
        WsExtension wsExtension = null;
        LoadStrategy loadStrategy = null;
        if (moduleFile != null) {
            loadStrategy = moduleFile.getLoadStrategy();
        }
        String string = null;
        if (eObject != null) {
            string = eObject instanceof WebApp ? "WEB-INF/ibm-webservices-ext.xmi" : "META-INF/ibm-webservices-ext.xmi";
        }
        if (loadStrategy != null && string != null) {
            wsExtension = this.loadWebServicesExtXML(loadStrategy, string);
        }
        boolean bl = false;
        EList eList = null;
        if (wsExtension != null) {
            eList = wsExtension.getWsDescExt();
        }
        if (eList != null && !eList.isEmpty()) {
            int n = eList.size();
            block0: for (int i = 0; i < n && !bl; ++i) {
                WsDescExt wsDescExt = (WsDescExt)eList.get(i);
                EList eList2 = wsDescExt.getPcBinding();
                if (eList2 == null || eList2.isEmpty()) continue;
                int n2 = eList2.size();
                for (int j = 0; j < n2; ++j) {
                    PcBinding pcBinding = (PcBinding)eList2.get(j);
                    ServerServiceConfig serverServiceConfig = pcBinding.getServerServiceConfig();
                    if (serverServiceConfig == null) continue;
                    if (serverServiceConfig.getSecurityRequestReceiverServiceConfig() != null) {
                        bl = true;
                        if (!tc.isDebugEnabled()) continue block0;
                        Tr.debug((TraceComponent)tc, (String)"SecurityRequestReceiverServiceConfig found, assuming ws-security is enabled");
                        continue block0;
                    }
                    if (serverServiceConfig.getSecurityResponseSenderServiceConfig() == null) continue;
                    bl = true;
                    if (!tc.isDebugEnabled()) continue block0;
                    Tr.debug((TraceComponent)tc, (String)"SecurityResponseSenderServiceConfig found, assuming ws-security is enabled");
                    continue block0;
                }
            }
        }
        if (bl) {
            TraceComponent traceComponent = Tr.register((String)"com.ibm.ws.webservices.deploy.GetServerNameHelper.checkWsSecurityEnabled", (String)"WebServices", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
            Tr.warning((TraceComponent)traceComponent, (String)"security.wssecurity.appinstall.warning");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkWsSecurityEnabled() returns " + bl));
        }
        return bl;
    }

    private class WsdlXsdFilter
    implements FilenameFilter {
        private WsdlXsdFilter() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".wsdl") || string.endsWith(".WSDL") || string.endsWith(".xsd") || string.endsWith(".XSD");
        }
    }
}

