/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.WSConstants;
import com.ibm.ws.webservices.deploy.DeployUtils;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;

public class BindingChoices
extends AppDeploymentTask {
    private static TraceComponent tc = Tr.register((Class)BindingChoices.class, (String)"WebServices", (String)"com.ibm.ws.webservices.deploy.resources.deployMessages");
    public static final String TaskName = "WebServicesPublishWSDLInfo";
    public static final int TOTAL_COLUMNS = 6;
    public static final String MODULE_COLUMN_NAME = "module";
    public static final String USER_INPUT_COLUMN_NAME = "webservices.bindingChoices.UrlFragmentColumnName";
    public static final String PROTOCOL_TYPE_COLUMN_NAME = "Protocol";
    public static final String USE_APPLY_FIELD_FLAG_COLUMN_NAME = "use apply field";
    public static final String LABEL_FOR_APPLY_TEXT_FIELD_COLUMN_NAME = "label for Text Field";
    public static final String DEFAULT_VALUE_FOR_APPLY_TEXT_FIELD_COLUMN_NAME = "Default Value for ApplyField";
    public static final int MODULE = 0;
    public static final int PROTOCOL_TYPE = 1;
    public static final int USER_INPUT = 2;
    public static final int USE_APPLY_FIELD_FLAG = 3;
    public static final int LABEL_FOR_APPLY_TEXT_FIELD = 4;
    public static final int DEFAULT_VALUE_FOR_APPLY_TEXT_FIELD = 5;
    private static final String JAVA_COLON_COMP = "java:comp";

    public BindingChoices(AppDeploymentController appDeploymentController) {
        super(appDeploymentController);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BindingChoices.ctor()");
        }
        this.name = TaskName;
        this.colNames = new String[6];
        this.colNames[0] = MODULE_COLUMN_NAME;
        this.colNames[1] = PROTOCOL_TYPE_COLUMN_NAME;
        this.colNames[2] = USER_INPUT_COLUMN_NAME;
        this.colNames[3] = USE_APPLY_FIELD_FLAG_COLUMN_NAME;
        this.colNames[4] = LABEL_FOR_APPLY_TEXT_FIELD_COLUMN_NAME;
        this.colNames[5] = DEFAULT_VALUE_FOR_APPLY_TEXT_FIELD_COLUMN_NAME;
        this.mutables = new boolean[6];
        this.mutables[0] = false;
        this.mutables[1] = false;
        this.mutables[2] = true;
        this.mutables[3] = false;
        this.mutables[4] = false;
        this.mutables[5] = false;
        this.requiredColumns = new boolean[6];
        this.requiredColumns[0] = false;
        this.requiredColumns[1] = false;
        this.requiredColumns[2] = false;
        this.requiredColumns[3] = false;
        this.requiredColumns[4] = false;
        this.requiredColumns[5] = false;
        this.hiddenColumns = new boolean[6];
        this.hiddenColumns[0] = false;
        this.hiddenColumns[1] = false;
        this.hiddenColumns[2] = false;
        this.hiddenColumns[3] = true;
        this.hiddenColumns[4] = true;
        this.hiddenColumns[5] = true;
        this.hasHiddenColumns = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"BindingChoices.ctor()");
        }
    }

    public String[] validate() {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validate");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BindingChoices.validate(), at the beginning: the taskData contains\n:" + DeployUtils.taskDataToString(this.getTaskData())));
        }
        Vector<String> vector = new Vector<String>();
        this.taskValidateErrorMessages = null;
        for (n = 0; this.taskData != null && n < this.taskData.length; ++n) {
            String string;
            Object object;
            if (this.taskData[n][1].equals("JMS")) {
                if (BindingChoices.isGoodJMSUrlSyntax(this.taskData[n][2])) continue;
                object = new Object[]{this.taskData[n][2], this.taskData[n][0]};
                string = MessageFormat.format(util.getMessage((AppDeploymentTask)this, (String)"WSWS0054E"), object);
                vector.addElement(string);
                continue;
            }
            if (!this.taskData[n][1].equals("EJB") || BindingChoices.isGoodEJBUrlSyntax(this.taskData[n][2])) continue;
            object = "";
            for (int i = 0; i < WSConstants.VALID_EJB_URL_PROPERTY_NAMES.length; ++i) {
                object = i == WSConstants.VALID_EJB_URL_PROPERTY_NAMES.length - 1 ? (String)object + " and " + WSConstants.VALID_EJB_URL_PROPERTY_NAMES[i] : (String)object + WSConstants.VALID_EJB_URL_PROPERTY_NAMES[i] + ",";
            }
            string = "";
            if (WSConstants.VALID_EJB_URL_PROPERTY_NAMES.length > 0) {
                string = WSConstants.VALID_EJB_URL_PROPERTY_NAMES[0] + "=someValue";
            }
            if (WSConstants.VALID_EJB_URL_PROPERTY_NAMES.length > 1) {
                string = string + "&" + WSConstants.VALID_EJB_URL_PROPERTY_NAMES[1] + "=someValue";
            }
            Object[] objectArray = new String[]{this.taskData[n][2], object, string};
            String string2 = MessageFormat.format(util.getMessage((AppDeploymentTask)this, (String)"WSWS0049E"), objectArray);
            vector.addElement(string2);
        }
        this.buildErrorMessages(vector);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validate");
            if (this.taskValidateErrorMessages != null && this.taskValidateErrorMessages.length > 0) {
                for (n = 0; n < this.taskValidateErrorMessages.length; ++n) {
                    Tr.exit((TraceComponent)tc, (String)("validate taskValidateErrorMessages[" + n + "]=" + this.taskValidateErrorMessages[n]));
                }
            }
        }
        return this.taskValidateErrorMessages;
    }

    public static boolean isGoodJMSUrlSyntax(String string) {
        if (string == null || string.length() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("isGoodJMSUrlSyntax(" + string + ") returning true"));
            }
            return true;
        }
        if (!string.startsWith("jms:/queue") && !string.startsWith("jms:/topic")) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("isGoodJMSUrlSyntax(" + string + ") returning false"));
            }
            return false;
        }
        int n = string.indexOf("?");
        String string2 = string.substring(n + 1);
        if (string2.indexOf(":") != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "&|");
            while (stringTokenizer.hasMoreElements()) {
                int n2;
                String string3 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "=");
                String string4 = stringTokenizer2.nextToken();
                String string5 = stringTokenizer2.nextToken();
                if (!string4.equals("destination") && !string4.equals("connectionFactory") || (n2 = string5.indexOf(JAVA_COLON_COMP)) == -1) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("isGoodJMSUrlSyntax(" + string + ") returning false"));
                }
                return false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isGoodJMSUrlSyntax(" + string + ") returning true"));
        }
        return true;
    }

    public static boolean isGoodEJBUrlSyntax(String string) {
        String string2 = "&|";
        String string3 = "=";
        if ((string = string.trim()).length() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("isGoodEJBUrlSyntax(" + string + ") returning true"));
            }
            return true;
        }
        string = DeployUtils.stripDelimitersFromFrontOfEJBURLPropertyString(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            int n = string4.indexOf(61);
            if (n == -1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("isGoodEJBUrlSyntax(" + string + ") returning false"));
                }
                return false;
            }
            int n2 = string4.lastIndexOf(61);
            if (n2 != n) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("isGoodEJBUrlSyntax(" + string + ") returning false"));
                }
                return false;
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, string3);
            String string5 = stringTokenizer2.nextToken();
            boolean bl = false;
            for (int i = 0; i < WSConstants.VALID_EJB_URL_PROPERTY_NAMES.length; ++i) {
                if (!string5.equals(WSConstants.VALID_EJB_URL_PROPERTY_NAMES[i])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("isGoodEJBUrlSyntax(" + string + ") returning false"));
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isGoodEJBUrlSyntax(" + string + ") returning true"));
        }
        return true;
    }
}

