/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.custom;

import com.ibm.ws.webservices.custom.CustomPropertyDescriptor;
import com.ibm.ws.webservices.custom.CustomPropertyValidator;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import org.apache.commons.logging.Log;

public class CustomPropertyStringValidator
implements CustomPropertyValidator {
    private Log log = LogFactory.getLog(CustomPropertyStringValidator.class.getName());
    private boolean ignoreCase = false;
    private String[] validStrings = null;

    CustomPropertyStringValidator(boolean bl) {
        this.ignoreCase = bl;
    }

    CustomPropertyStringValidator(boolean bl, String[] stringArray) {
        this.ignoreCase = bl;
        this.validStrings = stringArray;
    }

    public Object validate(Object object, CustomPropertyDescriptor customPropertyDescriptor) {
        block8: {
            try {
                String string = (String)object;
                if (this.validStrings != null && this.validStrings.length > 0) {
                    int n;
                    for (n = 0; n < this.validStrings.length; ++n) {
                        if (!this.matches(string, this.validStrings[n])) continue;
                        return string;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Failure occured during String validation.  Value " + string + " "));
                        this.log.debug((Object)"does not match valid values, which are: ");
                        for (n = 0; n < this.validStrings.length; ++n) {
                            this.log.debug((Object)("   " + this.validStrings[n] + " "));
                        }
                    }
                    break block8;
                }
                return string;
            }
            catch (ClassCastException classCastException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Failure occured during String validation.  ");
                    this.log.debug((Object)("Object passed to validator is not type " + String.class.getName() + "."));
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!this.log.isDebugEnabled()) break block8;
                this.log.debug((Object)"Failure occured during String validation.  ");
                this.log.debug((Object)"Object passed to validator is null.");
            }
        }
        return customPropertyDescriptor.getValue();
    }

    private boolean matches(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        if (this.ignoreCase) {
            return string.equalsIgnoreCase(string2);
        }
        return string.equals(string2);
    }
}

