/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.WebServicesException;
import com.ibm.ws.webservices.WebServicesServiceHome;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.metadata.ClientEntityMetaData;
import com.ibm.ws.webservices.metadata.ClientModuleMetaData;
import com.ibm.ws.webservices.metadata.ClientServiceMetaData;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.wsdl.Definition;

public class ServiceRefClientFactory
implements ObjectFactory {
    private static TraceComponent _tc = Tr.register((Class)ServiceRefClientFactory.class, (String)"WebServices", (String)"com.ibm.ws.webservices.resources.webservicesMessages");
    private static String SET_WSDDPORT_METHOD_PREFIX = "set";
    private static String SET_WSDDPORT_METHOD_SUFFIX = "WSDDPortName";
    private static String UNSPECIFIED_PORT_NAME = null;

    private static String getClassLocator(String string) {
        return string + "Locator";
    }

    public Object getObjectInstance(Object object, Name name2, Context context, Hashtable hashtable) throws Exception {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("Enter getObjectInstance(refObj=" + JavaUtils.getObjectIdentity(object) + ", Name=" + name2 + ", Context=" + context + ", env);"));
        }
        Service service = null;
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            String string = reference.getClassName();
            if (string.equals(ClientServiceMetaData.class.getName())) {
                ClientEntityMetaData clientEntityMetaData = WebServicesServiceHome.getWebServicesService().getClientEntityMetaData();
                if (clientEntityMetaData == null) {
                    String string2 = "ClientEntityMetaData is not available";
                    Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)string2);
                    throw new WebServicesException(string2);
                }
                ClientServiceMetaData clientServiceMetaData = clientEntityMetaData.getClientServiceMetaData(reference);
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("clientEntityMetaData.getClientServiceMetaData(ref) == " + clientServiceMetaData));
                }
                if (clientServiceMetaData.getServiceInterface().equals(javax.xml.rpc.Service.class.getName())) {
                    Definition definition = clientServiceMetaData.getWsdlDoc();
                    if (definition == null) {
                        service = new Service();
                        service.setEngine(clientEntityMetaData.getEngine());
                    } else {
                        Map map = clientServiceMetaData.getNamespaceToPackageMapping();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)("Service QName on java:comp lookup is " + clientServiceMetaData.getQName()));
                            Tr.debug((TraceComponent)_tc, (String)("Service WsdlDoc is " + definition));
                            Tr.debug((TraceComponent)_tc, (String)("refNamespace2PackageMapping is " + map));
                        }
                        service = new Service(clientEntityMetaData.getEngine(), definition, clientServiceMetaData.getQName(), map);
                    }
                } else {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    Class<?> clazz = null;
                    try {
                        clazz = classLoader.loadClass(ServiceRefClientFactory.getClassLocator(clientServiceMetaData.getServiceInterface()));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.webservices.client.ServiceRefClientFactory.getObjectInstance", (String)"132", (Object)this);
                        Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)classNotFoundException);
                        throw classNotFoundException;
                    }
                    if (!javax.xml.rpc.Service.class.isAssignableFrom(clazz)) {
                        Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)("Specified service " + clazz + " is not assignable from javax.xml.rpc.Service"));
                        throw new Exception("Specified service does not inherit from javax.xml.rpc.Service");
                    }
                    service = (javax.xml.rpc.Service)clazz.newInstance();
                    if (service instanceof Service) {
                        service.setEngine(clientEntityMetaData.getEngine());
                    }
                    Method[] methodArray = clazz.getMethods();
                    String[] stringArray = this.getWsdlPortsFromReferencable(clientServiceMetaData);
                    for (int i = 0; i < stringArray.length; ++i) {
                        Object object2;
                        int n;
                        Method method = null;
                        String string3 = null;
                        if (stringArray[i] == UNSPECIFIED_PORT_NAME) {
                            string3 = SET_WSDDPORT_METHOD_PREFIX + "<PortName>" + SET_WSDDPORT_METHOD_SUFFIX;
                            if (i != 0) {
                                Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)"ServiceRefClientFactory: Empty PortName in WSDL Port Names Array");
                            }
                            for (n = 0; n < methodArray.length; ++n) {
                                object2 = methodArray[n].getName();
                                if (!object2.startsWith(SET_WSDDPORT_METHOD_PREFIX) || !object2.endsWith(SET_WSDDPORT_METHOD_SUFFIX)) continue;
                                method = methodArray[n];
                                break;
                            }
                        } else {
                            string3 = SET_WSDDPORT_METHOD_PREFIX + stringArray[i] + SET_WSDDPORT_METHOD_SUFFIX;
                            for (n = 0; n < methodArray.length; ++n) {
                                object2 = methodArray[n].getName();
                                if (!object2.equals(string3)) continue;
                                method = methodArray[n];
                                break;
                            }
                        }
                        String string4 = ClientModuleMetaData.clientConfigurationPortName(clientServiceMetaData.getName(), stringArray[i]);
                        if (method != null) {
                            object2 = new Object[]{string4};
                            method.invoke((Object)service, object2);
                            if (!_tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)_tc, (String)("ServiceLocator " + clazz + " WSDDPort name set to " + string4));
                            continue;
                        }
                        object2 = new Object[]{clazz, string3, clientServiceMetaData.getName(), string4};
                        Tr.warning((TraceComponent)_tc, (String)"warning.ServiceNameSetter.notfound", (Object)object2);
                    }
                }
                service.setServiceRefName(clientServiceMetaData.getName());
                service.setWSDLFileName(clientServiceMetaData.getWsdlFileName());
                service.setPortTypeToPortMapping(clientServiceMetaData.getDefaultPortMapping());
                service.setSEIToPortTypeMapping(clientServiceMetaData.getSeiToPortTypeMapping());
                service.setOverriddingEndpointURIs(clientServiceMetaData.getOverriddingEndpointURIs());
            } else {
                Object[] objectArray = new Object[]{string, ClientServiceMetaData.class.getName()};
                Tr.warning((TraceComponent)_tc, (String)"warning.client.reference.wrong.type", (Object)objectArray);
            }
        } else {
            Tr.warning((TraceComponent)_tc, (String)"warning.client.reference.not.found");
        }
        return service;
    }

    private String[] getWsdlPortsFromReferencable(ClientServiceMetaData clientServiceMetaData) {
        String[] stringArray = clientServiceMetaData.getWsdlPortNames();
        if (stringArray == null) {
            stringArray = new String[]{UNSPECIFIED_PORT_NAME};
        }
        return stringArray;
    }
}

