/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import org.xml.sax.InputSource;

public abstract class BaseWSDLLocator {
    private static TraceComponent _tc = Tr.register((Class)BaseWSDLLocator.class, (String)"WebServices", (String)"com.ibm.ws.webservices.resources.webservicesMessages");
    protected String baseURI;
    protected String lastestImportURI;
    protected InputStream baseInputStream;
    private static final char WSDL_PATH_SEPERATOR_CHAR = '/';
    private static final String WSDL_PATH_SEPERATOR = new Character('/').toString();

    protected abstract InputStream getInputStream(String var1) throws IOException;

    public InputSource getBaseInputSource() {
        return new InputSource(this.baseInputStream);
    }

    public InputSource getImportInputSource(String string, String string2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getImportInputSource", (Object)new Object[]{string, string2, this});
        }
        InputSource inputSource = null;
        try {
            if (this.isAbsoluteImport(string2)) {
                URL uRL = new URL(string2);
                inputSource = new InputSource(uRL.openStream());
                this.lastestImportURI = uRL.toExternalForm();
            } else {
                String string3 = this.normalizePath(string, string2);
                InputStream inputStream = this.getInputStream(string3);
                inputSource = new InputSource(inputStream);
                this.lastestImportURI = string3;
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.client.BaseWSDLLocator.getImportInputSource", (String)"90", (Object)this);
            Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)iOException);
            throw new RuntimeException("Caught IOException reading wsdl file from EAR " + iOException);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"getImportInputSource", (Object)inputSource);
        }
        return inputSource;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getLatestImportURI() {
        return this.lastestImportURI;
    }

    protected String convertURI(String string) {
        int n = string.lastIndexOf(47);
        string = n > 0 ? string.substring(0, n + 1) : "";
        return string;
    }

    protected boolean isAbsoluteImport(String string) {
        boolean bl = false;
        if (string != null) {
            bl = string.indexOf("://") > 0;
        }
        return bl;
    }

    protected String normalizePath(String string, String string2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"normalizePath");
        }
        String string3 = this.convertURI(string);
        StringBuffer stringBuffer = new StringBuffer(string3);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, WSDL_PATH_SEPERATOR);
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("pathFromRoot = " + string3));
            Tr.debug((TraceComponent)_tc, (String)("relativeLocation = " + string2));
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("..")) {
                int n = stringBuffer.length() - 1;
                if (stringBuffer.charAt(n) == '/') {
                    stringBuffer.deleteCharAt(n--);
                }
                while (stringBuffer.charAt(n) != '/') {
                    stringBuffer.deleteCharAt(n--);
                }
                continue;
            }
            if (string4.equals(".")) continue;
            if (stringBuffer.charAt(stringBuffer.length() - 1) != '/') {
                stringBuffer.append('/');
            }
            stringBuffer.append(string4);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("Built path = " + stringBuffer.toString()));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"normalizePath");
        }
        return stringBuffer.toString();
    }
}

