/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.soap.container.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.soap.container.SoapContainerRouter;
import com.ibm.ws.soap.container.SoapContainerService;
import com.ibm.ws.webservices.WebServicesSystemService;
import com.ibm.wsspi.soapcontainer.SOAPRequest;
import com.ibm.wsspi.soapcontainer.SOAPResponse;
import java.beans.beancontext.BeanContextServiceProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class SOAPContainerChannelComponentImpl
extends ComponentImpl
implements SoapContainerService {
    private static final TraceComponent _tc = Tr.register((Class)SOAPContainerChannelComponentImpl.class, (String)"WebServices", (String)"com.ibm.ws.webservices.resources.webservicesMessages");
    Hashtable metaDataTable = new Hashtable();
    Hashtable engineTable = new Hashtable();
    SoapContainerRouter router = null;
    ThreadLocal threadLocalSysappName = new ThreadLocal();
    WebServicesSystemService wsSysSvc = null;
    boolean loadedConfig = false;
    Object configLoading = new Object();

    public void cacheMetaData(String string, Object object) {
        this.metaDataTable.put(string, object);
    }

    public Object getMetaData(String string) {
        return this.metaDataTable.get(string);
    }

    public Object getMetaData() {
        String string = (String)this.threadLocalSysappName.get();
        return this.metaDataTable.get(string);
    }

    public void cacheEngine(Object object) {
        String string = (String)this.threadLocalSysappName.get();
        this.engineTable.put(string, object);
    }

    public Object getEngine() {
        String string = (String)this.threadLocalSysappName.get();
        return this.engineTable.get(string);
    }

    public void registerRouter(SoapContainerRouter soapContainerRouter) {
        this.router = soapContainerRouter;
    }

    public Enumeration getRegisteredURLs() {
        return this.metaDataTable.keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void handleRequest(SOAPRequest sOAPRequest, SOAPResponse sOAPResponse) throws IOException {
        Object[] objectArray;
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"handleRequest");
        }
        if (!this.loadedConfig) {
            objectArray = this.configLoading;
            // MONITORENTER : this.configLoading
            if (!this.loadedConfig) {
                this.wsSysSvc.loadConfiguration();
                this.loadedConfig = true;
            }
            // MONITOREXIT : objectArray
        }
        if (this.router != null) {
            objectArray = sOAPRequest.getRequestURI();
            String string = sOAPRequest.getRequestPathInfo();
            String string2 = string.substring(1, string.indexOf("/", 1));
            Object v = this.metaDataTable.get(string2);
            Object v2 = this.engineTable.get(string2);
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Invoking system application...\nRequest URI:              " + sOAPRequest.getRequestURI() + "\n" + "Request PathInfo:         " + string + "\n" + "System Application Name:  " + string2 + "\n" + "Metadata for application: " + v + "\n" + "Engine for application:   " + v2 + "\n"));
            }
            if (v != null) {
                try {
                    this.threadLocalSysappName.set(string2);
                    this.router.doPost(sOAPRequest, sOAPResponse, v);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.soap.container.component.SOAPContainerChannelComponentImpl.handleRequest", (String)"151", (Object)this);
                    Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)exception);
                    SOAPContainerChannelComponentImpl.errorResponse(sOAPResponse, string, string2);
                }
                finally {
                    this.threadLocalSysappName.set(null);
                }
            } else {
                Object[] objectArray2 = new Object[]{string, string2};
                Tr.error((TraceComponent)_tc, (String)"no.system.application", (Object)objectArray2);
                SOAPContainerChannelComponentImpl.errorResponse(sOAPResponse, string, string2);
            }
        } else {
            objectArray = new Object[]{sOAPRequest.getRequestURI()};
            Tr.error((TraceComponent)_tc, (String)"no.system.router", (Object)objectArray);
            SOAPContainerChannelComponentImpl.errorResponse(sOAPResponse, sOAPRequest.getRequestURI(), null);
        }
        if (!_tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)_tc, (String)"handleRequest");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void errorResponse(SOAPResponse sOAPResponse, String string, String string2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"errorResponse");
        }
        try {
            try {
                sOAPResponse.setStatusCode(404);
                sOAPResponse.setContentType("text/html");
                OutputStream outputStream = sOAPResponse.getOutputStream();
                if (outputStream != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("<h2>ERROR</h2>\n");
                    stringBuffer.append("<p>URL recieved [" + string + "]\n");
                    if (string2 == null) {
                        stringBuffer.append("<p>No servlet engine router defined</p>\n");
                    } else {
                        stringBuffer.append("<p>No registration or metadata for system endpoint application " + string2 + "\n");
                    }
                    outputStream.write(stringBuffer.toString().getBytes());
                    outputStream.close();
                }
                sOAPResponse.finishResponse();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.soap.container.component.SOAPContainerChannelComponentImpl.errorResponse", (String)"215");
                Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)iOException);
                Object var6_7 = null;
                if (!_tc.isEntryEnabled()) return;
                Tr.exit((TraceComponent)_tc, (String)"errorResponse");
                return;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)_tc, (String)"errorResponse");
            throw throwable;
        }
        if (!_tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)_tc, (String)"errorResponse");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"initialize");
        }
        try {
            if (AdminServiceFactory.getAdminService().getProcessType().equals("DeploymentManager")) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"Disabling component in DMGR process.");
                }
                throw new ComponentDisabledException();
            }
            this.addService(SoapContainerService.class, (BeanContextServiceProvider)((Object)this));
            Tr.info((TraceComponent)_tc, (String)"soapcontainer.service");
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (_tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)_tc, (String)"initialize");
            }
            throw throwable;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"initialize");
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"start");
        }
        this.wsSysSvc = (WebServicesSystemService)this.getService(WebServicesSystemService.class);
        if (this.wsSysSvc == null) {
            Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)(this.getClass().getName() + ": Could not get service for WebServicesSystemService.class"));
            throw new RuntimeError("Cannot find WebServicesSystemService!");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"start");
        }
    }

    public void stop() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"stop");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"stop");
        }
    }
}

