/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.ibm.nio.Debug;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;
import sun.nio.ch.IOUtil;
import sun.nio.ch.SinkChannelImpl;
import sun.nio.ch.SourceChannelImpl;
import sun.nio.ch.Util;

class PipeImpl
extends Pipe {
    private Pipe.SourceChannel source;
    private Pipe.SinkChannel sink;
    private static final Debug debug = Debug.getInstance("pipe");
    private static final Random rnd;
    static /* synthetic */ Class class$sun$nio$ch$PipeImpl;

    PipeImpl(SelectorProvider selectorProvider) throws IOException {
        try {
            AccessController.doPrivileged(new Initializer(selectorProvider));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public Pipe.SourceChannel source() {
        return this.source;
    }

    public Pipe.SinkChannel sink() {
        return this.sink;
    }

    static {
        Util.load();
        byte[] byArray = new byte[8];
        boolean bl = IOUtil.randomBytes(byArray);
        rnd = bl ? new Random(ByteBuffer.wrap(byArray).getLong()) : new Random();
    }

    private class Initializer
    implements PrivilegedExceptionAction {
        private final SelectorProvider sp;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Initializer(SelectorProvider selectorProvider) {
            this.sp = selectorProvider;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object run() throws IOException {
            AbstractInterruptibleChannel abstractInterruptibleChannel = null;
            AbstractInterruptibleChannel abstractInterruptibleChannel2 = null;
            AbstractInterruptibleChannel abstractInterruptibleChannel3 = null;
            try {
                try {
                    Object object;
                    int n = 10;
                    while (n > 0) {
                        try {
                            object = InetAddress.getByName("127.0.0.1");
                            if (!$assertionsDisabled && !((InetAddress)object).isLoopbackAddress()) {
                                throw new AssertionError();
                            }
                            abstractInterruptibleChannel = ServerSocketChannel.open();
                            ((ServerSocketChannel)abstractInterruptibleChannel).socket().bind(new InetSocketAddress((InetAddress)object, 0));
                            InetSocketAddress inetSocketAddress = new InetSocketAddress((InetAddress)object, ((ServerSocketChannel)abstractInterruptibleChannel).socket().getLocalPort());
                            abstractInterruptibleChannel2 = SocketChannel.open(inetSocketAddress);
                            n = 0;
                            if (debug == null) continue;
                            debug.println("Loopback connection sucessful to port " + ((ServerSocketChannel)abstractInterruptibleChannel).socket().getLocalPort());
                        }
                        catch (ConnectException connectException) {
                            if (debug != null) {
                                debug.println("ConnectException caught while trying to connect to local host.");
                                debug.println("Port number :" + ((ServerSocketChannel)abstractInterruptibleChannel).socket().getLocalPort());
                                debug.println("Retry count :" + n);
                            }
                            if (--n != 0) continue;
                            throw connectException;
                        }
                    }
                    object = ByteBuffer.allocate(8);
                    long l = rnd.nextLong();
                    ((ByteBuffer)object).putLong(l).flip();
                    ((SocketChannel)abstractInterruptibleChannel2).write((ByteBuffer)object);
                    while (true) {
                        abstractInterruptibleChannel3 = ((ServerSocketChannel)abstractInterruptibleChannel).accept();
                        ((Buffer)object).clear();
                        ((SocketChannel)abstractInterruptibleChannel3).read((ByteBuffer)object);
                        ((Buffer)object).rewind();
                        if (((ByteBuffer)object).getLong() == l) {
                            PipeImpl.this.source = new SourceChannelImpl(this.sp, (SocketChannel)abstractInterruptibleChannel2);
                            PipeImpl.this.sink = new SinkChannelImpl(this.sp, (SocketChannel)abstractInterruptibleChannel3);
                            break;
                        }
                        abstractInterruptibleChannel3.close();
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (abstractInterruptibleChannel2 != null) {
                            abstractInterruptibleChannel2.close();
                        }
                        if (abstractInterruptibleChannel3 != null) {
                            abstractInterruptibleChannel3.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    IOException iOException3 = new IOException("Unable to establish loopback connection");
                    iOException3.initCause(iOException);
                    throw iOException3;
                }
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                try {
                    if (abstractInterruptibleChannel == null) throw throwable;
                    abstractInterruptibleChannel.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (abstractInterruptibleChannel == null) return null;
            abstractInterruptibleChannel.close();
            return null;
        }

        static {
            $assertionsDisabled = !(class$sun$nio$ch$PipeImpl == null ? (class$sun$nio$ch$PipeImpl = PipeImpl.class$("sun.nio.ch.PipeImpl")) : class$sun$nio$ch$PipeImpl).desiredAssertionStatus();
        }
    }
}

