/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;

public class Cleaner
extends PhantomReference {
    private static final ReferenceQueue dummyQueue = new ReferenceQueue();
    private static Cleaner first = null;
    private Cleaner next = null;
    private Cleaner prev = null;
    private final Runnable thunk;

    private static synchronized Cleaner add(Cleaner cleaner) {
        if (first != null) {
            cleaner.next = first;
            Cleaner.first.prev = cleaner;
        }
        first = cleaner;
        return cleaner;
    }

    private static synchronized boolean remove(Cleaner cleaner) {
        if (cleaner.next == cleaner) {
            return false;
        }
        if (first == cleaner) {
            first = cleaner.next != null ? cleaner.next : cleaner.prev;
        }
        if (cleaner.next != null) {
            cleaner.next.prev = cleaner.prev;
        }
        if (cleaner.prev != null) {
            cleaner.prev.next = cleaner.next;
        }
        cleaner.next = cleaner;
        cleaner.prev = cleaner;
        return true;
    }

    private Cleaner(Object object, Runnable runnable) {
        super(object, dummyQueue);
        this.thunk = runnable;
    }

    public static Cleaner create(Object object, Runnable runnable) {
        if (runnable == null) {
            return null;
        }
        return Cleaner.add(new Cleaner(object, runnable));
    }

    public void clean() {
        if (!Cleaner.remove(this)) {
            return;
        }
        try {
            this.thunk.run();
        }
        catch (Throwable throwable) {
            throw new Error("Cleaner terminated abnormally", throwable);
        }
    }
}

