/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import sun.util.calendar.ZoneInfo;

public class GregorianCalendar
extends Calendar {
    public static final int BC = 0;
    public static final int AD = 1;
    private static final int JAN_1_1_JULIAN_DAY = 1721426;
    private static final int EPOCH_JULIAN_DAY = 2440588;
    private static final int EPOCH_YEAR = 1970;
    private static final int[] NUM_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final int[] LEAP_NUM_DAYS = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    private static final int[] MONTH_LENGTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] LEAP_MONTH_LENGTH = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int ONE_SECOND = 1000;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    private static final int[] MIN_VALUES = new int[]{0, 1, 0, 1, 0, 1, 1, 1, -1, 0, 0, 0, 0, 0, 0, -43200000, 0};
    private static final int[] LEAST_MAX_VALUES = new int[]{1, 292269054, 11, 52, 4, 28, 365, 7, 4, 1, 11, 23, 59, 59, 999, 43200000, 3600000};
    private static final int[] MAX_VALUES = new int[]{1, 292278994, 11, 53, 6, 31, 366, 7, 6, 1, 11, 23, 59, 59, 999, 43200000, 3600000};
    private static final int CACHED_ERA = 0;
    private static final int CACHED_YEAR = 1;
    private static final int CACHED_MONTH = 2;
    private static final int CACHED_WEEK_OF_YEAR = 3;
    private static final int CACHED_WEEK_OF_MONTH = 4;
    private static final int CACHED_DATE = 5;
    private static final int CACHED_DAY_OF_YEAR = 6;
    private static final int CACHED_DAY_OF_WEEK = 7;
    private static final int CACHED_DAY_OF_WEEK_IN_MONTH = 8;
    private static final int CACHED_ZONE_OFFSET = 9;
    private static final int CACHED_DST_OFFSET = 10;
    private long gregorianCutover;
    private transient long normalizedGregorianCutover;
    private transient int gregorianCutoverYear;
    private transient int[] cachedTimeFields;
    private transient boolean isCachedTimeFieldsSet;
    private transient long cachedMidnightMillis;
    private transient long cachedLastnightMillis;
    static final long serialVersionUID = -8125100834729963327L;

    public GregorianCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public GregorianCalendar(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public GregorianCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public GregorianCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.normalizedGregorianCutover = this.gregorianCutover = -12219292800000L;
        this.gregorianCutoverYear = 1582;
        this.cachedTimeFields = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.isCachedTimeFieldsSet = false;
        this.cachedMidnightMillis = 0L;
        this.cachedLastnightMillis = 0L;
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public GregorianCalendar(int n, int n2, int n3) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.normalizedGregorianCutover = this.gregorianCutover = -12219292800000L;
        this.gregorianCutoverYear = 1582;
        this.cachedTimeFields = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.isCachedTimeFieldsSet = false;
        this.cachedMidnightMillis = 0L;
        this.cachedLastnightMillis = 0L;
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.normalizedGregorianCutover = this.gregorianCutover = -12219292800000L;
        this.gregorianCutoverYear = 1582;
        this.cachedTimeFields = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.isCachedTimeFieldsSet = false;
        this.cachedMidnightMillis = 0L;
        this.cachedLastnightMillis = 0L;
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.normalizedGregorianCutover = this.gregorianCutover = -12219292800000L;
        this.gregorianCutoverYear = 1582;
        this.cachedTimeFields = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.isCachedTimeFieldsSet = false;
        this.cachedMidnightMillis = 0L;
        this.cachedLastnightMillis = 0L;
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
        this.set(13, n6);
    }

    public void setGregorianChange(Date date) {
        this.gregorianCutover = date.getTime();
        long l = GregorianCalendar.floorDivide(this.gregorianCutover, 86400000L);
        this.normalizedGregorianCutover = l * 86400000L;
        if (l < 0L && this.normalizedGregorianCutover > 0L) {
            this.normalizedGregorianCutover = (l + 1L) * 86400000L;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
        gregorianCalendar.setTime(date);
        this.gregorianCutoverYear = gregorianCalendar.get(1);
        if (gregorianCalendar.get(0) == 0) {
            this.gregorianCutoverYear = 1 - this.gregorianCutoverYear;
        }
        this.isCachedTimeFieldsSet = false;
    }

    public final Date getGregorianChange() {
        return new Date(this.gregorianCutover);
    }

    public boolean isLeapYear(int n) {
        return n >= this.gregorianCutoverYear ? n % 4 == 0 && (n % 100 != 0 || n % 400 == 0) : n % 4 == 0;
    }

    public boolean equals(Object object) {
        return super.equals(object) && object instanceof GregorianCalendar && this.gregorianCutover == ((GregorianCalendar)object).gregorianCutover;
    }

    public int hashCode() {
        return super.hashCode() ^ (int)this.gregorianCutover;
    }

    public void add(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.complete();
        if (n == 1) {
            int n3 = this.internalGet(1);
            if (this.internalGetEra() == 1) {
                if ((n3 += n2) > 0) {
                    this.set(1, n3);
                } else {
                    this.set(1, 1 - n3);
                    this.set(0, 0);
                }
            } else if ((n3 -= n2) > 0) {
                this.set(1, n3);
            } else {
                this.set(1, 1 - n3);
                this.set(0, 1);
            }
            this.pinDayOfMonth();
        } else if (n == 2) {
            int n4 = this.internalGet(2) + n2;
            int n5 = this.internalGet(1);
            int n6 = n4 >= 0 ? n4 / 12 : (n4 + 1) / 12 - 1;
            if (n6 != 0) {
                if (this.internalGetEra() == 1) {
                    if ((n5 += n6) > 0) {
                        this.set(1, n5);
                    } else {
                        this.set(1, 1 - n5);
                        this.set(0, 0);
                    }
                } else if ((n5 -= n6) > 0) {
                    this.set(1, n5);
                } else {
                    this.set(1, 1 - n5);
                    this.set(0, 1);
                }
            }
            if (n4 >= 0) {
                this.set(2, n4 % 12);
            } else {
                if ((n4 %= 12) < 0) {
                    n4 += 12;
                }
                this.set(2, 0 + n4);
            }
            this.pinDayOfMonth();
        } else if (n == 0) {
            int n7 = this.internalGet(0) + n2;
            if (n7 < 0) {
                n7 = 0;
            }
            if (n7 > 1) {
                n7 = 1;
            }
            this.set(0, n7);
        } else {
            long l = n2;
            boolean bl = true;
            switch (n) {
                case 3: 
                case 4: 
                case 8: {
                    l *= 604800000L;
                    break;
                }
                case 9: {
                    l *= 43200000L;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    l *= 86400000L;
                    break;
                }
                case 10: 
                case 11: {
                    l *= 3600000L;
                    bl = false;
                    break;
                }
                case 12: {
                    l *= 60000L;
                    bl = false;
                    break;
                }
                case 13: {
                    l *= 1000L;
                    bl = false;
                    break;
                }
                case 14: {
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            long l2 = 0L;
            if (bl) {
                l2 = this.internalGet(16);
            }
            this.setTimeInMillis(this.time + l);
            if (bl && (l2 -= (long)this.internalGet(16)) != 0L) {
                this.setTimeInMillis(this.time + l2);
            }
        }
    }

    public void roll(int n, boolean bl) {
        this.roll(n, bl ? 1 : -1);
    }

    public void roll(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        if (n >= 0 && n < 17) {
            this.complete();
            n3 = this.getMinimum(n);
            n4 = this.getMaximum(n);
        }
        switch (n) {
            case 0: 
            case 1: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 10: 
            case 11: {
                Date date = this.getTime();
                int n5 = this.internalGet(n);
                int n6 = (n5 + n2) % (n4 + 1);
                if (n6 < 0) {
                    n6 += n4 + 1;
                }
                this.setTime(new Date(date.getTime() + (long)(3600000 * (n6 - n5))));
                return;
            }
            case 2: {
                int n7 = (this.internalGet(2) + n2) % 12;
                if (n7 < 0) {
                    n7 += 12;
                }
                this.set(2, n7);
                int n8 = this.monthLength(n7);
                int n9 = this.internalGet(5);
                if (n9 > n8) {
                    this.set(5, n8);
                }
                return;
            }
            case 3: {
                int n10 = this.internalGet(3);
                int n11 = this.internalGet(1);
                int n12 = this.internalGet(6);
                if (this.internalGet(2) == 0) {
                    if (n10 >= 52) {
                        n12 += this.yearLength(--n11);
                    }
                } else if (n10 == 1) {
                    n12 -= this.yearLength(n11);
                    ++n11;
                }
                if ((n10 += n2) < 1 || n10 > 52) {
                    int n13;
                    int n14;
                    int n15 = this.yearLength(n11);
                    int n16 = this.internalGet(7) - this.getFirstDayOfWeek();
                    if (n16 < 0) {
                        n16 += 7;
                    }
                    if ((n14 = (n15 - n12 + n16) % 7) < 0) {
                        n14 += 7;
                    }
                    if ((n15 -= n14 + 1) - (n13 = n15 / 7) * 7 >= this.getMinimalDaysInFirstWeek()) {
                        ++n13;
                    }
                    if (6 - n14 < this.getMinimalDaysInFirstWeek()) {
                        ++n13;
                    }
                    n10 = (n10 + n13 - 1) % n13 + 1;
                }
                this.set(3, n10);
                this.set(1, n11);
                return;
            }
            case 4: {
                int n17;
                int n18 = this.internalGet(7) - this.getFirstDayOfWeek();
                if (n18 < 0) {
                    n18 += 7;
                }
                if ((n17 = (n18 - this.internalGet(5) + 1) % 7) < 0) {
                    n17 += 7;
                }
                int n19 = 7 - n17 < this.getMinimalDaysInFirstWeek() ? 8 - n17 : 1 - n17;
                int n20 = this.monthLength(this.internalGet(2));
                int n21 = (n20 - this.internalGet(5) + n18) % 7;
                int n22 = n20 + 7 - n21;
                int n23 = n22 - n19;
                int n24 = (this.internalGet(5) + n2 * 7 - n19) % n23;
                if (n24 < 0) {
                    n24 += n23;
                }
                if ((n24 += n19) < 1) {
                    n24 = 1;
                }
                if (n24 > n20) {
                    n24 = n20;
                }
                this.set(5, n24);
                return;
            }
            case 5: {
                n4 = this.monthLength(this.internalGet(2));
                break;
            }
            case 6: {
                long l = (long)n2 * 86400000L;
                long l2 = this.time - (long)(this.internalGet(6) - 1) * 86400000L;
                int n25 = this.yearLength();
                this.time = (this.time + l - l2) % ((long)n25 * 86400000L);
                if (this.time < 0L) {
                    this.time += (long)n25 * 86400000L;
                }
                long l3 = this.internalGet(16);
                this.setTimeInMillis(this.time + l2);
                if ((l3 -= (long)this.internalGet(16)) != 0L) {
                    this.setTimeInMillis(this.time + l3);
                }
                return;
            }
            case 7: {
                long l = (long)n2 * 86400000L;
                int n26 = this.internalGet(7) - this.getFirstDayOfWeek();
                if (n26 < 0) {
                    n26 += 7;
                }
                long l4 = this.time - (long)n26 * 86400000L;
                this.time = (this.time + l - l4) % 604800000L;
                if (this.time < 0L) {
                    this.time += 604800000L;
                }
                long l5 = this.internalGet(16);
                this.setTimeInMillis(this.time + l4);
                if ((l5 -= (long)this.internalGet(16)) != 0L) {
                    this.setTimeInMillis(this.time + l5);
                }
                return;
            }
            case 8: {
                long l = (long)n2 * 604800000L;
                int n27 = (this.internalGet(5) - 1) / 7;
                int n28 = (this.monthLength(this.internalGet(2)) - this.internalGet(5)) / 7;
                long l6 = this.time - (long)n27 * 604800000L;
                long l7 = 604800000L * (long)(n27 + n28 + 1);
                this.time = (this.time + l - l6) % l7;
                if (this.time < 0L) {
                    this.time += l7;
                }
                long l8 = this.internalGet(16);
                this.setTimeInMillis(this.time + l6);
                if ((l8 -= (long)this.internalGet(16)) != 0L) {
                    this.setTimeInMillis(this.time + l8);
                }
                return;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int n29 = n4 - n3 + 1;
        int n30 = this.internalGet(n) + n2;
        n30 = (n30 - n3) % n29;
        if (n30 < 0) {
            n30 += n29;
        }
        this.set(n, n30 += n3);
    }

    public int getMinimum(int n) {
        return MIN_VALUES[n];
    }

    public int getMaximum(int n) {
        return MAX_VALUES[n];
    }

    public int getGreatestMinimum(int n) {
        return MIN_VALUES[n];
    }

    public int getLeastMaximum(int n) {
        return LEAST_MAX_VALUES[n];
    }

    public int getActualMinimum(int n) {
        return this.getMinimum(n);
    }

    public int getActualMaximum(int n) {
        switch (n) {
            case 5: {
                return this.monthLength(this.get(2));
            }
            case 6: {
                return this.yearLength();
            }
            case 3: 
            case 4: 
            case 8: {
                this.isCachedTimeFieldsSet = false;
                return super.getActualMaximum(n);
            }
            case 1: {
                Calendar calendar = (Calendar)this.clone();
                calendar.setLenient(true);
                int n2 = calendar.get(0);
                Date date = calendar.getTime();
                int n3 = LEAST_MAX_VALUES[1];
                int n4 = MAX_VALUES[1] + 1;
                while (n3 + 1 < n4) {
                    int n5 = (n3 + n4) / 2;
                    calendar.set(1, n5);
                    if (calendar.get(1) == n5 && calendar.get(0) == n2) {
                        n3 = n5;
                        continue;
                    }
                    n4 = n5;
                    calendar.setTime(date);
                }
                return n3;
            }
        }
        return this.getMaximum(n);
    }

    boolean inDaylightTime() {
        if (!this.getTimeZone().useDaylightTime()) {
            return false;
        }
        this.complete();
        return this.internalGet(16) != 0;
    }

    int getISOYear() {
        this.complete();
        int n = this.internalGet(3);
        int n2 = this.internalGet(1);
        if (this.internalGet(2) == 0) {
            if (n >= 52) {
                --n2;
            }
        } else if (n == 1) {
            ++n2;
        }
        return n2;
    }

    protected void computeFields() {
        this.computeFieldsImpl();
        if (this.stamp == null) {
            this.stamp = new int[17];
        }
        for (int i = 0; i < 17; ++i) {
            this.stamp[i] = 1;
            this.isSet[i] = true;
        }
    }

    private void computeFieldsImpl() {
        TimeZone timeZone = this.getTimeZone();
        int[] nArray = new int[2];
        int n = timeZone instanceof ZoneInfo ? ((ZoneInfo)timeZone).getOffsets(this.time, nArray) : timeZone.getOffsets(this.time, nArray);
        long l = this.time + (long)n;
        if (this.time > 0L && l < 0L && n > 0) {
            l = Long.MAX_VALUE;
        } else if (this.time < 0L && l > 0L && n < 0) {
            l = Long.MIN_VALUE;
        }
        this.callTimeToFields(l, false);
        long l2 = GregorianCalendar.floorDivide(l, 86400000L);
        int n2 = (int)(l - l2 * 86400000L);
        if (n2 < 0) {
            n2 = (int)((long)n2 + 86400000L);
        }
        this.internalSet(14, n2 % 1000);
        this.internalSet(13, (n2 /= 1000) % 60);
        this.internalSet(12, (n2 /= 60) % 60);
        this.internalSet(11, n2 /= 60);
        this.internalSet(9, n2 / 12);
        this.internalSet(10, n2 % 12);
        this.internalSet(15, nArray[0]);
        this.internalSet(16, nArray[1]);
        if (!this.isCachedTimeFieldsSet) {
            int n3 = 0;
            this.cachedTimeFields[0] = this.internalGet(0);
            this.cachedTimeFields[1] = this.internalGet(1);
            this.cachedTimeFields[2] = this.internalGet(2);
            this.cachedTimeFields[3] = this.internalGet(3);
            this.cachedTimeFields[4] = this.internalGet(4);
            this.cachedTimeFields[5] = this.internalGet(5);
            this.cachedTimeFields[6] = this.internalGet(6);
            this.cachedTimeFields[7] = this.internalGet(7);
            this.cachedTimeFields[8] = this.internalGet(8);
            this.cachedTimeFields[9] = this.internalGet(15);
            this.cachedTimeFields[10] = this.internalGet(16);
            n3 += (23 - this.internalGet(11)) * 60 * 60 * 1000;
            n3 += (59 - this.internalGet(12)) * 60 * 1000;
            this.cachedMidnightMillis = l + (long)(n3 += (59 - this.internalGet(13)) * 1000);
            n3 = this.internalGet(11) * 60 * 60 * 1000;
            n3 += this.internalGet(12) * 60 * 1000;
            this.cachedLastnightMillis = l - (long)(n3 += this.internalGet(13) * 1000);
            this.isCachedTimeFieldsSet = true;
        }
    }

    private final void callTimeToFields(long l, boolean bl) {
        if (!this.isCachedTimeFieldsSet || l >= this.cachedMidnightMillis || l <= this.cachedLastnightMillis || this.cachedTimeFields[9] != this.internalGet(15) || this.cachedTimeFields[10] != this.internalGet(16)) {
            this.timeToFields(l, bl);
            this.isCachedTimeFieldsSet = false;
        } else {
            this.internalSet(0, this.cachedTimeFields[0]);
            this.internalSet(1, this.cachedTimeFields[1]);
            this.internalSet(2, this.cachedTimeFields[2]);
            this.internalSet(3, this.cachedTimeFields[3]);
            this.internalSet(4, this.cachedTimeFields[4]);
            this.internalSet(5, this.cachedTimeFields[5]);
            this.internalSet(6, this.cachedTimeFields[6]);
            this.internalSet(7, this.cachedTimeFields[7]);
            this.internalSet(8, this.cachedTimeFields[8]);
        }
    }

    private final void timeToFields(long l, boolean bl) {
        int n;
        int n2;
        boolean bl2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        long l2;
        if (l >= this.normalizedGregorianCutover) {
            int n8;
            l2 = GregorianCalendar.millisToJulianDay(l) - 1721426L;
            if (l2 > 0L) {
                n8 = (int)(l2 / 146097L);
                n7 = (int)(l2 % 146097L);
                n6 = n7 / 36524;
                n5 = (n7 %= 36524) / 1461;
                n4 = (n7 %= 1461) / 365;
                n7 %= 365;
            } else {
                int[] nArray = new int[1];
                n8 = GregorianCalendar.floorDivide(l2, 146097, nArray);
                n6 = GregorianCalendar.floorDivide(nArray[0], 36524, nArray);
                n5 = GregorianCalendar.floorDivide(nArray[0], 1461, nArray);
                n4 = GregorianCalendar.floorDivide(nArray[0], 365, nArray);
                n7 = nArray[0];
            }
            n3 = 400 * n8 + 100 * n6 + 4 * n5 + n4;
            if (n6 == 4 || n4 == 4) {
                n7 = 365;
            } else {
                ++n3;
            }
            bl2 = (n3 & 3) == 0 && (n3 % 100 != 0 || n3 % 400 == 0);
            n2 = (int)((l2 + 1L) % 7L);
        } else {
            l2 = GregorianCalendar.millisToJulianDay(l) - 1721424L;
            n3 = (int)GregorianCalendar.floorDivide(4L * l2 + 1464L, 1461L);
            long l3 = 365 * (n3 - 1) + GregorianCalendar.floorDivide(n3 - 1, 4);
            n7 = (int)(l2 - l3);
            bl2 = (n3 & 3) == 0;
            n2 = (int)((l2 - 1L) % 7L);
        }
        int n9 = 0;
        int n10 = n = bl2 ? 60 : 59;
        if (n7 >= n) {
            n9 = bl2 ? 1 : 2;
        }
        int n11 = (12 * (n7 + n9) + 6) / 367;
        int n12 = n7 - (bl2 ? LEAP_NUM_DAYS[n11] : NUM_DAYS[n11]) + 1;
        n2 += n2 < 0 ? 8 : 1;
        int n13 = 1;
        int n14 = n3;
        if (n14 < 1) {
            n13 = 0;
            n14 = 1 - n14;
        }
        this.internalSet(0, n13);
        this.internalSet(1, n14);
        this.internalSet(2, n11 + 0);
        this.internalSet(5, n12);
        this.internalSet(7, n2);
        this.internalSet(6, ++n7);
        if (bl) {
            return;
        }
        int n15 = (n2 + 7 - this.getFirstDayOfWeek()) % 7;
        n6 = (n2 - n7 + 701 - this.getFirstDayOfWeek()) % 7;
        n5 = (n7 - 1 + n6) / 7;
        if (7 - n6 >= this.getMinimalDaysInFirstWeek()) {
            ++n5;
        }
        if (n7 > 359) {
            n4 = this.yearLength();
            int n16 = (n15 + n4 - n7) % 7;
            if (n16 < 0) {
                n16 += 7;
            }
            if (6 - n16 >= this.getMinimalDaysInFirstWeek() && n7 + 7 - n15 > n4) {
                n5 = 1;
            }
        } else if (n5 == 0) {
            n4 = n7 + this.yearLength(n3 - 1);
            n5 = this.weekNumber(n4, n2);
        }
        this.internalSet(3, n5);
        this.internalSet(4, this.weekNumber(n12, n2));
        this.internalSet(8, (n12 - 1) / 7 + 1);
    }

    protected void computeTime() {
        int n;
        int n2;
        int[] nArray;
        long l;
        long l2;
        boolean bl;
        if (!this.isLenient() && !this.validateFields()) {
            throw new IllegalArgumentException();
        }
        int n3 = this.stamp[1] != 0 ? this.internalGet(1) : 1970;
        int n4 = 2;
        int n5 = 1;
        if (this.stamp[0] != 0) {
            n5 = this.internalGet(0);
            n4 |= 1;
            if (n5 == 0) {
                n3 = 1 - n3;
            } else if (n5 != 1) {
                throw new IllegalArgumentException("Invalid era");
            }
        }
        if ((bl = n3 >= this.gregorianCutoverYear) != (l2 = GregorianCalendar.julianDayToMillis(l = this.computeJulianDay(bl, n3, nArray = new int[]{n4}))) >= this.normalizedGregorianCutover && l != -106749550580L) {
            nArray[0] = n4;
            l = this.computeJulianDay(!bl, n3, nArray);
            l2 = GregorianCalendar.julianDayToMillis(l);
        }
        n4 = nArray[0];
        int n6 = 0;
        int n7 = this.stamp[10];
        int n8 = this.stamp[11];
        int n9 = n2 = n7 > n8 ? n7 : n8;
        if (n2 != 0) {
            if (n2 == n8) {
                n6 += this.internalGet(11);
                n4 |= 0x800;
            } else {
                n6 += this.internalGet(10);
                n4 |= 0x400;
                if (this.stamp[9] != 0) {
                    n6 += 12 * this.internalGet(9);
                    n4 |= 0x200;
                }
            }
        }
        n6 *= 60;
        if (this.stamp[12] != 0) {
            n6 += this.internalGet(12);
            n4 |= 0x1000;
        }
        n6 *= 60;
        if (this.stamp[13] != 0) {
            n6 += this.internalGet(13);
            n4 |= 0x2000;
        }
        n6 *= 1000;
        if (this.stamp[14] != 0) {
            n6 += this.internalGet(14);
            n4 |= 0x4000;
        }
        l2 += (long)n6;
        TimeZone timeZone = this.getTimeZone();
        if (timeZone instanceof ZoneInfo) {
            int[] nArray2 = new int[2];
            ((ZoneInfo)timeZone).getOffsetsByWall(l2, nArray2);
            n = 0;
            if (this.stamp[15] >= 2) {
                n = this.internalGet(15);
                n4 |= 0x8000;
            } else {
                n = nArray2[0];
            }
            if (this.stamp[16] >= 2) {
                n += this.internalGet(16);
                n4 |= 0x10000;
            } else {
                n += nArray2[1];
            }
            this.time = l2 - (long)n;
        } else {
            int n10 = 0;
            if (this.stamp[15] >= 2) {
                n10 = this.internalGet(15);
                n4 |= 0x8000;
            } else {
                n10 = timeZone.getRawOffset();
            }
            if (this.stamp[16] >= 2) {
                this.time = l2 - (long)(n10 + this.internalGet(16));
                n4 |= 0x10000;
            } else {
                this.time = l2 - (long)timeZone.getOffsets(l2 - (long)n10, null);
            }
        }
        if (this.isLenient()) {
            this.computeFieldsImpl();
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.isSet(i)) continue;
            n = 1 << i;
            if ((n4 & n) != n) {
                this.internalClear(i);
                continue;
            }
            this.stamp[i] = 1;
            this.isSet[i] = true;
        }
    }

    private final long computeJulianDay(boolean bl, int n, int[] nArray) {
        int n2 = 0;
        int n3 = 0;
        long l = 0L;
        int n4 = nArray[0];
        int n5 = this.stamp[7];
        int n6 = this.stamp[2];
        int n7 = this.stamp[5];
        int n8 = GregorianCalendar.aggregateStamp(this.stamp[4], n5);
        int n9 = GregorianCalendar.aggregateStamp(this.stamp[8], n5);
        int n10 = this.stamp[6];
        int n11 = GregorianCalendar.aggregateStamp(this.stamp[3], n5);
        int n12 = n7;
        if (n8 > n12) {
            n12 = n8;
        }
        if (n9 > n12) {
            n12 = n9;
        }
        if (n10 > n12) {
            n12 = n10;
        }
        if (n11 > n12) {
            n12 = n11;
        }
        if (n12 == 0) {
            n8 = this.stamp[4];
            n9 = Math.max(this.stamp[8], n5);
            n11 = this.stamp[3];
            n12 = Math.max(Math.max(n8, n9), n11);
            if (n12 == 0) {
                n12 = n7 = n6;
            }
        }
        boolean bl2 = false;
        if (n12 == n7 || n12 == n8 && this.stamp[4] >= this.stamp[3] || n12 == n9 && this.stamp[8] >= this.stamp[3]) {
            bl2 = true;
            int n13 = n2 = n6 != 0 ? this.internalGet(2) - 0 : 0;
            if (n2 < 0 || n2 > 11) {
                int[] nArray2 = new int[1];
                n += GregorianCalendar.floorDivide(n2, 12, nArray2);
                n2 = nArray2[0];
            }
            n4 |= 4;
        }
        boolean bl3 = n % 4 == 0;
        int n14 = n - 1;
        long l2 = 365L * (long)n14 + (long)GregorianCalendar.floorDivide(n14, 4) + 1721423L;
        if (bl) {
            bl3 = bl3 && (n % 100 != 0 || n % 400 == 0);
            l2 += (long)(GregorianCalendar.floorDivide(n14, 400) - GregorianCalendar.floorDivide(n14, 100) + 2);
        }
        if (bl2) {
            l2 += bl3 ? (long)LEAP_NUM_DAYS[n2] : (long)NUM_DAYS[n2];
            if (n12 == n7) {
                if (this.stamp[5] != 0) {
                    n3 = this.internalGet(5);
                    n4 |= 0x20;
                } else {
                    n3 = 1;
                }
            } else {
                int n15 = GregorianCalendar.julianDayToDayOfWeek(l2 + 1L) - this.getFirstDayOfWeek();
                if (n15 < 0) {
                    n15 += 7;
                }
                int n16 = 0;
                if (n5 != 0) {
                    n16 = this.internalGet(7) - this.getFirstDayOfWeek();
                    if (n16 < 0) {
                        n16 += 7;
                    }
                    n4 |= 0x80;
                }
                n3 = 1 - n15 + n16;
                if (n12 == n8) {
                    if (7 - n15 < this.getMinimalDaysInFirstWeek()) {
                        n3 += 7;
                    }
                    n3 += 7 * (this.internalGet(4) - 1);
                    n4 |= 0x10;
                } else {
                    int n17;
                    if (n3 < 1) {
                        n3 += 7;
                    }
                    if (this.stamp[8] != 0) {
                        n17 = this.internalGet(8);
                        n4 |= 0x100;
                    } else {
                        n17 = 1;
                    }
                    n3 = n17 >= 0 ? (n3 += 7 * (n17 - 1)) : (n3 += ((this.monthLength(n2, n) - n3) / 7 + n17 + 1) * 7);
                }
            }
            l2 += (long)n3;
        } else if (n12 == n10) {
            l2 += (long)this.internalGet(6);
        } else {
            int n18 = GregorianCalendar.julianDayToDayOfWeek(l2 + 1L) - this.getFirstDayOfWeek();
            if (n18 < 0) {
                n18 += 7;
            }
            int n19 = 0;
            if (n5 != 0) {
                n19 = this.internalGet(7) - this.getFirstDayOfWeek();
                if (n19 < 0) {
                    n19 += 7;
                }
                n4 |= 0x80;
            }
            n3 = 1 - n18 + n19;
            if (7 - n18 < this.getMinimalDaysInFirstWeek()) {
                n3 += 7;
            }
            n4 |= 8;
            l2 += (long)(n3 += 7 * (this.internalGet(3) - 1));
        }
        nArray[0] = n4;
        return l2;
    }

    private static final long millisToJulianDay(long l) {
        return 2440588L + GregorianCalendar.floorDivide(l, 86400000L);
    }

    private static final long julianDayToMillis(long l) {
        return (l - 2440588L) * 86400000L;
    }

    private static final int julianDayToDayOfWeek(long l) {
        int n;
        return n + ((n = (int)((l + 1L) % 7L)) < 0 ? 8 : 1);
    }

    private static final long floorDivide(long l, long l2) {
        return l >= 0L ? l / l2 : (l + 1L) / l2 - 1L;
    }

    private static final int floorDivide(int n, int n2) {
        return n >= 0 ? n / n2 : (n + 1) / n2 - 1;
    }

    private static final int floorDivide(int n, int n2, int[] nArray) {
        if (n >= 0) {
            nArray[0] = n % n2;
            return n / n2;
        }
        int n3 = (n + 1) / n2 - 1;
        nArray[0] = n - n3 * n2;
        return n3;
    }

    private static final int floorDivide(long l, int n, int[] nArray) {
        if (l >= 0L) {
            nArray[0] = (int)(l % (long)n);
            return (int)(l / (long)n);
        }
        int n2 = (int)((l + 1L) / (long)n - 1L);
        nArray[0] = (int)(l - (long)(n2 * n));
        return n2;
    }

    private static final int aggregateStamp(int n, int n2) {
        return n != 0 && n2 != 0 ? Math.max(n, n2) : 0;
    }

    private final int weekNumber(int n, int n2) {
        int n3 = (n2 - this.getFirstDayOfWeek() - n + 1) % 7;
        if (n3 < 0) {
            n3 += 7;
        }
        int n4 = (n + n3 - 1) / 7;
        if (7 - n3 >= this.getMinimalDaysInFirstWeek()) {
            ++n4;
        }
        return n4;
    }

    private final int monthLength(int n, int n2) {
        return this.isLeapYear(n2) ? LEAP_MONTH_LENGTH[n] : MONTH_LENGTH[n];
    }

    private final int monthLength(int n) {
        int n2 = this.internalGet(1);
        if (this.internalGetEra() == 0) {
            n2 = 1 - n2;
        }
        return this.monthLength(n, n2);
    }

    private final int prevMonthLength(int n) {
        return n > 1 ? this.monthLength(n - 1) : 31;
    }

    private final int yearLength(int n) {
        return this.isLeapYear(n) ? 366 : 365;
    }

    private final int yearLength() {
        return this.isLeapYear(this.internalGet(1)) ? 366 : 365;
    }

    private final void pinDayOfMonth() {
        int n = this.monthLength(this.internalGet(2));
        int n2 = this.internalGet(5);
        if (n2 > n) {
            this.set(5, n);
        }
    }

    private boolean validateFields() {
        int n;
        for (n = 0; n < 17; ++n) {
            if (n == 5 || n == 6 || !this.isSet(n) || this.boundsCheck(this.internalGet(n), n)) continue;
            return false;
        }
        if (this.stamp[5] >= 2 && ((n = this.internalGet(5)) < this.getMinimum(5) || n > this.monthLength(this.internalGet(2)))) {
            return false;
        }
        if (this.stamp[6] >= 2 && ((n = this.internalGet(6)) < 1 || n > this.yearLength())) {
            return false;
        }
        return !this.isSet(8) || 0 != this.internalGet(8);
    }

    private final boolean boundsCheck(int n, int n2) {
        return n >= this.getMinimum(n2) && n <= this.getMaximum(n2);
    }

    private final long getEpochDay() {
        this.complete();
        long l = this.time / 1000L + (long)((this.internalGet(15) + this.internalGet(16)) / 1000);
        return GregorianCalendar.floorDivide(l, 86400L);
    }

    private final int internalGetEra() {
        return this.isSet(0) ? this.internalGet(0) : 1;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setGregorianChange(new Date(this.gregorianCutover));
        this.isCachedTimeFieldsSet = false;
        if (this.cachedTimeFields == null) {
            this.cachedTimeFields = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }
    }

    public void setFirstDayOfWeek(int n) {
        super.setFirstDayOfWeek(n);
        this.isCachedTimeFieldsSet = false;
    }

    public void setMinimalDaysInFirstWeek(int n) {
        super.setMinimalDaysInFirstWeek(n);
        this.isCachedTimeFieldsSet = false;
    }

    public Object clone() {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)super.clone();
        gregorianCalendar.cachedTimeFields = new int[11];
        for (int i = 0; i < gregorianCalendar.cachedTimeFields.length; ++i) {
            gregorianCalendar.cachedTimeFields[i] = 0;
        }
        gregorianCalendar.isCachedTimeFieldsSet = false;
        gregorianCalendar.cachedMidnightMillis = 0L;
        gregorianCalendar.cachedLastnightMillis = 0L;
        return gregorianCalendar;
    }
}

