/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Extension;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public abstract class X509Certificate
extends Certificate
implements X509Extension {
    static final long serialVersionUID = -2491127588187038216L;

    protected X509Certificate() {
        super("X.509");
    }

    public abstract void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException;

    public abstract void checkValidity(Date var1) throws CertificateExpiredException, CertificateNotYetValidException;

    public abstract int getVersion();

    public abstract BigInteger getSerialNumber();

    public abstract Principal getIssuerDN();

    public X500Principal getIssuerX500Principal() {
        X509CertImpl x509CertImpl = null;
        if (this instanceof X509CertImpl) {
            x509CertImpl = (X509CertImpl)this;
        } else {
            try {
                x509CertImpl = new X509CertImpl(this.getEncoded());
            }
            catch (CertificateException certificateException) {
                x509CertImpl = null;
            }
        }
        if (x509CertImpl != null) {
            Principal principal = x509CertImpl.getIssuerDN();
            if (principal == null) {
                throw new IllegalStateException("issuer may not be null");
            }
            try {
                return new X500Principal(((X500Name)principal).getEncoded());
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException.toString());
            }
        }
        return null;
    }

    public abstract Principal getSubjectDN();

    public X500Principal getSubjectX500Principal() {
        X509CertImpl x509CertImpl = null;
        if (this instanceof X509CertImpl) {
            x509CertImpl = (X509CertImpl)this;
        } else {
            try {
                x509CertImpl = new X509CertImpl(this.getEncoded());
            }
            catch (CertificateException certificateException) {
                x509CertImpl = null;
            }
        }
        if (x509CertImpl != null) {
            Principal principal = x509CertImpl.getSubjectDN();
            if (principal == null) {
                throw new IllegalStateException("subject may not be null");
            }
            try {
                return new X500Principal(((X500Name)principal).getEncoded());
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException.toString());
            }
        }
        return null;
    }

    public abstract Date getNotBefore();

    public abstract Date getNotAfter();

    public abstract byte[] getTBSCertificate() throws CertificateEncodingException;

    public abstract byte[] getSignature();

    public abstract String getSigAlgName();

    public abstract String getSigAlgOID();

    public abstract byte[] getSigAlgParams();

    public abstract boolean[] getIssuerUniqueID();

    public abstract boolean[] getSubjectUniqueID();

    public abstract boolean[] getKeyUsage();

    public List getExtendedKeyUsage() throws CertificateParsingException {
        return X509CertImpl.getExtendedKeyUsage((X509Certificate)this);
    }

    public abstract int getBasicConstraints();

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return X509CertImpl.getSubjectAlternativeNames((X509Certificate)this);
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return X509CertImpl.getIssuerAlternativeNames((X509Certificate)this);
    }
}

