/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PKIXParameters
implements CertPathParameters {
    private Set trustAnchors;
    private Set initialPolicies = new HashSet();
    private List certStores = new ArrayList();
    private boolean revocationEnabled;
    private boolean explicitPolicyRequired;
    private boolean policyMappingInhibited;
    private boolean policyQualifiersRejected;
    private boolean anyPolicyInhibited;
    private Date date;
    private List certPathCheckers = new ArrayList();
    private String sigProvider;
    private CertSelector targetConstraints;

    public PKIXParameters(Set set) throws InvalidAlgorithmParameterException {
        if (set == null) {
            throw new NullPointerException();
        }
        if (set.isEmpty()) {
            throw new InvalidAlgorithmParameterException();
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof TrustAnchor) continue;
            throw new ClassCastException("all elements must be java.security.cert.TrustAnchor type");
        }
        this.trustAnchors = set;
        this.initialize();
    }

    public PKIXParameters(KeyStore keyStore) throws KeyStoreException, InvalidAlgorithmParameterException {
        if (keyStore == null) {
            throw new NullPointerException();
        }
        this.trustAnchors = new HashSet();
        Enumeration enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate certificate;
            String string = (String)enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string) || !((certificate = keyStore.getCertificate(string)) instanceof X509Certificate)) continue;
            this.trustAnchors.add(new TrustAnchor((X509Certificate)certificate, null));
        }
        if (this.trustAnchors.isEmpty()) {
            throw new InvalidAlgorithmParameterException();
        }
        this.initialize();
    }

    private void initialize() {
        this.setInitialPolicies(new HashSet());
        this.setCertStores(new ArrayList());
        this.setRevocationEnabled(true);
        this.setExplicitPolicyRequired(false);
        this.setPolicyMappingInhibited(false);
        this.setPolicyQualifiersRejected(true);
        this.setDate(null);
        this.setCertPathCheckers(null);
        this.setSigProvider(null);
    }

    public Object clone() {
        PKIXParameters pKIXParameters = null;
        try {
            pKIXParameters = (PKIXParameters)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.certStores.iterator();
        while (iterator.hasNext()) {
            arrayList.add((CertStore)iterator.next());
        }
        pKIXParameters.certStores = arrayList;
        arrayList = new ArrayList();
        iterator = this.certPathCheckers.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((PKIXCertPathChecker)iterator.next()).clone());
        }
        pKIXParameters.certPathCheckers = arrayList;
        return pKIXParameters;
    }

    public CertSelector getTargetCertConstraints() {
        if (this.targetConstraints == null) {
            return null;
        }
        return (CertSelector)this.targetConstraints.clone();
    }

    public void setTargetCertConstraints(CertSelector certSelector) {
        this.targetConstraints = certSelector != null ? (CertSelector)certSelector.clone() : null;
    }

    public Set getTrustAnchors() {
        return Collections.unmodifiableSet(this.trustAnchors);
    }

    public void setTrustAnchors(Set set) throws InvalidAlgorithmParameterException {
        if (set == null) {
            throw new NullPointerException();
        }
        if (set.isEmpty()) {
            throw new InvalidAlgorithmParameterException();
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof TrustAnchor) continue;
            throw new ClassCastException("elements in trustAnchors must be java.security.cert.TrustAnchor type");
        }
        this.trustAnchors = new HashSet(set);
    }

    public Set getInitialPolicies() {
        return Collections.unmodifiableSet(new HashSet(this.initialPolicies));
    }

    public void setInitialPolicies(Set set) {
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object instanceof String) continue;
                throw new ClassCastException("all elements in initialPolicies must be String");
            }
            this.initialPolicies = new HashSet(set);
        } else {
            this.initialPolicies = new HashSet();
        }
    }

    public void setCertStores(List list) {
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object instanceof CertStore) continue;
                throw new ClassCastException("elements in stores must be java.security.cert.CertStore type");
            }
            this.certStores = new ArrayList(list);
        } else {
            this.certStores = new ArrayList();
        }
    }

    public void addCertStore(CertStore certStore) {
        if (certStore != null) {
            this.certStores.add(certStore);
        }
    }

    public List getCertStores() {
        return Collections.unmodifiableList(this.certStores);
    }

    public void setRevocationEnabled(boolean bl) {
        this.revocationEnabled = bl;
    }

    public boolean isRevocationEnabled() {
        return this.revocationEnabled;
    }

    public void setExplicitPolicyRequired(boolean bl) {
        this.explicitPolicyRequired = bl;
    }

    public boolean isExplicitPolicyRequired() {
        return this.explicitPolicyRequired;
    }

    public void setPolicyMappingInhibited(boolean bl) {
        this.policyMappingInhibited = bl;
    }

    public boolean isPolicyMappingInhibited() {
        return this.policyMappingInhibited;
    }

    public void setAnyPolicyInhibited(boolean bl) {
        this.anyPolicyInhibited = bl;
    }

    public boolean isAnyPolicyInhibited() {
        return this.anyPolicyInhibited;
    }

    public void setPolicyQualifiersRejected(boolean bl) {
        this.policyQualifiersRejected = bl;
    }

    public boolean getPolicyQualifiersRejected() {
        return this.policyQualifiersRejected;
    }

    public Date getDate() {
        return this.date != null ? (Date)this.date.clone() : null;
    }

    public void setDate(Date date) {
        this.date = date != null ? (Date)date.clone() : null;
    }

    public void setCertPathCheckers(List list) {
        this.certPathCheckers = new ArrayList();
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof PKIXCertPathChecker)) {
                    throw new ClassCastException("elements in checkers must be java.security.cert.PKIXCertPathChecker type");
                }
                this.addCertPathChecker((PKIXCertPathChecker)((PKIXCertPathChecker)object).clone());
            }
        }
    }

    public List getCertPathCheckers() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.certPathCheckers.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((PKIXCertPathChecker)iterator.next()).clone());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void addCertPathChecker(PKIXCertPathChecker pKIXCertPathChecker) {
        if (pKIXCertPathChecker != null) {
            this.certPathCheckers.add(pKIXCertPathChecker.clone());
        }
    }

    public String getSigProvider() {
        return this.sigProvider;
    }

    public void setSigProvider(String string) {
        this.sigProvider = string;
    }

    public String toString() {
        return "PKIXParameters:[\n  Trust Anchors:\t" + this.trustAnchors + "\n" + "  Initial Policies:\t" + this.initialPolicies + "\n" + "  Any Policy Inhibited: \t" + this.anyPolicyInhibited + "\n" + "  CertStore List:\t" + this.certStores + "\n" + "  Revocation Enabled:\t" + this.revocationEnabled + "\n" + "  Explicit Policy Required:\t" + this.explicitPolicyRequired + "\n" + "  Policy Mapping Inhibited:\t" + this.policyMappingInhibited + "\n" + "  Policy Qualifiers Rejected:\t" + this.policyQualifiersRejected + "\n" + "  Date:\t" + this.date + "\n" + "  Certification Path Checkers:\t" + this.certPathCheckers + "\n" + "  Signature provider: \t" + this.sigProvider + "\n" + "  TargetCertConstraints: \t" + this.targetConstraints + "\n]";
    }
}

