/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;
import sun.security.action.GetPropertyAction;
import sun.security.util.SecurityConstants;

public class ProtectionDomain {
    private CodeSource codesource;
    private ClassLoader classloader;
    private Principal[] principals;
    private PermissionCollection permissions;
    private boolean staticPermissions;
    private boolean loopingToString = false;

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection) {
        this.codesource = codeSource;
        if (permissionCollection != null) {
            this.permissions = permissionCollection;
            this.permissions.setReadOnly();
        }
        this.classloader = null;
        this.principals = new Principal[0];
        this.staticPermissions = true;
    }

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection, ClassLoader classLoader, Principal[] principalArray) {
        this.codesource = codeSource;
        if (permissionCollection != null) {
            this.permissions = permissionCollection;
            this.permissions.setReadOnly();
        }
        this.classloader = classLoader;
        this.principals = principalArray != null ? (Principal[])principalArray.clone() : new Principal[]{};
        this.staticPermissions = false;
    }

    public final CodeSource getCodeSource() {
        return this.codesource;
    }

    public final ClassLoader getClassLoader() {
        return this.classloader;
    }

    public final Principal[] getPrincipals() {
        return (Principal[])this.principals.clone();
    }

    public final PermissionCollection getPermissions() {
        return this.permissions;
    }

    public boolean implies(Permission permission) {
        if (!this.staticPermissions && Policy.getPolicyNoCheck().implies(this, permission)) {
            return true;
        }
        if (this.permissions != null) {
            return this.permissions.implies(permission);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        CharSequence charSequence;
        String string = "<no principals>";
        if (this.principals != null && this.principals.length > 0) {
            charSequence = new StringBuffer("(principals ");
            for (int i = 0; i < this.principals.length; ++i) {
                ((StringBuffer)charSequence).append(this.principals[i].getClass().getName() + " \"" + this.principals[i].getName() + "\"");
                if (i < this.principals.length - 1) {
                    ((StringBuffer)charSequence).append(",\n");
                    continue;
                }
                ((StringBuffer)charSequence).append(")\n");
            }
            string = ((StringBuffer)charSequence).toString();
        }
        ProtectionDomain protectionDomain = this;
        synchronized (protectionDomain) {
            if (this.loopingToString) {
                charSequence = "<permissions not available>";
            } else {
                this.loopingToString = true;
                PermissionCollection permissionCollection = Policy.isSet() && this.seeAllp() ? this.mergePermissions() : this.getPermissions();
                charSequence = permissionCollection == null ? "null" : permissionCollection.toString();
                this.loopingToString = false;
            }
        }
        return "ProtectionDomain  " + this.codesource + "\n" + " " + this.classloader + "\n" + " " + string + "\n" + " " + (String)charSequence + "\n";
    }

    private boolean seeAllp() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("java.security.debug"));
            if (string != null) {
                return true;
            }
            try {
                securityManager.checkPermission(SecurityConstants.GET_POLICY_PERMISSION);
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return true;
    }

    private PermissionCollection mergePermissions() {
        Permission permission;
        Enumeration enumeration;
        if (this.staticPermissions) {
            return this.permissions;
        }
        PermissionCollection permissionCollection = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Policy policy = Policy.getPolicyNoCheck();
                return policy.getPermissions(ProtectionDomain.this);
            }
        });
        Permissions permissions = new Permissions();
        int n = 32;
        int n2 = 8;
        Vector vector = new Vector(n2);
        Vector vector2 = new Vector(n);
        if (this.permissions != null) {
            enumeration = this.permissions.elements();
            while (enumeration.hasMoreElements()) {
                permission = (Permission)enumeration.nextElement();
                vector.add(permission);
            }
        }
        if (permissionCollection != null) {
            enumeration = permissionCollection.elements();
            while (enumeration.hasMoreElements()) {
                vector2.add(enumeration.nextElement());
                ++n2;
            }
        }
        if (permissionCollection != null && this.permissions != null) {
            enumeration = this.permissions.elements();
            block2: while (enumeration.hasMoreElements()) {
                permission = (Permission)enumeration.nextElement();
                for (int i = 0; i < vector2.size(); ++i) {
                    Permission permission2 = (Permission)vector2.elementAt(i);
                    if (!permission.getClass().isInstance(permission2) || !permission.getName().equals(permission2.getName()) || !permission.getActions().equals(permission2.getActions())) continue;
                    vector2.remove(i);
                    continue block2;
                }
            }
        }
        if (permissionCollection != null) {
            for (int i = vector2.size() - 1; i >= 0; --i) {
                permissions.add((Permission)vector2.elementAt(i));
            }
        }
        if (this.permissions != null) {
            for (int i = vector.size() - 1; i >= 0; --i) {
                permissions.add((Permission)vector.elementAt(i));
            }
        }
        return permissions;
    }
}

