/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import com.ibm.jvm.ExtendedSystem;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import sun.reflect.ConstructorAccessor;
import sun.reflect.Reflection;

public final class Constructor
extends AccessibleObject
implements Member {
    private Class clazz;
    private long slot;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;
    private int modifiers;
    private volatile ConstructorAccessor constructorAccessor;
    private Constructor root;

    Constructor(Class clazz, Class[] classArray, Class[] classArray2, int n, long l) {
        this.clazz = clazz;
        if (ExtendedSystem.isResettableJVM()) {
            this.parameterTypes = new Class[classArray.length];
            System.arraycopy(classArray, 0, this.parameterTypes, 0, classArray.length);
            this.exceptionTypes = new Class[classArray2.length];
            System.arraycopy(classArray2, 0, this.exceptionTypes, 0, classArray2.length);
        } else {
            this.parameterTypes = classArray;
            this.exceptionTypes = classArray2;
        }
        this.modifiers = n;
        this.slot = l;
    }

    Constructor copy() {
        Constructor constructor = new Constructor(this.clazz, this.parameterTypes, this.exceptionTypes, this.modifiers, this.slot);
        if (!ExtendedSystem.isResettableJVM()) {
            constructor.root = this;
            constructor.constructorAccessor = this.constructorAccessor;
        }
        return constructor;
    }

    public Class getDeclaringClass() {
        return this.clazz;
    }

    public String getName() {
        return this.getDeclaringClass().getName();
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Class[] getParameterTypes() {
        return Method.copy(this.parameterTypes);
    }

    public Class[] getExceptionTypes() {
        return Method.copy(this.exceptionTypes);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Constructor) {
            Class[] classArray;
            Class[] classArray2;
            Constructor constructor = (Constructor)object;
            if (this.getDeclaringClass() == constructor.getDeclaringClass() && (classArray2 = this.parameterTypes).length == (classArray = constructor.parameterTypes).length) {
                for (int i = 0; i < classArray2.length; ++i) {
                    if (classArray2[i] == classArray[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode();
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.getModifiers();
            if (n != 0) {
                stringBuffer.append(Modifier.toString(n) + " ");
            }
            stringBuffer.append(Field.getTypeName(this.getDeclaringClass()));
            stringBuffer.append("(");
            Class[] classArray = this.parameterTypes;
            for (int i = 0; i < classArray.length; ++i) {
                stringBuffer.append(Field.getTypeName(classArray[i]));
                if (i >= classArray.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
            Class[] classArray2 = this.exceptionTypes;
            if (classArray2.length > 0) {
                stringBuffer.append(" throws ");
                for (int i = 0; i < classArray2.length; ++i) {
                    stringBuffer.append(classArray2[i].getName());
                    if (i >= classArray2.length - 1) continue;
                    stringBuffer.append(",");
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    public Object newInstance(Object[] objectArray) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class clazz;
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.newInstance0(objectArray);
        }
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers) && this.securityCheckCache != (clazz = Reflection.getCallerClass(2))) {
            Reflection.ensureMemberAccess(clazz, this.clazz, null, this.modifiers);
            this.securityCheckCache = clazz;
        }
        if (this.constructorAccessor == null) {
            this.acquireConstructorAccessor();
        }
        return this.constructorAccessor.newInstance(objectArray);
    }

    private native Object newInstance0(Object[] var1) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    private void acquireConstructorAccessor() {
        ConstructorAccessor constructorAccessor = null;
        if (this.root != null) {
            constructorAccessor = this.root.getConstructorAccessor();
        }
        if (constructorAccessor != null) {
            this.constructorAccessor = constructorAccessor;
            return;
        }
        constructorAccessor = reflectionFactory.newConstructorAccessor(this);
        this.setConstructorAccessor(constructorAccessor);
    }

    ConstructorAccessor getConstructorAccessor() {
        return this.constructorAccessor;
    }

    void setConstructorAccessor(ConstructorAccessor constructorAccessor) {
        this.constructorAccessor = constructorAccessor;
        if (this.root != null) {
            this.root.setConstructorAccessor(constructorAccessor);
        }
    }

    long getSlot() {
        return this.slot;
    }
}

