/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import com.ibm.jvm.ExtendedSystem;
import java.lang.reflect.Constructor;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import sun.reflect.ReflectionFactory;

public class AccessibleObject {
    private static final Permission ACCESS_PERMISSION = new ReflectPermission("suppressAccessChecks");
    volatile Class securityCheckCache;
    boolean override;
    static final ReflectionFactory reflectionFactory = (ReflectionFactory)AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());

    public static void setAccessible(AccessibleObject[] accessibleObjectArray, boolean bl) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ACCESS_PERMISSION);
        }
        for (int i = 0; i < accessibleObjectArray.length; ++i) {
            AccessibleObject.setAccessible0(accessibleObjectArray[i], bl);
        }
        ExtendedSystem.setJVMUnresettableConditionally(131077, new String("Set accessibility using AccessibleObject.setAccessible()"));
    }

    public void setAccessible(boolean bl) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ACCESS_PERMISSION);
        }
        AccessibleObject.setAccessible0(this, bl);
        ExtendedSystem.setJVMUnresettableConditionally(131077, new String("Set accessibility using AccessibleObject.setAccessible()"));
    }

    private static void setAccessible0(AccessibleObject accessibleObject, boolean bl) throws SecurityException {
        Constructor constructor;
        if (accessibleObject instanceof Constructor && bl && (constructor = (Constructor)accessibleObject).getDeclaringClass() == Class.class) {
            throw new SecurityException("Can not make a java.lang.Class constructor accessible");
        }
        accessibleObject.override = bl;
    }

    public boolean isAccessible() {
        return this.override;
    }

    protected AccessibleObject() {
    }
}

