/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import com.ibm.jvm.ExtendedSystem;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.GenericBeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;

public class Introspector {
    public static final int USE_ALL_BEANINFO = 1;
    public static final int IGNORE_IMMEDIATE_BEANINFO = 2;
    public static final int IGNORE_ALL_BEANINFO = 3;
    private static Map declaredMethodCache = Collections.synchronizedMap(new WeakHashMap(100));
    private static Map beanInfoCache = Collections.synchronizedMap(new WeakHashMap(100));
    private Class beanClass;
    private BeanInfo explicitBeanInfo;
    private BeanInfo superBeanInfo;
    private BeanInfo[] additionalBeanInfo;
    private boolean propertyChangeSource = false;
    private static Class eventListenerType = EventListener.class;
    private String defaultEventName;
    private String defaultPropertyName;
    private int defaultEventIndex = -1;
    private int defaultPropertyIndex = -1;
    private Map methods = new TreeMap();
    private Map properties = new TreeMap();
    private Map events = new TreeMap();
    private static final String DEFAULT_INFO_PATH = "sun.beans.infos";
    private static String[] searchPath = new String[]{"sun.beans.infos"};
    private static final String ADD_PREFIX = "add";
    private static final String REMOVE_PREFIX = "remove";
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private static final String BEANINFO_SUFFIX = "BeanInfo";
    private HashMap pdStore;
    static /* synthetic */ Class class$java$beans$PropertyVetoException;
    static /* synthetic */ Class class$java$util$TooManyListenersException;

    public static BeanInfo getBeanInfo(Class clazz) throws IntrospectionException {
        GenericBeanInfo genericBeanInfo = (GenericBeanInfo)beanInfoCache.get(clazz);
        if (genericBeanInfo == null) {
            genericBeanInfo = new Introspector(clazz, null, 1).getBeanInfo();
            beanInfoCache.put(clazz, genericBeanInfo);
        }
        return genericBeanInfo;
    }

    public static BeanInfo getBeanInfo(Class clazz, int n) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz, null, n);
    }

    public static BeanInfo getBeanInfo(Class clazz, Class clazz2) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz, clazz2, 1);
    }

    private static BeanInfo getBeanInfo(Class clazz, Class clazz2, int n) throws IntrospectionException {
        GenericBeanInfo genericBeanInfo = clazz2 == null && n == 1 ? (GenericBeanInfo)Introspector.getBeanInfo(clazz) : new Introspector(clazz, clazz2, n).getBeanInfo();
        return genericBeanInfo;
    }

    public static String decapitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1)) && Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    public static synchronized String[] getBeanInfoSearchPath() {
        String[] stringArray = new String[searchPath.length];
        for (int i = 0; i < searchPath.length; ++i) {
            stringArray[i] = searchPath[i];
        }
        return stringArray;
    }

    public static synchronized void setBeanInfoSearchPath(String[] stringArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        searchPath = stringArray;
        ExtendedSystem.setJVMUnresettableConditionally(131073, new String("Modified searchPath in Introspector.setBeanInfoSearchPath()"));
    }

    public static void flushCaches() {
        beanInfoCache.clear();
        declaredMethodCache.clear();
    }

    public static void flushFromCaches(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        beanInfoCache.remove(clazz);
        declaredMethodCache.remove(clazz);
    }

    private Introspector(Class clazz, Class clazz2, int n) throws IntrospectionException {
        Class clazz3;
        this.beanClass = clazz;
        if (clazz2 != null) {
            boolean bl = false;
            for (Class clazz4 = clazz.getSuperclass(); clazz4 != null; clazz4 = clazz4.getSuperclass()) {
                if (clazz4 != clazz2) continue;
                bl = true;
            }
            if (!bl) {
                throw new IntrospectionException(clazz2.getName() + " not superclass of " + clazz.getName());
            }
        }
        if (n == 1) {
            this.explicitBeanInfo = Introspector.findExplicitBeanInfo(clazz);
        }
        if ((clazz3 = clazz.getSuperclass()) != clazz2) {
            int n2 = n;
            if (n2 == 2) {
                n2 = 1;
            }
            this.superBeanInfo = Introspector.getBeanInfo(clazz3, clazz2, n2);
        }
        if (this.explicitBeanInfo != null) {
            this.additionalBeanInfo = this.explicitBeanInfo.getAdditionalBeanInfo();
        }
        if (this.additionalBeanInfo == null) {
            this.additionalBeanInfo = new BeanInfo[0];
        }
    }

    private GenericBeanInfo getBeanInfo() throws IntrospectionException {
        BeanDescriptor beanDescriptor = this.getTargetBeanDescriptor();
        MethodDescriptor[] methodDescriptorArray = this.getTargetMethodInfo();
        EventSetDescriptor[] eventSetDescriptorArray = this.getTargetEventInfo();
        PropertyDescriptor[] propertyDescriptorArray = this.getTargetPropertyInfo();
        int n = this.getTargetDefaultEventIndex();
        int n2 = this.getTargetDefaultPropertyIndex();
        return new GenericBeanInfo(beanDescriptor, eventSetDescriptorArray, n, propertyDescriptorArray, n2, methodDescriptorArray, this.explicitBeanInfo);
    }

    private static synchronized BeanInfo findExplicitBeanInfo(Class clazz) {
        String string = clazz.getName() + BEANINFO_SUFFIX;
        try {
            return (BeanInfo)Introspector.instantiate(clazz, string);
        }
        catch (Exception exception) {
            try {
                if (Introspector.isSubclass(clazz, BeanInfo.class)) {
                    return (BeanInfo)clazz.newInstance();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            string = string.substring(string.lastIndexOf(46) + 1);
            for (int i = 0; i < searchPath.length; ++i) {
                if (DEFAULT_INFO_PATH.equals(searchPath[i]) && (!DEFAULT_INFO_PATH.equals(searchPath[i]) || !"ComponentBeanInfo".equals(string))) continue;
                try {
                    Method method;
                    int n;
                    FeatureDescriptor[] featureDescriptorArray;
                    String string2 = searchPath[i] + "." + string;
                    BeanInfo beanInfo = (BeanInfo)Introspector.instantiate(clazz, string2);
                    if (beanInfo.getBeanDescriptor() != null) {
                        if (beanInfo.getBeanDescriptor().getBeanClass() != clazz) continue;
                        return beanInfo;
                    }
                    if (beanInfo.getPropertyDescriptors() != null) {
                        featureDescriptorArray = beanInfo.getPropertyDescriptors();
                        for (n = 0; n < featureDescriptorArray.length; ++n) {
                            method = ((PropertyDescriptor)featureDescriptorArray[n]).getReadMethod();
                            if (method.getDeclaringClass() != clazz) continue;
                            return beanInfo;
                        }
                        continue;
                    }
                    if (beanInfo.getMethodDescriptors() == null) continue;
                    featureDescriptorArray = beanInfo.getMethodDescriptors();
                    for (n = 0; n < featureDescriptorArray.length; ++n) {
                        method = ((MethodDescriptor)featureDescriptorArray[n]).getMethod();
                        if (method.getDeclaringClass() != clazz) continue;
                        return beanInfo;
                    }
                    continue;
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private PropertyDescriptor[] getTargetPropertyInfo() throws IntrospectionException {
        int n;
        int n2;
        PropertyDescriptor[] propertyDescriptorArray = null;
        if (this.explicitBeanInfo != null) {
            propertyDescriptorArray = this.explicitBeanInfo.getPropertyDescriptors();
            n2 = this.explicitBeanInfo.getDefaultPropertyIndex();
            if (n2 >= 0 && n2 < propertyDescriptorArray.length) {
                this.defaultPropertyName = propertyDescriptorArray[n2].getName();
            }
        }
        if (propertyDescriptorArray == null && this.superBeanInfo != null) {
            PropertyDescriptor[] propertyDescriptorArray2 = this.superBeanInfo.getPropertyDescriptors();
            for (n = 0; n < propertyDescriptorArray2.length; ++n) {
                this.addPropertyDescriptor(propertyDescriptorArray2[n]);
            }
            n = this.superBeanInfo.getDefaultPropertyIndex();
            if (n >= 0 && n < propertyDescriptorArray2.length) {
                this.defaultPropertyName = propertyDescriptorArray2[n].getName();
            }
        }
        for (n2 = 0; n2 < this.additionalBeanInfo.length; ++n2) {
            PropertyDescriptor[] propertyDescriptorArray3 = this.additionalBeanInfo[n2].getPropertyDescriptors();
            if (propertyDescriptorArray3 == null) continue;
            for (int i = 0; i < propertyDescriptorArray3.length; ++i) {
                this.addPropertyDescriptor(propertyDescriptorArray3[i]);
            }
        }
        if (propertyDescriptorArray != null) {
            for (n2 = 0; n2 < propertyDescriptorArray.length; ++n2) {
                this.addPropertyDescriptor(propertyDescriptorArray[n2]);
            }
        } else {
            Method[] methodArray = Introspector.getPublicDeclaredMethods(this.beanClass);
            for (n = 0; n < methodArray.length; ++n) {
                int n3;
                Method method = methodArray[n];
                if (method == null || Modifier.isStatic(n3 = method.getModifiers())) continue;
                String string = method.getName();
                Class[] classArray = method.getParameterTypes();
                Class clazz = method.getReturnType();
                int n4 = classArray.length;
                PropertyDescriptor propertyDescriptor = null;
                try {
                    if (n4 == 0) {
                        if (string.startsWith(GET_PREFIX)) {
                            propertyDescriptor = new PropertyDescriptor(Introspector.decapitalize(string.substring(3)), method, null);
                        } else if (clazz == Boolean.TYPE && string.startsWith(IS_PREFIX)) {
                            propertyDescriptor = new PropertyDescriptor(Introspector.decapitalize(string.substring(2)), method, null);
                        }
                    } else if (n4 == 1) {
                        if (classArray[0] == Integer.TYPE && string.startsWith(GET_PREFIX)) {
                            propertyDescriptor = new IndexedPropertyDescriptor(Introspector.decapitalize(string.substring(3)), null, null, method, null);
                        } else if (clazz == Void.TYPE && string.startsWith(SET_PREFIX)) {
                            propertyDescriptor = new PropertyDescriptor(Introspector.decapitalize(string.substring(3)), null, method);
                            if (this.throwsException(method, class$java$beans$PropertyVetoException == null ? Introspector.class$("java.beans.PropertyVetoException") : class$java$beans$PropertyVetoException)) {
                                propertyDescriptor.setConstrained(true);
                            }
                        }
                    } else if (n4 == 2 && classArray[0] == Integer.TYPE && string.startsWith(SET_PREFIX)) {
                        propertyDescriptor = new IndexedPropertyDescriptor(Introspector.decapitalize(string.substring(3)), null, null, null, method);
                        if (this.throwsException(method, class$java$beans$PropertyVetoException == null ? Introspector.class$("java.beans.PropertyVetoException") : class$java$beans$PropertyVetoException)) {
                            propertyDescriptor.setConstrained(true);
                        }
                    }
                }
                catch (IntrospectionException introspectionException) {
                    propertyDescriptor = null;
                }
                if (propertyDescriptor == null) continue;
                if (this.propertyChangeSource) {
                    propertyDescriptor.setBound(true);
                }
                this.addPropertyDescriptor(propertyDescriptor);
            }
        }
        this.processPropertyDescriptors();
        Object[] objectArray = new PropertyDescriptor[this.properties.size()];
        objectArray = (PropertyDescriptor[])this.properties.values().toArray(objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            if (this.defaultPropertyName == null || !this.defaultPropertyName.equals(((FeatureDescriptor)objectArray[n]).getName())) continue;
            this.defaultPropertyIndex = n;
        }
        return objectArray;
    }

    private void addPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        String string;
        List list;
        if (this.pdStore == null) {
            this.pdStore = new HashMap();
        }
        if ((list = (List)this.pdStore.get(string = propertyDescriptor.getName())) == null) {
            list = new ArrayList();
            this.pdStore.put(string, list);
        }
        list.add(propertyDescriptor);
    }

    private void processPropertyDescriptors() {
        if (this.pdStore == null) {
            return;
        }
        Iterator iterator = this.pdStore.values().iterator();
        while (iterator.hasNext()) {
            int n;
            PropertyDescriptor propertyDescriptor = null;
            PropertyDescriptor propertyDescriptor2 = null;
            PropertyDescriptor propertyDescriptor3 = null;
            IndexedPropertyDescriptor indexedPropertyDescriptor = null;
            IndexedPropertyDescriptor indexedPropertyDescriptor2 = null;
            IndexedPropertyDescriptor indexedPropertyDescriptor3 = null;
            List list = (List)iterator.next();
            for (n = 0; n < list.size(); ++n) {
                propertyDescriptor = (PropertyDescriptor)list.get(n);
                if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
                    indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor;
                    if (indexedPropertyDescriptor.getIndexedReadMethod() == null) continue;
                    if (indexedPropertyDescriptor2 != null) {
                        indexedPropertyDescriptor2 = new IndexedPropertyDescriptor(indexedPropertyDescriptor2, indexedPropertyDescriptor);
                        continue;
                    }
                    indexedPropertyDescriptor2 = indexedPropertyDescriptor;
                    continue;
                }
                if (propertyDescriptor.getReadMethod() == null) continue;
                if (propertyDescriptor2 != null) {
                    Method method = propertyDescriptor2.getReadMethod();
                    if (method.getName().startsWith(IS_PREFIX)) continue;
                    propertyDescriptor2 = new PropertyDescriptor(propertyDescriptor2, propertyDescriptor);
                    continue;
                }
                propertyDescriptor2 = propertyDescriptor;
            }
            for (n = 0; n < list.size(); ++n) {
                propertyDescriptor = (PropertyDescriptor)list.get(n);
                if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
                    indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor;
                    if (indexedPropertyDescriptor.getIndexedWriteMethod() == null) continue;
                    if (indexedPropertyDescriptor2 != null) {
                        if (indexedPropertyDescriptor2.getIndexedPropertyType() != indexedPropertyDescriptor.getIndexedPropertyType()) continue;
                        if (indexedPropertyDescriptor3 != null) {
                            indexedPropertyDescriptor3 = new IndexedPropertyDescriptor(indexedPropertyDescriptor3, indexedPropertyDescriptor);
                            continue;
                        }
                        indexedPropertyDescriptor3 = indexedPropertyDescriptor;
                        continue;
                    }
                    if (indexedPropertyDescriptor3 != null) {
                        indexedPropertyDescriptor3 = new IndexedPropertyDescriptor(indexedPropertyDescriptor3, indexedPropertyDescriptor);
                        continue;
                    }
                    indexedPropertyDescriptor3 = indexedPropertyDescriptor;
                    continue;
                }
                if (propertyDescriptor.getWriteMethod() == null) continue;
                if (propertyDescriptor2 != null) {
                    if (propertyDescriptor2.getPropertyType() != propertyDescriptor.getPropertyType()) continue;
                    if (propertyDescriptor3 != null) {
                        propertyDescriptor3 = new PropertyDescriptor(propertyDescriptor3, propertyDescriptor);
                        continue;
                    }
                    propertyDescriptor3 = propertyDescriptor;
                    continue;
                }
                propertyDescriptor3 = propertyDescriptor3 != null ? new PropertyDescriptor(propertyDescriptor3, propertyDescriptor) : propertyDescriptor;
            }
            propertyDescriptor = null;
            indexedPropertyDescriptor = null;
            if (indexedPropertyDescriptor2 != null && indexedPropertyDescriptor3 != null) {
                if (propertyDescriptor2 != null && (propertyDescriptor2.getPropertyType().isArray() || propertyDescriptor2.getPropertyType().equals(indexedPropertyDescriptor2.getIndexedPropertyType()))) {
                    indexedPropertyDescriptor2 = new IndexedPropertyDescriptor(propertyDescriptor2, indexedPropertyDescriptor2);
                }
                if (propertyDescriptor3 != null && (propertyDescriptor3.getPropertyType().isArray() || propertyDescriptor3.getPropertyType().equals(indexedPropertyDescriptor3.getIndexedPropertyType()))) {
                    indexedPropertyDescriptor3 = new IndexedPropertyDescriptor(propertyDescriptor3, indexedPropertyDescriptor3);
                }
                propertyDescriptor = new IndexedPropertyDescriptor(indexedPropertyDescriptor2, indexedPropertyDescriptor3);
            } else if (propertyDescriptor2 != null && propertyDescriptor3 != null) {
                propertyDescriptor = new PropertyDescriptor(propertyDescriptor2, propertyDescriptor3);
            } else if (indexedPropertyDescriptor3 != null) {
                if (propertyDescriptor3 != null) {
                    indexedPropertyDescriptor3 = new IndexedPropertyDescriptor(propertyDescriptor3, indexedPropertyDescriptor3);
                }
                if (propertyDescriptor2 != null) {
                    indexedPropertyDescriptor3 = new IndexedPropertyDescriptor(propertyDescriptor2, indexedPropertyDescriptor3);
                }
                propertyDescriptor = indexedPropertyDescriptor3;
            } else if (indexedPropertyDescriptor2 != null) {
                if (propertyDescriptor2 != null) {
                    indexedPropertyDescriptor2 = new IndexedPropertyDescriptor(propertyDescriptor2, indexedPropertyDescriptor2);
                }
                if (propertyDescriptor3 != null) {
                    indexedPropertyDescriptor2 = new IndexedPropertyDescriptor(propertyDescriptor3, indexedPropertyDescriptor2);
                }
                propertyDescriptor = indexedPropertyDescriptor2;
            } else if (propertyDescriptor3 != null) {
                propertyDescriptor = propertyDescriptor3;
            } else if (propertyDescriptor2 != null) {
                propertyDescriptor = propertyDescriptor2;
            }
            if (propertyDescriptor instanceof IndexedPropertyDescriptor && ((indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor).getIndexedReadMethod() == null || indexedPropertyDescriptor.getIndexedWriteMethod() == null) && indexedPropertyDescriptor.getReadMethod() != null && indexedPropertyDescriptor.getWriteMethod() != null) {
                propertyDescriptor = new PropertyDescriptor(indexedPropertyDescriptor);
            }
            if (propertyDescriptor == null) continue;
            this.properties.put(propertyDescriptor.getName(), propertyDescriptor);
        }
    }

    private EventSetDescriptor[] getTargetEventInfo() throws IntrospectionException {
        int n;
        EventSetDescriptor[] eventSetDescriptorArray = null;
        if (this.explicitBeanInfo != null) {
            eventSetDescriptorArray = this.explicitBeanInfo.getEventSetDescriptors();
            n = this.explicitBeanInfo.getDefaultEventIndex();
            if (n >= 0 && n < eventSetDescriptorArray.length) {
                this.defaultEventName = eventSetDescriptorArray[n].getName();
            }
        }
        if (eventSetDescriptorArray == null && this.superBeanInfo != null) {
            int n2;
            EventSetDescriptor[] eventSetDescriptorArray2 = this.superBeanInfo.getEventSetDescriptors();
            for (n2 = 0; n2 < eventSetDescriptorArray2.length; ++n2) {
                this.addEvent(eventSetDescriptorArray2[n2]);
            }
            n2 = this.superBeanInfo.getDefaultEventIndex();
            if (n2 >= 0 && n2 < eventSetDescriptorArray2.length) {
                this.defaultEventName = eventSetDescriptorArray2[n2].getName();
            }
        }
        for (n = 0; n < this.additionalBeanInfo.length; ++n) {
            EventSetDescriptor[] eventSetDescriptorArray3 = this.additionalBeanInfo[n].getEventSetDescriptors();
            if (eventSetDescriptorArray3 == null) continue;
            for (int i = 0; i < eventSetDescriptorArray3.length; ++i) {
                this.addEvent(eventSetDescriptorArray3[i]);
            }
        }
        if (eventSetDescriptorArray != null) {
            for (n = 0; n < eventSetDescriptorArray.length; ++n) {
                this.addEvent(eventSetDescriptorArray[n]);
            }
        } else {
            Object object;
            Object object2;
            Object object3;
            String string;
            Object object4;
            Method[] methodArray = Introspector.getPublicDeclaredMethods(this.beanClass);
            HashMap hashMap = new HashMap(methodArray.length);
            HashMap hashMap2 = new HashMap(methodArray.length);
            HashMap hashMap3 = new HashMap(methodArray.length);
            for (int i = 0; i < methodArray.length; ++i) {
                int n3;
                object4 = methodArray[i];
                if (object4 == null || Modifier.isStatic(n3 = ((Method)object4).getModifiers())) continue;
                string = ((Method)object4).getName();
                object3 = ((Method)object4).getParameterTypes();
                object2 = ((Method)object4).getReturnType();
                if (string.startsWith(ADD_PREFIX) && ((Class[])object3).length == 1 && object2 == Void.TYPE && Introspector.isSubclass(object3[0], eventListenerType)) {
                    object = string.substring(3);
                    if (((String)object).length() <= 0 || !((Class)object3[0]).getName().endsWith((String)object)) continue;
                    hashMap.put(object, object4);
                    continue;
                }
                if (string.startsWith(REMOVE_PREFIX) && ((Class[])object3).length == 1 && object2 == Void.TYPE && Introspector.isSubclass(object3[0], eventListenerType)) {
                    object = string.substring(6);
                    if (((String)object).length() <= 0 || !((Class)object3[0]).getName().endsWith((String)object)) continue;
                    hashMap2.put(object, object4);
                    continue;
                }
                if (!string.startsWith(GET_PREFIX) || ((Class[])object3).length != 0 || !((Class)object2).isArray() || !Introspector.isSubclass(((Class)object2).getComponentType(), eventListenerType) || ((String)(object = string.substring(3, string.length() - 1))).length() <= 0 || !((Class)object2).getComponentType().getName().endsWith((String)object)) continue;
                hashMap3.put(object, object4);
            }
            Iterator iterator = hashMap.keySet().iterator();
            object4 = this.beanClass.getName();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (hashMap2.get(string2) == null) continue;
                string = Introspector.decapitalize(string2.substring(0, string2.length() - 8));
                object3 = (Method)hashMap.get(string2);
                object2 = (Method)hashMap2.get(string2);
                object = (Method)hashMap3.get(string2);
                Class clazz = ((Method)object3).getParameterTypes()[0];
                Method[] methodArray2 = Introspector.getPublicDeclaredMethods(clazz);
                ArrayList arrayList = new ArrayList(methodArray2.length);
                for (int i = 0; i < methodArray2.length; ++i) {
                    if (methodArray2[i] == null || !this.isEventHandler(methodArray2[i])) continue;
                    arrayList.add(methodArray2[i]);
                }
                Method[] methodArray3 = (Method[])arrayList.toArray(new Method[arrayList.size()]);
                EventSetDescriptor eventSetDescriptor = new EventSetDescriptor(string, clazz, methodArray3, (Method)object3, (Method)object2, (Method)object);
                if (this.throwsException((Method)object3, class$java$util$TooManyListenersException == null ? Introspector.class$("java.util.TooManyListenersException") : class$java$util$TooManyListenersException)) {
                    eventSetDescriptor.setUnicast(true);
                }
                this.addEvent(eventSetDescriptor);
            }
        }
        Object[] objectArray = new EventSetDescriptor[this.events.size()];
        objectArray = (EventSetDescriptor[])this.events.values().toArray(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.defaultEventName == null || !this.defaultEventName.equals(((FeatureDescriptor)objectArray[i]).getName())) continue;
            this.defaultEventIndex = i;
        }
        return objectArray;
    }

    private void addEvent(EventSetDescriptor eventSetDescriptor) {
        EventSetDescriptor eventSetDescriptor2;
        String string = eventSetDescriptor.getName();
        if (eventSetDescriptor.getName().equals("propertyChange")) {
            this.propertyChangeSource = true;
        }
        if ((eventSetDescriptor2 = (EventSetDescriptor)this.events.get(string)) == null) {
            this.events.put(string, eventSetDescriptor);
            return;
        }
        EventSetDescriptor eventSetDescriptor3 = new EventSetDescriptor(eventSetDescriptor2, eventSetDescriptor);
        this.events.put(string, eventSetDescriptor3);
    }

    private MethodDescriptor[] getTargetMethodInfo() throws IntrospectionException {
        int n;
        int n2;
        MethodDescriptor[] methodDescriptorArray = null;
        if (this.explicitBeanInfo != null) {
            methodDescriptorArray = this.explicitBeanInfo.getMethodDescriptors();
        }
        if (methodDescriptorArray == null && this.superBeanInfo != null) {
            MethodDescriptor[] methodDescriptorArray2 = this.superBeanInfo.getMethodDescriptors();
            for (n2 = 0; n2 < methodDescriptorArray2.length; ++n2) {
                this.addMethod(methodDescriptorArray2[n2]);
            }
        }
        for (n = 0; n < this.additionalBeanInfo.length; ++n) {
            MethodDescriptor[] methodDescriptorArray3 = this.additionalBeanInfo[n].getMethodDescriptors();
            if (methodDescriptorArray3 == null) continue;
            for (int i = 0; i < methodDescriptorArray3.length; ++i) {
                this.addMethod(methodDescriptorArray3[i]);
            }
        }
        if (methodDescriptorArray != null) {
            for (n = 0; n < methodDescriptorArray.length; ++n) {
                this.addMethod(methodDescriptorArray[n]);
            }
        } else {
            Method[] methodArray = Introspector.getPublicDeclaredMethods(this.beanClass);
            for (n2 = 0; n2 < methodArray.length; ++n2) {
                Method method = methodArray[n2];
                if (method == null) continue;
                MethodDescriptor methodDescriptor = new MethodDescriptor(method);
                this.addMethod(methodDescriptor);
            }
        }
        Object[] objectArray = new MethodDescriptor[this.methods.size()];
        objectArray = (MethodDescriptor[])this.methods.values().toArray(objectArray);
        return objectArray;
    }

    private void addMethod(MethodDescriptor methodDescriptor) {
        String string = methodDescriptor.getName();
        MethodDescriptor methodDescriptor2 = (MethodDescriptor)this.methods.get(string);
        if (methodDescriptor2 == null) {
            this.methods.put(string, methodDescriptor);
            return;
        }
        Class[] classArray = methodDescriptor.getMethod().getParameterTypes();
        Class[] classArray2 = methodDescriptor2.getMethod().getParameterTypes();
        boolean bl = false;
        if (classArray.length == classArray2.length) {
            bl = true;
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i] == classArray2[i]) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            MethodDescriptor methodDescriptor3 = new MethodDescriptor(methodDescriptor2, methodDescriptor);
            this.methods.put(string, methodDescriptor3);
            return;
        }
        String string2 = this.makeQualifiedMethodName(methodDescriptor);
        methodDescriptor2 = (MethodDescriptor)this.methods.get(string2);
        if (methodDescriptor2 == null) {
            this.methods.put(string2, methodDescriptor);
            return;
        }
        MethodDescriptor methodDescriptor4 = new MethodDescriptor(methodDescriptor2, methodDescriptor);
        this.methods.put(string2, methodDescriptor4);
    }

    private String makeQualifiedMethodName(MethodDescriptor methodDescriptor) {
        Method method = methodDescriptor.getMethod();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(method.getName());
        stringBuffer.append('=');
        Class[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(':');
            stringBuffer.append(classArray[i].getName());
        }
        return stringBuffer.toString();
    }

    private int getTargetDefaultEventIndex() {
        return this.defaultEventIndex;
    }

    private int getTargetDefaultPropertyIndex() {
        return this.defaultPropertyIndex;
    }

    private BeanDescriptor getTargetBeanDescriptor() throws IntrospectionException {
        BeanDescriptor beanDescriptor;
        if (this.explicitBeanInfo != null && (beanDescriptor = this.explicitBeanInfo.getBeanDescriptor()) != null) {
            return beanDescriptor;
        }
        return new BeanDescriptor(this.beanClass);
    }

    private boolean isEventHandler(Method method) throws IntrospectionException {
        try {
            Class[] classArray = method.getParameterTypes();
            if (classArray.length != 1) {
                return false;
            }
            return Introspector.isSubclass(classArray[0], EventObject.class);
        }
        catch (Exception exception) {
            throw new IntrospectionException("Unexpected reflection exception: " + exception);
        }
    }

    private static synchronized Method[] getPublicDeclaredMethods(Class clazz) {
        final Class clazz2 = clazz;
        Method[] methodArray = (Method[])declaredMethodCache.get(clazz2);
        if (methodArray != null) {
            return methodArray;
        }
        methodArray = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz2.getDeclaredMethods();
            }
        });
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            int n = method.getModifiers();
            if (Modifier.isPublic(n)) continue;
            methodArray[i] = null;
        }
        declaredMethodCache.put(clazz2, methodArray);
        return methodArray;
    }

    private static Method internalFindMethod(Class classArray, String string, int n, Class[] classArray2) {
        Object object;
        for (object = classArray; object != null; object = object.getSuperclass()) {
            Method[] methodArray = Introspector.getPublicDeclaredMethods((Class)object);
            for (int i = 0; i < methodArray.length; ++i) {
                int n2;
                Method method = methodArray[i];
                if (method == null || Modifier.isStatic(n2 = method.getModifiers())) continue;
                Class[] classArray3 = method.getParameterTypes();
                if (!method.getName().equals(string) || classArray3.length != n) continue;
                if (classArray2 != null) {
                    boolean bl = false;
                    if (n > 0) {
                        for (int j = 0; j < n; ++j) {
                            if (classArray3[j] == classArray2[j]) continue;
                            bl = true;
                        }
                        if (bl) continue;
                    }
                }
                return method;
            }
        }
        object = classArray.getInterfaces();
        for (int i = 0; i < ((Class[])object).length; ++i) {
            Method method = Introspector.internalFindMethod(object[i], string, n, null);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    static Method findMethod(Class clazz, String string, int n) throws IntrospectionException {
        return Introspector.findMethod(clazz, string, n, null);
    }

    static Method findMethod(Class clazz, String string, int n, Class[] classArray) throws IntrospectionException {
        if (string == null) {
            return null;
        }
        Method method = Introspector.internalFindMethod(clazz, string, n, classArray);
        if (method != null) {
            return method;
        }
        throw new IntrospectionException("No method \"" + string + "\" with " + n + " arg(s) of matching types.");
    }

    static boolean isSubclass(Class clazz, Class clazz2) {
        if (clazz == clazz2) {
            return true;
        }
        if (clazz == null || clazz2 == null) {
            return false;
        }
        for (Class clazz3 = clazz; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            if (clazz3 == clazz2) {
                return true;
            }
            if (!clazz2.isInterface()) continue;
            Class[] classArray = clazz3.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                if (!Introspector.isSubclass(classArray[i], clazz2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean throwsException(Method method, Class clazz) {
        Class[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] != clazz) continue;
            return true;
        }
        return false;
    }

    static Object instantiate(Class clazz, String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader != null) {
            try {
                Class clazz2 = classLoader.loadClass(string);
                return clazz2.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            classLoader = ClassLoader.getSystemClassLoader();
            if (classLoader != null) {
                Class clazz3 = classLoader.loadClass(string);
                return clazz3.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        classLoader = Thread.currentThread().getContextClassLoader();
        Class clazz4 = classLoader.loadClass(string);
        return clazz4.newInstance();
    }
}

