/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.Converter;
import com.ibm.nio.cs.IBMCharsetEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

class EUCJP_Encoder
extends IBMCharsetEncoder {
    private final short[] index;
    private final String data;
    private final int shift;
    private final int mask1;
    private final int mask2;
    private final boolean maplow;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    EUCJP_Encoder(Charset charset, short[] sArray, int n, String string, byte[] byArray, byte[] byArray2) {
        super(charset, 1.5f, 3.0f);
        this.index = sArray;
        this.data = string;
        this.shift = n;
        this.mask1 = Converter.mask1[n];
        this.mask2 = Converter.mask2[n];
        this.maplow = byArray != null && byArray.length > 1 ? byArray[1] == 1 : false;
        if (byArray2 != null) {
            this.replaceWith(byArray2);
        }
    }

    public boolean isLegalReplacement(byte[] byArray) {
        if (byArray.length == 1 && byArray[0] >= 0) {
            return true;
        }
        return super.isLegalReplacement(byArray);
    }

    public boolean canEncode(char c) {
        if (c < '\u007f') {
            return true;
        }
        return this.data.charAt(this.index[c >> this.shift] + (c & this.mask2)) > '\u0001';
    }

    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        char[] cArray = charBuffer.array();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        CoderResult coderResult = CoderResult.UNDERFLOW;
        for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
            char c = cArray[n];
            if (Surrogate.is(c)) {
                if (this.sgp.parse(c, cArray, n, n2) < 0) {
                    coderResult = this.sgp.error();
                    break;
                }
                coderResult = this.sgp.unmappableResult();
                break;
            }
            if (this.maplow && c < '\u007f') {
                if (n4 - n3 < 1) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                byArray[n3++] = (byte)c;
                continue;
            }
            char c2 = this.data.charAt(this.index[c >> this.shift] + (c & this.mask2));
            if (c2 < '\u0100') {
                if (c2 < '\u0002' && c2 != c) {
                    coderResult = CoderResult.unmappableForLength(1);
                    break;
                }
                if (n4 - n3 < 1) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                byArray[n3++] = (byte)c2;
                continue;
            }
            int n5 = c2 & 0x8080;
            if (n5 == 32896) {
                if (n4 - n3 < 2) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                byArray[n3++] = (byte)(c2 >> 8);
                byArray[n3++] = (byte)c2;
                continue;
            }
            if (n5 == 32768) {
                if (n4 - n3 < 3) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                byArray[n3++] = -113;
                byArray[n3++] = (byte)(c2 >> 8);
                byArray[n3++] = (byte)(c2 | 0x80);
                continue;
            }
            if (n4 - n3 < 2) {
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            byArray[n3++] = -114;
            byArray[n3++] = (byte)(c2 | 0x80);
        }
        charBuffer.position(n - charBuffer.arrayOffset());
        byteBuffer.position(n3 - byteBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        try {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (this.maplow && c < '\u007f') {
                    if (!byteBuffer.hasRemaining()) break;
                    byteBuffer.put((byte)c);
                } else {
                    char c2 = this.data.charAt(this.index[c >> this.shift] + (c & this.mask2));
                    if (c2 < '\u0100') {
                        if (c2 < '\u0002' && c2 != c) {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)c2);
                        continue;
                    }
                    int n2 = c2 & 0x8080;
                    switch (n2) {
                        case 32896: {
                            if (byteBuffer.remaining() < 2) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)(c2 >> 8));
                            byteBuffer.put((byte)c2);
                            break;
                        }
                        case 32768: {
                            if (byteBuffer.remaining() < 3) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)-113);
                            byteBuffer.put((byte)(c2 >> 8));
                            byteBuffer.put((byte)(c2 | 0x80));
                            break;
                        }
                        default: {
                            if (byteBuffer.remaining() < 2) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)-114);
                            byteBuffer.put((byte)(c2 | 0x80));
                        }
                    }
                }
                ++n;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray() && !UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

