/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.Converter;
import com.ibm.nio.cs.IBMCharsetDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;

class DBE_Decoder
extends IBMCharsetDecoder {
    private final short[] index;
    private final int shift;
    private final int mask1;
    private final int mask2;
    private final int convertType;
    private int state;
    private final String indexSurrogate;
    private final String indexSurrogate2;
    private final int bytePairLead;
    private final int[] pairsArray;
    private final String bytePairs;
    private final char[] charMap;
    private static final int SBCS = 0;
    private static final int DBCS = 1;
    private static final byte SO = 14;
    private static final byte SI = 15;

    DBE_Decoder(Charset charset, short[] sArray, int n, byte by, String string, String string2, int[] nArray, String string3, int n2, char[] cArray) {
        super(charset, 1.0f, 1.0f);
        this.index = sArray;
        this.shift = n;
        this.mask1 = Converter.mask1[n];
        this.mask2 = Converter.mask2[n];
        this.convertType = by;
        this.state = by == 2 ? 1 : 0;
        this.indexSurrogate = string;
        this.indexSurrogate2 = string2;
        this.pairsArray = nArray;
        this.bytePairs = string3;
        this.bytePairLead = n2;
        this.charMap = cArray;
    }

    protected void implReset() {
        if (this.convertType == 0) {
            this.state = 0;
        }
    }

    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n;
        byte[] byArray = byteBuffer.array();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        int n5 = 1;
        int n6 = 65533;
        int n7 = 65533;
        boolean bl = false;
        boolean bl2 = false;
        CoderResult coderResult = CoderResult.UNDERFLOW;
        for (n = byteBuffer.arrayOffset() + byteBuffer.position(); n < n2; n += n5) {
            int n8;
            char c;
            n5 = 1;
            int n9 = byArray[n] & 0xFF;
            if (n9 == 14 && this.convertType == 0) {
                if (this.state != 0) {
                    coderResult = CoderResult.malformedForLength(1);
                    break;
                }
                this.state = 1;
                continue;
            }
            if (n9 == 15 && this.convertType == 0) {
                if (this.state != 1) {
                    coderResult = CoderResult.malformedForLength(1);
                    break;
                }
                this.state = 0;
                continue;
            }
            if (this.state == 0) {
                c = this.charMap[n9];
            } else {
                if (n9 < 64 || n9 > 254) {
                    coderResult = CoderResult.malformedForLength(1);
                    break;
                }
                if (n + 1 >= n2) break;
                int n10 = byArray[n + 1] & 0xFF;
                if (!(n9 == 64 && n10 == 64 || n10 >= 65 && n10 <= 254)) {
                    coderResult = CoderResult.malformedForLength(2);
                    break;
                }
                c = this.charMap[n9 * 256 + n10];
                n5 = 2;
                if (c >= '\ud800' && c <= '\udbff') {
                    n6 = this.getSurrogatePair(n9 * 256 + n10);
                    if (n6 == 65533) {
                        coderResult = CoderResult.unmappableForLength(n5);
                        break;
                    }
                    bl = true;
                }
                if (c == '\ufffd' && n9 == this.bytePairLead && null != this.bytePairs) {
                    for (n8 = 0; n8 < this.bytePairs.length(); ++n8) {
                        if (this.bytePairs.charAt(n8) != n9 * 256 + n10) continue;
                        int n11 = this.pairsArray[n8];
                        c = (char)(n11 >> 16 & 0xFFFF);
                        n7 = (char)(n11 & 0xFFFF);
                        bl2 = true;
                        break;
                    }
                }
            }
            if (c == '\ufffd') {
                coderResult = CoderResult.unmappableForLength(n5);
                break;
            }
            if (n4 - n3 < 1) {
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            if ((bl || bl2) && n4 - ((n8 = n3) + 1) < 1) {
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            cArray[n3++] = c;
            if (bl) {
                if (n4 - n3 < 1) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                cArray[n3++] = n6;
                bl = false;
                continue;
            }
            if (!bl2) continue;
            if (n4 - n3 < 1) {
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            cArray[n3++] = n7;
            bl2 = false;
        }
        byteBuffer.position(n - byteBuffer.arrayOffset());
        charBuffer.position(n3 - charBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        int n2 = 1;
        char c = '\ufffd';
        char c2 = '\ufffd';
        boolean bl = false;
        boolean bl2 = false;
        try {
            while (byteBuffer.hasRemaining()) {
                int n3 = byteBuffer.get() & 0xFF;
                if (n3 == 14 && this.convertType == 0) {
                    if (this.state != 0) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    this.state = 1;
                } else if (n3 == 15 && this.convertType == 0) {
                    if (this.state != 1) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    this.state = 0;
                } else {
                    char c3;
                    if (this.state == 0) {
                        c3 = this.charMap[n3];
                        n2 = 1;
                    } else {
                        if (n3 < 64 || n3 > 254) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        if (!byteBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        int n4 = byteBuffer.get() & 0xFF;
                        if (!(n3 == 64 && n4 == 64 || n4 >= 65 && n4 <= 254)) {
                            CoderResult coderResult = CoderResult.malformedForLength(2);
                            return coderResult;
                        }
                        c3 = this.charMap[n3 * 256 + n4];
                        n2 = 2;
                        if (c3 >= '\ud800' && c3 <= '\udbff') {
                            c = this.getSurrogatePair(n3 * 256 + n4);
                            if (c == '\ufffd') {
                                CoderResult coderResult = CoderResult.unmappableForLength(2);
                                return coderResult;
                            }
                            bl = true;
                        }
                        if (c3 == '\ufffd' && n3 == this.bytePairLead && null != this.bytePairs) {
                            for (int i = 0; i < this.bytePairs.length(); ++i) {
                                if (this.bytePairs.charAt(i) != n3 * 256 + n4) continue;
                                int n5 = this.pairsArray[i];
                                c3 = (char)(n5 >> 16 & 0xFFFF);
                                c2 = (char)(n5 & 0xFFFF);
                                bl2 = true;
                                break;
                            }
                        }
                    }
                    if (c3 == '\ufffd') {
                        CoderResult coderResult = CoderResult.unmappableForLength(n2);
                        return coderResult;
                    }
                    if (!charBuffer.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    charBuffer.put(c3);
                    if (bl) {
                        if (!charBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put(c);
                        bl = false;
                    } else if (bl2) {
                        if (!charBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put(c2);
                        bl2 = false;
                    }
                }
                n += n2;
                n2 = 1;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    protected char getSurrogatePair(int n) {
        int n2 = this.index[n >> this.shift] + (n & this.mask2);
        char c = this.indexSurrogate2 == null || n2 < 15000 ? this.indexSurrogate.charAt(n2) : this.indexSurrogate2.charAt(n2 - 15000);
        if (c == '\u0000' && n != 0) {
            return '\ufffd';
        }
        return c;
    }

    protected final CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray() && !UseBuffer) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }
}

