/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.ArabicDecoder;
import com.ibm.nio.cs.ArabicEncoder;
import com.ibm.nio.cs.ConverterDescription;
import com.ibm.nio.cs.DBA_Decoder;
import com.ibm.nio.cs.DBA_Encoder;
import com.ibm.nio.cs.DBCS_Decoder;
import com.ibm.nio.cs.DBCS_Encoder;
import com.ibm.nio.cs.DBE_Decoder;
import com.ibm.nio.cs.DBE_Encoder;
import com.ibm.nio.cs.DirectDecoder;
import com.ibm.nio.cs.DirectEncoder;
import com.ibm.nio.cs.EUCJP_Decoder;
import com.ibm.nio.cs.EUCJP_Encoder;
import com.ibm.nio.cs.EUCTW_Decoder;
import com.ibm.nio.cs.EUCTW_Encoder;
import com.ibm.nio.cs.EUC_Decoder;
import com.ibm.nio.cs.GB18030Decoder;
import com.ibm.nio.cs.GB18030Encoder;
import com.ibm.nio.cs.IBMCharsets;
import com.ibm.nio.cs.ISO2022JP_Encoder;
import com.ibm.nio.cs.ISO2022_Decoder;
import com.ibm.nio.cs.ISO2022_Encoder;
import com.ibm.nio.cs.SBCS_Decoder;
import com.ibm.nio.cs.SBCS_Encoder;
import com.ibm.nio.cs.UTF16Decoder;
import com.ibm.nio.cs.UTF16Encoder;
import com.ibm.nio.cs.UTF32Decoder;
import com.ibm.nio.cs.UTF32Encoder;
import com.ibm.nio.cs.UTF8_Decoder;
import com.ibm.nio.cs.UTF8_Encoder;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;
import sun.nio.cs.HistoricallyNamedCharset;

class Converter
extends Charset
implements HistoricallyNamedCharset {
    static final int UNSUPPORTED = 0;
    static final int DIRECT = 1;
    static final int UTF8 = 2;
    static final int UTF16 = 3;
    static final int UTF32 = 4;
    static final int ISO2022 = 5;
    static final int SBCS = 6;
    static final int DBCS = 7;
    static final int DBCS_EBCDIC = 8;
    static final int DBCS_ASCII = 9;
    static final int ARABIC = 10;
    static final int EUC = 11;
    static final int GB18030 = 12;
    static final int DBCS_EBCDIC_GB = 13;
    static final int EUCJP = 14;
    static final int EUCTW = 15;
    protected String baseName;
    protected final String name;
    protected final ByteToCharConverter b2c;
    protected final CharToByteConverter c2b;
    protected long Contains;
    private int b2cClass = 0;
    private int c2bClass = 0;
    private int maxCode = 0;
    private int endian = 0;
    private int mark = 0;
    private final String Option;
    public static final int[] mask1 = new int[]{65535, 65534, 65532, 65528, 65520, 65504, 65472, 65408, 65280};
    public static final int[] mask2 = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};

    public Converter(String string, String string2) {
        super(string, IBMCharsets.getInstance().aliases(string));
        this.name = string;
        int n = string2.indexOf(",");
        this.Option = n >= 0 ? string2.substring(n + 1) : "";
        String string3 = this.baseName = n >= 0 ? string2.substring(0, n) : string2;
        if (this.baseName.charAt(0) == '!') {
            this.baseName = this.baseName.substring(1);
            this.c2bClass = this.b2cClass = this.mapAlgorithmic(this.baseName);
            this.b2c = null;
            this.c2b = null;
        } else {
            String[] stringArray;
            try {
                this.b2c = ByteToCharConverter.getConverter(this.baseName);
                this.c2b = CharToByteConverter.getConverter(this.baseName);
                this.b2cClass = this.mapClass(this.b2c.getType());
                this.c2bClass = this.mapClass(this.c2b.getType());
            }
            catch (Throwable throwable) {
                throw new UnsupportedCharsetException(string);
            }
            if (!this.Option.equals("") && (stringArray = IBMCharsets.getInstance().aliases(string)).length > 0) {
                this.baseName = stringArray[0];
            }
        }
        if (this.b2cClass == 0 || this.c2bClass == 0) {
            throw new UnsupportedCharsetException(string);
        }
    }

    protected int mapClass(String string) {
        if ("sbcs".equals(string)) {
            return 6;
        }
        if ("dbcs".equals(string)) {
            return 7;
        }
        if ("dbcs_ebcdic".equals(string)) {
            return 8;
        }
        if ("dbcs_ascii".equals(string)) {
            return 9;
        }
        if ("arabic".equals(string)) {
            return 10;
        }
        if ("euc".equals(string)) {
            return 11;
        }
        if ("euc_jp".equals(string)) {
            return 14;
        }
        if ("euc_tw".equals(string)) {
            return 15;
        }
        if ("gb18030".equals(string)) {
            return 12;
        }
        if ("dbcs_ebcdic_gb".equals(string)) {
            return 13;
        }
        return 0;
    }

    private int mapAlgorithmic(String string) {
        if (string.equals("ASCII")) {
            this.maxCode = 127;
            return 1;
        }
        if (string.equals("ISO8859_1")) {
            this.maxCode = 255;
            return 1;
        }
        if (string.equals("UTF8")) {
            return 2;
        }
        if (string.equals("CESU8")) {
            this.mark = 4;
            return 2;
        }
        if (string.equals("UTF8X")) {
            this.mark = 2;
            return 2;
        }
        if (string.equals("UTF8J")) {
            this.mark = 6;
            return 2;
        }
        if (string.equals("UTF16")) {
            this.endian = 0;
            this.mark = 1;
            return 3;
        }
        if (string.equals("Unicode")) {
            this.endian = 0;
            this.mark = 1;
            return 3;
        }
        if (string.equals("UTF-16BE")) {
            this.endian = 2;
            this.mark = 0;
            return 3;
        }
        if (string.equals("UnicodeBig")) {
            this.endian = 2;
            this.mark = 1;
            return 3;
        }
        if (string.equals("UTF-16LE")) {
            this.endian = 1;
            this.mark = 0;
            return 3;
        }
        if (string.equals("UnicodeLittle")) {
            this.endian = 1;
            this.mark = 1;
            return 3;
        }
        if (string.equals("UTF32")) {
            this.endian = 0;
            return 4;
        }
        if (string.equals("UTF32LE")) {
            this.endian = 1;
            this.mark = 0;
            return 4;
        }
        if (string.equals("UTF32BE")) {
            this.endian = 2;
            this.mark = 0;
            return 4;
        }
        if (string.equals("UTF32LEM")) {
            this.endian = 1;
            this.mark = 1;
            return 4;
        }
        if (string.equals("UTF32BEM")) {
            this.endian = 2;
            this.mark = 1;
            return 4;
        }
        if (string.equals("ISO2022")) {
            this.baseName = string + this.Option;
            return 5;
        }
        return 0;
    }

    public String historicalName() {
        return this.baseName;
    }

    public String displayName() {
        String string = ConverterDescription.getDescription(this.baseName);
        if (string != null && string.length() > 0) {
            return this.name + ": " + string;
        }
        return this.name;
    }

    public String displayName(Locale locale) {
        return this.displayName();
    }

    public long getContains() {
        if (this.Contains == 0L) {
            this.Contains = IBMCharsets.getInstance().getContains(this.name());
        }
        return this.Contains;
    }

    public boolean contains(Charset charset) {
        long l = charset instanceof Converter ? ((Converter)charset).getContains() : IBMCharsets.getInstance().getContains(charset.name());
        long l2 = this.getContains();
        return ((l2 ^ 0xFFFFFFFFFFFFFFFFL) & l) == 0L;
    }

    public CharsetDecoder newDecoder() {
        if (this.b2cClass <= 6) {
            switch (this.b2cClass) {
                case 1: {
                    return new DirectDecoder(this, this.maxCode);
                }
                case 2: {
                    return new UTF8_Decoder(this, this.mark);
                }
                case 3: {
                    return new UTF16Decoder(this, this.endian);
                }
                case 4: {
                    return new UTF32Decoder(this, this.endian);
                }
                case 5: {
                    return new ISO2022_Decoder(this, this.Option);
                }
                case 6: {
                    return new SBCS_Decoder((Charset)this, this.b2c.getCharData());
                }
            }
        }
        short[] sArray = this.b2c.getIndex();
        byte[] byArray = this.b2c.getByteData();
        char[] cArray = this.b2c.getCharData();
        switch (this.b2cClass) {
            case 7: {
                return new DBCS_Decoder(this, sArray, (String[])this.b2c.getObjectData(), byArray, cArray, byArray[256], byArray[257], byArray[258]);
            }
            case 9: {
                return new DBA_Decoder(this, byArray, cArray, byArray[257], this.b2c.getCharMap());
            }
            case 8: {
                return new DBE_Decoder(this, sArray, this.b2c.getShift(), byArray[0], this.b2c.getIndexSurrogate(), this.b2c.getIndexSurrogate2(), this.b2c.getPairsArray(), this.b2c.getBytePairs(), this.b2c.getBytePairLead(), this.b2c.getCharMap());
            }
            case 10: {
                return new ArabicDecoder((Charset)this, cArray, byArray[0]);
            }
            case 11: {
                return new EUC_Decoder(this, cArray, this.b2c.getStringData(), byArray);
            }
            case 14: {
                return new EUCJP_Decoder(this, cArray, this.b2c.getShift(), sArray, this.b2c.getStringData(), byArray);
            }
            case 15: {
                return new EUCTW_Decoder(this, cArray, this.b2c.getShift(), sArray, this.b2c.getStringData(), byArray);
            }
            case 12: {
                char[][] cArray2 = (char[][])this.b2c.getObjectData();
                return new GB18030Decoder(this, cArray2[0], cArray2[1], cArray2[2], this.Option);
            }
        }
        return null;
    }

    public CharsetEncoder newEncoder() {
        if (this.c2bClass < 6) {
            switch (this.c2bClass) {
                case 1: {
                    return new DirectEncoder((Charset)this, this.maxCode, null);
                }
                case 2: {
                    return new UTF8_Encoder(this, this.mark);
                }
                case 3: {
                    return new UTF16Encoder((Charset)this, this.endian, this.mark != 0);
                }
                case 4: {
                    return new UTF32Encoder((Charset)this, this.endian, this.mark != 0);
                }
                case 5: {
                    if ("JP".equals(this.Option)) {
                        return new ISO2022JP_Encoder(this, this.Option);
                    }
                    return new ISO2022_Encoder(this, this.Option);
                }
            }
        }
        short[] sArray = this.c2b.getIndex();
        byte[] byArray = this.c2b.getByteData();
        char[] cArray = this.c2b.getCharData();
        int n = this.c2b.getShift();
        byte[] byArray2 = this.c2b.getReplace();
        switch (this.c2bClass) {
            case 6: {
                return new SBCS_Encoder((Charset)this, sArray, cArray, byArray, n, byArray2);
            }
            case 7: {
                return new DBCS_Encoder(this, sArray, (String[])this.c2b.getObjectData(), cArray, byArray[0], byArray2);
            }
            case 9: {
                return new DBA_Encoder(this, byArray[0], byArray[1], byArray2, this.c2b.getCharMap());
            }
            case 8: {
                return new DBE_Encoder(this, byArray[0], byArray2, this.c2b.getByteArray(), this.c2b.getLeftPair(), this.c2b.getRightPair(), this.c2b.getBytePair(), this.c2b.getSurrogateArray(), this.c2b.getNumberOfSurrogates(), this.c2b.getCharMap());
            }
            case 10: {
                return new ArabicEncoder(this, sArray, cArray, n, byArray, byArray2);
            }
            case 11: {
                return null;
            }
            case 14: {
                return new EUCJP_Encoder(this, sArray, n, this.c2b.getStringData(), byArray, byArray2);
            }
            case 15: {
                return new EUCTW_Encoder(this, sArray, n, this.c2b.getStringData(), byArray, byArray2);
            }
            case 12: {
                char[][] cArray2 = (char[][])this.c2b.getObjectData();
                return new GB18030Encoder(this, cArray2[0], cArray2[1], cArray2[2], this.Option);
            }
        }
        return null;
    }
}

