/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.oldformat;

import com.ibm.jvm.oldformat.ProcVariableSection;
import com.ibm.jvm.oldformat.TraceFormat;
import com.ibm.jvm.oldformat.Util;
import java.io.BufferedWriter;
import java.io.IOException;

public class VariableSection {
    protected static final int TRACE = 0;
    protected static final int SERVICE = 1;
    protected static final int START_UP = 2;
    protected static final int ACTIVE = 3;
    protected static final int PROC = 4;
    protected static final int NUM_SECTIONS = 5;
    protected static final int OFFSET_TO_DATA = 16;
    protected static final int[] OFFSETS = new int[]{24, 28, 32, 36, 40};
    protected static final String[] names = new String[]{"Internal Trace Data :", "Service Level :", "JVM Start-up Params :", "Activation Info :", "Sys Processor Info :"};
    protected static int OFFSET_TO_START_PLATFORM;
    protected static int OFFSET_TO_START_SYSTEM;
    protected static int OFFSET_TO_TYPE;
    protected static int OFFSET_TO_GENERATIONS;
    protected static int OFFSET_TO_PTRSIZE;
    protected long length;
    protected long versionInfo;
    protected long modificationInfo;
    protected byte[] data;
    protected boolean doSummary = false;
    protected int offset;
    protected int type;

    private VariableSection() {
    }

    public VariableSection(int n, byte[] byArray, int n2, boolean bl) {
        int n3 = n2 + 4;
        this.length = Util.constructUnsignedInt(byArray, n3);
        this.versionInfo = Util.constructUnsignedInt(byArray, n3 + 4);
        this.modificationInfo = Util.constructUnsignedInt(byArray, n3 + 4 + 4);
        this.data = new byte[(int)this.length];
        this.offset = 16;
        this.doSummary = bl;
        this.type = n;
        System.arraycopy(byArray, n2, this.data, 0, (int)this.length);
    }

    public static VariableSection newSection(int n, byte[] byArray, int n2) {
        switch (n) {
            case 0: {
                return new VariableSection(n, byArray, n2, false){

                    protected void process() {
                        int n = 4;
                        if ((double)TraceFormat.verMod >= 1.1) {
                            OFFSET_TO_START_PLATFORM = 16;
                            OFFSET_TO_START_SYSTEM = 24;
                            OFFSET_TO_TYPE = 32;
                            OFFSET_TO_GENERATIONS = 36;
                            OFFSET_TO_PTRSIZE = 40;
                            TraceFormat.startSystem = Util.constructUnsignedLong(this.data, OFFSET_TO_START_SYSTEM);
                            TraceFormat.startPlatform = Util.constructUnsignedLong(this.data, OFFSET_TO_START_PLATFORM);
                            n = (int)Util.constructUnsignedInt(this.data, OFFSET_TO_PTRSIZE);
                        }
                        int n2 = (int)Util.constructUnsignedInt(this.data, OFFSET_TO_TYPE);
                        int n3 = (int)Util.constructUnsignedInt(this.data, OFFSET_TO_GENERATIONS);
                        Util.setProperty("POINTER_SIZE", String.valueOf(n));
                        switch (n2) {
                            case 0: {
                                Util.setProperty("TRACE_TYPE", "INTERNAL");
                                break;
                            }
                            case 1: {
                                Util.setProperty("TRACE_TYPE", "EXTERNAL");
                                break;
                            }
                            default: {
                                System.out.println("VariableSection.process():invalid trace type");
                            }
                        }
                        Util.setProperty("GENERATIONS", Integer.toString(n3));
                    }
                };
            }
            case 1: {
                return new VariableSection(n, byArray, n2, true);
            }
            case 2: {
                return new VariableSection(n, byArray, n2, true);
            }
            case 3: {
                return new VariableSection(n, byArray, n2, true);
            }
            case 4: {
                return new ProcVariableSection(n, byArray, n2, true);
            }
        }
        return null;
    }

    protected void process() {
    }

    protected void summary(BufferedWriter bufferedWriter) throws IOException {
        if (this.doSummary) {
            int n = this.offset;
            String string = Util.constructString(this.data, n);
            bufferedWriter.write(names[this.type]);
            bufferedWriter.newLine();
            while (!string.equals("")) {
                bufferedWriter.write("        " + string);
                bufferedWriter.newLine();
                string = Util.constructString(this.data, n += string.length() + 1);
            }
            bufferedWriter.newLine();
        }
    }

    static {
        OFFSET_TO_TYPE = 16;
        OFFSET_TO_GENERATIONS = 20;
    }
}

