/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.util;

import com.ibm.xml.b2b.util.CharConversionError;
import com.ibm.xml.b2b.util.EncodingSupport;
import com.ibm.xml.b2b.util.SingleByteEncodingSupport;

public final class Windows125xEncodingSupport
extends SingleByteEncodingSupport {
    public static final int CP1250 = 0;
    public static final int CP1251 = 1;
    public static final int CP1252 = 2;
    public static final int CP1253 = 3;
    public static final int CP1254 = 4;
    public static final int CP1255 = 5;
    public static final int CP1256 = 6;
    public static final int CP1257 = 7;
    public static final int CP1258 = 8;
    private static final int ENCODINGS_COUNT = 9;
    private int[] fIntervalMap;
    private byte[] fByteMap;
    private static EncodingSupport[] fgSingletons;

    public static EncodingSupport getInstance(int n) {
        EncodingSupport encodingSupport;
        if (n < 0 || n > 8) {
            return null;
        }
        if (fgSingletons == null) {
            fgSingletons = new EncodingSupport[9];
        } else if (fgSingletons[n] != null) {
            return fgSingletons[n];
        }
        switch (n) {
            case 0: {
                encodingSupport = CP1250Mappings.createEncodingSupport();
                break;
            }
            case 1: {
                encodingSupport = CP1251Mappings.createEncodingSupport();
                break;
            }
            case 2: {
                encodingSupport = CP1252Mappings.createEncodingSupport();
                break;
            }
            case 3: {
                encodingSupport = CP1253Mappings.createEncodingSupport();
                break;
            }
            case 4: {
                encodingSupport = CP1254Mappings.createEncodingSupport();
                break;
            }
            case 5: {
                encodingSupport = CP1255Mappings.createEncodingSupport();
                break;
            }
            case 6: {
                encodingSupport = CP1256Mappings.createEncodingSupport();
                break;
            }
            case 7: {
                encodingSupport = CP1257Mappings.createEncodingSupport();
                break;
            }
            case 8: {
                encodingSupport = CP1258Mappings.createEncodingSupport();
                break;
            }
            default: {
                return null;
            }
        }
        Windows125xEncodingSupport.fgSingletons[n] = encodingSupport;
        return encodingSupport;
    }

    public boolean isASCIITransparent() {
        return true;
    }

    private byte charToByte(int n) {
        int n2;
        int n3 = 0;
        while ((n2 = this.fIntervalMap[n3++]) != -1) {
            int n4 = this.fIntervalMap[n3++];
            int n5 = this.fIntervalMap[n3++];
            if (n < n4 || n > n5) continue;
            return this.fByteMap[n - n4];
        }
        CharConversionError.unableToConvertOutOfRangeUnicodeCharacter();
        return -1;
    }

    public void convertCharsToBytes(char[] cArray, int n, int n2, byte[][] byArray, int[] nArray) {
        int n3;
        int n4 = nArray[0];
        int n5 = n4 + (n2 - n);
        byte[] byArray2 = byArray[0];
        if (n5 > byArray2.length) {
            n3 = byArray2.length << 1;
            while (n5 > n3) {
                n3 <<= 1;
            }
            byArray2 = new byte[n3];
            System.arraycopy(byArray[0], 0, byArray2, 0, n4);
            byArray[0] = byArray2;
        }
        while (n4 < n5) {
            n3 = cArray[n++];
            byte by = this.charToByte(n3);
            byArray2[n4++] = by;
        }
        nArray[0] = n4;
    }

    public int encodeCharacter(int n, byte[][] byArray, int n2) {
        byte[] byArray2 = byArray[0];
        int n3 = n2 + 1;
        if (n2 == byArray2.length) {
            int n4 = byArray2.length << 1;
            byArray2 = new byte[n4];
            System.arraycopy(byArray[0], 0, byArray2, 0, n2);
            byArray[0] = byArray2;
        }
        byte by = this.charToByte(n);
        byArray2[n2++] = by;
        return n2;
    }

    public int normalizeLineBreaks(byte[] byArray, int n, int n2, boolean[] blArray) {
        char[] cArray = this.byteToCharMap;
        boolean bl = blArray[0];
        int n3 = n;
        while (n3 < n2) {
            block6: {
                char c;
                int n4;
                block5: {
                    n4 = byArray[n3];
                    c = cArray[n4 & 0xFF];
                    if (!bl) break block5;
                    bl = false;
                    if (c == '\n') break block6;
                }
                if (c == '\r') {
                    n4 = 10;
                    bl = true;
                }
                byArray[n++] = n4;
            }
            ++n3;
        }
        blArray[0] = bl;
        return n;
    }

    protected Windows125xEncodingSupport(char[] cArray, int[] nArray, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        super(cArray, byArray2, byArray3);
        this.fIntervalMap = nArray;
        this.fByteMap = byArray;
    }

    static final class CP1258Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u20ac', '\ufffd', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\ufffd', '\u2039', '\u0152', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u02dc', '\u2122', '\ufffd', '\u203a', '\u0153', '\ufffd', '\ufffd', '\u0178', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u0102', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u0300', '\u00cd', '\u00ce', '\u00cf', '\u0110', '\u00d1', '\u0309', '\u00d3', '\u00d4', '\u01a0', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u01af', '\u0303', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u0103', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u0301', '\u00ed', '\u00ee', '\u00ef', '\u0111', '\u00f1', '\u0323', '\u00f3', '\u00f4', '\u01a1', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u01b0', '\u20ab', '\u00ff'};
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, -86, -85, -84, -83, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, -63, -62, -60, -59, -58, -57, -56, -55, -54, -53, -51, -50, -49, -47, -45, -44, -42, -41, -40, -39, -38, -37, -36, -33, -32, -31, -30, -28, -27, -26, -25, -24, -23, -22, -21, -19, -18, -17, -15, -13, -12, -10, -9, -8, -7, -6, -5, -4, -1, -61, -29, -48, -16, -116, -100, -97, -125, -43, -11, -35, -3, -120, -104, -52, -20, -34, -46, -14, -106, -105, -111, -110, -126, -109, -108, -124, -122, -121, -107, -123, -119, -117, -101, -2, -128, -103};
        static final int[] fgIntervalMap = new int[]{0, 0, 127, 128, 160, 194, 163, 196, 203, 171, 205, 207, 174, 209, 209, 175, 211, 212, 177, 214, 220, 184, 223, 226, 188, 228, 235, 196, 237, 239, 199, 241, 241, 200, 243, 244, 202, 246, 252, 209, 255, 255, 210, 258, 259, 212, 272, 273, 214, 338, 339, 216, 376, 376, 217, 402, 402, 218, 416, 417, 220, 431, 432, 222, 710, 710, 223, 732, 732, 224, 768, 769, 226, 771, 771, 227, 777, 777, 228, 803, 803, 229, 8211, 8212, 231, 8216, 8218, 234, 8220, 8222, 237, 8224, 8226, 240, 8230, 8230, 241, 8240, 8240, 242, 8249, 8250, 244, 8363, 8364, 246, 8482, 8482, -1};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 20, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 2, 2, 12, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 28, 8, 24, 16, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 8, 8, 8, 8, 3, 8, 8, 8, 8, 8, 8, 8, 8, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 8, 8, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 3, 3, 3, 3, 3, 2, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 3, 3, 3, 3, 3, 2, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 8, 3};

        CP1258Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new Windows125xEncodingSupport(fgCharMap, fgIntervalMap, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP1257Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u20ac', '\ufffd', '\u201a', '\ufffd', '\u201e', '\u2026', '\u2020', '\u2021', '\ufffd', '\u2030', '\ufffd', '\u2039', '\ufffd', '\u00a8', '\u02c7', '\u00b8', '\ufffd', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\ufffd', '\u2122', '\ufffd', '\u203a', '\ufffd', '\u00af', '\u02db', '\ufffd', '\u00a0', '\ufffd', '\u00a2', '\u00a3', '\u00a4', '\ufffd', '\u00a6', '\u00a7', '\u00d8', '\u00a9', '\u0156', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00c6', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00f8', '\u00b9', '\u0157', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00e6', '\u0104', '\u012e', '\u0100', '\u0106', '\u00c4', '\u00c5', '\u0118', '\u0112', '\u010c', '\u00c9', '\u0179', '\u0116', '\u0122', '\u0136', '\u012a', '\u013b', '\u0160', '\u0143', '\u0145', '\u00d3', '\u014c', '\u00d5', '\u00d6', '\u00d7', '\u0172', '\u0141', '\u015a', '\u016a', '\u00dc', '\u017b', '\u017d', '\u00df', '\u0105', '\u012f', '\u0101', '\u0107', '\u00e4', '\u00e5', '\u0119', '\u0113', '\u010d', '\u00e9', '\u017a', '\u0117', '\u0123', '\u0137', '\u012b', '\u013c', '\u0161', '\u0144', '\u0146', '\u00f3', '\u014d', '\u00f5', '\u00f6', '\u00f7', '\u0173', '\u0142', '\u015b', '\u016b', '\u00fc', '\u017c', '\u017e', '\u02d9'};
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, -96, -94, -93, -92, -90, -89, -115, -87, -85, -84, -83, -82, -99, -80, -79, -78, -77, -76, -75, -74, -73, -113, -71, -69, -68, -67, -66, -60, -59, -81, -55, -45, -43, -42, -41, -88, -36, -33, -28, -27, -65, -23, -13, -11, -10, -9, -72, -4, -62, -30, -64, -32, -61, -29, -56, -24, -57, -25, -53, -21, -58, -26, -52, -20, -50, -18, -63, -31, -51, -19, -49, -17, -39, -7, -47, -15, -46, -14, -44, -12, -86, -70, -38, -6, -48, -16, -37, -5, -40, -8, -54, -22, -35, -3, -34, -2, -114, -1, -98, -106, -105, -111, -110, -126, -109, -108, -124, -122, -121, -107, -123, -119, -117, -101, -128, -103};
        static final int[] fgIntervalMap = new int[]{0, 0, 127, 128, 160, 160, 129, 162, 164, 132, 166, 169, 136, 171, 185, 151, 187, 190, 155, 196, 198, 158, 201, 201, 159, 211, 211, 160, 213, 216, 164, 220, 220, 165, 223, 223, 166, 228, 230, 169, 233, 233, 170, 243, 243, 171, 245, 248, 175, 252, 252, 176, 256, 257, 178, 260, 263, 182, 268, 269, 184, 274, 275, 186, 278, 281, 190, 290, 291, 192, 298, 299, 194, 302, 303, 196, 310, 311, 198, 315, 316, 200, 321, 326, 206, 332, 333, 208, 342, 343, 210, 346, 347, 212, 352, 353, 214, 362, 363, 216, 370, 371, 218, 377, 382, 224, 711, 711, 225, 729, 729, 226, 731, 731, 227, 8211, 8212, 229, 8216, 8218, 232, 8220, 8222, 235, 8224, 8226, 238, 8230, 8230, 239, 8240, 8240, 240, 8249, 8250, 242, 8364, 8364, 243, 8482, 8482, -1};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 20, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 2, 2, 12, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 28, 8, 24, 16, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 8, 3, 8, 8, 8, 8, 3, 8, 8, 8, 8, 8, 8, 8, 2, 3, 8, 3, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 8};

        CP1257Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new Windows125xEncodingSupport(fgCharMap, fgIntervalMap, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP1256Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u20ac', '\u067e', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0679', '\u2039', '\u0152', '\u0686', '\u0698', '\u0688', '\u06af', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u06a9', '\u2122', '\u0691', '\u203a', '\u0153', '\u200c', '\u200d', '\u06ba', '\u00a0', '\u060c', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u06be', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u061b', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u061f', '\u06c1', '\u0621', '\u0622', '\u0623', '\u0624', '\u0625', '\u0626', '\u0627', '\u0628', '\u0629', '\u062a', '\u062b', '\u062c', '\u062d', '\u062e', '\u062f', '\u0630', '\u0631', '\u0632', '\u0633', '\u0634', '\u0635', '\u0636', '\u00d7', '\u0637', '\u0638', '\u0639', '\u063a', '\u0640', '\u0641', '\u0642', '\u0643', '\u00e0', '\u0644', '\u00e2', '\u0645', '\u0646', '\u0647', '\u0648', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u0649', '\u064a', '\u00ee', '\u00ef', '\u064b', '\u064c', '\u064d', '\u064e', '\u00f4', '\u064f', '\u0650', '\u00f7', '\u0651', '\u00f9', '\u0652', '\u00fb', '\u00fc', '\u200e', '\u200f', '\u06d2'};
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, -96, -94, -93, -92, -91, -90, -89, -88, -87, -85, -84, -83, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -69, -68, -67, -66, -41, -32, -30, -25, -24, -23, -22, -21, -18, -17, -12, -9, -7, -5, -4, -116, -100, -125, -120, -95, -70, -65, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -40, -39, -38, -37, -36, -35, -34, -33, -31, -29, -28, -27, -26, -20, -19, -16, -15, -14, -13, -11, -10, -8, -6, -118, -127, -115, -113, -102, -114, -104, -112, -97, -86, -64, -1, -99, -98, -3, -2, -106, -105, -111, -110, -126, -109, -108, -124, -122, -121, -107, -123, -119, -117, -101, -128, -103};
        static final int[] fgIntervalMap = new int[]{0, 0, 127, 128, 160, 160, 129, 162, 169, 137, 171, 185, 152, 187, 190, 156, 215, 215, 157, 224, 224, 158, 226, 226, 159, 231, 235, 164, 238, 239, 166, 244, 244, 167, 247, 247, 168, 249, 249, 169, 251, 252, 171, 338, 339, 173, 402, 402, 174, 710, 710, 175, 1548, 1548, 176, 1563, 1563, 177, 1567, 1567, 178, 1569, 1594, 204, 1600, 1618, 223, 1657, 1657, 224, 1662, 1662, 225, 1670, 1670, 226, 1672, 1672, 227, 1681, 1681, 228, 1688, 1688, 229, 1705, 1705, 230, 1711, 1711, 231, 1722, 1722, 232, 1726, 1726, 233, 1729, 1729, 234, 1746, 1746, 235, 8204, 8207, 239, 8211, 8212, 241, 8216, 8218, 244, 8220, 8222, 247, 8224, 8226, 250, 8230, 8230, 251, 8240, 8240, 252, 8249, 8250, 254, 8364, 8364, 255, 8482, 8482, -1};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 20, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 2, 2, 12, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 28, 8, 24, 16, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 8, 8, 3, 8, 3, 8, 8, 8, 8, 8, 8, 3, 8, 3, 3, 3, 3, 3, 8, 8, 8, 8, 8, 8, 8, 3, 8, 3, 8, 3, 8, 8, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 3, 2, 2, 8, 2, 3, 2, 3, 3, 8, 8, 3};

        CP1256Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new Windows125xEncodingSupport(fgCharMap, fgIntervalMap, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP1255Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u20ac', '\ufffd', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\ufffd', '\u2039', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u02dc', '\u2122', '\ufffd', '\u203a', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u20aa', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00d7', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00f7', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u05b0', '\u05b1', '\u05b2', '\u05b3', '\u05b4', '\u05b5', '\u05b6', '\u05b7', '\u05b8', '\u05b9', '\ufffd', '\u05bb', '\u05bc', '\u05bd', '\u05be', '\u05bf', '\u05c0', '\u05c1', '\u05c2', '\u05c3', '\u05f0', '\u05f1', '\u05f2', '\u05f3', '\u05f4', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\u05d0', '\u05d1', '\u05d2', '\u05d3', '\u05d4', '\u05d5', '\u05d6', '\u05d7', '\u05d8', '\u05d9', '\u05da', '\u05db', '\u05dc', '\u05dd', '\u05de', '\u05df', '\u05e0', '\u05e1', '\u05e2', '\u05e3', '\u05e4', '\u05e5', '\u05e6', '\u05e7', '\u05e8', '\u05e9', '\u05ea', '\ufffd', '\ufffd', '\u200e', '\u200f', '\ufffd'};
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, -96, -95, -94, -93, -91, -90, -89, -88, -87, -85, -84, -83, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -69, -68, -67, -66, -65, -86, -70, -125, -120, -104, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -53, -52, -51, -50, -49, -48, -47, -46, -45, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -44, -43, -42, -41, -40, -3, -2, -106, -105, -111, -110, -126, -109, -108, -124, -122, -121, -107, -123, -119, -117, -101, -92, -128, -103};
        static final int[] fgIntervalMap = new int[]{0, 0, 127, 128, 160, 163, 132, 165, 169, 137, 171, 185, 152, 187, 191, 157, 215, 215, 158, 247, 247, 159, 402, 402, 160, 710, 710, 161, 732, 732, 162, 1456, 1465, 172, 1467, 1475, 181, 1488, 1514, 208, 1520, 1524, 213, 8206, 8207, 215, 8211, 8212, 217, 8216, 8218, 220, 8220, 8222, 223, 8224, 8226, 226, 8230, 8230, 227, 8240, 8240, 228, 8249, 8250, 230, 8362, 8362, 231, 8364, 8364, 232, 8482, 8482, -1};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 20, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 2, 2, 12, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 28, 8, 24, 16, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 8, 8, 8, 8, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 2, 2, 2, 8, 2, 8, 2, 2, 8, 3, 3, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 8};

        CP1255Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new Windows125xEncodingSupport(fgCharMap, fgIntervalMap, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP1254Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u20ac', '\ufffd', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0160', '\u2039', '\u0152', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u02dc', '\u2122', '\u0161', '\u203a', '\u0153', '\ufffd', '\ufffd', '\u0178', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u011e', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u0130', '\u015e', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u011f', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u0131', '\u015f', '\u00ff'};
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, -86, -85, -84, -83, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -1, -48, -16, -35, -3, -116, -100, -34, -2, -118, -102, -97, -125, -120, -104, -106, -105, -111, -110, -126, -109, -108, -124, -122, -121, -107, -123, -119, -117, -101, -128, -103};
        static final int[] fgIntervalMap = new int[]{0, 0, 127, 128, 160, 207, 176, 209, 220, 188, 223, 239, 205, 241, 252, 217, 255, 255, 218, 286, 287, 220, 304, 305, 222, 338, 339, 224, 350, 353, 228, 376, 376, 229, 402, 402, 230, 710, 710, 231, 732, 732, 232, 8211, 8212, 234, 8216, 8218, 237, 8220, 8222, 240, 8224, 8226, 243, 8230, 8230, 244, 8240, 8240, 245, 8249, 8250, 247, 8364, 8364, 248, 8482, 8482, -1};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 20, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 2, 2, 12, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 28, 8, 24, 16, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 8, 8, 8, 8, 3, 8, 8, 8, 8, 8, 8, 3, 8, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 8, 3, 8, 8, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3};

        CP1254Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new Windows125xEncodingSupport(fgCharMap, fgIntervalMap, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP1253Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u20ac', '\ufffd', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\ufffd', '\u2030', '\ufffd', '\u2039', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\ufffd', '\u2122', '\ufffd', '\u203a', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\u00a0', '\u0385', '\u0386', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\ufffd', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u2015', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u0384', '\u00b5', '\u00b6', '\u00b7', '\u0388', '\u0389', '\u038a', '\u00bb', '\u038c', '\u00bd', '\u038e', '\u038f', '\u0390', '\u0391', '\u0392', '\u0393', '\u0394', '\u0395', '\u0396', '\u0397', '\u0398', '\u0399', '\u039a', '\u039b', '\u039c', '\u039d', '\u039e', '\u039f', '\u03a0', '\u03a1', '\ufffd', '\u03a3', '\u03a4', '\u03a5', '\u03a6', '\u03a7', '\u03a8', '\u03a9', '\u03aa', '\u03ab', '\u03ac', '\u03ad', '\u03ae', '\u03af', '\u03b0', '\u03b1', '\u03b2', '\u03b3', '\u03b4', '\u03b5', '\u03b6', '\u03b7', '\u03b8', '\u03b9', '\u03ba', '\u03bb', '\u03bc', '\u03bd', '\u03be', '\u03bf', '\u03c0', '\u03c1', '\u03c2', '\u03c3', '\u03c4', '\u03c5', '\u03c6', '\u03c7', '\u03c8', '\u03c9', '\u03ca', '\u03cb', '\u03cc', '\u03cd', '\u03ce', '\ufffd'};
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, -96, -93, -92, -91, -90, -89, -88, -87, -85, -84, -83, -82, -80, -79, -78, -77, -75, -74, -73, -69, -67, -125, -76, -95, -94, -72, -71, -70, -68, -66, -65, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -106, -105, -81, -111, -110, -126, -109, -108, -124, -122, -121, -107, -123, -119, -117, -101, -128, -103};
        static final int[] fgIntervalMap = new int[]{0, 0, 127, 128, 160, 160, 129, 163, 169, 136, 171, 174, 140, 176, 179, 144, 181, 183, 147, 187, 187, 148, 189, 189, 149, 402, 402, 150, 900, 902, 153, 904, 906, 156, 908, 908, 157, 910, 929, 177, 931, 974, 221, 8211, 8213, 224, 8216, 8218, 227, 8220, 8222, 230, 8224, 8226, 233, 8230, 8230, 234, 8240, 8240, 235, 8249, 8250, 237, 8364, 8364, 238, 8482, 8482, -1};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 20, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 2, 2, 12, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 28, 8, 24, 16, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 8, 8, 8, 8, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 2, 3, 3, 3, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8};

        CP1253Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new Windows125xEncodingSupport(fgCharMap, fgIntervalMap, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP1252Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u20ac', '\ufffd', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0160', '\u2039', '\u0152', '\ufffd', '\u017d', '\ufffd', '\ufffd', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u02dc', '\u2122', '\u0161', '\u203a', '\u0153', '\ufffd', '\u017e', '\u0178', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, -86, -85, -84, -83, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1, -116, -100, -118, -102, -97, -114, -98, -125, -120, -104, -106, -105, -111, -110, -126, -109, -108, -124, -122, -121, -107, -123, -119, -117, -101, -128, -103};
        static final int[] fgIntervalMap = new int[]{0, 0, 127, 128, 160, 255, 224, 338, 339, 226, 352, 353, 228, 376, 376, 229, 381, 382, 231, 402, 402, 232, 710, 710, 233, 732, 732, 234, 8211, 8212, 236, 8216, 8218, 239, 8220, 8222, 242, 8224, 8226, 245, 8230, 8230, 246, 8240, 8240, 247, 8249, 8250, 249, 8364, 8364, 250, 8482, 8482, -1};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 20, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 2, 2, 12, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 28, 8, 24, 16, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 8, 8, 8, 8, 3, 8, 8, 8, 8, 8, 8, 3, 8, 3, 8, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 8, 3, 8, 3, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3};

        CP1252Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new Windows125xEncodingSupport(fgCharMap, fgIntervalMap, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP1251Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u0402', '\u0403', '\u201a', '\u0453', '\u201e', '\u2026', '\u2020', '\u2021', '\u20ac', '\u2030', '\u0409', '\u2039', '\u040a', '\u040c', '\u040b', '\u040f', '\u0452', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\ufffd', '\u2122', '\u0459', '\u203a', '\u045a', '\u045c', '\u045b', '\u045f', '\u00a0', '\u040e', '\u045e', '\u0408', '\u00a4', '\u0490', '\u00a6', '\u00a7', '\u0401', '\u00a9', '\u0404', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u0407', '\u00b0', '\u00b1', '\u0406', '\u0456', '\u0491', '\u00b5', '\u00b6', '\u00b7', '\u0451', '\u2116', '\u0454', '\u00bb', '\u0458', '\u0405', '\u0455', '\u0457', '\u0410', '\u0411', '\u0412', '\u0413', '\u0414', '\u0415', '\u0416', '\u0417', '\u0418', '\u0419', '\u041a', '\u041b', '\u041c', '\u041d', '\u041e', '\u041f', '\u0420', '\u0421', '\u0422', '\u0423', '\u0424', '\u0425', '\u0426', '\u0427', '\u0428', '\u0429', '\u042a', '\u042b', '\u042c', '\u042d', '\u042e', '\u042f', '\u0430', '\u0431', '\u0432', '\u0433', '\u0434', '\u0435', '\u0436', '\u0437', '\u0438', '\u0439', '\u043a', '\u043b', '\u043c', '\u043d', '\u043e', '\u043f', '\u0440', '\u0441', '\u0442', '\u0443', '\u0444', '\u0445', '\u0446', '\u0447', '\u0448', '\u0449', '\u044a', '\u044b', '\u044c', '\u044d', '\u044e', '\u044f'};
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, -96, -92, -90, -89, -87, -85, -84, -83, -82, -80, -79, -75, -74, -73, -69, -88, -128, -127, -86, -67, -78, -81, -93, -118, -116, -114, -115, -95, -113, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1, -72, -112, -125, -70, -66, -77, -65, -68, -102, -100, -98, -99, -94, -97, -91, -76, -106, -105, -111, -110, -126, -109, -108, -124, -122, -121, -107, -123, -119, -117, -101, -120, -71, -103};
        static final int[] fgIntervalMap = new int[]{0, 0, 127, 128, 160, 160, 129, 164, 164, 130, 166, 167, 132, 169, 169, 133, 171, 174, 137, 176, 177, 139, 181, 183, 142, 187, 187, 143, 1025, 1036, 155, 1038, 1103, 221, 1105, 1116, 233, 1118, 1119, 235, 1168, 1169, 237, 8211, 8212, 239, 8216, 8218, 242, 8220, 8222, 245, 8224, 8226, 248, 8230, 8230, 249, 8240, 8240, 250, 8249, 8250, 252, 8364, 8364, 253, 8470, 8470, 254, 8482, 8482, -1};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 20, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 2, 2, 12, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 28, 8, 24, 16, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 8, 3, 3, 8, 3, 8, 8, 8, 8, 8, 8, 3, 8, 3, 3, 3, 3, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 8, 3, 3, 3, 3, 8, 3, 3, 3, 8, 3, 8, 8, 3, 8, 3, 8, 8, 8, 8, 3, 8, 8, 3, 3, 3, 8, 8, 2, 3, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};

        CP1251Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new Windows125xEncodingSupport(fgCharMap, fgIntervalMap, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP1250Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u20ac', '\ufffd', '\u201a', '\ufffd', '\u201e', '\u2026', '\u2020', '\u2021', '\ufffd', '\u2030', '\u0160', '\u2039', '\u015a', '\u0164', '\u017d', '\u0179', '\ufffd', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\ufffd', '\u2122', '\u0161', '\u203a', '\u015b', '\u0165', '\u017e', '\u017a', '\u00a0', '\u02c7', '\u02d8', '\u0141', '\u00a4', '\u0104', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u015e', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u017b', '\u00b0', '\u00b1', '\u02db', '\u0142', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u0105', '\u015f', '\u00bb', '\u013d', '\u02dd', '\u013e', '\u017c', '\u0154', '\u00c1', '\u00c2', '\u0102', '\u00c4', '\u0139', '\u0106', '\u00c7', '\u010c', '\u00c9', '\u0118', '\u00cb', '\u011a', '\u00cd', '\u00ce', '\u010e', '\u0110', '\u0143', '\u0147', '\u00d3', '\u00d4', '\u0150', '\u00d6', '\u00d7', '\u0158', '\u016e', '\u00da', '\u0170', '\u00dc', '\u00dd', '\u0162', '\u00df', '\u0155', '\u00e1', '\u00e2', '\u0103', '\u00e4', '\u013a', '\u0107', '\u00e7', '\u010d', '\u00e9', '\u0119', '\u00eb', '\u011b', '\u00ed', '\u00ee', '\u010f', '\u0111', '\u0144', '\u0148', '\u00f3', '\u00f4', '\u0151', '\u00f6', '\u00f7', '\u0159', '\u016f', '\u00fa', '\u0171', '\u00fc', '\u00fd', '\u0163', '\u02d9'};
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, -96, -92, -90, -89, -88, -87, -85, -84, -83, -82, -80, -79, -76, -75, -74, -73, -72, -69, -63, -62, -60, -57, -55, -53, -51, -50, -45, -44, -42, -41, -38, -36, -35, -33, -31, -30, -28, -25, -23, -21, -19, -18, -13, -12, -10, -9, -6, -4, -3, -61, -29, -91, -71, -58, -26, -56, -24, -49, -17, -48, -16, -54, -22, -52, -20, -59, -27, -68, -66, -93, -77, -47, -15, -46, -14, -43, -11, -64, -32, -40, -8, -116, -100, -86, -70, -118, -102, -34, -2, -115, -99, -39, -7, -37, -5, -113, -97, -81, -65, -114, -98, -95, -94, -1, -78, -67, -106, -105, -111, -110, -126, -109, -108, -124, -122, -121, -107, -123, -119, -117, -101, -128, -103};
        static final int[] fgIntervalMap = new int[]{0, 0, 127, 128, 160, 160, 129, 164, 164, 130, 166, 169, 134, 171, 174, 138, 176, 177, 140, 180, 184, 145, 187, 187, 146, 193, 194, 148, 196, 196, 149, 199, 199, 150, 201, 201, 151, 203, 203, 152, 205, 206, 154, 211, 212, 156, 214, 215, 158, 218, 218, 159, 220, 221, 161, 223, 223, 162, 225, 226, 164, 228, 228, 165, 231, 231, 166, 233, 233, 167, 235, 235, 168, 237, 238, 170, 243, 244, 172, 246, 247, 174, 250, 250, 175, 252, 253, 177, 258, 263, 183, 268, 273, 189, 280, 283, 193, 313, 314, 195, 317, 318, 197, 321, 324, 201, 327, 328, 203, 336, 337, 205, 340, 341, 207, 344, 347, 211, 350, 357, 219, 366, 369, 223, 377, 382, 229, 711, 711, 230, 728, 729, 232, 731, 731, 233, 733, 733, 234, 8211, 8212, 236, 8216, 8218, 239, 8220, 8222, 242, 8224, 8226, 245, 8230, 8230, 246, 8240, 8240, 247, 8249, 8250, 249, 8364, 8364, 250, 8482, 8482, -1};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 20, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 2, 2, 12, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 28, 8, 24, 16, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 8, 3, 3, 3, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 8, 3, 3, 3, 3, 8, 8, 8, 3, 8, 3, 8, 8, 8, 8, 3, 8, 8, 8, 8, 3, 8, 8, 8, 3, 8, 8, 8, 2, 8, 3, 3, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 8};

        CP1250Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new Windows125xEncodingSupport(fgCharMap, fgIntervalMap, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }
}

