/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.servlet;

import com.sun.javaws.servlet.JnlpDownloadServlet;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Date;
import java.util.MissingResourceException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public abstract class DownloadResponse {
    private static final String HEADER_LASTMOD = "Last-Modified";
    private static final String HEADER_JNLP_VERSION = "x-java-jnlp-version-id";
    private static final String JNLP_ERROR_MIMETYPE = "application/x-java-jnlp-error";
    public static final int STS_00_OK = 0;
    public static final int ERR_10_NO_RESOURCE = 10;
    public static final int ERR_11_NO_VERSION = 11;
    public static final int ERR_20_UNSUP_OS = 20;
    public static final int ERR_21_UNSUP_ARCH = 21;
    public static final int ERR_22_UNSUP_LOCALE = 22;
    public static final int ERR_23_UNSUP_JRE = 23;
    public static final int ERR_99_UNKNOWN = 99;

    public String toString() {
        return this.getClass().getName();
    }

    abstract void sendRespond(HttpServletResponse var1) throws IOException;

    static DownloadResponse getNotFoundResponse() {
        return new NotFoundResponse();
    }

    static DownloadResponse getNoContentResponse() {
        return new NotFoundResponse();
    }

    static DownloadResponse getJnlpErrorResponse(int n) {
        return new JnlpErrorResponse(n);
    }

    static DownloadResponse getFileDownloadResponse(byte[] byArray, String string, long l, String string2) {
        return new ByteArrayFileDownloadResponse(byArray, string, string2, l);
    }

    static DownloadResponse getFileDownloadResponse(URL uRL, String string, long l, String string2) {
        return new ResourceFileDownloadResponse(uRL, string, string2, l);
    }

    static DownloadResponse getFileDownloadResponse(File file, String string, long l, String string2) {
        return new DiskFileDownloadResponse(file, string, string2, l);
    }

    private static class DiskFileDownloadResponse
    extends FileDownloadResponse {
        private File _file;

        DiskFileDownloadResponse(File file, String string, String string2, long l) {
            super(string, string2, l);
            this._file = file;
        }

        int getContentLength() throws IOException {
            return (int)this._file.length();
        }

        InputStream getContent() throws IOException {
            return new BufferedInputStream(new FileInputStream(this._file));
        }

        public String toString() {
            return super.toString() + "[ " + this.getArgString() + "]";
        }
    }

    private static class ResourceFileDownloadResponse
    extends FileDownloadResponse {
        URL _url;

        ResourceFileDownloadResponse(URL uRL, String string, String string2, long l) {
            super(string, string2, l);
            this._url = uRL;
        }

        int getContentLength() throws IOException {
            return this._url.openConnection().getContentLength();
        }

        InputStream getContent() throws IOException {
            return this._url.openConnection().getInputStream();
        }

        public String toString() {
            return super.toString() + "[ " + this.getArgString() + "]";
        }
    }

    private static class ByteArrayFileDownloadResponse
    extends FileDownloadResponse {
        private byte[] _content;

        ByteArrayFileDownloadResponse(byte[] byArray, String string, String string2, long l) {
            super(string, string2, l);
            this._content = byArray;
        }

        int getContentLength() {
            return this._content.length;
        }

        InputStream getContent() {
            return new ByteArrayInputStream(this._content);
        }

        public String toString() {
            return super.toString() + "[ " + this.getArgString() + "]";
        }
    }

    private static abstract class FileDownloadResponse
    extends DownloadResponse {
        private String _mimeType;
        private String _versionId;
        private long _lastModified;

        FileDownloadResponse(String string, String string2, long l) {
            this._mimeType = string;
            this._versionId = string2;
            this._lastModified = l;
        }

        String getMimeType() {
            return this._mimeType;
        }

        String getVersionId() {
            return this._versionId;
        }

        long getLastModified() {
            return this._lastModified;
        }

        abstract int getContentLength() throws IOException;

        abstract InputStream getContent() throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void sendRespond(HttpServletResponse httpServletResponse) throws IOException {
            httpServletResponse.setContentType(this.getMimeType());
            httpServletResponse.setContentLength(this.getContentLength());
            if (this.getVersionId() != null) {
                httpServletResponse.setHeader(DownloadResponse.HEADER_JNLP_VERSION, this.getVersionId());
            }
            if (this.getLastModified() != 0L) {
                httpServletResponse.setDateHeader(DownloadResponse.HEADER_LASTMOD, this.getLastModified());
            }
            InputStream inputStream = this.getContent();
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            try {
                int n;
                byte[] byArray = new byte[32768];
                while ((n = inputStream.read(byArray)) != -1) {
                    servletOutputStream.write(byArray, 0, n);
                }
                Object var7_6 = null;
                if (inputStream == null) return;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
        }

        protected String getArgString() {
            long l = 0L;
            try {
                l = this.getContentLength();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return "Mimetype=" + this.getMimeType() + " VersionId=" + this.getVersionId() + " Timestamp=" + new Date(this.getLastModified()) + " Length=" + l;
        }
    }

    public static class JnlpErrorResponse
    extends DownloadResponse {
        private String _message;

        public JnlpErrorResponse(int n) {
            String string = Integer.toString(n);
            String string2 = "No description";
            try {
                string2 = JnlpDownloadServlet.getResourceBundle().getString("servlet.jnlp.err." + string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            this._message = string + " " + string2;
        }

        public void sendRespond(HttpServletResponse httpServletResponse) throws IOException {
            httpServletResponse.setContentType(DownloadResponse.JNLP_ERROR_MIMETYPE);
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println(this._message);
        }

        public String toString() {
            return super.toString() + "[" + this._message + "]";
        }
    }

    private static class NoContentResponse
    extends DownloadResponse {
        private NoContentResponse() {
        }

        public void sendRespond(HttpServletResponse httpServletResponse) throws IOException {
            httpServletResponse.sendError(204);
        }
    }

    private static class NotFoundResponse
    extends DownloadResponse {
        private NotFoundResponse() {
        }

        public void sendRespond(HttpServletResponse httpServletResponse) throws IOException {
            httpServletResponse.sendError(404);
        }
    }
}

