/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler.tools;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.PropertyResourceBundle;
import java.util.StringTokenizer;

public class ConvertSQLtoDDL {
    private static final String task = "TASK";
    private static final String treg = "TREG";
    private static final String dropTable = "DROPTABLE";
    private static final String createTable = "CREATETABLE";
    private static final String alterTable = "ALTERTABLE";
    private static final String dropIndex = "DROPINDEX";
    private static final String createIndex = "CREATEINDEX";
    private static final String lease = "LEASE";
    private static final String properties = "PROPERTIES";
    private static final String createSchema = "createSchema";
    private static final String dropSchema = "dropSchema";
    private static final String ddl = "ddl";
    private static final String sql = "sql";
    private static final String go = "\nGO\n\n";
    private static final String semi_colon = ";\n\n";
    private static final String template = "template";
    private static final String cloudscape = "Cloudscape";
    private static final String msg_prefix = "Warning: ConvertSQLtoDDL ";
    private static final String postfix = "POSTFIX";
    private static final String mssql = "MSSQL";
    private static final String mssql7 = "MSSQL7";
    private static final String informix = "INFORMIX";
    private static final String sybase = "SYBASE";
    private static final String sybaseOutputName = "Sybase12";
    private static final String defaultUpper = "DEFAULT";
    private String ending = null;
    private String input_dir = null;
    private String output_dir = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PropertyResourceBundle loadProperties(String string) {
        PropertyResourceBundle propertyResourceBundle = null;
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(string);
        propertyResourceBundle = new PropertyResourceBundle(fileInputStream);
        Object var6_4 = null;
        if (fileInputStream == null) return propertyResourceBundle;
        try {
            fileInputStream.close();
            return propertyResourceBundle;
        }
        catch (Exception exception) {
            System.out.println("Warning: ConvertSQLtoDDL Exception closing " + string);
            System.out.println(exception.getMessage());
        }
        return propertyResourceBundle;
        {
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Warning: ConvertSQLtoDDL Exception attempting to load " + string);
                System.out.println(fileNotFoundException.getMessage());
                Object var6_5 = null;
                if (fileInputStream == null) return propertyResourceBundle;
                try {
                    fileInputStream.close();
                    return propertyResourceBundle;
                }
                catch (Exception exception) {
                    System.out.println("Warning: ConvertSQLtoDDL Exception closing " + string);
                    System.out.println(exception.getMessage());
                }
                return propertyResourceBundle;
            }
            catch (SecurityException securityException) {
                System.out.println("Warning: ConvertSQLtoDDL Exception attempting to load " + string);
                System.out.println(securityException.getMessage());
                Object var6_6 = null;
                if (fileInputStream == null) return propertyResourceBundle;
                try {
                    fileInputStream.close();
                    return propertyResourceBundle;
                }
                catch (Exception exception) {
                    System.out.println("Warning: ConvertSQLtoDDL Exception closing " + string);
                    System.out.println(exception.getMessage());
                }
                return propertyResourceBundle;
            }
            catch (IOException iOException) {
                System.out.println("Warning: ConvertSQLtoDDL Exception attempting to load " + string);
                System.out.println(iOException.getMessage());
                Object var6_7 = null;
                if (fileInputStream == null) return propertyResourceBundle;
                try {
                    fileInputStream.close();
                    return propertyResourceBundle;
                }
                catch (Exception exception) {
                    System.out.println("Warning: ConvertSQLtoDDL Exception closing " + string);
                    System.out.println(exception.getMessage());
                }
                return propertyResourceBundle;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                System.out.println("Warning: ConvertSQLtoDDL Exception closing " + string);
                System.out.println(exception.getMessage());
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeProlog(String string, String string2, FileWriter fileWriter) {
        String string3 = string2.toUpperCase();
        FileReader fileReader = null;
        char[] cArray = new char[1024];
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer(this.input_dir);
        stringBuffer.append("/templates/");
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append(".");
        stringBuffer.append(template);
        string4 = stringBuffer.toString();
        try {
            fileReader = new FileReader(string4);
        }
        catch (IOException iOException) {
            System.out.println("Warning: ConvertSQLtoDDL Exception attempting to open " + string4);
            System.out.println(iOException.getMessage());
            return false;
        }
        try {
            try {
                int n = 0;
                int n2 = cArray.length;
                while ((n2 = fileReader.read(cArray, n, n2)) != -1) {
                    fileWriter.write(cArray, n, n2);
                }
                fileWriter.write("\n\n");
                fileWriter.flush();
                fileReader.close();
            }
            catch (IOException iOException) {
                System.out.println("Warning: ConvertSQLtoDDL Exception attempting to read " + string4 + " or write to" + fileWriter.toString());
                System.out.println(iOException.getMessage());
                boolean bl = false;
                Object var12_15 = null;
                if (fileReader == null) return bl;
                try {
                    fileReader.close();
                    return bl;
                }
                catch (Exception exception) {
                    System.out.println("Warning: ConvertSQLtoDDL Exception closing " + fileReader);
                    System.out.println(exception.getMessage());
                    return false;
                }
            }
            Object var12_14 = null;
            if (fileReader == null) return true;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (fileReader == null) throw throwable;
            try {}
            catch (Exception exception) {
                System.out.println("Warning: ConvertSQLtoDDL Exception closing " + fileReader);
                System.out.println(exception.getMessage());
                return false;
            }
            fileReader.close();
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            System.out.println("Warning: ConvertSQLtoDDL Exception closing " + fileReader);
            System.out.println(exception.getMessage());
            return false;
        }
        fileReader.close();
        return true;
    }

    private void writeDDL(String string, FileWriter fileWriter, String string2) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            if (stringTokenizer.hasMoreTokens()) {
                fileWriter.write(stringTokenizer.nextToken());
            }
            while (stringTokenizer.hasMoreTokens()) {
                fileWriter.write(",\n              " + stringTokenizer.nextToken());
            }
            if (string2 != null) {
                fileWriter.write(string2);
            }
            fileWriter.write(this.ending);
            fileWriter.flush();
        }
        catch (IOException iOException) {
            System.out.println("Warning: ConvertSQLtoDDL Exception attempting to write to" + fileWriter.toString());
            System.out.println(iOException.getMessage());
        }
        catch (NoSuchElementException noSuchElementException) {
            System.out.println("Warning: ConvertSQLtoDDL Exception attempting to write to" + fileWriter.toString());
            System.out.println(noSuchElementException.getMessage());
        }
    }

    private String replaceCarrot(String string) {
        String string2 = null;
        String string3 = null;
        if (string == null || string.equals("")) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<>");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        } else {
            System.out.println("Warning: ConvertSQLtoDDL  expected a token and one was not found in string " + string);
        }
        while (stringTokenizer.hasMoreTokens()) {
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken().toUpperCase();
            } else {
                System.out.println("Warning: ConvertSQLtoDDL  expected a token and one was not found in string " + string);
            }
            string2 = string2 + "@" + string3 + "@";
            if (!stringTokenizer.hasMoreTokens()) continue;
            string2 = string2 + stringTokenizer.nextToken();
        }
        return string2;
    }

    private void convertStatement(String string, FileWriter fileWriter, String string2) {
        String string3 = this.replaceCarrot(string);
        String string4 = this.replaceCarrot(string2);
        this.writeDDL(string3, fileWriter, string4);
    }

    private String getPropertyValue(PropertyResourceBundle propertyResourceBundle, String string) {
        String string2 = null;
        try {
            string2 = propertyResourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }

    private String getSQLString(PropertyResourceBundle propertyResourceBundle, String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("_");
        stringBuffer.append(string3);
        stringBuffer.append("_");
        stringBuffer.append(string2);
        StringBuffer stringBuffer2 = new StringBuffer(string);
        stringBuffer2.append("_");
        stringBuffer2.append(defaultUpper);
        stringBuffer2.append("_");
        stringBuffer2.append(string2);
        String string4 = this.getPropertyValue(propertyResourceBundle, stringBuffer.toString());
        if (string4 == null) {
            string4 = this.getPropertyValue(propertyResourceBundle, stringBuffer2.toString());
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateCreateDDLforPlatform(PropertyResourceBundle propertyResourceBundle, PropertyResourceBundle propertyResourceBundle2, String string) {
        FileWriter fileWriter;
        String string2;
        block18: {
            String string3 = string.toUpperCase();
            String string4 = this.getSQLString(propertyResourceBundle, task, createTable, string3);
            String string5 = this.getSQLString(propertyResourceBundle, task, alterTable, string3);
            String string6 = this.getSQLString(propertyResourceBundle, task, "CREATEINDEX1", string3);
            String string7 = this.getSQLString(propertyResourceBundle, task, "CREATEINDEX2", string3);
            String string8 = this.getSQLString(propertyResourceBundle, treg, createTable, string3);
            String string9 = this.getSQLString(propertyResourceBundle, treg, alterTable, string3);
            String string10 = this.getSQLString(propertyResourceBundle2, lease, createTable, string3);
            String string11 = this.getSQLString(propertyResourceBundle2, lease, alterTable, string3);
            String string12 = this.getSQLString(propertyResourceBundle2, "LEASE_PROPERTIES", createTable, string3);
            String string13 = this.getSQLString(propertyResourceBundle2, "LEASE_PROPERTIES", alterTable, string3);
            String string14 = this.getSQLString(propertyResourceBundle2, "LEASE_PROPERTIES", createIndex, string3);
            String string15 = this.getSQLString(propertyResourceBundle, postfix, createTable, string3);
            String string16 = this.getSQLString(propertyResourceBundle, postfix, alterTable, string3);
            String string17 = this.getSQLString(propertyResourceBundle, postfix, "CREATEINDEX1", string3);
            string2 = null;
            String string18 = null;
            string18 = string3.equals(mssql) || string3.equals(mssql7) || string3.equals(informix) ? sql : ddl;
            StringBuffer stringBuffer = new StringBuffer(this.output_dir);
            stringBuffer.append("/");
            stringBuffer.append(createSchema);
            String string19 = null;
            string19 = string3.equals(sybase) ? sybaseOutputName : string;
            stringBuffer.append(string19);
            stringBuffer.append(".");
            stringBuffer.append(string18);
            string2 = stringBuffer.toString();
            fileWriter = null;
            fileWriter = new FileWriter(string2, false);
            this.writeProlog(createSchema, string, fileWriter);
            this.ending = string3.equals(mssql) || string3.equals(mssql7) || string3.equals(sybase) ? go : semi_colon;
            if (string4 != null) {
                this.convertStatement(string4, fileWriter, string15);
            }
            if (string5 != null) {
                this.convertStatement(string5, fileWriter, string16);
            }
            if (string6 != null) {
                this.convertStatement(string6, fileWriter, string17);
            }
            if (string7 != null) {
                this.convertStatement(string7, fileWriter, string17);
            }
            if (string8 != null) {
                this.convertStatement(string8, fileWriter, string15);
            }
            if (string9 != null) {
                this.convertStatement(string9, fileWriter, string16);
            }
            if (string10 != null) {
                this.convertStatement(string10, fileWriter, string15);
            }
            if (string11 != null) {
                this.convertStatement(string11, fileWriter, string16);
            }
            if (string12 != null) {
                this.convertStatement(string12, fileWriter, string15);
            }
            if (string13 != null) {
                this.convertStatement(string13, fileWriter, string16);
            }
            if (string14 == null) break block18;
            this.convertStatement(string14, fileWriter, string17);
        }
        Object var26_24 = null;
        if (fileWriter == null) return;
        try {
            fileWriter.close();
            return;
        }
        catch (Exception exception) {
            System.out.println("Warning: ConvertSQLtoDDL Exception closing " + string2);
            System.out.println(exception.getMessage());
        }
        return;
        {
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                Object var26_25 = null;
                if (fileWriter == null) return;
                try {
                    fileWriter.close();
                    return;
                }
                catch (Exception exception) {
                    System.out.println("Warning: ConvertSQLtoDDL Exception closing " + string2);
                    System.out.println(exception.getMessage());
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var26_26 = null;
            if (fileWriter == null) throw throwable;
            try {
                fileWriter.close();
                throw throwable;
            }
            catch (Exception exception) {
                System.out.println("Warning: ConvertSQLtoDDL Exception closing " + string2);
                System.out.println(exception.getMessage());
            }
            throw throwable;
        }
    }

    private void generateDropDDLforPlatform(PropertyResourceBundle propertyResourceBundle, PropertyResourceBundle propertyResourceBundle2, String string) {
        String string2 = string.toUpperCase();
        String string3 = this.getSQLString(propertyResourceBundle, task, dropTable, string2);
        String string4 = this.getSQLString(propertyResourceBundle, task, "DROPINDEX1", string2);
        String string5 = this.getSQLString(propertyResourceBundle, task, "DROPINDEX2", string2);
        String string6 = this.getSQLString(propertyResourceBundle, treg, dropTable, string2);
        String string7 = this.getSQLString(propertyResourceBundle2, lease, dropTable, string2);
        String string8 = this.getSQLString(propertyResourceBundle2, "LEASE_PROPERTIES", dropTable, string2);
        String string9 = this.getSQLString(propertyResourceBundle2, "LEASE_PROPERTIES", dropIndex, string2);
        String string10 = null;
        String string11 = null;
        string11 = string2.equals(mssql) || string2.equals(mssql7) || string2.equals(informix) ? sql : ddl;
        StringBuffer stringBuffer = new StringBuffer(this.output_dir);
        stringBuffer.append("/");
        stringBuffer.append(dropSchema);
        String string12 = null;
        string12 = string2.equals(sybase) ? sybaseOutputName : string;
        stringBuffer.append(string12);
        stringBuffer.append(".");
        stringBuffer.append(string11);
        string10 = stringBuffer.toString();
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string10, false);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        this.writeProlog(dropSchema, string, fileWriter);
        this.ending = string2.equals(mssql) || string2.equals(mssql7) || string2.equals(sybase) ? go : semi_colon;
        if (string4 != null) {
            this.convertStatement(string4, fileWriter, "");
        }
        if (string5 != null) {
            this.convertStatement(string5, fileWriter, "");
        }
        if (string3 != null) {
            this.convertStatement(string3, fileWriter, "");
        }
        if (string6 != null) {
            this.convertStatement(string6, fileWriter, "");
        }
        if (string7 != null) {
            this.convertStatement(string7, fileWriter, "");
        }
        if (string9 != null) {
            this.convertStatement(string9, fileWriter, "");
        }
        if (string8 != null) {
            this.convertStatement(string8, fileWriter, "");
        }
    }

    private void convert(String[] stringArray) {
        if (stringArray.length < 4) {
            System.out.println("Warning: ConvertSQLtoDDL Not enough args inputted, num of args is = " + stringArray.length);
            System.out.println("The positional arguments are: ");
            System.out.println("   input directory: fully qualified directory for properties and template files.");
            System.out.println("   output directory: fully qualified directory for storing generated DDL files.");
            System.out.println("   database properties: name of properties file that contain TASK SQL statements.");
            System.out.println("   lease properties: name of properties file that contain Lease Manager SQL statements.");
            System.out.println("   platform list: a blank delimeted list of platform names. (0-n platforms)");
        } else {
            this.input_dir = stringArray[0];
            this.output_dir = stringArray[1];
            String string = stringArray[2];
            String string2 = stringArray[3];
            PropertyResourceBundle propertyResourceBundle = this.loadProperties(this.input_dir + "/" + string);
            PropertyResourceBundle propertyResourceBundle2 = this.loadProperties(this.input_dir + "/" + string2);
            String string3 = null;
            for (int i = 4; i < stringArray.length; ++i) {
                string3 = stringArray[i];
                this.generateCreateDDLforPlatform(propertyResourceBundle, propertyResourceBundle2, string3);
                this.generateDropDDLforPlatform(propertyResourceBundle, propertyResourceBundle2, string3);
            }
        }
    }

    public static void main(String[] stringArray) {
        ConvertSQLtoDDL convertSQLtoDDL = new ConvertSQLtoDDL();
        convertSQLtoDDL.convert(stringArray);
    }
}

