/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.java.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jem.internal.java.adapters.IJavaReflectionKeyExtension;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaDataType;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.Method;

public class JavaReflectionKey {
    public static final String N_VOID = "void";
    public static final String N_INT = "int";
    public static final String N_BOOLEAN = "boolean";
    public static final String N_CHAR = "char";
    public static final String N_BYTE = "byte";
    public static final String N_LONG = "long";
    public static final String N_FLOAT = "float";
    public static final String N_DOUBLE = "double";
    public static final String N_SHORT = "short";
    private static final Collection PRIMITIVES = new ArrayList(8);
    protected XMIResource resource;
    protected List extensions;

    static {
        JavaReflectionKey.initializePrimitivesCollection();
    }

    public JavaReflectionKey(List extensions, XMIResource resource) {
        this.extensions = extensions;
        this.resource = resource;
    }

    public ArrayType createArrayType() {
        return JavaReflectionKey.getJavaFactory().createArrayType();
    }

    public JavaClass createJavaClass() {
        return JavaReflectionKey.getJavaFactory().createJavaClass();
    }

    protected EClassifier getJavaDataType(String typeName) {
        JavaDataType result = JavaReflectionKey.getJavaFactory().createJavaDataType();
        result.setName(typeName);
        this.getPackage().getEClassifiers().add((Object)result);
        this.resource.setID((EObject)result, typeName);
        return result;
    }

    public Field createJavaField() {
        return JavaReflectionKey.getJavaFactory().createField();
    }

    public Method createJavaMethod() {
        return JavaReflectionKey.getJavaFactory().createMethod();
    }

    public JavaParameter createJavaParameter() {
        return JavaReflectionKey.getJavaFactory().createJavaParameter();
    }

    public Object get(String key) {
        Object javaObject = this.getObjectFromExtensions(key);
        if (javaObject == null) {
            javaObject = this.getJavaObject(key);
        }
        return javaObject;
    }

    public EClassifier getArrayType(String typeName) {
        ArrayType arrayType = this.createArrayType();
        arrayType.setName(typeName);
        int pos = -1;
        int braces = 0;
        do {
            if ((pos = typeName.indexOf("[", pos + 1)) == -1) continue;
            ++braces;
        } while (pos != -1);
        arrayType.setArrayDimensions(braces);
        this.getPackage().getEClassifiers().add((Object)arrayType);
        this.resource.setID((EObject)arrayType, typeName);
        return arrayType;
    }

    public EClassifier getJavaClass(String typeName) {
        JavaClass javaClass = this.createJavaClass();
        javaClass.setName(typeName);
        this.getPackage().getEClassifiers().add((Object)javaClass);
        this.resource.setID((EObject)javaClass, typeName);
        return javaClass;
    }

    protected static JavaRefFactory getJavaFactory() {
        return JavaRefFactory.eINSTANCE;
    }

    protected Field getJavaField(String keyValue) {
        Field result = null;
        int memberDelimiter = keyValue.indexOf(46);
        String className = keyValue.substring(0, memberDelimiter);
        String memberName = keyValue.substring(memberDelimiter + 1);
        EClassifier javaClass = (EClassifier)this.primGet(className);
        if (javaClass == null) {
            javaClass = this.getJavaType(className);
        }
        if (javaClass != null && !((JavaHelpers)javaClass).isPrimitive()) {
            ((JavaClass)javaClass).getFields();
            result = (Field)this.primGet(keyValue);
            if (result == null) {
                Field tempField = this.createJavaField();
                tempField.setName(memberName);
                ((JavaClass)javaClass).getFields().add((Object)tempField);
                result = tempField;
            }
        }
        return result;
    }

    protected Method getJavaMethod(String keyValue) {
        Method result = null;
        int memberDelimiter = keyValue.indexOf(46);
        String className = keyValue.substring(0, memberDelimiter);
        int parmDelimiter = keyValue.indexOf(40, memberDelimiter);
        String memberName = keyValue.substring(memberDelimiter + 1, parmDelimiter);
        EClassifier javaClass = (EClassifier)this.primGet(className);
        if (javaClass == null) {
            javaClass = this.getJavaType(className);
        }
        if (javaClass != null && !((JavaHelpers)javaClass).isPrimitive()) {
            ((JavaClass)javaClass).getMethods();
            result = (Method)this.primGet(keyValue);
            if (result == null) {
                Method tempMethod = this.createJavaMethod();
                tempMethod.setName(memberName);
                this.resource.setID((EObject)tempMethod, keyValue);
                ((JavaClass)javaClass).getMethods().add((Object)tempMethod);
                result = tempMethod;
            }
        }
        return result;
    }

    public EObject getJavaObject(String keyValue) {
        Object result = null;
        int index = keyValue.indexOf(46);
        if (index > 0) {
            boolean isParameter;
            boolean bl = isParameter = keyValue.indexOf(45, index) != -1;
            if (isParameter) {
                result = this.getJavaParameter(keyValue);
            } else {
                boolean isField;
                int parmStart = keyValue.indexOf(40, index);
                boolean bl2 = isField = parmStart == -1;
                result = isField ? this.getJavaField(keyValue) : this.getJavaMethod(keyValue);
            }
        } else {
            result = this.getJavaType(keyValue);
        }
        return result;
    }

    protected Object getObjectFromExtensions(String keyValue) {
        if (this.extensions != null) {
            Iterator iter = this.extensions.iterator();
            while (iter.hasNext()) {
                IJavaReflectionKeyExtension extension = (IJavaReflectionKeyExtension)iter.next();
                Object obj = extension.getObject(keyValue, this);
                if (obj == null) continue;
                return obj;
            }
        }
        return null;
    }

    protected JavaParameter getJavaParameter(String keyValue) {
        JavaParameter result = null;
        int memberDelimiter = keyValue.indexOf(46);
        int parmDelimiter = keyValue.indexOf(45, memberDelimiter);
        String parmName = keyValue.substring(parmDelimiter + 1);
        Method method = this.getJavaMethod(keyValue.substring(parmDelimiter));
        if (method != null && (result = method.getParameter(parmName)) == null) {
            JavaParameter tempParameter = this.createJavaParameter();
            tempParameter.setName(parmName);
            method.getParameters().add((Object)tempParameter);
            result = tempParameter;
        }
        return result;
    }

    public EClassifier getJavaType(String typeName) {
        if (this.isPrimitive(typeName)) {
            return this.getJavaDataType(typeName);
        }
        if (this.isArray(typeName)) {
            return this.getArrayType(typeName);
        }
        if (this.isValidJavaIdentifier(typeName)) {
            return this.getJavaClass(typeName);
        }
        return null;
    }

    protected boolean isValidJavaIdentifier(String typeName) {
        if (typeName.length() > 0 && Character.isJavaIdentifierStart(typeName.charAt(0))) {
            int i = 1;
            while (i < typeName.length()) {
                if (!Character.isJavaIdentifierPart(typeName.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public Object primGet(String key) {
        return this.resource.getIDToEObjectMap().get(key);
    }

    protected EPackage getPackage() {
        return (EPackage)EcoreUtil.getObjectByType((Collection)this.resource.getContents(), (EClassifier)EcorePackage.eINSTANCE.getEPackage());
    }

    private static void initializePrimitivesCollection() {
        PRIMITIVES.add(N_VOID);
        PRIMITIVES.add(N_BOOLEAN);
        PRIMITIVES.add(N_BYTE);
        PRIMITIVES.add(N_CHAR);
        PRIMITIVES.add(N_DOUBLE);
        PRIMITIVES.add(N_FLOAT);
        PRIMITIVES.add(N_INT);
        PRIMITIVES.add(N_LONG);
        PRIMITIVES.add(N_SHORT);
    }

    public boolean isArray(String typeName) {
        return typeName.endsWith("[]");
    }

    private boolean isPrimitive(String typeName) {
        return PRIMITIVES.contains(typeName);
    }
}

