/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.xmi10;

import com.ibm.xmi.uml.UML;
import com.ibm.xmi.uml.UMLException;
import com.ibm.xmi.utility.Stat;
import com.ibm.xmi.xmi10.DefaultTransform;
import com.ibm.xmi.xmi10.Output;
import com.ibm.xmi.xmi10.ToolkitException;
import com.ibm.xmi.xmi10.Transform;
import com.ibm.xmi.xmi10.TransformFactory;
import com.ibm.xmi.xmi10.TransformUtility;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.Vector;

public class Toolkit
extends DefaultTransform {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999,2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Toolkit toolkit;
    private Transform currentTransform;
    private int numActive;
    private int numCompleted;
    private int numOpen;
    private Stat s0;
    private String loader;
    private boolean saveMemory;
    private boolean debug;
    private boolean expert;
    private boolean quiet;
    private final String version = new String("1.25");
    private boolean autoTesting;
    static /* synthetic */ Class class$com$ibm$xmi$xmi10$Toolkit;

    public Toolkit() {
        this.init();
    }

    private boolean areAllTransformsCompleted() {
        TransformFactory transformFactory = TransformFactory.instance();
        boolean bl = true;
        for (int i = 1; i < transformFactory.numTransforms(); ++i) {
            Transform transform = transformFactory.getTransform(i);
            if (transform.isClosed()) continue;
            bl = false;
        }
        return bl;
    }

    public static void autoTest(String[] stringArray) {
        Toolkit toolkit = Toolkit.instance();
        toolkit.autoTesting = true;
        toolkit.run(stringArray);
        Toolkit.toolkit = null;
    }

    public void done() {
        if (this.areAllTransformsCompleted()) {
            if (this.autoTesting) {
                return;
            }
            if (!this.getQuiet()) {
                Stat stat = new Stat(this.s0);
                stat.print("Total toolkit time");
            }
            System.exit(0);
        }
    }

    public static void error(String string) throws ToolkitException {
        Output.out("Toolkit error: " + string);
        Output.out("For help, run again with no parameters.");
        throw new ToolkitException(string);
    }

    public static Transform getCurrentTransform() {
        return Toolkit.instance().currentTransform;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public boolean getExpert() {
        return this.expert;
    }

    public String getLoader() {
        return this.loader;
    }

    public boolean getQuiet() {
        return this.quiet;
    }

    public boolean getSaveMemory() {
        return this.saveMemory;
    }

    public String getVersion() {
        return this.version;
    }

    public static void help() {
        Output.out("The XMI Toolkit will run a series of transform beans in the order you specify.");
        Output.out("(If no argument is provided, an user interface window will be shown.)");
        Output.out("Syntax:  Bean1 Bean2(-option1 value -option2 value) Bean3");
        Output.out("A \"?\" instead of a bean will print the settings.");
        Output.out("A \"??\" instead of a bean will include expert settings with a *.");
        Output.out("");
        Output.out("The following transform beans are available:");
        TransformUtility transformUtility = TransformUtility.instance();
        transformUtility.instantiateAll();
        transformUtility.printAllTransforms(Toolkit.instance().getExpert(), false);
    }

    public void init() {
        this.numActive = 0;
        this.numCompleted = 0;
        this.numOpen = 0;
        this.currentTransform = this;
        this.loader = "";
        this.saveMemory = false;
        this.debug = false;
        this.expert = false;
        this.quiet = true;
    }

    public static Toolkit instance() {
        TransformFactory transformFactory;
        if (toolkit == null && (toolkit = (Toolkit)(transformFactory = TransformFactory.instance()).getTransform(class$com$ibm$xmi$xmi10$Toolkit == null ? (class$com$ibm$xmi$xmi10$Toolkit = Toolkit.class$("com.ibm.xmi.xmi10.Toolkit")) : class$com$ibm$xmi$xmi10$Toolkit)) == null) {
            toolkit = (Toolkit)transformFactory.makeTransform(class$com$ibm$xmi$xmi10$Toolkit == null ? (class$com$ibm$xmi$xmi10$Toolkit = Toolkit.class$("com.ibm.xmi.xmi10.Toolkit")) : class$com$ibm$xmi$xmi10$Toolkit);
        }
        return toolkit;
    }

    private void linkTransforms() {
        TransformFactory transformFactory = TransformFactory.instance();
        Transform transform = null;
        for (int i = 1; i < transformFactory.numTransforms(); ++i) {
            Transform transform2 = transformFactory.getTransform(i);
            if (transform != null) {
                transform.addPropertyChangeListener(transform2);
            }
            transform2.addPropertyChangeListener(this);
            transform = transform2;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 0 && stringArray[0].equals("?")) {
            Toolkit.help();
            return;
        }
        Toolkit toolkit = Toolkit.instance();
        toolkit.run(stringArray);
    }

    public boolean process(String[] stringArray) throws ToolkitException {
        Vector vector = this.processParens(stringArray);
        return this.processParameters(vector);
    }

    private boolean processParameters(Vector vector) throws ToolkitException {
        Enumeration enumeration = vector.elements();
        boolean bl = false;
        String string = null;
        Transform transform = this;
        boolean bl2 = true;
        TransformUtility transformUtility = TransformUtility.instance();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Output.dbg("Processing '" + string2 + "'");
            if (string2.equals("?")) {
                transformUtility.instantiateAll();
                transformUtility.printAllTransforms(this.getExpert(), false);
                bl2 = false;
                continue;
            }
            if (string2.equals("??")) {
                transformUtility.instantiateAll();
                transformUtility.printAllTransforms(true, false);
                bl2 = false;
                continue;
            }
            if (string2.equals("(")) {
                if (bl) {
                    Toolkit.error("Nested left parentheses.");
                }
                if (transform == null) {
                    Toolkit.error("Missing transform name.");
                }
                bl = true;
                continue;
            }
            if (string2.equals(")")) {
                if (bl) {
                    transform = null;
                    bl = false;
                    continue;
                }
                Toolkit.error("Missing left parenthesis.");
                continue;
            }
            if (bl) {
                if (string2.charAt(0) == '-' || string2.charAt(0) == '/') {
                    string = string2.substring(1);
                    if (transform.propertyDescriptor(string) != null) continue;
                    Toolkit.error("Option -" + string + " is not part of bean " + transform.getName() + ".");
                    continue;
                }
                if (!transform.setProperty(string, string2)) {
                    Toolkit.error("Option -" + string + " could not be set to value " + string2 + ".");
                }
                string = null;
                continue;
            }
            transform = TransformFactory.instance().makeTransform(string2);
            if (transform != null) continue;
            Toolkit.error("Bean '" + string2 + "' not found.");
        }
        if (bl) {
            Toolkit.error("No closing right parenthesis.");
        }
        return bl2;
    }

    private Vector processParens(String[] stringArray) {
        Vector<String> vector = new Vector<String>(stringArray.length + 4);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = string.length();
            if (n > 1) {
                if (string.charAt(0) == '(') {
                    vector.addElement("(");
                    vector.addElement(string.substring(1));
                    continue;
                }
                if (string.charAt(n - 1) == ')') {
                    vector.addElement(string.substring(0, n - 1));
                    vector.addElement(")");
                    continue;
                }
                int n2 = string.indexOf(40);
                if (n2 > 0) {
                    vector.addElement(string.substring(0, n2));
                    vector.addElement("(");
                    vector.addElement(string.substring(n2 + 1));
                    continue;
                }
            }
            vector.addElement(string);
        }
        return vector;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Transform transform = (Transform)propertyChangeEvent.getSource();
        if (propertyChangeEvent.getPropertyName().equals(Transform.progress)) {
            if (transform.isConst()) {
                return;
            }
            this.setScaledProgress(this.numCompleted * 100 + (Integer)propertyChangeEvent.getNewValue());
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals(Transform.finished)) {
            if (!transform.isConst()) {
                ++this.numCompleted;
            }
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals(Transform.started)) {
            this.currentTransform = transform;
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals(Transform.closed)) {
            if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                --this.numOpen;
                if (this.numOpen <= 0 && this.numCompleted >= this.numActive) {
                    this.done();
                }
            } else {
                ++this.numOpen;
            }
        }
    }

    public void ready() {
        TransformFactory transformFactory = TransformFactory.instance();
        Enumeration enumeration = transformFactory.transformsLoaded();
        enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            Transform transform = (Transform)enumeration.nextElement();
            transform.ready();
            if (transform.isConst()) continue;
            ++this.numActive;
        }
    }

    private void run(String[] stringArray) {
        if (!this.autoTesting) {
            this.s0 = new Stat();
        }
        try {
            if (stringArray.length == 0 || stringArray[0].length() == 0) {
                this.done();
            } else if (this.process(stringArray)) {
                this.linkTransforms();
                this.ready();
                this.start();
            }
        }
        catch (ToolkitException toolkitException) {
        }
        catch (Exception exception) {
            Output.exc(exception);
        }
        if (!this.autoTesting && stringArray.length != 0) {
            this.done();
        }
    }

    public void setDebug(boolean bl) {
        boolean bl2 = this.debug;
        this.debug = bl;
        UML.instance().setLog(bl);
        Output.setDebug(bl);
        this.fire("debug", (Object)new Boolean(bl2), (Object)new Boolean(this.debug));
    }

    public void setExpert(boolean bl) {
        boolean bl2 = this.expert;
        this.expert = bl;
        this.fire("expert", (Object)new Boolean(bl2), (Object)new Boolean(this.expert));
    }

    public void setLoader(String string) {
        String string2 = this.loader;
        this.loader = string;
        TransformFactory.instance().setCustomLoader(this.loader);
        this.fire("loader", (Object)string2, (Object)this.loader);
    }

    public void setQuiet(boolean bl) {
        boolean bl2 = this.quiet;
        this.quiet = bl;
        Output.setQuiet(bl);
        this.fire("quiet", (Object)new Boolean(bl2), (Object)new Boolean(this.quiet));
    }

    public void setSaveMemory(boolean bl) {
        boolean bl2 = this.saveMemory;
        try {
            UML.instance().setSaveMemory(bl);
            this.saveMemory = bl;
            this.fire("saveMemory", (Object)new Boolean(bl2), (Object)new Boolean(this.saveMemory));
        }
        catch (UMLException uMLException) {
            Output.exc(uMLException);
        }
    }

    public void setVersion(String string) {
        Output.out("-version is " + this.version + " and cannot be set.");
    }

    public void start() {
        this.setProgressScale(this.numActive * 100);
        this.numCompleted = 0;
        this.preStart();
        if (TransformFactory.instance().numTransforms() > 1) {
            Transform transform = TransformFactory.instance().getTransform(1);
            transform.start();
        }
        Output.dbg("All Transforms complete.");
        this.postStart();
    }

    public void test() {
        TransformUtility.instance().instantiateAll();
        this.start();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

