/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.uml;

import com.ibm.xmi.mod.Id;
import com.ibm.xmi.mod.ModelAPI;
import com.ibm.xmi.mod.ModelLink;
import com.ibm.xmi.mod.ModelProperty;
import com.ibm.xmi.mod.PrintXML;
import com.ibm.xmi.mod.XMISave;
import com.ibm.xmi.uml.Link;
import com.ibm.xmi.uml.Property;
import com.ibm.xmi.uml.Type;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipOutputStream;

class UMLXMISave
extends XMISave {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public UMLXMISave(ModelAPI modelAPI, Vector vector, File file, ZipOutputStream zipOutputStream, int n, String string, String string2, String string3, Vector vector2, Vector vector3, Vector vector4) {
        super(modelAPI, vector, file, zipOutputStream, n, string, string2, string3, vector2, vector3, vector4);
    }

    protected Vector getSetNames(Id id) throws Exception {
        Vector vector = id.getSets();
        if (vector == null) {
            vector = new Vector(1);
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (!vector.elementAt(i).equals("")) continue;
            vector.removeElementAt(i);
        }
        if (id.getType() == Type.STEREOTYPE && vector.contains("requiredTag")) {
            vector.removeElement("requiredTag");
        }
        return vector;
    }

    protected void printAttribute(ModelProperty modelProperty, Id id, int n) throws Exception {
        if (modelProperty == Property.EXTENSION_POINT) {
            this.printExtensionPoint(id, n);
        } else {
            super.printAttribute(modelProperty, id, n);
        }
    }

    protected void printExtensionLinks(Id id, int n) throws Exception {
        super.printExtensionLinks(id, n);
        this.printLink(id, Link.TAGGED_VALUE, null, n);
    }

    private void printExtensionPoint(Id id, int n) throws Exception {
        Property property = Property.EXTENSION_POINT;
        String string = id.get(property);
        if (string != null) {
            PrintXML.printStartElement(((ModelProperty)property).getFullName(), null, false, n);
            PrintXML.printStartElement("XMI.any", null, false, -1);
            PrintXML.printText(string);
            PrintXML.printEndElement("XMI.any", -1);
            PrintXML.printEndElement(((ModelProperty)property).getFullName(), -1);
        }
    }

    protected void printLink(Id id, ModelLink modelLink, Vector vector, int n) throws Exception {
        if (modelLink == Link.TAGGED_VALUE || modelLink == Link.REQUIRED_TAG) {
            this.printTaggedValues(id, modelLink, n);
        } else {
            super.printLink(id, modelLink, vector, n);
        }
    }

    private void printTaggedValues(Id id, ModelLink modelLink, int n) throws Exception {
        Vector vector = null;
        if (modelLink == Link.TAGGED_VALUE) {
            vector = id.getTags("");
        } else if (modelLink == Link.REQUIRED_TAG) {
            vector = id.getTags("requiredTag");
        }
        if (vector == null) {
            return;
        }
        PrintXML.printStartElement(modelLink.getFullName(), null, false, n);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = null;
            if (modelLink == Link.TAGGED_VALUE) {
                string2 = id.get("", string);
            } else if (modelLink == Link.REQUIRED_TAG) {
                string2 = id.get("requiredTag", string);
            }
            PrintXML.printStartElement(Type.TAGGED_VALUE.getFullName(), null, false, n + 2);
            PrintXML.printStartElement(Property.TAG.getFullName(), null, false, n + 4);
            PrintXML.printText(string);
            PrintXML.printEndElement(Property.TAG.getFullName(), -1);
            PrintXML.printStartElement(Property.TG_VALUE.getFullName(), null, false, n + 4);
            PrintXML.printText(string2);
            PrintXML.printEndElement(Property.TG_VALUE.getFullName(), -1);
            PrintXML.printEndElement(Type.TAGGED_VALUE.getFullName(), n + 2);
        }
        PrintXML.printEndElement(modelLink.getFullName(), n);
    }
}

