/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.uml;

import com.ibm.xmi.mod.GetTestBuilder;
import com.ibm.xmi.mod.Metamodel;
import com.ibm.xmi.mod.ModelType;
import com.ibm.xmi.mod.TestScript;
import com.ibm.xmi.uml.Link;
import com.ibm.xmi.uml.Property;
import com.ibm.xmi.uml.Type;
import java.util.Enumeration;
import java.util.Vector;

class UMLGetTestBuilder
extends GetTestBuilder {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    protected UMLGetTestBuilder(String string, Metamodel metamodel, ModelType modelType, int n, boolean bl, boolean bl2) {
        super(string, metamodel, modelType, n, bl, bl2);
    }

    public Vector build() {
        Vector vector = new Vector();
        int n = this.getFirstNum();
        if (!this.buildContTests(vector, n)) {
            return null;
        }
        n = this.getFirstNum() + vector.size();
        if (!this.buildLinkTests(vector, n)) {
            return null;
        }
        n = this.getFirstNum() + vector.size();
        if (!this.buildInhTests(vector, n)) {
            return null;
        }
        n = this.getFirstNum() + vector.size();
        if (!this.buildReflectiveTests(vector, n)) {
            return null;
        }
        n = this.getFirstNum() + vector.size();
        if (!this.buildComplicatedTests(vector, n)) {
            return null;
        }
        return vector;
    }

    private boolean buildComplicatedTests(Vector vector, int n) {
        int n2 = n;
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement("ntv");
        vector2.addElement("rtv");
        vector2.addElement("np");
        vector2.addElement("rp");
        vector2.addElement("nl");
        vector2.addElement("rl");
        vector2.addElement("nc");
        vector2.addElement("rc");
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Vector<String> vector3 = new Vector<String>();
            vector3.addElement("comp");
            vector3.addElement((String)enumeration.nextElement());
            if (this.buildTest(n2++, vector3, vector)) continue;
            return false;
        }
        return true;
    }

    private boolean buildContTests(Vector vector, int n) {
        int n2 = n;
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement("sr");
        vector2.addElement("cr");
        vector2.addElement("sa");
        vector2.addElement("ca");
        vector2.addElement("ce");
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Vector<String> vector3 = new Vector<String>();
            vector3.addElement("cont");
            vector3.addElement((String)enumeration.nextElement());
            if (this.buildTest(n2++, vector3, vector)) continue;
            return false;
        }
        return true;
    }

    private boolean buildInhTests(Vector vector, int n) {
        int n2 = n;
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement("rsub");
        vector2.addElement("nsub");
        vector2.addElement("rsup");
        vector2.addElement("nsup");
        vector2.addElement("natt");
        vector2.addElement("ratt");
        vector2.addElement("iatt");
        vector2.addElement("nop");
        vector2.addElement("rop");
        vector2.addElement("iop");
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Vector<String> vector3 = new Vector<String>();
            vector3.addElement("inh");
            vector3.addElement((String)enumeration.nextElement());
            if (this.buildTest(n2++, vector3, vector)) continue;
            return false;
        }
        return true;
    }

    private boolean buildLinkTests(Vector vector, int n) {
        int n2 = n;
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement("re");
        vector2.addElement("r1");
        vector2.addElement("r2");
        vector2.addElement("ne");
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Vector<String> vector3 = new Vector<String>();
            vector3.addElement("link");
            vector3.addElement((String)enumeration.nextElement());
            if (this.buildTest(n2++, vector3, vector)) continue;
            return false;
        }
        return true;
    }

    private boolean buildReflectiveTests(Vector vector, int n) {
        int n2 = n;
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement("gdt0");
        vector2.addElement("gdt1");
        vector2.addElement("gdt2");
        vector2.addElement("gt0");
        vector2.addElement("gt1");
        vector2.addElement("gt2");
        vector2.addElement("gs0");
        vector2.addElement("gs1");
        vector2.addElement("gs2");
        vector2.addElement("gp0");
        vector2.addElement("gp1");
        vector2.addElement("gp2");
        vector2.addElement("gl0");
        vector2.addElement("gl1");
        vector2.addElement("gl2");
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Vector<String> vector3 = new Vector<String>();
            vector3.addElement("refl");
            vector3.addElement((String)enumeration.nextElement());
            if (this.buildTest(n2++, vector3, vector)) continue;
            return false;
        }
        return true;
    }

    protected String getTestType() {
        return "mg";
    }

    private boolean makeClasses(TestScript testScript, Type type) {
        testScript.add("s", this.getName(Type.CLASS), "c1", "id");
        testScript.setLabel("c1");
        testScript.add("s", this.getName(Type.CLASS), "c2", "id");
        testScript.setLabel("c2");
        testScript.add("s", this.getName(Type.CLASS), "c3", "id");
        testScript.setLabel("c3");
        testScript.add("s", this.getName(Type.CLASS), "c4", "id");
        testScript.setLabel("c4");
        testScript.add("s", this.getName(Type.GENERALIZATION), "g1", "id");
        testScript.setLabel("g1");
        testScript.add("g1", this.getName(Link.SUBTYPE), "c2", "");
        testScript.add("g1", this.getName(Link.SUPERTYPE), "c1", "");
        testScript.add("c1", this.getName(Link.SPECIALIZATION), "g1", "");
        testScript.add("c2", "Link." + this.getName(Link.GENERALIZATION), "g1", "");
        testScript.add("s", this.getName(Type.GENERALIZATION), "g2", "id");
        testScript.setLabel("g2");
        testScript.add("g2", this.getName(Link.SUBTYPE), "c3", "");
        testScript.add("g2", this.getName(Link.SUPERTYPE), "c1", "");
        testScript.add("c1", this.getName(Link.SPECIALIZATION), "g2", "");
        testScript.add("c2", "Link." + this.getName(Link.GENERALIZATION), "g2", "");
        testScript.add("s", this.getName(Type.GENERALIZATION), "g3", "id");
        testScript.setLabel("g3");
        testScript.add("g3", this.getName(Link.SUBTYPE), "c4", "");
        testScript.add("g3", this.getName(Link.SUPERTYPE), "c2", "");
        testScript.add("c2", this.getName(Link.SPECIALIZATION), "g3", "");
        testScript.add("c4", "Link." + this.getName(Link.GENERALIZATION), "g3", "");
        testScript.add("s", this.getName(Type.GENERALIZATION), "g4", "id");
        testScript.setLabel("g4");
        testScript.add("g4", this.getName(Link.SUBTYPE), "c4", "");
        testScript.add("g4", this.getName(Link.SUPERTYPE), "c3", "");
        testScript.add("c3", this.getName(Link.SPECIALIZATION), "g4", "");
        testScript.add("c4", "Link." + this.getName(Link.GENERALIZATION), "g4", "");
        if (type != null) {
            testScript.add("c1", "Type." + this.getName(type), "construct1", "id");
            testScript.setLabel("construct1");
            testScript.add("c2", "Type." + this.getName(type), "construct2", "id");
            testScript.setLabel("construct2");
            testScript.add("c3", "Type." + this.getName(type), "construct3", "id");
            testScript.setLabel("construct3");
            testScript.add("c4", "Type." + this.getName(type), "construct4", "id");
            testScript.setLabel("construct4");
        }
        return true;
    }

    protected boolean makeCompContent(TestScript testScript, Vector vector) {
        if (!this.makeContConstructs(testScript)) {
            return false;
        }
        String string = (String)vector.elementAt(1);
        if (string.equals("ntv")) {
            testScript.set("m1", "\"\"", "t1", "v1", "");
            testScript.set("p1", "\"\"", "t1", "v1", "");
            testScript.set("p2", "\"\"", "t1", "v1", "");
            testScript.set("p2", "s1", "t2", "v2", "");
            Vector<String> vector2 = new Vector<String>(3);
            vector2.addElement("\"\"");
            vector2.addElement("t1");
            vector2.addElement("v1");
            testScript.get("s", "Type.all", vector2, "false", "m1 p1");
            vector2 = new Vector(6);
            vector2.addElement("\"\"");
            vector2.addElement("t1");
            vector2.addElement("v1");
            vector2.addElement("s1");
            vector2.addElement("t2");
            vector2.addElement("v2");
            testScript.get("p1", "Type.all", vector2, "false", "p2");
        } else if (string.equals("rtv")) {
            testScript.set("m1", "\"\"", "t1", "v1", "");
            testScript.set("p1", "\"\"", "t1", "v1", "");
            testScript.set("p2", "\"\"", "t1", "v1", "");
            testScript.set("p2", "s1", "t2", "v2", "");
            Vector<String> vector3 = new Vector<String>(3);
            vector3.addElement("\"\"");
            vector3.addElement("t1");
            vector3.addElement("v1");
            testScript.get("s", "Type.all", vector3, "true", "m1 p1 p2");
            vector3 = new Vector(6);
            vector3.addElement("\"\"");
            vector3.addElement("t1");
            vector3.addElement("v1");
            vector3.addElement("s1");
            vector3.addElement("t2");
            vector3.addElement("v2");
            testScript.get("p1", "Type.all", vector3, "true", "p2");
        } else if (string.equals("np")) {
            testScript.set("m1", this.getName(Property.ME_VISIBILITY), "private", "");
            testScript.set("p1", this.getName(Property.ME_VISIBILITY), "private", "");
            testScript.set("p2", this.getName(Property.ME_VISIBILITY), "private", "");
            Vector<String> vector4 = new Vector<String>(2);
            vector4.addElement("Property." + this.getName(Property.ME_VISIBILITY));
            vector4.addElement("private");
            testScript.get("s", "Type.all", vector4, "false", "m1 p1");
            vector4 = new Vector(4);
            vector4.addElement("Property." + this.getName(Property.NAME));
            vector4.addElement("p2");
            vector4.addElement("Property." + this.getName(Property.ME_VISIBILITY));
            vector4.addElement("private");
            testScript.get("p1", "Type.all", vector4, "false", "p2");
        } else if (string.equals("rp")) {
            testScript.set("m1", this.getName(Property.ME_VISIBILITY), "private", "");
            testScript.set("p1", this.getName(Property.ME_VISIBILITY), "private", "");
            testScript.set("p2", this.getName(Property.ME_VISIBILITY), "private", "");
            Vector<String> vector5 = new Vector<String>(2);
            vector5.addElement("Property." + this.getName(Property.ME_VISIBILITY));
            vector5.addElement("private");
            testScript.get("s", "Type.all", vector5, "true", "m1 p1 p2");
            vector5 = new Vector(4);
            vector5.addElement("Property." + this.getName(Property.NAME));
            vector5.addElement("p2");
            vector5.addElement("Property." + this.getName(Property.ME_VISIBILITY));
            vector5.addElement("private");
            testScript.get("p1", "Type.all", vector5, "true", "p2");
        } else if (string.equals("nl")) {
            testScript.add("m1", this.getName(Link.AE_TYPE), "c2", "");
            testScript.add("p1", this.getName(Link.AE_TYPE), "c2", "");
            testScript.add("p2", this.getName(Link.AE_TYPE), "c2", "");
            Vector<String> vector6 = new Vector<String>(2);
            vector6.addElement("Link." + this.getName(Link.AE_TYPE));
            vector6.addElement("c2");
            testScript.get("s", "Type.all", vector6, "false", "m1 p1");
            vector6 = new Vector(4);
            vector6.addElement("Link." + this.getName(Link.AE_TYPE));
            vector6.addElement("c2");
            vector6.addElement("Link." + this.getName(Link.OWNED_ELEMENT));
            vector6.addElement("c2");
            testScript.get("p1", "Type.all", vector6, "false", "p2");
        } else if (string.equals("rl")) {
            testScript.add("m1", this.getName(Link.AE_TYPE), "c2", "");
            testScript.add("p1", this.getName(Link.AE_TYPE), "c2", "");
            testScript.add("p2", this.getName(Link.AE_TYPE), "c2", "");
            Vector<String> vector7 = new Vector<String>(2);
            vector7.addElement("Link." + this.getName(Link.AE_TYPE));
            vector7.addElement("c2");
            testScript.get("s", "Type.all", vector7, "true", "m1 p1 p2");
            vector7 = new Vector(4);
            vector7.addElement("Link." + this.getName(Link.AE_TYPE));
            vector7.addElement("c2");
            vector7.addElement("Link." + this.getName(Link.OWNED_ELEMENT));
            vector7.addElement("c2");
            testScript.get("p1", "Type.all", vector7, "true", "p2");
        } else if (string.equals("nc")) {
            testScript.set("m1", this.getName(Property.ME_VISIBILITY), "private", "");
            testScript.set("p1", this.getName(Property.ME_VISIBILITY), "private", "");
            Vector<String> vector8 = new Vector<String>(4);
            vector8.addElement("Property." + this.getName(Property.ME_VISIBILITY));
            vector8.addElement("private");
            vector8.addElement("Link." + this.getName(Link.OWNED_ELEMENT));
            vector8.addElement("c1");
            testScript.get("s", "Type.all", vector8, "false", "p1");
        } else if (string.equals("rc")) {
            testScript.set("m1", this.getName(Property.ME_VISIBILITY), "private", "");
            testScript.set("p2", this.getName(Property.ME_VISIBILITY), "private", "");
            Vector<String> vector9 = new Vector<String>(4);
            vector9.addElement("Link." + this.getName(Link.OWNED_ELEMENT));
            vector9.addElement("c2");
            vector9.addElement("Property." + this.getName(Property.ME_VISIBILITY));
            vector9.addElement("private");
            testScript.get("s", "Type.all", vector9, "true", "p2");
        } else {
            return false;
        }
        return true;
    }

    private boolean makeContConstructs(TestScript testScript) {
        testScript.add("s", this.getName(Type.MODEL), "m1", "id");
        testScript.setLabel("m1");
        testScript.add("s", this.getName(Type.PACKAGE), "p1", "id");
        testScript.setLabel("p1");
        testScript.add("p1", this.getName(Type.PACKAGE), "p2", "id");
        testScript.setLabel("p2");
        testScript.add("p1", this.getName(Type.CLASS), "c1", "id");
        testScript.setLabel("c1");
        testScript.add("p2", this.getName(Type.CLASS), "c2", "id");
        testScript.setLabel("c2");
        return true;
    }

    protected boolean makeContContent(TestScript testScript, Vector vector) {
        if (!this.makeContConstructs(testScript)) {
            return false;
        }
        String string = (String)vector.elementAt(1);
        if (string.equals("sr")) {
            Vector<String> vector2 = new Vector<String>();
            vector2.addElement("p1");
            vector2.addElement("p2");
            testScript.get("s", this.getName(Type.PACKAGE), "true", vector2);
        } else if (string.equals("sa")) {
            Vector<String> vector3 = new Vector<String>();
            vector3.addElement("m1");
            vector3.addElement("p1");
            vector3.addElement("p2");
            vector3.addElement("c1");
            vector3.addElement("c2");
            testScript.get("s", "Type.all", "true", vector3);
        } else if (string.equals("cr")) {
            Vector<String> vector4 = new Vector<String>();
            vector4.addElement("c1");
            vector4.addElement("c2");
            testScript.get("p1", this.getName(Type.CLASS), "true", vector4);
        } else if (string.equals("ca")) {
            Vector<String> vector5 = new Vector<String>();
            vector5.addElement("p2");
            vector5.addElement("c1");
            vector5.addElement("c2");
            testScript.get("p1", "Type.all", "true", vector5);
        } else if (string.equals("ce")) {
            testScript.get("c2", "Type.all", "false", "null");
        } else {
            return false;
        }
        return true;
    }

    protected boolean makeContent(TestScript testScript, Vector vector) {
        String string = (String)vector.firstElement();
        if (string.equals("cont")) {
            return this.makeContContent(testScript, vector);
        }
        if (string.equals("inh")) {
            return this.makeInhContent(testScript, vector);
        }
        if (string.equals("link")) {
            return this.makeLinkContent(testScript, vector);
        }
        if (string.equals("refl")) {
            return this.makeReflContent(testScript, vector);
        }
        if (string.equals("comp")) {
            return this.makeCompContent(testScript, vector);
        }
        return false;
    }

    protected boolean makeDescription(TestScript testScript, Vector vector) {
        String string = "Test if can get ";
        String string2 = (String)vector.firstElement();
        String string3 = (String)vector.elementAt(1);
        if (string2.equals("cont") && string3.equals("sr")) {
            string = string + "nested packages in session";
        } else if (string2.equals("cont") && string3.equals("sa")) {
            string = string + "all constructs in session";
        } else if (string2.equals("cont") && string3.equals("cr")) {
            string = string + "nested classes in package";
        } else if (string2.equals("cont") && string3.equals("ca")) {
            string = string + "all constructs in package";
        } else if (string2.equals("cont") && string3.equals("ce")) {
            string = "Test if null returned if try to get constructs ";
            string = string + "in package but none exist.";
        } else if (string2.equals("inh") && string3.equals("rsub")) {
            string = string + "all subclasses of class";
        } else if (string2.equals("inh") && string3.equals("nsub")) {
            string = string + "direct subclasses of class";
        } else if (string2.equals("inh") && string3.equals("rsup")) {
            string = string + "all superclasses of class";
        } else if (string2.equals("inh") && string3.equals("nsup")) {
            string = string + "direct superclasses of class";
        } else if (string2.equals("inh") && string3.equals("natt")) {
            string = string + "local attributes of class";
        } else if (string2.equals("inh") && string3.equals("iatt")) {
            string = string + "inherited attributes of class";
        } else if (string2.equals("inh") && string3.equals("ratt")) {
            string = string + "all attributes of class";
        } else if (string2.equals("inh") && string3.equals("nop")) {
            string = string + "local operations of class";
        } else if (string2.equals("inh") && string3.equals("iop")) {
            string = string + "inherited operations of class";
        } else if (string2.equals("inh") && string3.equals("rop")) {
            string = string + "all operations of class";
        } else if (string2.equals("link") && string3.equals("re")) {
            string = "Test that null is returned if get link that does not exist for ";
            string = string + "construct with recursive true";
        } else if (string2.equals("link") && string3.equals("r1")) {
            string = string + "one link for construct with recursive true";
        } else if (string2.equals("link") && string3.equals("r2")) {
            string = string + "two links for construct with recursive true";
        } else if (string2.equals("link") && string3.equals("ne")) {
            string = "Test that null is returned if get link that does not exist for ";
            string = string + "construct with recursive false";
        } else if (string2.equals("refl") && string3.equals("gdt0")) {
            string = "Test that null is returned if get default tag name for a ";
            string = string + "construct and none exist";
        } else if (string2.equals("refl") && string3.equals("gdt1")) {
            string = string + "default tag name for a construct";
        } else if (string2.equals("refl") && string3.equals("gdt2")) {
            string = string + "two default tag names for a construct";
        } else if (string2.equals("refl") && string3.equals("gt0")) {
            string = "Test that null is returned if get tag name for a ";
            string = string + "construct and none exist";
        } else if (string2.equals("refl") && string3.equals("gt1")) {
            string = string + "tag name for a construct";
        } else if (string2.equals("refl") && string3.equals("gt2")) {
            string = string + "two tag names for a construct";
        } else if (string2.equals("refl") && string3.equals("gs0")) {
            string = "Test that null is returned if get sets for a ";
            string = string + "construct and none exist";
        } else if (string2.equals("refl") && string3.equals("gs1")) {
            string = string + "a set for a construct";
        } else if (string2.equals("refl") && string3.equals("gs2")) {
            string = string + "two sets for a construct";
        } else if (string2.equals("refl") && string3.equals("gp0")) {
            string = "Test that null is returned if get property names for a ";
            string = string + "construct and none exist";
        } else if (string2.equals("refl") && string3.equals("gp1")) {
            string = string + "a property name for a construct";
        } else if (string2.equals("refl") && string3.equals("gp2")) {
            string = string + "two property names for a construct";
        } else if (string2.equals("refl") && string3.equals("gl0")) {
            string = "Test that null is returned if get link names for a ";
            string = string + "construct and none exist";
        } else if (string2.equals("refl") && string3.equals("gl1")) {
            string = string + "a link name for a construct";
        } else if (string2.equals("refl") && string3.equals("gl2")) {
            string = string + "two link names for a construct";
        } else if (string2.equals("comp") && string3.equals("ntv")) {
            string = string + "construct with specific tagged values";
        } else if (string2.equals("comp") && string3.equals("rtv")) {
            string = string + "construct with specific tagged values recursively";
        } else if (string2.equals("comp") && string3.equals("np")) {
            string = string + "construct with specific property values";
        } else if (string2.equals("comp") && string3.equals("rp")) {
            string = string + "construct with specific property values recursively";
        } else if (string2.equals("comp") && string3.equals("nl")) {
            string = string + "construct with specific links";
        } else if (string2.equals("comp") && string3.equals("rl")) {
            string = string + "construct with specific links recursively";
        } else if (string2.equals("comp") && string3.equals("nc")) {
            string = string + "construct with specific criteria";
        } else if (string2.equals("comp") && string3.equals("rc")) {
            string = string + "construct with specific criteria recursively";
        }
        string = string + this.getModeString();
        testScript.setDescription(string);
        return true;
    }

    protected boolean makeInhContent(TestScript testScript, Vector vector) {
        Type type = null;
        String string = (String)vector.elementAt(1);
        if (string.equals("natt") || string.equals("ratt") || string.equals("iatt")) {
            type = Type.ATTRIBUTE;
        } else if (string.equals("nop") || string.equals("rop") || string.equals("iop")) {
            type = Type.OPERATION;
        }
        if (!this.makeClasses(testScript, type)) {
            return false;
        }
        if (string.equals("rsub")) {
            Vector<String> vector2 = new Vector<String>();
            vector2.addElement("c2");
            vector2.addElement("c3");
            vector2.addElement("c4");
            testScript.get("c1", this.getName(Type.SUBCLASSES), "true", vector2);
        } else if (string.equals("nsub")) {
            Vector<String> vector3 = new Vector<String>();
            vector3.addElement("c2");
            vector3.addElement("c3");
            testScript.get("c1", this.getName(Type.SUBCLASSES), "false", vector3);
        } else if (string.equals("rsup")) {
            Vector<String> vector4 = new Vector<String>();
            vector4.addElement("c2");
            vector4.addElement("c3");
            vector4.addElement("c1");
            testScript.get("c4", this.getName(Type.SUPERCLASSES), "true", vector4);
        } else if (string.equals("nsup")) {
            Vector<String> vector5 = new Vector<String>();
            vector5.addElement("c2");
            vector5.addElement("c3");
            testScript.get("c4", this.getName(Type.SUPERCLASSES), "false", vector5);
        } else if (string.equals("natt") || string.equals("nop")) {
            testScript.get("c4", "Type." + this.getName(type), "false", "construct4");
        } else if (string.equals("iatt") || string.equals("iop")) {
            Vector<String> vector6 = new Vector<String>();
            vector6.addElement("construct2");
            vector6.addElement("construct3");
            vector6.addElement("construct1");
            String string2 = "Attributes";
            if (type == Type.OPERATION) {
                string2 = "Operations";
            }
            testScript.get("c4", "Type.inherited" + string2, "false", vector6);
        } else if (string.equals("ratt") || string.equals("rop")) {
            Vector<String> vector7 = new Vector<String>();
            vector7.addElement("construct4");
            vector7.addElement("construct2");
            vector7.addElement("construct3");
            vector7.addElement("construct1");
            testScript.get("c4", "Type." + this.getName(type), "true", vector7);
        } else {
            return false;
        }
        return true;
    }

    protected boolean makeLinkContent(TestScript testScript, Vector vector) {
        if (!this.makeContConstructs(testScript)) {
            return false;
        }
        String string = (String)vector.elementAt(1);
        if (string.equals("re")) {
            testScript.get("c2", this.getName(Link.OWNED_ELEMENT), "true", "null");
        } else if (string.equals("r1")) {
            testScript.get("p2", this.getName(Link.NAMESPACE), "true", "p1");
        } else if (string.equals("r2")) {
            Vector<String> vector2 = new Vector<String>();
            vector2.addElement("p2");
            vector2.addElement("p1");
            testScript.get("c2", this.getName(Link.NAMESPACE), "true", vector2);
        } else if (string.equals("ne")) {
            testScript.get("c2", this.getName(Link.OWNED_ELEMENT), "false", "null");
        } else {
            return false;
        }
        return true;
    }

    protected boolean makeReflContent(TestScript testScript, Vector vector) {
        String string = (String)vector.elementAt(1);
        testScript.add("s", this.getName(Type.CLASS), "c1", "id");
        testScript.setLabel("c1");
        if (string.equals("gdt0")) {
            testScript.getTags("c1", "\"\"", "null");
        } else if (string.equals("gdt1")) {
            testScript.set("c1", "\"\"", "t1", "v1", "");
            testScript.getTags("c1", "\"\"", "t1");
        } else if (string.equals("gdt2")) {
            testScript.set("c1", "\"\"", "t1", "v1", "");
            testScript.set("c1", "\"\"", "t2", "v2", "");
            testScript.getTags("c1", "\"\"", "t1 t2");
        } else if (string.equals("gt0")) {
            testScript.getTags("c1", "s1", "null");
        } else if (string.equals("gt1")) {
            testScript.set("c1", "s1", "t1", "v1", "");
            testScript.getTags("c1", "s1", "t1");
        } else if (string.equals("gt2")) {
            testScript.set("c1", "s1", "t1", "v1", "");
            testScript.set("c1", "s1", "t2", "v1", "");
            testScript.getTags("c1", "s1", "t2 t1");
        } else if (string.equals("gs0")) {
            testScript.getSets("c1", "null");
        } else if (string.equals("gs1")) {
            testScript.set("c1", "s1", "t1", "v1", "");
            testScript.getSets("c1", "s1");
        } else if (string.equals("gs2")) {
            testScript.set("c1", "s1", "t1", "v1", "");
            testScript.set("c1", "s2", "t2", "v2", "");
            testScript.getSets("c1", "s1 s2");
        } else if (string.equals("gp0")) {
            testScript.add("s", this.getName(Type.CLASS), null, "id");
            testScript.setLabel("c2");
            testScript.getProperties("c2", "null");
        } else if (string.equals("gp1")) {
            testScript.getProperties("c1", "name");
        } else if (string.equals("gp2")) {
            testScript.set("c1", this.getName(Property.ME_VISIBILITY), "public", "");
            if (this.getMode()) {
                testScript.getProperties("c1", "name visibility");
            } else {
                testScript.getProperties("c1", "visibility name");
            }
        } else if (string.equals("gl0")) {
            testScript.getLinks("c1", "null");
        } else if (string.equals("gl1")) {
            testScript.add("s", this.getName(Type.CLASS), "c2", "id");
            testScript.setLabel("c2");
            testScript.add("c1", this.getName(Link.OWNED_ELEMENT), "c2", "");
            testScript.getLinks("c1", "ownedElement");
        } else if (string.equals("gl2")) {
            testScript.add("c1", this.getName(Type.CLASS), "c2", "id");
            testScript.setLabel("c2");
            testScript.add("c2", this.getName(Type.CLASS), "c3", "id");
            testScript.setLabel("c3");
            testScript.getLinks("c2", "namespace ownedElement");
        }
        return true;
    }
}

