/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.uml;

import com.ibm.xmi.mod.Id;
import com.ibm.xmi.mod.ModelAPI;
import com.ibm.xmi.mod.ModelException;
import com.ibm.xmi.mod.ModelType;
import com.ibm.xmi.uml.Link;
import com.ibm.xmi.uml.Type;
import com.ibm.xmi.uml.UMLConstruct;
import java.util.Enumeration;
import java.util.Vector;

class UMLClass
extends UMLConstruct {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    UMLClass(ModelAPI modelAPI, ModelType modelType) {
        super(modelAPI, modelType);
    }

    private Vector getAll(Id id, ModelType modelType) throws ModelException {
        Vector<Id> vector = this.getSuperClasses(id, true);
        if (vector == null) {
            vector = new Vector<Id>(1);
            vector.addElement(id);
        } else {
            vector.addElement(id);
        }
        Vector vector2 = new Vector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector3;
            Id id2 = (Id)enumeration.nextElement();
            if (!id2.isLoaded()) {
                ModelAPI.instance().demandLoad(id2);
            }
            if ((vector3 = id2.getConstruct().getType(id2, modelType, false)) == null) continue;
            for (int i = 0; i < vector3.size(); ++i) {
                vector2.addElement(vector3.elementAt(i));
            }
        }
        if (vector2.size() == 0) {
            return null;
        }
        return vector2;
    }

    private Vector getInherited(Id id, ModelType modelType) throws ModelException {
        Vector vector = this.getSuperClasses(id, true);
        if (vector == null) {
            return null;
        }
        Vector vector2 = new Vector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector3;
            Id id2 = (Id)enumeration.nextElement();
            if (!id2.isLoaded()) {
                ModelAPI.instance().demandLoad(id2);
            }
            if ((vector3 = id2.getConstruct().getType(id2, modelType, false)) == null) continue;
            for (int i = 0; i < vector3.size(); ++i) {
                vector2.addElement(vector3.elementAt(i));
            }
        }
        if (vector2.size() == 0) {
            return null;
        }
        return vector2;
    }

    public Vector getSubClasses(Id id, boolean bl) throws ModelException {
        Vector<Id> vector = new Vector<Id>();
        Vector vector2 = id.get(Link.SPECIALIZATION, false);
        if (vector2 != null) {
            for (int i = 0; i < vector2.size(); ++i) {
                Vector vector3;
                Vector vector4;
                Id id2 = (Id)vector2.elementAt(i);
                if (!id2.isLoaded()) {
                    ModelAPI.instance().demandLoad(id2);
                }
                if ((vector4 = id2.get(Link.SUBTYPE, false)) == null || vector4.size() <= 0) continue;
                Id id3 = (Id)vector4.firstElement();
                if (!id3.isLoaded()) {
                    ModelAPI.instance().demandLoad(id3);
                }
                if (!vector.contains(id3)) {
                    vector.addElement(id3);
                }
                if (!bl || (vector3 = this.getSubClasses(id3, true)) == null) continue;
                for (int j = 0; j < vector3.size(); ++j) {
                    if (vector.contains(vector3.elementAt(j))) continue;
                    vector.addElement((Id)vector3.elementAt(j));
                }
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public Vector getSuperClasses(Id id, boolean bl) throws ModelException {
        Vector vector = new Vector();
        Vector vector2 = id.get(Link.GENERALIZATION, false);
        if (vector2 != null) {
            for (int i = 0; i < vector2.size(); ++i) {
                Vector vector3;
                Vector vector4;
                Id id2 = (Id)vector2.elementAt(i);
                if (!id2.isLoaded()) {
                    ModelAPI.instance().demandLoad(id2);
                }
                if ((vector4 = ((Id)vector2.elementAt(i)).get(Link.SUPERTYPE, false)) == null || vector4.size() <= 0) continue;
                Id id3 = (Id)vector4.firstElement();
                if (!id3.isLoaded()) {
                    ModelAPI.instance().demandLoad(id3);
                }
                if (bl && (vector3 = this.getSuperClasses(id3, true)) != null) {
                    for (int j = 0; j < vector3.size(); ++j) {
                        if (vector.contains(vector3.elementAt(j))) continue;
                        vector.addElement(vector3.elementAt(j));
                    }
                }
                if (vector.contains(id3)) continue;
                vector.addElement(id3);
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public Vector getType(Id id, ModelType modelType, boolean bl) throws ModelException {
        if (modelType == Type.INHERITED_ATTRIBUTES) {
            return this.getInherited(id, Type.ATTRIBUTE);
        }
        if (modelType == Type.ATTRIBUTE && bl) {
            return this.getAll(id, modelType);
        }
        if (modelType == Type.INHERITED_OPERATIONS) {
            return this.getInherited(id, Type.OPERATION);
        }
        if (modelType == Type.OPERATION && bl) {
            return this.getAll(id, modelType);
        }
        if (modelType == Type.SUBCLASSES) {
            return this.getSubClasses(id, bl);
        }
        if (modelType == Type.SUPERCLASSES) {
            return this.getSuperClasses(id, bl);
        }
        return super.getType(id, modelType, bl);
    }
}

