/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.uml;

import com.ibm.xmi.mod.MetamodelManager;
import com.ibm.xmi.mod.ModelAPI;
import com.ibm.xmi.mod.ModelException;
import com.ibm.xmi.mod.ModelLink;
import com.ibm.xmi.mod.ModelProperty;
import com.ibm.xmi.mod.ModelType;
import com.ibm.xmi.uml.Constructs;
import com.ibm.xmi.uml.ConvertException;
import com.ibm.xmi.uml.CoreProgressListener;
import com.ibm.xmi.uml.Id;
import com.ibm.xmi.uml.Link;
import com.ibm.xmi.uml.MakeMetamodel;
import com.ibm.xmi.uml.ProgressListener;
import com.ibm.xmi.uml.Property;
import com.ibm.xmi.uml.StringAPI;
import com.ibm.xmi.uml.Type;
import com.ibm.xmi.uml.UMLException;
import com.ibm.xmi.uml.UMLSession;
import com.ibm.xmi.uml.XMILoaderFactory;
import com.ibm.xmi.uml.XMISaveFactory;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipOutputStream;

public class UML {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int DEFAULT = 1;
    public static final int TRACK_FILES = 2;
    public static final int LOAD_HEADER = 3;
    public static final int NO_DTD = 4;
    private static UML instance;
    ModelAPI api = new ModelAPI();
    private Hashtable listenerToCoreListener;
    private StringAPI stringAPI;
    private Hashtable coreIdToId;

    public UML() {
        MakeMetamodel.make(this.api);
        this.listenerToCoreListener = new Hashtable(20);
        Constructs constructs = new Constructs();
        this.api.setConstructs(constructs);
        XMILoaderFactory xMILoaderFactory = new XMILoaderFactory();
        this.api.setXMILoaderFactory(xMILoaderFactory);
        XMISaveFactory xMISaveFactory = new XMISaveFactory();
        this.api.setXMISaveFactory(xMISaveFactory);
        this.api.setSession(new UMLSession(this.api, null));
        if (instance == null) {
            instance = this;
        }
        this.coreIdToId = new Hashtable();
    }

    public void add(Id id, Link link, Id id2) throws UMLException {
        ModelLink modelLink = link != null && link.getCoreLink() != null ? link.getCoreLink() : link;
        com.ibm.xmi.mod.Id id3 = null;
        com.ibm.xmi.mod.Id id4 = null;
        if (id != null) {
            id3 = id.getCoreId();
        }
        if (id2 != null) {
            id4 = id2.getCoreId();
        }
        try {
            this.api.add(id3, modelLink, id4);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
    }

    public Id add(Id id, Type type, String string) throws UMLException {
        return this.add(id, type, string, true);
    }

    public Id add(Id id, Type type, String string, boolean bl) throws UMLException {
        ModelType modelType = type != null && type.getCoreType() != null ? type.getCoreType() : type;
        com.ibm.xmi.mod.Id id2 = null;
        com.ibm.xmi.mod.Id id3 = null;
        if (id != null) {
            id3 = id.getCoreId();
        }
        try {
            id2 = this.api.add(id3, modelType, string, bl);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
        return new Id(id2, this);
    }

    public void addListener(Id id, EventListener eventListener) throws UMLException {
        com.ibm.xmi.mod.Id id2 = null;
        if (id != null) {
            id2 = id.getCoreId();
        }
        CoreProgressListener coreProgressListener = null;
        if (this.listenerToCoreListener.get(eventListener) == null && eventListener instanceof ProgressListener) {
            coreProgressListener = new CoreProgressListener((ProgressListener)eventListener);
            this.listenerToCoreListener.put(eventListener, coreProgressListener);
        }
        try {
            this.api.addListener(id2, coreProgressListener);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
    }

    public void check(Id id, boolean bl) throws UMLException {
        com.ibm.xmi.mod.Id id2 = null;
        if (id != null) {
            id2 = id.getCoreId();
        }
        try {
            this.api.check(id2, bl);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
    }

    private void convertCoreWarnings(Vector vector) {
        int n;
        if (vector == null) {
            return;
        }
        Vector<UMLException> vector2 = new Vector<UMLException>(vector.size());
        for (n = 0; n < vector.size(); ++n) {
            Object e = vector.elementAt(n);
            if (e instanceof ModelException) {
                vector2.addElement(ConvertException.convert((ModelException)e, this));
                continue;
            }
            vector2.addElement((UMLException)e);
        }
        vector.removeAllElements();
        for (n = 0; n < vector2.size(); ++n) {
            vector.addElement(vector2.elementAt(n));
        }
    }

    private Vector convertInputVectorToCore(Vector vector) {
        if (vector == null) {
            return null;
        }
        Vector<Object> vector2 = new Vector<Object>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (e instanceof Type && ((Type)e).getCoreType() != null) {
                vector2.addElement(((Type)e).getCoreType());
                continue;
            }
            if (e instanceof Link && ((Link)e).getCoreLink() != null) {
                vector2.addElement(((Link)e).getCoreLink());
                continue;
            }
            if (e instanceof Property && ((Property)e).getCoreProperty() != null) {
                vector2.addElement(((Property)e).getCoreProperty());
                continue;
            }
            if (e instanceof Id) {
                vector2.addElement(((Id)e).getCoreId());
                continue;
            }
            vector2.addElement(e);
        }
        return vector2;
    }

    public Id create(Type type) throws UMLException {
        ModelType modelType = type != null && type.getCoreType() != null ? type.getCoreType() : type;
        com.ibm.xmi.mod.Id id = null;
        try {
            id = this.api.create(modelType);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
        return new Id(id, this);
    }

    public Vector delete(Id id) throws UMLException {
        int n;
        Vector vector = null;
        com.ibm.xmi.mod.Id id2 = null;
        boolean bl = false;
        if (id == this.getSession()) {
            bl = true;
        }
        if (id != null) {
            id2 = id.getCoreId();
        }
        try {
            vector = this.api.delete(id2);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
        Vector vector2 = this.wrapVectorFromCore(vector);
        if (bl) {
            this.coreIdToId = new Hashtable();
            this.coreIdToId.put(id2, id);
        } else if (vector != null) {
            for (n = 0; n < vector.size(); ++n) {
                this.coreIdToId.remove(vector.elementAt(n));
            }
        }
        if (vector2 != null) {
            for (n = 0; n < vector2.size(); ++n) {
                if (!bl || vector2.elementAt(n) == id) continue;
                ((Id)vector2.elementAt(n)).clear();
            }
        }
        return vector2;
    }

    public void delete(Id id, Link link, Id id2) throws UMLException {
        ModelLink modelLink = null;
        modelLink = link != null && link.getCoreLink() != null ? link.getCoreLink() : link;
        com.ibm.xmi.mod.Id id3 = null;
        com.ibm.xmi.mod.Id id4 = null;
        if (id != null) {
            id3 = id.getCoreId();
        }
        if (id2 != null) {
            id4 = id2.getCoreId();
        }
        try {
            this.api.delete(id3, modelLink, id4);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
    }

    public String execute(String string) {
        if (this.stringAPI == null) {
            this.stringAPI = new StringAPI(this, this.api);
        }
        return this.stringAPI.execute(string);
    }

    public Vector get(Id id, Link link, boolean bl) throws UMLException {
        ModelLink modelLink = null;
        modelLink = link != null && link.getCoreLink() != null ? link.getCoreLink() : link;
        Vector vector = null;
        com.ibm.xmi.mod.Id id2 = null;
        if (id != null) {
            id2 = id.getCoreId();
        }
        try {
            vector = this.api.get(id2, modelLink, bl);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
        return this.wrapVectorFromCore(vector);
    }

    public String get(Id id, Property property) throws UMLException {
        ModelProperty modelProperty = null;
        modelProperty = property != null && property.getCoreProperty() != null ? property.getCoreProperty() : property;
        String string = null;
        com.ibm.xmi.mod.Id id2 = null;
        if (id != null) {
            id2 = id.getCoreId();
        }
        try {
            string = this.api.get(id2, modelProperty);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
        return string;
    }

    public Vector get(Id id, Type type, Vector vector, boolean bl) throws UMLException {
        ModelType modelType = type != null && type.getCoreType() != null ? type.getCoreType() : type;
        Vector vector2 = null;
        com.ibm.xmi.mod.Id id2 = null;
        if (id != null) {
            id2 = id.getCoreId();
        }
        Vector vector3 = this.convertInputVectorToCore(vector);
        try {
            vector2 = this.api.get(id2, modelType, vector3, bl);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
        return this.wrapVectorFromCore(vector2);
    }

    public Vector get(Id id, Type type, boolean bl) throws UMLException {
        ModelType modelType = type != null && type.getCoreType() != null ? type.getCoreType() : type;
        Vector vector = null;
        com.ibm.xmi.mod.Id id2 = null;
        if (id != null) {
            id2 = id.getCoreId();
        }
        try {
            vector = this.api.get(id2, modelType, bl);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
        return this.wrapVectorFromCore(vector);
    }

    public String get(Id id, String string) throws UMLException {
        String string2 = null;
        com.ibm.xmi.mod.Id id2 = null;
        if (id != null) {
            id2 = id.getCoreId();
        }
        try {
            string2 = this.api.get(id2, string);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
        return string2;
    }

    public String get(Id id, String string, String string2) throws UMLException {
        String string3 = null;
        com.ibm.xmi.mod.Id id2 = null;
        if (id != null) {
            id2 = id.getCoreId();
        }
        try {
            string3 = this.api.get(id2, string, string2);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
        return string3;
    }

    public boolean getDemandLoad() {
        return this.api.getDemandLoad();
    }

    public String getFilePath() {
        return this.api.getFilePath();
    }

    Id getId(com.ibm.xmi.mod.Id id) {
        return (Id)this.coreIdToId.get(id);
    }

    public Id getId(String string) {
        com.ibm.xmi.mod.Id id = this.api.getIds().getId(string);
        if (id != null) {
            Id id2 = this.getId(id);
            if (id2 == null) {
                id2 = new Id(id, this);
            }
            return id2;
        }
        return null;
    }

    public Vector getIds(String string) {
        Vector vector = this.api.getIds().getIdsFromLabel(string);
        return this.wrapVectorFromCore(vector);
    }

    public Vector getLinks(Id id) throws UMLException {
        Vector vector = null;
        com.ibm.xmi.mod.Id id2 = null;
        if (id != null) {
            id2 = id.getCoreId();
        }
        try {
            vector = this.api.getLinks(id2);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
        return this.wrapVectorFromCore(vector);
    }

    public Vector getLoadIds() {
        return this.wrapVectorFromCore(this.api.getLoadIds());
    }

    public boolean getLog() {
        return this.api.getLog();
    }

    MetamodelManager getMetamodelManager() {
        return this.api.getMetamodelManager();
    }

    public Vector getProperties(Id id) throws UMLException {
        Vector vector = null;
        com.ibm.xmi.mod.Id id2 = null;
        if (id != null) {
            id2 = id.getCoreId();
        }
        try {
            vector = this.api.getProperties(id2);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
        return this.wrapVectorFromCore(vector);
    }

    public Id getSession() {
        Id id = this.getId(this.api.getSession());
        if (id != null) {
            return id;
        }
        return new Id(this.api.getSession(), this);
    }

    public Vector getSets(Id id) throws UMLException {
        Vector vector = null;
        com.ibm.xmi.mod.Id id2 = null;
        if (id != null) {
            id2 = id.getCoreId();
        }
        try {
            vector = this.api.getSets(id.getCoreId());
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
        return vector;
    }

    public Vector getTags(Id id, String string) throws UMLException {
        Vector vector = null;
        com.ibm.xmi.mod.Id id2 = null;
        if (id != null) {
            id2 = id.getCoreId();
        }
        try {
            vector = this.api.getTags(id.getCoreId(), string);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
        return vector;
    }

    public static UML instance() {
        if (instance == null) {
            instance = new UML();
        }
        return instance;
    }

    public boolean isSaveMemory() {
        return this.api.isSaveMemory();
    }

    public Vector load(String string, Vector vector, int n, boolean bl) throws Exception {
        return this.load(string, vector, n, bl, null);
    }

    public Vector load(String string, Vector vector, int n, boolean bl, Vector vector2) throws Exception {
        Vector vector3 = null;
        try {
            vector3 = this.api.load(string, vector, n, bl, vector2);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
        catch (Exception exception) {
            throw exception;
        }
        this.convertCoreWarnings(vector);
        return this.wrapVectorFromCore(vector3);
    }

    void registerCoreId(com.ibm.xmi.mod.Id id, Id id2) {
        this.coreIdToId.put(id, id2);
    }

    public void removeListener(Id id, EventListener eventListener) throws UMLException {
        com.ibm.xmi.mod.Id id2 = null;
        if (id != null) {
            id2 = id.getCoreId();
        }
        try {
            this.api.removeListener(id2, (EventListener)this.listenerToCoreListener.get(eventListener));
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
    }

    public void save(Id id, String string, int n) throws Exception {
        Vector<Id> vector = new Vector<Id>(1);
        vector.addElement(id);
        this.save(vector, string, n, new Vector());
    }

    public void save(Id id, String string, int n, Vector vector) throws Exception {
        Vector<Id> vector2 = new Vector<Id>(1);
        vector2.addElement(id);
        this.save(vector2, string, n, vector);
    }

    public void save(Id id, ZipOutputStream zipOutputStream, int n, Vector vector) throws Exception {
        Vector<Id> vector2 = new Vector<Id>(1);
        vector2.addElement(id);
        this.save(vector2, zipOutputStream, n, vector);
    }

    public void save(Vector vector, String string, int n) throws Exception {
        this.save(vector, string, n, new Vector());
    }

    public void save(Vector vector, String string, int n, Vector vector2) throws Exception {
        this.save(vector, string, n, vector2, null);
    }

    public void save(Vector vector, String string, int n, Vector vector2, Vector vector3) throws Exception {
        Vector vector4 = this.convertInputVectorToCore(vector);
        try {
            this.api.save(vector4, string, n, vector2, vector3);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
        catch (Exception exception) {
            throw exception;
        }
        this.convertCoreWarnings(vector2);
    }

    public void save(Vector vector, ZipOutputStream zipOutputStream, int n, Vector vector2) throws Exception {
        this.save(vector, zipOutputStream, n, vector2, null);
    }

    public void save(Vector vector, ZipOutputStream zipOutputStream, int n, Vector vector2, Vector vector3) throws Exception {
        Vector vector4 = this.convertInputVectorToCore(vector);
        try {
            this.api.save(vector4, zipOutputStream, n, vector2, vector3);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
        catch (Exception exception) {
            throw exception;
        }
        this.convertCoreWarnings(vector2);
    }

    public void set(Id id, Property property, String string) throws UMLException {
        ModelProperty modelProperty = property != null && property.getCoreProperty() != null ? property.getCoreProperty() : property;
        com.ibm.xmi.mod.Id id2 = null;
        if (id != null) {
            id2 = id.getCoreId();
        }
        try {
            this.api.set(id2, modelProperty, string);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
    }

    public void set(Id id, String string, String string2) throws UMLException {
        com.ibm.xmi.mod.Id id2 = null;
        if (id != null) {
            id2 = id.getCoreId();
        }
        try {
            this.api.set(id2, string, string2);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
    }

    public void set(Id id, String string, String string2, String string3) throws UMLException {
        com.ibm.xmi.mod.Id id2 = null;
        if (id != null) {
            id2 = id.getCoreId();
        }
        try {
            this.api.set(id2, string, string2, string3);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this);
        }
    }

    public void setDemandLoad(boolean bl) {
        this.api.setDemandLoad(bl);
    }

    public void setFilePath(String string) {
        this.api.setFilePath(string);
    }

    public void setLog(boolean bl) {
        this.api.setLog(bl);
    }

    public void setSaveMemory(boolean bl) throws UMLException {
        try {
            this.api.setSaveMemory(bl);
        }
        catch (ModelException modelException) {
            ConvertException.convert(modelException, this);
        }
    }

    private Vector wrapVectorFromCore(Vector vector) {
        if (vector == null) {
            return null;
        }
        Vector<Object> vector2 = new Vector<Object>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            if (vector.elementAt(i) instanceof com.ibm.xmi.mod.Id) {
                object = this.getId((com.ibm.xmi.mod.Id)vector.elementAt(i));
                if (object != null) {
                    vector2.addElement(object);
                    continue;
                }
                vector2.addElement(new Id((com.ibm.xmi.mod.Id)vector.elementAt(i), this));
                continue;
            }
            if (vector.elementAt(i) instanceof Type || vector.elementAt(i) instanceof Property || vector.elementAt(i) instanceof Link) {
                vector2.addElement(vector.elementAt(i));
                continue;
            }
            if (vector.elementAt(i) instanceof ModelType) {
                object = Type.convertCoreTypeToType((ModelType)vector.elementAt(i));
                if (object == null) continue;
                vector2.addElement(object);
                continue;
            }
            if (vector.elementAt(i) instanceof ModelLink) {
                object = Link.convertCoreLinkToLink((ModelLink)vector.elementAt(i));
                if (object == null) continue;
                vector2.addElement(object);
                continue;
            }
            if (vector.elementAt(i) instanceof ModelProperty) {
                object = Property.convertCorePropertyToProperty((ModelProperty)vector.elementAt(i));
                if (object == null) continue;
                vector2.addElement(object);
                continue;
            }
            vector2.addElement(vector.elementAt(i));
        }
        return vector2;
    }
}

