/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.framework.MIME2Java;
import com.ibm.xmi.mod.DirectoryException;
import com.ibm.xmi.mod.FilenameIgnoredException;
import com.ibm.xmi.mod.Id;
import com.ibm.xmi.mod.LinkNotSavedException;
import com.ibm.xmi.mod.Listeners;
import com.ibm.xmi.mod.Metamodel;
import com.ibm.xmi.mod.ModelAPI;
import com.ibm.xmi.mod.ModelException;
import com.ibm.xmi.mod.ModelLink;
import com.ibm.xmi.mod.ModelProperty;
import com.ibm.xmi.mod.ModelType;
import com.ibm.xmi.mod.PrintXML;
import com.ibm.xmi.mod.XMIFileNotSetException;
import com.ibm.xmi.mod.XMISaveFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class XMISave {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String XML_VERSION = "1.0";
    private static final String XML_ID = "ID";
    private static final String XML_CDATA = "CDATA";
    private static final String XML_IMPLIED = "#IMPLIED";
    private static final String XML_IDREF = "IDREF";
    private static final String ID_REF = "xmi.idref";
    private static final String ID = "xmi.id";
    protected static final String XMI_UUID = "xmi.uuid";
    private static final String XMI_VERSION = "xmi.version";
    private static final String XMI_NAME = "xmi.name";
    protected static final String XMI_LABEL = "xmi.label";
    private static final String XMI_VALUE = "xmi.value";
    private static final String EXTENDER = "xmi.extender";
    private static final String EXTENDER_ID = "xmi.extenderID";
    private static final String TIMESTAMP = "timestamp";
    private static final String XML_LINK = "xml:link";
    private static final String INLINE = "inline";
    private static final String ACTUATE = "actuate";
    protected static final String HREF = "href";
    private static final String ROLE = "role";
    private static final String TITLE = "title";
    private static final String SHOW = "show";
    private static final String BEHAVIOR = "behavior";
    private static final String XMI_IDREF = "xmi.idref";
    private static final String XMI_UUIDREF = "xmi.uuidref";
    private static final String EXTENSION = "XMI.extension";
    private static final String REFERENCE = "XMI.reference";
    private static final String XMI_HEADER = "XMI.header";
    private static final String XMI_DOCUMENTATION = "XMI.documentation";
    private static final String XMI_SHORT_DESCRIPTION = "XMI.shortDescription";
    private static final String XMI_EXPORTER = "XMI.exporter";
    private static final String XMI_EXPORTER_VERSION = "XMI.exporterVersion";
    private static final String XMI_METAMODEL = "XMI.metamodel";
    private static final String XMI_NOTICE = "XMI.notice";
    private static final String XMI_CONTENT = "XMI.content";
    protected static final String XMI_ANY = "XMI.any";
    public static final String XMI_TOOLKIT = "IXT";
    public static final String IXTS_NAME = "s";
    public static final String IXTTV_TAG = "t";
    public static final String IXTTV_VALUE = "v";
    private static final String ENCODING = "UTF-8";
    protected static final int INDENT = 2;
    private boolean debug;
    private Vector constructs;
    private int option;
    private int currentIndent = 0;
    private String product;
    private String versionNumber;
    private String encoding;
    private File fileOrDir;
    protected Hashtable idToX;
    protected static Hashtable idToFile;
    private static File dir;
    private static ZipOutputStream zos;
    private static String entry;
    private Vector warnings;
    private Stack elements;
    private boolean xmiFileSet;
    private PrintWriter pw;
    private long totalConstructs = 0L;
    private long constructCount = 0L;
    protected ModelAPI api;
    private Metamodel metamodel;
    private Vector metamodels;
    private Vector header;

    public XMISave(ModelAPI modelAPI, Vector vector, File file, ZipOutputStream zipOutputStream, int n, String string, String string2, String string3, Vector vector2, Vector vector3, Vector vector4) {
        this.api = modelAPI;
        this.constructs = vector;
        this.fileOrDir = file;
        if (this.fileOrDir == null) {
            this.fileOrDir = new File("");
        }
        this.option = n;
        this.warnings = vector3;
        this.product = string;
        this.versionNumber = string2;
        this.xmiFileSet = false;
        zos = zipOutputStream;
        if (string3.equals("")) {
            this.encoding = ENCODING;
            PrintXML.setEncoding(ENCODING);
        } else {
            this.encoding = string3;
            PrintXML.setEncoding(string3);
        }
        this.idToX = new Hashtable();
        if (idToFile == null) {
            idToFile = new Hashtable();
        }
        if (dir == null && file != null && !file.getPath().equals("") && file.isDirectory()) {
            dir = file;
        }
        if (zos == null) {
            zos = zipOutputStream;
        }
        this.metamodels = vector2;
        if (vector2 != null && vector2.size() == 2) {
            this.metamodel = (Metamodel)vector2.elementAt(1);
        }
        this.header = vector4;
    }

    public void addToWarnings(ModelException modelException) {
        this.warnings.addElement(modelException);
    }

    private boolean allFilesSpecified() {
        Enumeration enumeration = this.constructs.elements();
        while (enumeration.hasMoreElements()) {
            Id id = (Id)enumeration.nextElement();
            String string = this.api.getProperties().getTag(id, "", "xmiFile");
            if (string != null) continue;
            return false;
        }
        return true;
    }

    private void assignFiles(Id id, String string) throws Exception {
        if (idToFile.get(id) == null) {
            Object object;
            Object object2;
            Object object3;
            String string2 = this.api.getProperties().getTag(id, "", "xmiFile");
            if (string2 != null) {
                string = string2;
                this.xmiFileSet = true;
            }
            idToFile.put(id, string);
            Vector vector = this.api.getMetamodelManager().getProperties(id.getType());
            if (vector != null) {
                object3 = vector.elements();
                while (object3.hasMoreElements()) {
                    object2 = (ModelProperty)object3.nextElement();
                    if (!((ModelProperty)object2).isClass() || (object = id.get(((ModelProperty)object2).getModelLink(), false)) == null || ((Vector)object).size() <= 0) continue;
                    Id id2 = (Id)((Vector)object).firstElement();
                    this.assignFiles(id2, string);
                }
            }
            if ((object3 = this.api.get(id, ModelType.IXT_ALL, false)) != null) {
                object2 = ((Vector)object3).elements();
                while (object2.hasMoreElements()) {
                    object = (Id)object2.nextElement();
                    this.assignFiles((Id)object, string);
                }
            }
        }
    }

    private void assignFilesAndUUIDs() throws Exception {
        try {
            int n;
            Vector vector = this.api.get(this.api.getSession(), ModelType.IXT_ALL, false);
            for (n = 0; n < vector.size(); ++n) {
                this.assignFiles((Id)vector.elementAt(n), this.fileOrDir.getPath());
            }
            if (this.xmiFileSet) {
                for (n = 0; n < vector.size(); ++n) {
                    this.assignUUIDs((Id)vector.elementAt(n));
                }
            }
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    private void assignIds(String string, Id id) throws Exception {
        if (this.idToX.get(id) == null) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            ++this.totalConstructs;
            this.putInIdToXHashtable(id, string);
            int n = 1;
            Vector vector = this.api.getMetamodelManager().getProperties(id.getType());
            if (vector != null) {
                object4 = vector.elements();
                while (object4.hasMoreElements()) {
                    object3 = (ModelProperty)object4.nextElement();
                    if (!((ModelProperty)object3).isClass() || (object2 = id.get(((ModelProperty)object3).getModelLink(), false)) == null || ((Vector)object2).size() <= 0) continue;
                    object = (Id)((Vector)object2).firstElement();
                    String string2 = string + "." + n++;
                    this.assignIds(string2, (Id)object);
                }
            }
            if ((object4 = this.api.get(id, ModelType.IXT_ALL, false)) != null) {
                object3 = ((Vector)object4).elements();
                while (object3.hasMoreElements()) {
                    object2 = (Id)object3.nextElement();
                    object = string + "." + n++;
                    this.assignIds((String)object, (Id)object2);
                }
            }
        }
    }

    private void assignUUIDs(Id id) throws Exception {
        Object object;
        Object object2;
        Object object3;
        id.getUUID();
        Vector vector = this.api.getMetamodelManager().getProperties(id.getType());
        if (vector != null) {
            object3 = vector.elements();
            while (object3.hasMoreElements()) {
                object2 = (ModelProperty)object3.nextElement();
                if (!((ModelProperty)object2).isClass() || (object = id.get(((ModelProperty)object2).getModelLink(), false)) == null || ((Vector)object).size() <= 0) continue;
                Id id2 = (Id)((Vector)object).firstElement();
                this.assignUUIDs(id2);
            }
        }
        if ((object3 = this.api.get(id, ModelType.IXT_ALL, false)) != null) {
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                object = (Id)object2.nextElement();
                this.assignUUIDs((Id)object);
            }
        }
    }

    protected Vector getSetNames(Id id) throws Exception {
        Vector vector = id.getSets();
        if (vector == null) {
            vector = new Vector(1);
        }
        return vector;
    }

    public String getXMIId(Id id) {
        return (String)this.idToX.get(id);
    }

    private void makeXMIIds() throws Exception {
        int n = 1;
        Enumeration enumeration = this.constructs.elements();
        while (enumeration.hasMoreElements()) {
            Id id = (Id)enumeration.nextElement();
            String string = "_" + n++;
            this.assignIds(string, id);
        }
    }

    public static XMISave makeXMISave(ModelAPI modelAPI, Vector vector, File file, ZipOutputStream zipOutputStream, int n, String string, String string2, String string3, Vector vector2, Vector vector3, Vector vector4) {
        XMISaveFactory xMISaveFactory = modelAPI.getXMISaveFactory();
        return xMISaveFactory.makeXMISave(modelAPI, vector, file, zipOutputStream, n, string, string2, string3, vector2, vector3, vector4);
    }

    protected void printAttribute(ModelProperty modelProperty, Id id, int n) throws Exception {
        if (modelProperty.isClass()) {
            this.printClassAttribute(id, modelProperty, n);
        } else {
            String string = id.get(modelProperty);
            this.printAttribute(modelProperty, string, n);
        }
    }

    private void printAttribute(ModelProperty modelProperty, String string, int n) throws Exception {
        if (string == null) {
            return;
        }
        if (modelProperty.getLegalValues().equals("")) {
            PrintXML.printStartElement(modelProperty.getFullName(), null, false, n);
            PrintXML.printText(string);
            PrintXML.printEndElement(modelProperty.getFullName(), -1);
        } else {
            Vector<String> vector = new Vector<String>(2);
            vector.addElement(XMI_VALUE);
            vector.addElement(string);
            PrintXML.printStartElement(modelProperty.getFullName(), vector, true, n);
        }
    }

    private void printAttributes(Id id, int n) throws Exception {
        Vector vector = this.api.getMetamodelManager().getProperties(id.getType());
        if (vector == null) {
            return;
        }
        vector = (Vector)vector.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.printAttribute((ModelProperty)enumeration.nextElement(), id, n);
        }
    }

    private void printClassAttribute(Id id, ModelProperty modelProperty, int n) throws Exception {
        ModelLink modelLink = modelProperty.getModelLink();
        Vector vector = this.api.getRelationships().get(id, modelLink, false);
        if (vector == null || vector.size() == 0) {
            return;
        }
        PrintXML.printStartElement(modelProperty.getFullName(), null, false, n);
        this.printId((Id)vector.firstElement(), n + 2, false);
        PrintXML.printEndElement(modelProperty.getFullName(), n);
    }

    private void printDoctype() throws Exception {
        Vector<String> vector = new Vector<String>();
        vector.addElement(ID);
        vector.addElement(XML_ID);
        vector.addElement(XML_IMPLIED);
        vector.addElement(XMI_LABEL);
        vector.addElement(XML_CDATA);
        vector.addElement(XML_IMPLIED);
        vector.addElement(XMI_UUID);
        vector.addElement(XML_CDATA);
        vector.addElement(XML_IMPLIED);
        vector.addElement(XML_LINK);
        vector.addElement(XML_CDATA);
        vector.addElement(XML_IMPLIED);
        vector.addElement(INLINE);
        vector.addElement("(true|false)");
        vector.addElement(XML_IMPLIED);
        vector.addElement(ACTUATE);
        vector.addElement("(show|user)");
        vector.addElement(XML_IMPLIED);
        vector.addElement(HREF);
        vector.addElement(XML_CDATA);
        vector.addElement(XML_IMPLIED);
        vector.addElement(ROLE);
        vector.addElement(XML_CDATA);
        vector.addElement(XML_IMPLIED);
        vector.addElement(TITLE);
        vector.addElement(XML_CDATA);
        vector.addElement(XML_IMPLIED);
        vector.addElement(SHOW);
        vector.addElement("(embed|replace|new)");
        vector.addElement(XML_IMPLIED);
        vector.addElement(BEHAVIOR);
        vector.addElement(XML_CDATA);
        vector.addElement(XML_IMPLIED);
        vector.addElement("xmi.idref");
        vector.addElement(XML_IDREF);
        vector.addElement(XML_IMPLIED);
        vector.addElement(XMI_UUIDREF);
        vector.addElement(XML_CDATA);
        vector.addElement(XML_IMPLIED);
        vector.addElement(ModelProperty.IXT_EXTENSION_NAME.getFullName());
        vector.addElement(XML_CDATA);
        vector.addElement(XML_IMPLIED);
        vector.addElement(ModelProperty.IXT_EXTENSION_TYPE.getFullName());
        vector.addElement(XML_CDATA);
        vector.addElement(XML_IMPLIED);
        vector.addElement(ModelProperty.IXT_EXTENSION_DELETE.getFullName());
        vector.addElement(XML_CDATA);
        vector.addElement(XML_IMPLIED);
        vector.addElement(ModelProperty.IXT_EXTENSION_DATA.getFullName());
        vector.addElement(XML_CDATA);
        vector.addElement(XML_IMPLIED);
        if (this.option != 4) {
            PrintXML.printDoctype("XMI", this.metamodel.getDTD(), ModelType.IXT_EXTENSION.getFullName(), "ANY", vector, 2);
        }
    }

    private void printExtension(Id id, int n) throws Exception {
        boolean bl = false;
        if (id.get(ModelLink.IXT_XMI_CONTENT, false) == null && id.get(ModelLink.IXT_EXTENSION_REFERENCE, false) == null && id.getSets() == null) {
            bl = true;
        }
        Vector<String> vector = new Vector<String>(14);
        vector.addElement(ID);
        vector.addElement((String)this.idToX.get(id));
        if (id.getLabel() != null) {
            vector.addElement(XMI_LABEL);
            vector.addElement(id.getLabel());
        }
        if (id.retrieveUUID() != null) {
            vector.addElement(XMI_UUID);
            vector.addElement(id.retrieveUUID());
        }
        String string = id.get(ModelProperty.IXT_EXTENSION_NAME);
        String string2 = id.get(ModelProperty.IXT_EXTENSION_TYPE);
        String string3 = id.get(ModelProperty.IXT_EXTENSION_DATA);
        String string4 = id.get(ModelProperty.IXT_EXTENSION_DELETE);
        if (string != null) {
            vector.addElement(ModelProperty.IXT_EXTENSION_NAME.getFullName());
            vector.addElement(string);
        }
        if (string2 != null) {
            vector.addElement(ModelProperty.IXT_EXTENSION_TYPE.getFullName());
            vector.addElement(string2);
        }
        if (string3 != null) {
            vector.addElement(ModelProperty.IXT_EXTENSION_DATA.getFullName());
            vector.addElement(string3);
        }
        if (string4 != null) {
            vector.addElement(ModelProperty.IXT_EXTENSION_DELETE.getFullName());
            vector.addElement(string4);
        }
        PrintXML.printStartElement(id.getType().getFullName(), vector, bl, n);
        if (!bl) {
            this.printExtensions(id, n + 2);
            this.printExtensionLinks(id, n + 2);
            PrintXML.printEndElement(id.getType().getFullName(), n);
        }
    }

    protected void printExtensionLinks(Id id, int n) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Vector vector = this.api.getRelationships().get(id, ModelLink.IXT_EXTENSION_REFERENCE, false);
        if (vector != null && vector.size() != 0) {
            object3 = (String)idToFile.get(id);
            object2 = (String)idToFile.get((Id)vector.firstElement());
            if (object2 == null) {
                object = this.api.getProperties().getTag((Id)vector.firstElement(), "", "xmiFile");
                if (object == null) {
                    object = ((Id)vector.firstElement()).getHref();
                }
                if (object != null) {
                    idToFile.put(vector.firstElement(), object);
                }
                object2 = object;
            }
            if (object3 != null && object2 != null && !((String)object3).equals(object2)) {
                this.printLinkReference((Id)vector.firstElement(), n);
            } else {
                this.printReference((Id)vector.firstElement(), n);
            }
        }
        if ((object3 = id.get(ModelLink.IXT_XMI_CONTENT, false)) != null) {
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                object = (Id)object2.nextElement();
                if (((Id)object).getType() != ModelType.IXT_EXTENSION) {
                    this.printId((Id)object, n, false);
                    continue;
                }
                this.printExtension((Id)object, n);
            }
        }
    }

    private void printExtensionPoint(Id id, int n) throws Exception {
    }

    private void printExtensions(Id id, int n) throws Exception {
        Vector vector = this.getSetNames(id);
        if (vector.size() == 0) {
            return;
        }
        Vector<String> vector2 = new Vector<String>(4);
        vector2.addElement(EXTENDER);
        vector2.addElement(XMI_TOOLKIT);
        vector2.addElement(EXTENDER_ID);
        vector2.addElement("");
        PrintXML.printStartElement(ModelType.IXT_XMI_EXTENSION.getFullName(), vector2, false, n);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            vector2 = new Vector(4);
            vector2.addElement(IXTS_NAME);
            vector2.addElement(string);
            PrintXML.printStartElement(ModelType.IXT_EXT_SET.getFullName(), vector2, false, n + 2);
            Vector vector3 = id.getTags(string);
            Enumeration enumeration2 = vector3.elements();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                String string3 = id.get(string, string2);
                vector2 = new Vector(4);
                vector2.addElement(IXTTV_TAG);
                vector2.addElement(string2);
                vector2.addElement(IXTTV_VALUE);
                vector2.addElement(string3);
                PrintXML.printStartElement(ModelType.IXT_EXT_TV.getFullName(), vector2, true, n + 4);
            }
            PrintXML.printEndElement(ModelType.IXT_EXT_SET.getFullName(), n + 2);
        }
        PrintXML.printEndElement(ModelType.IXT_XMI_EXTENSION.getFullName(), n);
    }

    private void printHeader() throws Exception {
        PrintXML.printXMLPI(XML_VERSION);
        this.printDoctype();
    }

    private void printId(Id id, int n, boolean bl) throws Exception {
        String string = (String)idToFile.get(id);
        if (!this.sameAsFileOrDir(string)) {
            Vector<Id> vector = new Vector<Id>(1);
            vector.addElement(id);
            if (bl) {
                if (dir != null) {
                    string = dir.getAbsolutePath() + System.getProperty("file.separator") + this.replaceForwardSlashes(string);
                } else if (zos != null) {
                    entry = string;
                }
                XMISave xMISave = null;
                xMISave = zos != null ? XMISave.makeXMISave(this.api, vector, new File(string), zos, this.option, this.product, this.versionNumber, this.encoding, this.metamodels, this.warnings, this.header) : XMISave.makeXMISave(this.api, vector, new File(string), null, this.option, this.product, this.versionNumber, this.encoding, this.metamodels, this.warnings, this.header);
                xMISave.printXMIFile();
            }
            if (this.pw != null) {
                PrintXML.setPrintWriter(this.pw);
                this.printLinkReference(id, n);
            }
            return;
        }
        ++this.constructCount;
        if (this.constructCount % 100L == 0L) {
            PrintXML.printEndDocument();
        }
        int n2 = this.totalConstructs != 0L ? (int)(100L * this.constructCount / this.totalConstructs) : (int)(100L * this.constructCount / (this.constructCount + 1L));
        Listeners.fireProgress(2, n2);
        boolean bl2 = false;
        if (id.getProperties() == null && id.getSets() == null && id.getLinks() == null) {
            bl2 = true;
        }
        Vector<String> vector = new Vector<String>(6);
        vector.addElement(ID);
        vector.addElement((String)this.idToX.get(id));
        if (id.getLabel() != null) {
            vector.addElement(XMI_LABEL);
            vector.addElement(id.getLabel());
        }
        if (id.retrieveUUID() != null) {
            vector.addElement(XMI_UUID);
            vector.addElement(id.retrieveUUID());
        }
        PrintXML.printStartElement(id.getType().getFullName(), vector, bl2, n);
        if (!bl2) {
            this.printAttributes(id, n + 2);
            this.printExtensions(id, n + 2);
            this.printLinks(id, n + 2);
            PrintXML.printEndElement(id.getType().getFullName(), n);
        }
    }

    protected void printLink(Id id, ModelLink modelLink, Vector vector, int n) throws Exception {
        if (vector == null) {
            return;
        }
        if (modelLink == ModelLink.IXT_XMI_EXTENSION) {
            this.printUserExtensions(vector, n);
            return;
        }
        boolean bl = false;
        boolean bl2 = true;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Id id2 = (Id)enumeration.nextElement();
            String string = (String)this.idToX.get(id2);
            String string2 = id2.getUUIDREF();
            String string3 = this.api.getProperties().getTag(id2, "", "xmiFile");
            if (idToFile.get(id2) == null && string3 == null && id2.getHref() != null) {
                string3 = id2.getHref();
                idToFile.put(id2, string3);
            }
            if (idToFile.get(id2) == null && string3 != null) {
                idToFile.put(id2, string3);
            }
            if (string == null && string2 == null && idToFile.get(id2) == null) {
                object = new LinkNotSavedException(id, modelLink, id2);
                this.addToWarnings((ModelException)object);
                continue;
            }
            if (bl2) {
                PrintXML.printStartElement(modelLink.getFullName(), null, false, n);
                bl2 = false;
            }
            if (modelLink.isContainment() && string != null) {
                this.printId(id2, n + 2, false);
            } else {
                object = (String)idToFile.get(id);
                String string4 = (String)idToFile.get(id2);
                if (object != null && string4 != null && !((String)object).equals(string4)) {
                    this.printLinkReference(id2, n + 2);
                } else {
                    this.printReference(id2, n + 2);
                }
            }
            bl = true;
        }
        if (bl) {
            PrintXML.printEndElement(modelLink.getFullName(), n);
        }
    }

    protected void printLinkReference(Id id, int n) throws Exception {
        Vector<String> vector = new Vector<String>(2);
        vector.addElement(XMI_UUID);
        vector.addElement(id.getUUID());
        vector.addElement(HREF);
        String string = this.api.getProperties().getTag(id, "", "xmiFile");
        if (string == null) {
            string = (String)idToFile.get(id);
        }
        vector.addElement(string);
        PrintXML.printStartElement(id.getType().getFullName(), vector, true, n);
    }

    private void printLinks(Id id, int n) throws Exception {
        Vector vector = this.api.getMetamodelManager().getLinks(id.getType());
        if (vector == null) {
            return;
        }
        vector = (Vector)vector.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ModelLink modelLink = (ModelLink)enumeration.nextElement();
            Vector vector2 = id.get(modelLink, false);
            this.printLink(id, modelLink, vector2, n);
        }
    }

    private void printReference(Id id, int n) throws Exception {
        Vector<String> vector = new Vector<String>(2);
        String string = (String)this.idToX.get(id);
        String string2 = id.getUUIDREF();
        if (string != null) {
            vector.addElement("xmi.idref");
            vector.addElement(string);
        }
        if (string2 != null) {
            vector.addElement(XMI_UUIDREF);
            vector.addElement(string2);
        }
        PrintXML.printStartElement(id.getType().getFullName(), vector, true, n);
    }

    private void printTaggedValues(Id id, ModelLink modelLink, int n) throws Exception {
    }

    private void printUserExtensions(Vector vector, int n) throws Exception {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Id id = (Id)enumeration.nextElement();
            this.printXMIExtension(id, n);
        }
    }

    private void printXMIContent() throws Exception {
        Vector<String> vector = new Vector<String>(4);
        vector.addElement(XMI_VERSION);
        vector.addElement(XML_VERSION);
        vector.addElement(TIMESTAMP);
        vector.addElement(new Date().toString());
        PrintXML.printStartElement("XMI", vector, false, 0);
        this.printXMIHeader(2);
        if (this.constructs == null || this.constructs.size() == 0) {
            PrintXML.printStartElement(XMI_CONTENT, null, true, 2);
        } else {
            PrintXML.printStartElement(XMI_CONTENT, null, false, 2);
        }
        Enumeration enumeration = this.constructs.elements();
        while (enumeration.hasMoreElements()) {
            Id id = (Id)enumeration.nextElement();
            this.printId(id, 4, false);
        }
        if (this.constructs != null && this.constructs.size() != 0) {
            PrintXML.printEndElement(XMI_CONTENT, 2);
        }
        PrintXML.printEndElement("XMI", 0);
    }

    private void printXMIExtension(Id id, int n) throws Exception {
        boolean bl = false;
        if (id.get(ModelLink.IXT_XMI_CONTENT, false) == null) {
            bl = true;
        }
        Vector<String> vector = new Vector<String>(10);
        vector.addElement(ID);
        vector.addElement((String)this.idToX.get(id));
        if (id.getLabel() != null) {
            vector.addElement(XMI_LABEL);
            vector.addElement(id.getLabel());
        }
        if (id.retrieveUUID() != null) {
            vector.addElement(XMI_UUID);
            vector.addElement(id.retrieveUUID());
        }
        String string = id.get(ModelProperty.IXT_XMI_EXTENDER);
        String string2 = id.get(ModelProperty.IXT_XMI_EXTENDER_ID);
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        vector.addElement(EXTENDER);
        vector.addElement(string);
        vector.addElement(EXTENDER_ID);
        vector.addElement(string2);
        PrintXML.printStartElement(id.getType().getFullName(), vector, bl, n);
        this.printXMIExtensionLinks(id, n + 2);
        if (!bl) {
            PrintXML.printEndElement(id.getType().getFullName(), n);
        }
    }

    private void printXMIExtensionLinks(Id id, int n) throws Exception {
        Vector vector = id.get(ModelLink.IXT_XMI_CONTENT, false);
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Id id2 = (Id)enumeration.nextElement();
            if (id2.getType() != ModelType.IXT_EXTENSION) {
                this.printId(id2, n, false);
                continue;
            }
            this.printExtension(id2, n);
        }
    }

    private void printXMIFile() throws Exception {
        Object object;
        String string = this.fileOrDir.getParent();
        if (string != null && zos == null) {
            object = new File(string);
            ((File)object).mkdirs();
        }
        object = null;
        if (!this.fileOrDir.getPath().equals("") && zos == null) {
            object = new FileOutputStream(this.fileOrDir);
        }
        String string2 = MIME2Java.convert(this.encoding);
        if (object != null) {
            this.pw = new PrintWriter(new OutputStreamWriter((OutputStream)object, string2));
        } else if (zos != null) {
            this.pw = new PrintWriter(new OutputStreamWriter((OutputStream)zos, string2));
        }
        PrintXML.setPrintWriter(this.pw);
        if (zos != null) {
            zos.putNextEntry(new ZipEntry(entry));
        }
        this.printHeader();
        this.makeXMIIds();
        this.printXMIContent();
        PrintXML.printEndDocument();
        if (zos != null) {
            zos.closeEntry();
        } else {
            ((OutputStream)object).close();
        }
    }

    private void printXMIHeader(int n) throws Exception {
        PrintXML.printStartElement(XMI_HEADER, null, false, n);
        PrintXML.printStartElement(XMI_DOCUMENTATION, null, false, n + 2);
        if (this.header != null) {
            for (int i = 0; i < this.header.size(); ++i) {
                if (!this.header.elementAt(i).equals(XMI_NOTICE) || i + 1 >= this.header.size()) continue;
                PrintXML.printStartElement(XMI_NOTICE, null, false, n + 4);
                PrintXML.printText((String)this.header.elementAt(i + 1));
                PrintXML.printEndElement(XMI_NOTICE, -1);
            }
        }
        PrintXML.printStartElement(XMI_EXPORTER, null, false, n + 4);
        PrintXML.printText(this.product);
        PrintXML.printEndElement(XMI_EXPORTER, -1);
        PrintXML.printStartElement(XMI_EXPORTER_VERSION, null, false, n + 4);
        PrintXML.printText(this.versionNumber);
        PrintXML.printEndElement(XMI_EXPORTER_VERSION, -1);
        PrintXML.printEndElement(XMI_DOCUMENTATION, n + 2);
        Vector<String> vector = new Vector<String>(4);
        vector.addElement(XMI_NAME);
        vector.addElement(this.metamodel.getName());
        vector.addElement(XMI_VERSION);
        vector.addElement(this.metamodel.getVersion());
        PrintXML.printStartElement(XMI_METAMODEL, vector, true, n + 2);
        PrintXML.printEndElement(XMI_HEADER, n);
    }

    protected void putInIdToXHashtable(Id id, String string) {
        this.idToX.put(id, string);
    }

    private String replaceForwardSlashes(String string) {
        return string.replace('/', File.separatorChar);
    }

    private boolean sameAsFileOrDir(String string) {
        File file = new File(string);
        if (file.getName().equals(this.fileOrDir.getName())) {
            return true;
        }
        file = new File(string.replace('/', File.separatorChar));
        return file.getName().equals(this.fileOrDir.getName());
    }

    public void save() throws Exception {
        this.assignFilesAndUUIDs();
        if (!this.allFilesSpecified()) {
            if (this.fileOrDir.isDirectory() && zos == null) {
                throw new DirectoryException(this.fileOrDir.getPath());
            }
            if (zos != null) {
                throw new XMIFileNotSetException();
            }
            this.printXMIFile();
        } else {
            if (!this.fileOrDir.getPath().equals("") && !this.fileOrDir.isDirectory() && zos == null) {
                this.warnings.addElement(new FilenameIgnoredException());
            }
            this.makeXMIIds();
            this.fileOrDir = new File("");
            Enumeration enumeration = this.constructs.elements();
            while (enumeration.hasMoreElements()) {
                Id id = (Id)enumeration.nextElement();
                this.printId(id, 0, true);
            }
        }
        Listeners.fireProgress(2, 100);
        idToFile = null;
        dir = null;
        zos = null;
        entry = null;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }
}

