/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.UIntHashtableEntry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class UIntHashtable
implements Cloneable,
Serializable {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private transient UIntHashtableEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public UIntHashtable() {
        this(101, 0.75f);
    }

    public UIntHashtable(int n) {
        this(n, 0.75f);
    }

    public UIntHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new UIntHashtableEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public void clear() {
        UIntHashtableEntry[] uIntHashtableEntryArray = this.table;
        int n = uIntHashtableEntryArray.length;
        while (--n >= 0) {
            uIntHashtableEntryArray[n] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            UIntHashtable uIntHashtable = (UIntHashtable)super.clone();
            uIntHashtable.table = new UIntHashtableEntry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                uIntHashtable.table[n] = this.table[n] != null ? (UIntHashtableEntry)this.table[n].clone() : null;
            }
            return uIntHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        UIntHashtableEntry[] uIntHashtableEntryArray = this.table;
        int n = uIntHashtableEntryArray.length;
        while (n-- > 0) {
            UIntHashtableEntry uIntHashtableEntry = uIntHashtableEntryArray[n];
            if (!uIntHashtableEntry.value.equals(object)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(int n) {
        int n2 = n % this.table.length;
        return this.table[n2] != null && this.table[n2].key == n;
    }

    public Enumeration elements() {
        return null;
    }

    public Object get(int n) {
        UIntHashtableEntry[] uIntHashtableEntryArray = this.table;
        int n2 = n % uIntHashtableEntryArray.length;
        if (uIntHashtableEntryArray[n2] != null && uIntHashtableEntryArray[n2].key == n) {
            return uIntHashtableEntryArray[n2].value;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Vector keys() {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.table.length; ++i) {
            if (this.table[i] == null) continue;
            vector.addElement(new Integer(this.table[i].key));
        }
        return vector;
    }

    public Object put(int n, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        UIntHashtableEntry[] uIntHashtableEntryArray = this.table;
        int n2 = n % uIntHashtableEntryArray.length;
        if (uIntHashtableEntryArray[n2] != null && uIntHashtableEntryArray[n2].key != n) {
            this.rehash();
            return this.put(n, object);
        }
        if (uIntHashtableEntryArray[n2] != null && uIntHashtableEntryArray[n2].key == n) {
            uIntHashtableEntryArray[n2].value = object;
            return null;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(n, object);
        }
        UIntHashtableEntry uIntHashtableEntry = new UIntHashtableEntry();
        uIntHashtableEntry.key = n;
        uIntHashtableEntry.value = object;
        uIntHashtableEntryArray[n2] = uIntHashtableEntry;
        ++this.count;
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new UIntHashtableEntry[n];
        this.count = 0;
        for (int i = objectInputStream.readInt(); i > 0; --i) {
            int n2 = objectInputStream.readInt();
            Object object = objectInputStream.readObject();
            this.put(n2, object);
        }
    }

    protected void rehash() {
        int n = this.table.length;
        UIntHashtableEntry[] uIntHashtableEntryArray = this.table;
        int n2 = 0;
        if (n < 1000) {
            n2 = n * 2 + 1;
        } else {
            n2 = (int)((float)n * 1.5f);
            if ((n2 & 1) == 0) {
                ++n2;
            }
        }
        UIntHashtableEntry[] uIntHashtableEntryArray2 = new UIntHashtableEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = uIntHashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            UIntHashtableEntry uIntHashtableEntry = uIntHashtableEntryArray[n3];
            if (uIntHashtableEntry == null) continue;
            int n4 = uIntHashtableEntry.key % n2;
            uIntHashtableEntryArray2[n4] = uIntHashtableEntry;
        }
    }

    public Object remove(int n) {
        UIntHashtableEntry[] uIntHashtableEntryArray = this.table;
        int n2 = n % uIntHashtableEntryArray.length;
        UIntHashtableEntry uIntHashtableEntry = uIntHashtableEntryArray[n2];
        if (uIntHashtableEntry != null && uIntHashtableEntry.key == n) {
            uIntHashtableEntryArray[n2] = null;
            --this.count;
            return uIntHashtableEntry.value;
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        int n = this.size();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < this.table.length; ++i) {
            if (this.table[i] == null) continue;
            stringBuffer.append(i + "=" + this.table[i].value);
            if (++n2 < n) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        for (int i = this.table.length - 1; i >= 0; --i) {
            UIntHashtableEntry uIntHashtableEntry = this.table[i];
            if (uIntHashtableEntry == null) continue;
            objectOutputStream.writeInt(uIntHashtableEntry.key);
            objectOutputStream.writeObject(uIntHashtableEntry.value);
        }
    }
}

