/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.AddTestBuilder;
import com.ibm.xmi.mod.GetTestBuilder;
import com.ibm.xmi.mod.Metamodel;
import com.ibm.xmi.mod.ModelLink;
import com.ibm.xmi.mod.ModelProperty;
import com.ibm.xmi.mod.ModelType;
import com.ibm.xmi.mod.SaveTestBuilder;
import com.ibm.xmi.mod.SetTestBuilder;
import com.ibm.xmi.mod.TestScript;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TestBuilder {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private String directory;
    private int firstNum;
    private boolean mode;
    private boolean fullNames;
    protected Metamodel metamodel;
    private ModelType type;
    private Hashtable typeToAbbrev;
    public static final String session = "s";
    private final String prefix = "x";

    protected TestBuilder(String string, Metamodel metamodel, ModelType modelType, int n, boolean bl, boolean bl2) {
        this.directory = string;
        this.metamodel = metamodel;
        this.type = modelType;
        this.firstNum = n;
        this.mode = bl;
        this.fullNames = bl2;
    }

    public Vector build() {
        return null;
    }

    protected String buildATest(int n, Vector vector) {
        String string = this.getTestName(n);
        String string2 = this.getTestFile(string);
        TestScript testScript = new TestScript(string2, this.metamodel, this.type, this.mode);
        if (!this.makeDescription(testScript, vector)) {
            return null;
        }
        if (!this.makeContent(testScript, vector)) {
            return null;
        }
        if (!testScript.write()) {
            return null;
        }
        return string;
    }

    protected boolean buildTest(int n, Vector vector, Vector vector2) {
        String string = this.buildATest(n, vector);
        if (string == null) {
            return false;
        }
        vector2.addElement(string);
        return true;
    }

    protected int getFirstNum() {
        return this.firstNum;
    }

    protected Metamodel getMetamodel() {
        return this.metamodel;
    }

    protected boolean getMode() {
        return this.mode;
    }

    protected String getModeString() {
        if (this.mode) {
            return " in save memory mode";
        }
        return "";
    }

    protected String getName(ModelLink modelLink) {
        if (this.fullNames) {
            return modelLink.getFullName();
        }
        return modelLink.toString();
    }

    protected String getName(ModelProperty modelProperty) {
        if (this.fullNames) {
            return modelProperty.getFullName();
        }
        return modelProperty.toString();
    }

    protected String getName(ModelType modelType) {
        if (this.fullNames) {
            return modelType.getFullName();
        }
        return modelType.toString();
    }

    protected Vector getProperties() {
        return this.metamodel.getProperties(this.type);
    }

    protected String getTestFile(String string) {
        return this.directory + System.getProperty("file.separator") + string;
    }

    protected String getTestName(int n) {
        if (!this.fullNames) {
            return "x" + this.getTestType() + this.getTypeAbbrev() + n;
        }
        return "x" + this.getTestType() + "f" + this.getTypeAbbrev() + n;
    }

    protected String getTestType() {
        return "";
    }

    protected ModelType getType() {
        return this.type;
    }

    private String getTypeAbbrev() {
        if (this.typeToAbbrev == null) {
            this.initializeAbbrev();
        }
        return (String)this.typeToAbbrev.get(this.type);
    }

    private void initializeAbbrev() {
        this.typeToAbbrev = new Hashtable();
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.metamodel.getAllTypes();
        block0: while (enumeration.hasMoreElements()) {
            ModelType modelType = (ModelType)enumeration.nextElement();
            String string = modelType.toString().substring(0, 3);
            if (!vector.contains(string)) {
                this.typeToAbbrev.put(modelType, string);
                vector.addElement(string);
                continue;
            }
            String string2 = string.substring(0, 2);
            for (int i = 4; i < modelType.toString().length(); ++i) {
                string = string2 + modelType.toString().charAt(i);
                if (vector.contains(string)) continue;
                this.typeToAbbrev.put(modelType, string);
                vector.addElement(string);
                continue block0;
            }
        }
    }

    public static TestBuilder make(String string, int n, Metamodel metamodel, ModelType modelType, int n2, boolean bl, boolean bl2) {
        if (n == 2) {
            return new AddTestBuilder(string, metamodel, modelType, n2, bl, bl2);
        }
        if (n == 3) {
            return new SetTestBuilder(string, metamodel, modelType, n2, bl, bl2);
        }
        if (n == 5) {
            return new GetTestBuilder(string, metamodel, modelType, n2, bl, bl2);
        }
        if (n == 9) {
            return new SaveTestBuilder(string, metamodel, modelType, n2, bl, bl2);
        }
        return null;
    }

    protected boolean makeContent(TestScript testScript, Vector vector) {
        return false;
    }

    protected boolean makeDescription(TestScript testScript, Vector vector) {
        return false;
    }
}

