/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.Id;
import com.ibm.xmi.mod.LargeHashtable;
import com.ibm.xmi.mod.ModelAPI;
import com.ibm.xmi.mod.ModelException;
import com.ibm.xmi.mod.ModelProperty;
import com.ibm.xmi.mod.NoPropertyException;
import com.ibm.xmi.mod.NoTagException;
import com.ibm.xmi.mod.Properties;
import com.ibm.xmi.mod.UHashtable;
import com.ibm.xmi.mod.UProperties;
import java.util.Enumeration;
import java.util.Vector;

class SMProperties
extends Properties {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String PROP_PREFIX = "p";
    private static final String TAG_PREFIX = "t";
    private LargeHashtable props;
    private LargeHashtable tags;

    SMProperties(ModelAPI modelAPI) {
        super(modelAPI);
        String string = modelAPI.getHashPrefix() + PROP_PREFIX;
        this.props = new LargeHashtable(1001, string);
        String string2 = modelAPI.getHashPrefix() + TAG_PREFIX;
        this.tags = new LargeHashtable(1001, string2);
    }

    public void clear() {
        this.props.clear();
        this.tags.clear();
    }

    public Vector getProperties(Id id) {
        UProperties uProperties = (UProperties)this.props.get(id.getInt());
        if (uProperties == null) {
            return null;
        }
        Enumeration enumeration = uProperties.propertyNames();
        Vector<Object> vector = new Vector<Object>();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            vector.addElement(this.api.getMetamodelManager().getMMConstruct(string));
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public String getProperty(Id id, ModelProperty modelProperty) {
        UProperties uProperties = (UProperties)this.props.get(id.getInt());
        if (uProperties == null) {
            return null;
        }
        return uProperties.getProperty(modelProperty.getFullName());
    }

    public Vector getSets(Id id) {
        UHashtable uHashtable = (UHashtable)this.tags.get(id.getInt());
        if (uHashtable == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>(10);
        Enumeration enumeration = uHashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n = ((UProperties)uHashtable.get(string)).size();
            if (n == 0) continue;
            vector.addElement(string);
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public String getTag(Id id, String string, String string2) {
        UHashtable uHashtable;
        if (string == null) {
            string = "";
        }
        if ((uHashtable = (UHashtable)this.tags.get(id.getInt())) == null) {
            return null;
        }
        UProperties uProperties = (UProperties)uHashtable.get(string);
        if (uProperties == null) {
            return null;
        }
        return uProperties.getProperty(string2);
    }

    public Vector getTags(Id id, String string) {
        UHashtable uHashtable;
        if (string == null) {
            string = "";
        }
        if ((uHashtable = (UHashtable)this.tags.get(id.getInt())) == null) {
            return null;
        }
        UProperties uProperties = (UProperties)uHashtable.get(string);
        if (uProperties == null) {
            return null;
        }
        Vector vector = new Vector();
        Enumeration enumeration = uProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public void remove(Id id) {
        this.props.remove(id.getInt());
        this.tags.remove(id.getInt());
    }

    protected void removeProperty(Id id, ModelProperty modelProperty) throws ModelException {
        UProperties uProperties = (UProperties)this.props.get(id.getInt());
        if (uProperties == null) {
            throw new NoPropertyException(modelProperty);
        }
        if (uProperties.getProperty(modelProperty.getFullName()) == null) {
            throw new NoPropertyException(modelProperty);
        }
        uProperties.remove(modelProperty.getFullName());
    }

    protected void removeTag(Id id, String string, String string2) throws ModelException {
        UHashtable uHashtable;
        if (string == null) {
            string = "";
        }
        if ((uHashtable = (UHashtable)this.tags.get(id.getInt())) == null) {
            throw new NoTagException();
        }
        UProperties uProperties = (UProperties)uHashtable.get(string);
        if (uProperties == null || uProperties.getProperty(string2) == null) {
            throw new NoTagException();
        }
        uProperties.remove(string2);
    }

    protected void updateProperty(Id id, ModelProperty modelProperty, String string) {
        UProperties uProperties = (UProperties)this.props.get(id.getInt());
        if (uProperties == null) {
            uProperties = new UProperties();
            this.props.put(id.getInt(), uProperties);
        }
        uProperties.put(modelProperty.getFullName(), string);
    }

    protected void updateTag(Id id, String string, String string2, String string3) {
        UProperties uProperties;
        UHashtable uHashtable = (UHashtable)this.tags.get(id.getInt());
        if (uHashtable == null) {
            uHashtable = new UHashtable(3, 1.0f);
            this.tags.put(id.getInt(), uHashtable);
        }
        if ((uProperties = (UProperties)uHashtable.get(string)) == null) {
            uProperties = new UProperties();
            uHashtable.put(string, uProperties);
        }
        uProperties.put(string2, string3);
    }
}

