/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.FastRelationships;
import com.ibm.xmi.mod.Id;
import com.ibm.xmi.mod.ModelAPI;
import com.ibm.xmi.mod.ModelException;
import com.ibm.xmi.mod.ModelLink;
import com.ibm.xmi.mod.ModelProperty;
import com.ibm.xmi.mod.SMRelationships;
import java.util.Enumeration;
import java.util.Vector;

abstract class Relationships {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected ModelAPI api;

    protected Relationships(ModelAPI modelAPI) {
        this.api = modelAPI;
    }

    public void add(Id id, ModelLink modelLink, Id id2) throws ModelException {
        if (modelLink == ModelLink.IXT_EXTENSION_REFERENCE) {
            String string = null;
            try {
                string = this.api.get(id, ModelProperty.IXT_EXTENSION_DELETE);
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            if (string != null && string.equals("true")) {
                this.add(id2, ModelLink.IXT_DATA, id);
            }
        }
        id2.setRefCount(id2.getRefCount() + 1);
    }

    public abstract void clear();

    public Vector filterLinks(Vector vector, Vector vector2) {
        if (vector == null) {
            return null;
        }
        if (vector2.size() == 0) {
            return vector;
        }
        Vector vector3 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            if (!this.hasLinks((Id)vector.elementAt(i), vector2)) continue;
            vector3.addElement(vector.elementAt(i));
        }
        return vector3;
    }

    protected abstract Vector get(Id var1, ModelLink var2);

    public Vector get(Id id, ModelLink modelLink, boolean bl) throws ModelException {
        if (modelLink == ModelLink.IXT_ALL) {
            return this.getAll(id, bl);
        }
        if (modelLink == ModelLink.IXT_CONTAINER) {
            return this.getContainer(id, bl);
        }
        if (!bl) {
            return this.get(id, modelLink);
        }
        Vector vector = this.get(id, modelLink);
        if (vector == null) {
            return null;
        }
        if ((vector = this.removeDeletedIds(vector)).size() == 0) {
            return null;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector2;
            Id id2 = (Id)enumeration.nextElement();
            if (!id2.isLoaded() && this.api.getDemandLoad()) {
                this.api.demandLoad(id2);
            }
            if ((vector2 = this.get(id2, modelLink)) == null) continue;
            for (int i = 0; i < vector2.size(); ++i) {
                Id id3 = (Id)vector2.elementAt(i);
                if (vector.contains(id3) || id3.isDeleted()) continue;
                vector.addElement(id3);
            }
        }
        return vector;
    }

    private Vector getAll(Id id, boolean bl) throws ModelException {
        Object object;
        Object object2;
        Vector vector = this.getLinks(id);
        if (vector == null) {
            return null;
        }
        Enumeration enumeration = vector.elements();
        Vector<Id> vector2 = new Vector<Id>();
        while (enumeration.hasMoreElements()) {
            object2 = (ModelLink)enumeration.nextElement();
            object = this.get(id, (ModelLink)object2);
            if (object == null) continue;
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                Id id2 = (Id)((Vector)object).elementAt(i);
                if (vector2.contains(id2) || id2.isDeleted()) continue;
                vector2.addElement(id2);
            }
        }
        if (bl) {
            object2 = vector2.elements();
            while (object2.hasMoreElements()) {
                Vector vector3;
                object = (Id)object2.nextElement();
                if (!((Id)object).isLoaded() && this.api.getDemandLoad()) {
                    this.api.demandLoad((Id)object);
                }
                if ((vector3 = this.getAll((Id)object, false)) == null) continue;
                for (int i = 0; i < vector3.size(); ++i) {
                    Id id3 = (Id)vector3.elementAt(i);
                    if (vector2.contains(id3) || id3.isDeleted()) continue;
                    vector2.addElement(id3);
                }
            }
        }
        if (vector2.size() == 0) {
            return null;
        }
        return vector2;
    }

    protected abstract Vector getAllLinks();

    private Vector getContainer(Id id, boolean bl) throws ModelException {
        Object object;
        Object object2;
        Vector vector = this.api.getMetamodelManager().getAllContainerLinks(id.getType());
        if (vector == null) {
            return null;
        }
        Enumeration enumeration = vector.elements();
        Vector<Id> vector2 = new Vector<Id>();
        while (enumeration.hasMoreElements()) {
            object2 = (ModelLink)enumeration.nextElement();
            object = this.get(id, (ModelLink)object2);
            if (object == null) continue;
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                Id id2 = (Id)((Vector)object).elementAt(i);
                if (vector2.contains(id2) || id2.isDeleted()) continue;
                vector2.addElement(id2);
            }
        }
        if (bl) {
            object2 = vector2.elements();
            while (object2.hasMoreElements()) {
                Vector vector3;
                object = (Id)object2.nextElement();
                if (!((Id)object).isLoaded() && this.api.getDemandLoad()) {
                    this.api.demandLoad((Id)object);
                }
                if ((vector3 = this.getContainer((Id)object, false)) == null) continue;
                for (int i = 0; i < vector3.size(); ++i) {
                    Id id3 = (Id)vector3.elementAt(i);
                    if (vector2.contains(id3) || id3.isDeleted()) continue;
                    vector2.addElement(id3);
                }
            }
        }
        if (vector2.size() == 0) {
            return null;
        }
        return vector2;
    }

    public abstract Vector getIds();

    public Vector getLinks(Id id) {
        Vector<ModelLink> vector = new Vector<ModelLink>();
        Vector vector2 = this.getAllLinks();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            ModelLink modelLink = (ModelLink)enumeration.nextElement();
            if (!this.hasSource(modelLink, id)) continue;
            vector.addElement(modelLink);
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public abstract Vector getSources();

    private boolean hasLinks(Id id, Vector vector) {
        for (int i = 0; i < vector.size() - 1; i += 2) {
            ModelLink modelLink = (ModelLink)vector.elementAt(i);
            Id id2 = (Id)vector.elementAt(i + 1);
            Vector vector2 = null;
            vector2 = this.get(id, modelLink);
            if (vector2 == null) {
                return false;
            }
            if (vector2.contains(id2)) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean hasSource(ModelLink var1, Id var2);

    public static Relationships makeRelationships(ModelAPI modelAPI, boolean bl) {
        if (bl) {
            return new SMRelationships(modelAPI);
        }
        return new FastRelationships(modelAPI);
    }

    public abstract Vector remove(Id var1);

    public void remove(Id id, ModelLink modelLink, Id id2) throws ModelException {
        if (modelLink == ModelLink.IXT_EXTENSION_REFERENCE) {
            try {
                this.remove(id2, ModelLink.IXT_DATA, id);
            }
            catch (ModelException modelException) {
                // empty catch block
            }
        }
        id2.setRefCount(id2.getRefCount() - 1);
    }

    protected Vector removeDeletedIds(Vector vector) {
        if (vector == null) {
            return null;
        }
        Vector<Id> vector2 = new Vector<Id>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Id id = (Id)enumeration.nextElement();
            if (id.isDeleted()) continue;
            vector2.addElement(id);
        }
        return vector2;
    }
}

