/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.framework.Util;
import com.ibm.xmi.mod.ModelType;
import java.io.PrintWriter;
import java.util.Vector;

public class PrintXML {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static PrintWriter writer;
    private static String encoding;

    private static void printAttListDecl(String string, Vector vector, int n, int n2) throws Exception {
        Util.indent(writer, n);
        writer.write("<!ATTLIST " + string);
        for (int i = 0; i < vector.size() - 2; i += 3) {
            Util.indent(writer, n + n2);
            writer.write((String)vector.elementAt(i));
            writer.write(" " + vector.elementAt(i + 1));
            writer.write(" " + vector.elementAt(i + 2));
        }
        writer.write(">\n");
    }

    public static void printDoctype(String string, String string2, String string3, String string4, Vector vector, int n) throws Exception {
        writer.write("<!DOCTYPE ");
        writer.write(string);
        writer.write(" ");
        writer.write("SYSTEM \"");
        writer.write(string2);
        writer.write("\" ");
        writer.write("[");
        PrintXML.printElementDecl(string3, string4, vector, n, n);
        String string5 = ModelType.IXT_EXT_SET.getFullName();
        String string6 = "(" + ModelType.IXT_EXT_TV.getFullName() + ")+";
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement("s");
        vector2.addElement("CDATA");
        vector2.addElement("#REQUIRED");
        PrintXML.printElementDecl(string5, string6, vector2, n, n);
        string5 = ModelType.IXT_EXT_TV.getFullName();
        string6 = "EMPTY";
        vector2 = new Vector();
        vector2.addElement("t");
        vector2.addElement("CDATA");
        vector2.addElement("#REQUIRED");
        vector2.addElement("v");
        vector2.addElement("CDATA");
        vector2.addElement("#REQUIRED");
        PrintXML.printElementDecl(string5, string6, vector2, n, n);
        writer.write("]>");
    }

    private static void printElementDecl(String string, String string2, Vector vector, int n, int n2) throws Exception {
        Util.indent(writer, n);
        writer.write("<!ELEMENT " + string + " " + string2 + ">");
        if (vector != null && vector.size() > 0) {
            PrintXML.printAttListDecl(string, vector, n, n2);
        }
    }

    public static void printEndDocument() throws Exception {
        writer.flush();
    }

    public static void printEndElement(String string, int n) throws Exception {
        if (n >= 0) {
            Util.indent(writer, n);
        }
        writer.write("</");
        writer.write(string);
        writer.write(">");
    }

    public static void printStartElement(String string, Vector vector, boolean bl, int n) throws Exception {
        Util.indent(writer, n);
        writer.write("<" + string);
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size() - 1; i += 2) {
                writer.write(" " + vector.elementAt(i));
                writer.write("=\"");
                writer.write(Util.backReference((String)vector.elementAt(i + 1), "<&\"", encoding));
                writer.write("\"");
            }
        }
        if (bl) {
            writer.write("/");
        }
        writer.write(">");
    }

    public static void printText(String string) {
        writer.write(Util.backReference(string, encoding));
    }

    public static void printXMLPI(String string) throws Exception {
        writer.write("<?xml version=\"" + string + "\"");
        if (encoding != null && !encoding.equals("")) {
            writer.write(" encoding=\"" + encoding + "\"");
        }
        writer.write("?>\n");
    }

    public static void setEncoding(String string) {
        encoding = string;
    }

    public static void setPrintWriter(PrintWriter printWriter) {
        writer = printWriter;
    }
}

