/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.Metamodel;
import com.ibm.xmi.mod.ModelLink;
import com.ibm.xmi.mod.ModelProperty;
import com.ibm.xmi.mod.ModelType;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MetamodelManager {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    Vector metamodels = null;
    Hashtable typeStrings;
    Hashtable propStrings;
    Hashtable linkStrings;
    private static MetamodelManager instance = null;

    MetamodelManager() {
        if (instance == null) {
            instance = this;
        }
        Metamodel metamodel = this.createXMI();
        this.metamodels = new Vector(2);
        this.metamodels.addElement(metamodel);
        this.typeStrings = new Hashtable();
        this.propStrings = new Hashtable();
        this.linkStrings = new Hashtable();
        this.initializeStrings(metamodel);
        String string = "com.ibm.xmi.Data";
        this.typeStrings.put(string.intern(), ModelType.IXT_EXTENSION);
        this.typeStrings.put(ModelType.IXT_EXT_SET.getFullName(), ModelType.IXT_EXT_SET);
        this.typeStrings.put(ModelType.IXT_EXT_TV.getFullName(), ModelType.IXT_EXT_TV);
        this.linkStrings.put(ModelLink.IXT_XMI_CONTENT.toString(), ModelLink.IXT_XMI_CONTENT);
        this.linkStrings.put(ModelLink.IXT_XMI_CONTENT.getFullName(), ModelLink.IXT_XMI_CONTENT);
        this.linkStrings.put(ModelLink.IXT_XMI_EXTENSION.toString(), ModelLink.IXT_XMI_EXTENSION);
        this.linkStrings.put(ModelLink.IXT_XMI_EXTENSION.getFullName(), ModelLink.IXT_XMI_EXTENSION);
        this.linkStrings.put(ModelLink.IXT_CONTAINER.toString(), ModelLink.IXT_CONTAINER);
    }

    public void addMetamodel(Metamodel metamodel) {
        this.metamodels.addElement(metamodel);
        this.initializeStrings(metamodel);
    }

    private Metamodel createXMI() {
        Metamodel metamodel = new Metamodel("XMI", "1.0", "", "");
        Vector<ModelType> vector = new Vector<ModelType>(13);
        vector.addElement(ModelType.IXT_XMI);
        vector.addElement(ModelType.IXT_XMI_HEADER);
        vector.addElement(ModelType.IXT_XMI_DOCUMENTATION);
        vector.addElement(ModelType.IXT_XMI_MODEL);
        vector.addElement(ModelType.IXT_XMI_METAMODEL);
        vector.addElement(ModelType.IXT_XMI_METAMETAMODEL);
        vector.addElement(ModelType.IXT_XMI_CONTENT);
        vector.addElement(ModelType.IXT_XMI_EXTENSIONS);
        vector.addElement(ModelType.IXT_XMI_EXTENSION);
        vector.addElement(ModelType.IXT_XMI_DIFFERENCE);
        vector.addElement(ModelType.IXT_XMI_DELETE);
        vector.addElement(ModelType.IXT_XMI_ADD);
        vector.addElement(ModelType.IXT_XMI_REPLACE);
        vector.addElement(ModelType.IXT_EXTENSION);
        metamodel.setTypes(vector);
        Hashtable<ModelType, ModelLink> hashtable = new Hashtable<ModelType, ModelLink>(14);
        hashtable.put(ModelType.IXT_XMI_HEADER, ModelLink.IXT_XMI_CONTENT);
        hashtable.put(ModelType.IXT_XMI_CONTENT, ModelLink.IXT_XMI_CONTENT);
        hashtable.put(ModelType.IXT_XMI_DIFFERENCE, ModelLink.IXT_XMI_CONTENT);
        hashtable.put(ModelType.IXT_XMI_EXTENSIONS, ModelLink.IXT_XMI_CONTENT);
        hashtable.put(ModelType.IXT_XMI_DOCUMENTATION, ModelLink.IXT_XMI_CONTENT);
        hashtable.put(ModelType.IXT_XMI_MODEL, ModelLink.IXT_XMI_CONTENT);
        hashtable.put(ModelType.IXT_XMI_METAMODEL, ModelLink.IXT_XMI_CONTENT);
        hashtable.put(ModelType.IXT_XMI_METAMETAMODEL, ModelLink.IXT_XMI_CONTENT);
        hashtable.put(ModelType.IXT_XMI_DELETE, ModelLink.IXT_XMI_CONTENT);
        hashtable.put(ModelType.IXT_XMI_ADD, ModelLink.IXT_XMI_CONTENT);
        hashtable.put(ModelType.IXT_XMI_REPLACE, ModelLink.IXT_XMI_CONTENT);
        hashtable.put(ModelType.IXT_XMI_EXTENSION, ModelLink.IXT_XMI_EXTENSION);
        hashtable.put(ModelType.IXT_EXTENSION, ModelLink.IXT_XMI_CONTENT);
        metamodel.setContainedLink(hashtable);
        Hashtable hashtable2 = new Hashtable();
        Vector<Object> vector2 = new Vector<Object>(1);
        vector2.addElement(ModelLink.IXT_XMI_CONTENT);
        hashtable2.put(ModelType.IXT_XMI, vector2);
        hashtable2.put(ModelType.IXT_XMI_HEADER, vector2);
        hashtable2.put(ModelType.IXT_XMI_DIFFERENCE, vector2);
        hashtable2.put(ModelType.IXT_XMI_EXTENSIONS, vector2);
        hashtable2.put(ModelType.IXT_XMI_EXTENSION, vector2);
        metamodel.setAllContainedLink(hashtable2);
        Hashtable<ModelType, Vector<Object>> hashtable3 = new Hashtable<ModelType, Vector<Object>>();
        vector2 = new Vector(1);
        vector2.addElement(ModelType.IXT_XMI);
        hashtable3.put(ModelType.IXT_XMI_HEADER, vector2);
        hashtable3.put(ModelType.IXT_XMI_CONTENT, vector2);
        hashtable3.put(ModelType.IXT_XMI_DIFFERENCE, vector2);
        hashtable3.put(ModelType.IXT_XMI_EXTENSIONS, vector2);
        vector2 = new Vector(1);
        vector2.addElement(ModelType.IXT_XMI_HEADER);
        hashtable3.put(ModelType.IXT_XMI_DOCUMENTATION, vector2);
        hashtable3.put(ModelType.IXT_XMI_MODEL, vector2);
        hashtable3.put(ModelType.IXT_XMI_METAMODEL, vector2);
        hashtable3.put(ModelType.IXT_XMI_METAMETAMODEL, vector2);
        vector2 = new Vector(1);
        vector2.addElement(ModelType.IXT_XMI_DIFFERENCE);
        hashtable3.put(ModelType.IXT_XMI_DIFFERENCE, vector2);
        hashtable3.put(ModelType.IXT_XMI_ADD, vector2);
        hashtable3.put(ModelType.IXT_XMI_REPLACE, vector2);
        hashtable3.put(ModelType.IXT_XMI_DELETE, vector2);
        metamodel.setContainerTypes(hashtable3);
        Hashtable hashtable4 = new Hashtable();
        Vector<ModelProperty> vector3 = new Vector<ModelProperty>(3);
        vector3.addElement(ModelProperty.IXT_XMI_VERSION);
        vector3.addElement(ModelProperty.IXT_XMI_TIMESTAMP);
        vector3.addElement(ModelProperty.IXT_XMI_VERIFIED);
        hashtable4.put(ModelType.IXT_XMI, vector3);
        vector3 = new Vector(8);
        vector3.addElement(ModelProperty.IXT_XMI_OWNER);
        vector3.addElement(ModelProperty.IXT_XMI_CONTACT);
        vector3.addElement(ModelProperty.IXT_XMI_LONG_DESCRIPTION);
        vector3.addElement(ModelProperty.IXT_XMI_SHORT_DESCRIPTION);
        vector3.addElement(ModelProperty.IXT_XMI_EXPORTER);
        vector3.addElement(ModelProperty.IXT_XMI_EXPORTER_VERSION);
        vector3.addElement(ModelProperty.IXT_XMI_EXPORTER_ID);
        vector3.addElement(ModelProperty.IXT_XMI_NOTICE);
        hashtable4.put(ModelType.IXT_XMI_DOCUMENTATION, vector3);
        vector3 = new Vector(2);
        vector3.addElement(ModelProperty.IXT_XMI_NAME);
        vector3.addElement(ModelProperty.IXT_XMI_VERSION);
        hashtable4.put(ModelType.IXT_XMI_MODEL, vector3);
        hashtable4.put(ModelType.IXT_XMI_METAMODEL, vector3);
        hashtable4.put(ModelType.IXT_XMI_METAMETAMODEL, vector3);
        vector3 = new Vector(2);
        vector3.addElement(ModelProperty.IXT_XMI_EXTENDER);
        vector3.addElement(ModelProperty.IXT_XMI_EXTENDER_ID);
        hashtable4.put(ModelType.IXT_XMI_EXTENSION, vector3);
        vector3 = new Vector(1);
        vector3.addElement(ModelProperty.IXT_XMI_POSITION);
        hashtable4.put(ModelType.IXT_XMI_ADD, vector3);
        hashtable4.put(ModelType.IXT_XMI_REPLACE, vector3);
        vector3 = new Vector(4);
        vector3.addElement(ModelProperty.IXT_EXTENSION_NAME);
        vector3.addElement(ModelProperty.IXT_EXTENSION_TYPE);
        vector3.addElement(ModelProperty.IXT_EXTENSION_DELETE);
        vector3.addElement(ModelProperty.IXT_EXTENSION_DATA);
        hashtable4.put(ModelType.IXT_EXTENSION, vector3);
        metamodel.setProperties(hashtable4);
        Hashtable hashtable5 = new Hashtable();
        Vector<ModelLink> vector4 = new Vector<ModelLink>(1);
        vector4.addElement(ModelLink.IXT_EXTENSION_REFERENCE);
        hashtable5.put(ModelType.IXT_EXTENSION, vector4);
        metamodel.setLinks(hashtable5);
        return metamodel;
    }

    public Vector getAllContainedLink(ModelType modelType) {
        if (modelType == ModelType.IXT_EXTENSION || modelType == ModelType.IXT_XMI_EXTENSION) {
            Vector<ModelLink> vector = new Vector<ModelLink>(1);
            vector.addElement(ModelLink.IXT_XMI_CONTENT);
            return vector;
        }
        Enumeration enumeration = this.metamodels.elements();
        while (enumeration.hasMoreElements()) {
            Metamodel metamodel = (Metamodel)enumeration.nextElement();
            if (!metamodel.containsType(modelType)) continue;
            Vector vector = metamodel.getAllContainedLink(modelType);
            Vector<ModelLink> vector2 = vector == null ? new Vector<ModelLink>(1) : (Vector<ModelLink>)vector.clone();
            vector2.addElement(ModelLink.IXT_XMI_EXTENSION);
            return vector2;
        }
        return null;
    }

    public Vector getAllContainerLinks(ModelType modelType) {
        if (modelType == ModelType.IXT_EXTENSION || modelType == ModelType.IXT_XMI_EXTENSION) {
            return null;
        }
        Enumeration enumeration = this.metamodels.elements();
        while (enumeration.hasMoreElements()) {
            Metamodel metamodel = (Metamodel)enumeration.nextElement();
            if (!metamodel.containsType(modelType)) continue;
            return metamodel.getAllContainerLinks(modelType);
        }
        return null;
    }

    public ModelLink getContainedLink(ModelType modelType, ModelType modelType2) {
        if (modelType == ModelType.IXT_EXTENSION) {
            return ModelLink.IXT_XMI_CONTENT;
        }
        if (modelType == ModelType.IXT_XMI_EXTENSION) {
            return ModelLink.IXT_XMI_EXTENSION;
        }
        if (modelType2 == ModelType.IXT_XMI_EXTENSION) {
            return ModelLink.IXT_XMI_CONTENT;
        }
        Enumeration enumeration = this.metamodels.elements();
        while (enumeration.hasMoreElements()) {
            Metamodel metamodel = (Metamodel)enumeration.nextElement();
            if (!metamodel.containsType(modelType)) continue;
            return metamodel.getContainedLink(modelType, modelType2);
        }
        return null;
    }

    public ModelLink getContainerLink(ModelType modelType, ModelType modelType2) {
        Enumeration enumeration = this.metamodels.elements();
        while (enumeration.hasMoreElements()) {
            Metamodel metamodel = (Metamodel)enumeration.nextElement();
            if (!metamodel.containsType(modelType)) continue;
            return metamodel.getContainerLink(modelType, modelType2);
        }
        return null;
    }

    public Vector getContainerTypes(ModelType modelType) {
        Enumeration enumeration = this.metamodels.elements();
        while (enumeration.hasMoreElements()) {
            Metamodel metamodel = (Metamodel)enumeration.nextElement();
            if (!metamodel.containsType(modelType)) continue;
            return metamodel.getContainerTypes(modelType);
        }
        return null;
    }

    public Vector getLinks(ModelType modelType) {
        Enumeration enumeration = this.metamodels.elements();
        while (enumeration.hasMoreElements()) {
            Metamodel metamodel = (Metamodel)enumeration.nextElement();
            if (!metamodel.containsType(modelType)) continue;
            Vector<ModelLink> vector = metamodel.getLinks(modelType);
            if (vector == null) {
                vector = new Vector<ModelLink>(1);
            }
            vector = (Vector)vector.clone();
            vector.insertElementAt(ModelLink.IXT_XMI_EXTENSION, 0);
            return vector;
        }
        return null;
    }

    public Metamodel getMetamodel(String string) {
        if (string != null) {
            Enumeration enumeration = this.metamodels.elements();
            while (enumeration.hasMoreElements()) {
                Metamodel metamodel = (Metamodel)enumeration.nextElement();
                if (!metamodel.getName().equals(string)) continue;
                return metamodel;
            }
        }
        return null;
    }

    public Vector getMetamodels() {
        return this.metamodels;
    }

    public Object getMMConstruct(String string) {
        if (string.startsWith("Type.") && !string.equals("Type.all")) {
            return this.typeStrings.get(string.substring(5).intern());
        }
        if (string.startsWith("Property.")) {
            return this.propStrings.get(string.substring(9).intern());
        }
        if (string.startsWith("Link.") && !string.equals("Link.all")) {
            return this.linkStrings.get(string.substring(5).intern());
        }
        if (string.equals("Link.all")) {
            return ModelLink.IXT_ALL;
        }
        Object v = this.typeStrings.get(string.intern());
        if (v != null) {
            return v;
        }
        v = this.propStrings.get(string.intern());
        if (v != null) {
            return v;
        }
        v = this.linkStrings.get(string.intern());
        if (v != null) {
            return v;
        }
        if (string.equals("all") || string.equals("Type.all")) {
            return ModelType.IXT_ALL;
        }
        return null;
    }

    public Vector getProperties(ModelType modelType) {
        Enumeration enumeration = this.metamodels.elements();
        while (enumeration.hasMoreElements()) {
            Metamodel metamodel = (Metamodel)enumeration.nextElement();
            if (!metamodel.containsType(modelType)) continue;
            return metamodel.getProperties(modelType);
        }
        return null;
    }

    private void initializeStrings(Metamodel metamodel) {
        Enumeration enumeration = metamodel.getAllTypes();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            Vector vector;
            ModelType modelType = (ModelType)enumeration.nextElement();
            this.typeStrings.put(modelType.toString(), modelType);
            if (!modelType.toString().equals(modelType.getFullName())) {
                this.typeStrings.put(modelType.getFullName(), modelType);
            }
            if ((vector = metamodel.getProperties(modelType)) != null) {
                object2 = vector.elements();
                while (object2.hasMoreElements()) {
                    object = (ModelProperty)object2.nextElement();
                    this.propStrings.put(((ModelProperty)object).toString(), object);
                    this.propStrings.put(((ModelProperty)object).getFullName(), object);
                    if (!((ModelProperty)object).isClass()) continue;
                    this.linkStrings.put(((ModelProperty)object).getModelLink().toString(), ((ModelProperty)object).getModelLink());
                    this.linkStrings.put(((ModelProperty)object).getModelLink().getFullName(), ((ModelProperty)object).getModelLink());
                }
            }
            if ((object2 = metamodel.getLinks(modelType)) == null) continue;
            object = ((Vector)object2).elements();
            while (object.hasMoreElements()) {
                ModelLink modelLink = (ModelLink)object.nextElement();
                this.linkStrings.put(modelLink.toString(), modelLink);
                this.linkStrings.put(modelLink.getFullName(), modelLink);
            }
        }
    }

    public static MetamodelManager instance() {
        if (instance == null) {
            instance = new MetamodelManager();
        }
        return instance;
    }
}

