/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.UIntHashtable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

class LargeHashtable {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    int maximum;
    int current;
    int maxHashNum;
    UIntHashtable h;
    String prefix;

    LargeHashtable(int n, String string) {
        this.maximum = n;
        this.prefix = string;
        this.current = 1;
        this.maxHashNum = 1;
        this.h = new UIntHashtable(n, 1.0f);
    }

    public void clear() {
        String string = System.getProperty("user.dir");
        String string2 = string + System.getProperty("file.separator");
        File file = new File(string);
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(this.prefix)) continue;
            String string3 = string2 + stringArray[i];
            File file2 = new File(string3);
            file2.delete();
        }
        this.current = 1;
        this.maxHashNum = 1;
        this.h = new UIntHashtable(this.maximum, 1.0f);
    }

    public boolean containsKey(int n) {
        if (n > this.maxHashNum * this.maximum) {
            return false;
        }
        this.swap(n);
        return this.h.containsKey(n);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
    }

    public Object get(int n) {
        this.swap(n);
        return this.h.get(n);
    }

    public boolean isEmpty() {
        if (this.maxHashNum > 1) {
            return false;
        }
        return this.h.isEmpty();
    }

    public Vector keys() {
        Vector vector = new Vector();
        for (int i = 0; i < this.maxHashNum; ++i) {
            int n = (i + 1) * this.maximum - 1;
            this.swap(n);
            Vector vector2 = this.h.keys();
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    public Object put(int n, Object object) {
        this.swap(n);
        return this.h.put(n, object);
    }

    public Object remove(int n) {
        this.swap(n);
        return this.h.remove(n);
    }

    private void saveLoad(int n) {
        Closeable closeable;
        Closeable closeable2;
        Object object;
        String string = System.getProperty("user.dir");
        string = string + System.getProperty("file.separator");
        String string2 = string + this.prefix + this.current;
        if (this.h.size() > 0) {
            try {
                object = new FileOutputStream(string2);
                closeable2 = new BufferedOutputStream((OutputStream)object);
                closeable = new ObjectOutputStream((OutputStream)closeable2);
                closeable.writeObject(this.h);
                closeable.flush();
                closeable.close();
                ((FileOutputStream)object).close();
            }
            catch (Exception exception) {
                System.out.println("exception: " + exception);
            }
        }
        this.h = null;
        string2 = string + this.prefix + n;
        object = new File(string2);
        if (!((File)object).exists()) {
            this.h = new UIntHashtable(this.maximum, 1.0f);
        } else {
            try {
                closeable2 = new FileInputStream(string2);
                closeable = new BufferedInputStream((InputStream)closeable2);
                ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)closeable);
                this.h = (UIntHashtable)objectInputStream.readObject();
                objectInputStream.close();
                ((FileInputStream)closeable2).close();
            }
            catch (Exception exception) {
                System.out.println("exception: " + exception);
            }
        }
        this.current = n;
        if (n > this.maxHashNum) {
            this.maxHashNum = n;
        }
    }

    private void swap(int n) {
        long l = this.current * this.maximum;
        long l2 = (this.current - 1) * this.maximum + 1;
        if ((long)n <= l && (long)n >= l2) {
            return;
        }
        this.saveLoad((n - 1) / this.maximum + 1);
    }

    public String toString() {
        return this.h.toString();
    }
}

