/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.Construct;
import com.ibm.xmi.mod.ModelAPI;
import com.ibm.xmi.mod.ModelException;
import com.ibm.xmi.mod.ModelLink;
import com.ibm.xmi.mod.ModelProperty;
import com.ibm.xmi.mod.ModelType;
import com.ibm.xmi.utility.UUID;
import java.util.EventListener;
import java.util.Vector;
import java.util.zip.ZipOutputStream;

public abstract class Id {
    private Construct c;
    private int refCount;
    private boolean deleted;
    private boolean loaded;
    private ModelAPI api;

    Id(Construct construct, ModelAPI modelAPI) {
        this.c = construct;
        this.api = modelAPI;
        this.deleted = false;
        this.loaded = true;
    }

    public void add(ModelLink modelLink, Id id) throws ModelException {
        this.api.add(this, modelLink, id);
    }

    public Id add(ModelType modelType) throws ModelException {
        return this.api.add(this, modelType, null);
    }

    public Id add(ModelType modelType, boolean bl) throws ModelException {
        return this.api.add(this, modelType, null, bl);
    }

    public void addListener(EventListener eventListener) throws ModelException {
        this.api.addListener(this, eventListener);
    }

    public void check(boolean bl) throws ModelException {
        this.api.check(this, bl);
    }

    public static String createUUID() {
        return UUID.uuid();
    }

    public Vector delete() throws ModelException {
        return this.api.delete(this);
    }

    public void delete(ModelLink modelLink, Id id) throws ModelException {
        this.api.delete(this, modelLink, id);
    }

    public Vector get(ModelLink modelLink, boolean bl) throws ModelException {
        return this.api.get(this, modelLink, bl);
    }

    public String get(ModelProperty modelProperty) throws ModelException {
        return this.api.get(this, modelProperty);
    }

    public Vector get(ModelType modelType, Vector vector, boolean bl) throws ModelException {
        return this.api.get(this, modelType, vector, bl);
    }

    public Vector get(ModelType modelType, boolean bl) throws ModelException {
        return this.api.get(this, modelType, bl);
    }

    public String get(String string) throws ModelException {
        return this.api.get(this, string);
    }

    public String get(String string, String string2) throws ModelException {
        return this.api.get(this, string, string2);
    }

    public Construct getConstruct() {
        return this.c;
    }

    public abstract String getHref();

    int getInt() {
        return -1;
    }

    public abstract String getLabel();

    public Vector getLinks() throws ModelException {
        return this.api.getLinks(this);
    }

    public Vector getProperties() throws ModelException {
        return this.api.getProperties(this);
    }

    int getRefCount() {
        return this.refCount;
    }

    public Vector getSets() throws ModelException {
        return this.api.getSets(this);
    }

    public Vector getTags(String string) throws ModelException {
        return this.api.getTags(this, string);
    }

    public ModelType getType() {
        return this.c.getType();
    }

    public abstract String getUUID();

    public abstract String getUUIDREF();

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    abstract void remove();

    public void removeListener(EventListener eventListener) throws ModelException {
        this.api.removeListener(this, eventListener);
    }

    public abstract String retrieveUUID();

    public void save(String string, int n) throws Exception {
        Vector<Id> vector = new Vector<Id>(1);
        vector.addElement(this);
        this.api.save(vector, string, n, new Vector());
    }

    public void save(String string, int n, Vector vector) throws Exception {
        Vector<Id> vector2 = new Vector<Id>(1);
        vector2.addElement(this);
        this.api.save(vector2, string, n, vector);
    }

    public void save(ZipOutputStream zipOutputStream, int n, Vector vector) throws Exception {
        Vector<Id> vector2 = new Vector<Id>(1);
        vector2.addElement(this);
        this.api.save(vector2, zipOutputStream, n, vector);
    }

    public void set(ModelProperty modelProperty, String string) throws ModelException {
        this.api.set(this, modelProperty, string);
    }

    public void set(String string, String string2) throws ModelException {
        this.api.set(this, string, string2);
    }

    public void set(String string, String string2, String string3) throws ModelException {
        this.api.set(this, string, string2, string3);
    }

    public void setDeleted(boolean bl) {
        this.deleted = bl;
    }

    public abstract void setHref(String var1);

    public abstract void setLabel(String var1);

    public void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    void setRefCount(int n) {
        this.refCount = n;
    }

    public abstract void setUUID(String var1) throws ModelException;

    public abstract void setUUIDREF(String var1);

    public String toString() {
        String string = this.getLabel();
        if (string != null) {
            return string;
        }
        string = this.retrieveUUID();
        if (string != null) {
            return string;
        }
        return super.toString();
    }
}

