/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.DuplicateException;
import com.ibm.xmi.mod.Id;
import com.ibm.xmi.mod.ModelAPI;
import com.ibm.xmi.mod.ModelException;
import com.ibm.xmi.mod.ModelLink;
import com.ibm.xmi.mod.NoLinkException;
import com.ibm.xmi.mod.Relationships;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class FastRelationships
extends Relationships {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Hashtable links = new Hashtable(11, 1.0f);

    FastRelationships(ModelAPI modelAPI) {
        super(modelAPI);
    }

    public void add(Id id, ModelLink modelLink, Id id2) throws ModelException {
        this.addToLinks(id, modelLink, id2);
        super.add(id, modelLink, id2);
    }

    private void addToLinks(Id id, ModelLink modelLink, Id id2) throws DuplicateException {
        Vector<Id> vector;
        Hashtable hashtable = (Hashtable)this.links.get(modelLink);
        if (hashtable == null) {
            hashtable = new Hashtable(101, 1.0f);
            this.links.put(modelLink, hashtable);
        }
        if ((vector = (Vector<Id>)hashtable.get(id)) == null) {
            vector = new Vector<Id>();
            hashtable.put(id, vector);
        }
        if (vector.contains(id2)) {
            throw new DuplicateException();
        }
        vector.addElement(id2);
    }

    public void clear() {
        this.links.clear();
    }

    protected Vector get(Id id, ModelLink modelLink) {
        Hashtable hashtable = (Hashtable)this.links.get(modelLink);
        if (hashtable == null) {
            return null;
        }
        return this.removeDeletedIds((Vector)hashtable.get(id));
    }

    protected Vector getAllLinks() {
        Vector vector = new Vector();
        Enumeration enumeration = this.links.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public Vector getIds() {
        Vector<Id> vector = new Vector<Id>();
        if (this.links == null) {
            return vector;
        }
        Enumeration enumeration = this.links.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                Id id = (Id)enumeration2.nextElement();
                if (vector.contains(id) || id.isDeleted()) continue;
                vector.addElement(id);
            }
        }
        return vector;
    }

    public Vector getSources() {
        Vector<Id> vector = new Vector<Id>();
        if (this.links == null) {
            return vector;
        }
        Enumeration enumeration = this.links.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                Id id = (Id)enumeration2.nextElement();
                if (vector.contains(id) || id.isDeleted()) continue;
                vector.addElement(id);
            }
        }
        return vector;
    }

    protected boolean hasSource(ModelLink modelLink, Id id) {
        Hashtable hashtable = (Hashtable)this.links.get(modelLink);
        if (hashtable == null) {
            return false;
        }
        return hashtable.containsKey(id);
    }

    public Vector remove(Id id) {
        Vector<Id> vector = null;
        Enumeration enumeration = this.links.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Vector vector2 = (Vector)hashtable.get(id);
            if (vector2 == null) continue;
            for (int i = 0; i < vector2.size(); ++i) {
                Id id2 = (Id)vector2.elementAt(i);
                if (id2.isDeleted()) continue;
                id2.setRefCount(id2.getRefCount() - 1);
                if (id2.getRefCount() != 0) continue;
                if (vector == null) {
                    vector = new Vector<Id>();
                }
                vector.addElement(id2);
            }
            hashtable.remove(id);
        }
        return vector;
    }

    public void remove(Id id, ModelLink modelLink, Id id2) throws ModelException {
        this.removeFromLinks(id, modelLink, id2);
        super.remove(id, modelLink, id2);
    }

    private void removeFromLinks(Id id, ModelLink modelLink, Id id2) throws ModelException {
        Hashtable hashtable = (Hashtable)this.links.get(modelLink);
        if (hashtable == null) {
            throw new NoLinkException(id, modelLink, id2);
        }
        Vector vector = (Vector)hashtable.get(id);
        if (vector == null) {
            throw new NoLinkException(id, modelLink, id2);
        }
        if (!vector.contains(id2)) {
            throw new NoLinkException(id, modelLink, id2);
        }
        vector.removeElement(id2);
        if (vector.size() == 0) {
            hashtable.remove(id);
        }
        if (hashtable.isEmpty()) {
            this.links.remove(modelLink);
        }
    }
}

