/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.Id;
import com.ibm.xmi.mod.ModelAPI;
import com.ibm.xmi.mod.ModelException;
import com.ibm.xmi.mod.ModelProperty;
import com.ibm.xmi.mod.NoPropertyException;
import com.ibm.xmi.mod.NoTagException;
import com.ibm.xmi.mod.Properties;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class FastProperties
extends Properties {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Hashtable props = new Hashtable(101, 1.0f);
    private Hashtable tags = new Hashtable(101, 1.0f);

    FastProperties(ModelAPI modelAPI) {
        super(modelAPI);
    }

    public void clear() {
        this.props.clear();
        this.tags.clear();
    }

    public Vector getProperties(Id id) {
        Hashtable hashtable = (Hashtable)this.props.get(id);
        if (hashtable == null) {
            return null;
        }
        Vector vector = new Vector();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public String getProperty(Id id, ModelProperty modelProperty) {
        Hashtable hashtable = (Hashtable)this.props.get(id);
        if (hashtable == null) {
            return null;
        }
        return (String)hashtable.get(modelProperty);
    }

    public Vector getSets(Id id) {
        Vector<String> vector = new Vector<String>();
        Hashtable hashtable = (Hashtable)this.tags.get(id);
        if (hashtable == null) {
            return null;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n = ((java.util.Properties)hashtable.get(string)).size();
            if (n == 0) continue;
            vector.addElement(string);
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public String getTag(Id id, String string, String string2) {
        Hashtable hashtable;
        if (string == null) {
            string = "";
        }
        if ((hashtable = (Hashtable)this.tags.get(id)) == null) {
            return null;
        }
        java.util.Properties properties = (java.util.Properties)hashtable.get(string);
        if (properties == null) {
            return null;
        }
        return properties.getProperty(string2);
    }

    public Vector getTags(Id id, String string) {
        Hashtable hashtable;
        if (string == null) {
            string = "";
        }
        if ((hashtable = (Hashtable)this.tags.get(id)) == null) {
            return null;
        }
        java.util.Properties properties = (java.util.Properties)hashtable.get(string);
        if (properties == null) {
            return null;
        }
        Vector vector = new Vector();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public void remove(Id id) {
        this.props.remove(id);
        this.tags.remove(id);
    }

    protected void removeProperty(Id id, ModelProperty modelProperty) throws ModelException {
        Hashtable hashtable = (Hashtable)this.props.get(id);
        if (hashtable == null) {
            throw new NoPropertyException(modelProperty);
        }
        if (!hashtable.containsKey(modelProperty)) {
            throw new NoPropertyException(modelProperty);
        }
        hashtable.remove(modelProperty);
    }

    protected void removeTag(Id id, String string, String string2) throws ModelException {
        Hashtable hashtable;
        if (string == null) {
            string = "";
        }
        if ((hashtable = (Hashtable)this.tags.get(id)) == null) {
            throw new NoTagException();
        }
        java.util.Properties properties = (java.util.Properties)hashtable.get(string);
        if (properties == null || properties.getProperty(string2) == null) {
            throw new NoTagException();
        }
        properties.remove(string2);
    }

    protected void updateProperty(Id id, ModelProperty modelProperty, String string) {
        Hashtable<ModelProperty, String> hashtable = (Hashtable<ModelProperty, String>)this.props.get(id);
        if (hashtable == null) {
            hashtable = new Hashtable<ModelProperty, String>(10, 1.0f);
            this.props.put(id, hashtable);
        }
        hashtable.put(modelProperty, string);
    }

    protected void updateTag(Id id, String string, String string2, String string3) {
        java.util.Properties properties;
        Hashtable<String, java.util.Properties> hashtable = (Hashtable<String, java.util.Properties>)this.tags.get(id);
        if (hashtable == null) {
            hashtable = new Hashtable<String, java.util.Properties>(3, 1.0f);
            this.tags.put(id, hashtable);
        }
        if ((properties = (java.util.Properties)hashtable.get(string)) == null) {
            properties = new java.util.Properties();
            hashtable.put(string, properties);
        }
        properties.put(string2, string3);
    }
}

