/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.Construct;
import com.ibm.xmi.mod.DuplicateException;
import com.ibm.xmi.mod.Id;
import com.ibm.xmi.mod.Ids;
import com.ibm.xmi.mod.ModelAPI;
import com.ibm.xmi.mod.ModelException;
import java.util.Hashtable;
import java.util.Vector;

public class FastIds
extends Ids {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Hashtable hLabelToId;
    private Hashtable hUUIDToId;

    FastIds(ModelAPI modelAPI) {
        super(modelAPI);
    }

    Id add(Construct construct) {
        return new FastId(construct);
    }

    private void addToHashtable(Hashtable hashtable, String string, Id id) {
        if (string == null) {
            return;
        }
        Vector<Id> vector = (Vector<Id>)hashtable.get(string);
        if (vector != null) {
            vector.addElement(id);
        } else {
            vector = new Vector<Id>(10);
            vector.addElement(id);
            hashtable.put(string, vector);
        }
    }

    void clear() {
        if (this.hLabelToId != null) {
            this.hLabelToId.clear();
        }
        if (this.hUUIDToId != null) {
            this.hUUIDToId.clear();
        }
    }

    public Id getId(String string) {
        if (string == null) {
            return null;
        }
        if (this.hUUIDToId == null) {
            return null;
        }
        return (Id)this.hUUIDToId.get(string);
    }

    public Vector getIdsFromLabel(String string) {
        if (string == null) {
            return null;
        }
        if (this.hLabelToId == null) {
            return null;
        }
        return (Vector)this.hLabelToId.get(string);
    }

    void remove(Id id) {
        this.removeFromHashtable(this.hLabelToId, id.getLabel(), id);
        if (id.retrieveUUID() != null) {
            this.hUUIDToId.remove(id.retrieveUUID());
        }
    }

    private void removeFromHashtable(Hashtable hashtable, String string, Id id) {
        if (hashtable == null || string == null) {
            return;
        }
        Vector vector = (Vector)hashtable.get(string);
        if (vector != null && vector.size() == 0) {
            hashtable.remove(string);
        }
    }

    void setLabel(Id id, String string, String string2) {
        this.removeFromHashtable(this.hLabelToId, string2, id);
        if (this.hLabelToId == null) {
            this.hLabelToId = new Hashtable();
        }
        this.addToHashtable(this.hLabelToId, string, id);
    }

    void setUUID(Id id, String string, String string2) {
        if (this.hUUIDToId != null && string2 != null) {
            this.hUUIDToId.remove(string2);
        }
        if (this.hUUIDToId == null) {
            this.hUUIDToId = new Hashtable();
        }
        this.hUUIDToId.put(string, id);
    }

    private class FastId
    extends Id {
        private String label;
        private String uuid;
        private String href;
        private String uuidRef;

        FastId(Construct construct) {
            super(construct, FastIds.this.api);
        }

        public String getHref() {
            return this.href;
        }

        public String getLabel() {
            return this.label;
        }

        public String getUUID() {
            if (this.uuid == null) {
                this.uuid = FastId.createUUID();
                FastIds.this.setUUID(this, this.uuid, null);
            }
            return this.uuid;
        }

        public String getUUIDREF() {
            return this.uuidRef;
        }

        void remove() {
            this.setDeleted(true);
            FastIds.this.remove(this);
        }

        public String retrieveUUID() {
            return this.uuid;
        }

        public void setHref(String string) {
            this.href = string;
        }

        public void setLabel(String string) {
            FastIds.this.setLabel(this, string, this.label);
            this.label = string;
        }

        public void setUUID(String string) throws ModelException {
            if (this.uuid != null && this.uuid.equals(string)) {
                return;
            }
            if (FastIds.this.hUUIDToId != null && FastIds.this.hUUIDToId.get(string) != null) {
                throw new DuplicateException();
            }
            FastIds.this.setUUID(this, string, this.uuid);
            this.uuid = string;
        }

        public void setUUIDREF(String string) {
            this.uuidRef = string;
        }
    }
}

