/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.Id;
import com.ibm.xmi.mod.InternalErrorException;
import com.ibm.xmi.mod.MetamodelManager;
import com.ibm.xmi.mod.ModelAPI;
import com.ibm.xmi.mod.ModelException;
import com.ibm.xmi.mod.ModelLink;
import com.ibm.xmi.mod.ModelProperty;
import com.ibm.xmi.mod.ModelType;
import com.ibm.xmi.mod.NoContainLinkException;
import com.ibm.xmi.mod.Session;
import java.util.Enumeration;
import java.util.Vector;

public class Construct {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private ModelType type;
    protected ModelAPI api;

    public Construct(ModelAPI modelAPI, ModelType modelType) {
        this.type = modelType;
        this.api = modelAPI;
    }

    public Id add(Id id, ModelType modelType, String string, boolean bl) throws ModelException {
        Construct construct = this.api.getConstructs().makeConstruct(this.api, modelType);
        if (construct == null) {
            if (this.api.getLog()) {
                System.out.println("Internal error: can't make type " + modelType);
            }
            throw new InternalErrorException();
        }
        Id id2 = this.api.getIds().add(construct);
        if (id == this.api.getSession()) {
            ((Session)this.api.getSession().getConstruct()).add(id2);
        } else {
            ModelType modelType2;
            MetamodelManager metamodelManager = this.api.getMetamodelManager();
            ModelLink modelLink = metamodelManager.getContainedLink(modelType, modelType2 = id.getConstruct().getType());
            if (modelLink == null) {
                throw new NoContainLinkException(id);
            }
            try {
                ModelLink modelLink2 = metamodelManager.getContainerLink(modelType, modelType2);
                this.api.getRelationships().add(id, modelLink, id2);
                if (modelLink2 != null && bl) {
                    this.api.getRelationships().add(id2, modelLink2, id);
                }
            }
            catch (ModelException modelException) {
                if (this.api.getLog()) {
                    System.out.println("Internal error: containment and container roles are messed up.");
                }
                throw new InternalErrorException();
            }
        }
        if (string != null && modelType == ModelType.IXT_EXTENSION) {
            this.api.getProperties().setProperty(id2, ModelProperty.IXT_EXTENSION_NAME, string);
        }
        return id2;
    }

    private void addExtensionObjects(Id id, Vector vector) {
        Vector vector2 = null;
        try {
            vector2 = this.api.getRelationships().get(id, ModelLink.IXT_DATA, false);
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        if (vector2 == null) {
            return;
        }
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Id id2 = (Id)enumeration.nextElement();
            String string = this.api.getProperties().getProperty(id2, ModelProperty.IXT_EXTENSION_DELETE);
            if (string == null || !string.equals("true")) continue;
            vector.addElement(id2);
        }
    }

    public boolean checkCriteria(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) instanceof ModelProperty) {
                if (i + 1 == vector.size()) {
                    return false;
                }
                if (!(vector.elementAt(i + 1) instanceof String)) {
                    return false;
                }
                ++i;
                continue;
            }
            if (vector.elementAt(i) instanceof ModelLink) {
                if (i + 1 == vector.size()) {
                    return false;
                }
                if (!(vector.elementAt(i + 1) instanceof Id)) {
                    return false;
                }
                ++i;
                continue;
            }
            if (vector.elementAt(i) instanceof String) {
                if (i + 2 >= vector.size()) {
                    return false;
                }
                if (!(vector.elementAt(i + 1) instanceof String)) {
                    return false;
                }
                if (!(vector.elementAt(i + 2) instanceof String)) {
                    return false;
                }
                i += 2;
                continue;
            }
            return false;
        }
        return true;
    }

    public Vector delete(Id id) throws ModelException {
        Vector<Id> vector = this.getDeletedIds(id);
        if (vector == null) {
            vector = new Vector<Id>();
        }
        this.addExtensionObjects(id, vector);
        vector.insertElementAt(id, 0);
        Enumeration enumeration = vector.elements();
        Vector vector2 = new Vector();
        while (enumeration.hasMoreElements()) {
            id = (Id)enumeration.nextElement();
            ((Session)this.api.getSession().getConstruct()).remove(id);
            Vector vector3 = this.api.getRelationships().remove(id);
            if (vector3 != null) {
                for (int i = 0; i < vector3.size(); ++i) {
                    vector2.addElement(vector3.elementAt(i));
                }
            }
            this.api.getIds().remove(id);
            this.api.getProperties().remove(id);
            id.setDeleted(true);
        }
        for (int i = 0; i < vector2.size(); ++i) {
            Vector vector4;
            Id id2 = (Id)vector2.elementAt(i);
            if (id2.isDeleted() || (vector4 = this.delete(id2)) == null) continue;
            for (int j = 0; j < vector4.size(); ++j) {
                if (vector.contains(vector4.elementAt(j))) continue;
                vector.addElement((Id)vector4.elementAt(j));
            }
        }
        return vector;
    }

    protected Vector filter(Vector vector, ModelType modelType) {
        if (vector == null) {
            return null;
        }
        Vector<Id> vector2 = new Vector<Id>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Id id = (Id)enumeration.nextElement();
            if (modelType != ModelType.IXT_ALL && modelType != id.getConstruct().getType()) continue;
            vector2.addElement(id);
        }
        return vector2;
    }

    public Vector filterCriteria(Vector vector, Vector vector2) {
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Vector vector5 = new Vector();
        for (int i = 0; i < vector2.size(); ++i) {
            if (vector2.elementAt(i) instanceof ModelProperty) {
                vector4.addElement(vector2.elementAt(i));
                vector4.addElement(vector2.elementAt(i + 1));
                ++i;
                continue;
            }
            if (vector2.elementAt(i) instanceof ModelLink) {
                vector3.addElement(vector2.elementAt(i));
                vector3.addElement(vector2.elementAt(i + 1));
                ++i;
                continue;
            }
            vector5.addElement(vector2.elementAt(i));
            vector5.addElement(vector2.elementAt(i + 1));
            vector5.addElement(vector2.elementAt(i + 2));
            i += 2;
        }
        Vector vector6 = this.api.getRelationships().filterLinks(vector, vector3);
        vector6 = this.api.getProperties().filterProperties(vector6, vector4);
        vector6 = this.api.getProperties().filterSets(vector6, vector5);
        if (vector6 != null && vector6.size() == 0) {
            return null;
        }
        return vector6;
    }

    private Vector getDeletedIds(Id id) throws ModelException {
        Vector vector = null;
        if (!id.isLoaded()) {
            return null;
        }
        vector = id.getConstruct().getType(id, ModelType.IXT_ALL, false);
        Vector vector2 = new Vector();
        if (vector != null) {
            int n;
            for (n = 0; n < vector.size(); ++n) {
                Vector vector3;
                Id id2 = (Id)vector.elementAt(n);
                if (!id2.isLoaded() || (vector3 = id2.getConstruct().getDeletedIds(id2)) == null) continue;
                for (int i = 0; i < vector3.size(); ++i) {
                    vector2.addElement(vector3.elementAt(i));
                }
            }
            for (n = 0; n < vector2.size(); ++n) {
                vector.addElement(vector2.elementAt(n));
            }
        }
        return vector;
    }

    public ModelType getType() {
        return this.type;
    }

    public Vector getType(Id id, ModelType modelType, boolean bl) throws ModelException {
        Object object;
        Object object2;
        Object object3;
        Vector vector = null;
        Vector vector2 = null;
        ModelType modelType2 = id.getConstruct().getType();
        Vector vector3 = this.api.getMetamodelManager().getAllContainedLink(modelType2);
        if (vector3 == null) {
            vector3 = new Vector();
        }
        Enumeration enumeration = vector3.elements();
        while (enumeration.hasMoreElements()) {
            object3 = (ModelLink)enumeration.nextElement();
            object2 = this.api.getRelationships().get(id, (ModelLink)object3);
            if (object2 == null) continue;
            object = ((Vector)object2).elements();
            while (object.hasMoreElements()) {
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement(object.nextElement());
            }
        }
        vector = this.removeDeleted(vector);
        vector2 = this.filter(vector, modelType);
        if (vector != null && bl) {
            object3 = vector.elements();
            while (object3.hasMoreElements()) {
                object2 = (Id)object3.nextElement();
                if (!((Id)object2).isLoaded() && this.api.getDemandLoad()) {
                    this.api.demandLoad((Id)object2);
                }
                if ((object = ((Id)object2).getConstruct().getType((Id)object2, modelType, bl)) == null) continue;
                Enumeration enumeration2 = ((Vector)object).elements();
                while (enumeration2.hasMoreElements()) {
                    vector2.addElement(enumeration2.nextElement());
                }
            }
        }
        return this.removeDeleted(vector2);
    }

    protected Vector removeDeleted(Vector vector) {
        if (vector == null) {
            return null;
        }
        Vector<Id> vector2 = new Vector<Id>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Id id = (Id)enumeration.nextElement();
            if (id.isDeleted()) continue;
            vector2.addElement(id);
        }
        if (vector2.size() == 0) {
            return null;
        }
        return vector2;
    }
}

