/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.BadDefinitionException;
import com.ibm.xmi.framework.BasicProperty;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.DataImpl;
import com.ibm.xmi.framework.EnumProperty;
import com.ibm.xmi.framework.Extension;
import com.ibm.xmi.framework.FactoryRegister;
import com.ibm.xmi.framework.Link;
import com.ibm.xmi.framework.MultipleLinkException;
import com.ibm.xmi.framework.NoExtensionException;
import com.ibm.xmi.framework.NoLinkException;
import com.ibm.xmi.framework.NoPropertyException;
import com.ibm.xmi.framework.ObjectProperty;
import com.ibm.xmi.framework.Property;
import com.ibm.xmi.framework.XMIClass;
import com.ibm.xmi.framework.XMIException;
import com.ibm.xmi.framework.XMIObject;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class XMIObjectImpl
extends DataImpl
implements XMIObject {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private String id;
    private String uuid;
    private String label;
    private String href;
    private boolean isProxy = false;
    private Vector properties;
    private Vector links;
    private Vector extensions;
    private Hashtable sets;

    public XMIObjectImpl() {
    }

    public XMIObjectImpl(Data data) {
        super(data);
    }

    public XMIObjectImpl(String string) {
        super(string);
    }

    public XMIObjectImpl(String string, Iterator iterator) {
        this(string);
        this.properties = new Vector(20);
        while (iterator.hasNext()) {
            this.properties.addElement(iterator.next());
        }
    }

    public XMIObjectImpl(String string, Iterator iterator, Iterator iterator2) {
        this(string, iterator);
        this.links = new Vector(20);
        while (iterator2.hasNext()) {
            this.links.addElement(iterator2.next());
        }
    }

    public void add(Extension extension) {
        if (this.extensions == null) {
            this.extensions = new Vector(5);
        }
        this.extensions.addElement(extension);
    }

    public void add(Link link) {
        if (this.links == null) {
            this.links = new Vector(5);
        }
        this.links.addElement(link);
        link.setXMIOwner(this);
    }

    public void add(Property property) {
        if (this.properties == null) {
            this.properties = new Vector(5);
        }
        this.properties.addElement(property);
        property.setXMIOwner(this);
    }

    public void delete(Extension extension) throws XMIException {
        if (this.extensions == null) {
            throw new NoExtensionException(extension);
        }
        boolean bl = this.extensions.removeElement(extension);
        if (!bl) {
            throw new NoExtensionException(extension);
        }
    }

    public void delete(Link link) throws XMIException {
        if (this.links == null) {
            throw new NoLinkException(link);
        }
        boolean bl = this.links.removeElement(link);
        if (!bl) {
            throw new NoLinkException(link);
        }
    }

    public void delete(Property property) throws XMIException {
        if (this.properties == null) {
            throw new NoPropertyException(property);
        }
        boolean bl = this.properties.removeElement(property);
        if (!bl) {
            throw new NoPropertyException(property);
        }
    }

    public void delete(String string, XMIObject xMIObject) {
        Property property = this.getXMIProperty(string);
        if (property != null && property instanceof ObjectProperty && ((ObjectProperty)property).getXMIValue() == xMIObject) {
            try {
                this.delete(property);
            }
            catch (XMIException xMIException) {
                // empty catch block
            }
            return;
        }
        Iterator iterator = this.getLinks(string).iterator();
        while (iterator.hasNext()) {
            Link link = (Link)iterator.next();
            if (link.getXMIObject() != xMIObject) continue;
            try {
                this.delete(link);
            }
            catch (XMIException xMIException) {
                // empty catch block
            }
            return;
        }
    }

    public void demandLoad() {
        String string = this.getXMIHref();
        if (string == null) {
            return;
        }
        int n = string.indexOf("|");
        if (n == -1) {
            n = string.indexOf("#");
        }
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        try {
            if (this.getXMIFile() != null && this.getXMIFile().getXMIFiles() != null && this.getXMIFile().getXMIFiles().isDemandLoad()) {
                this.getXMIFile().getXMIFiles().load(string, 1, false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Collection getContained() {
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        Vector<XMIObject> vector = new Vector<XMIObject>();
        if (this.links != null) {
            for (int i = 0; i < this.links.size(); ++i) {
                if (((Link)this.links.elementAt(i)).getXMIType() != 4) continue;
                vector.addElement(((Link)this.links.elementAt(i)).getXMIObject());
            }
        }
        return vector;
    }

    public XMIObject getLinkedObject(String string) throws XMIException {
        Collection collection;
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        if ((collection = this.getLinks(string)).size() > 1) {
            throw new MultipleLinkException(string);
        }
        if (collection.size() == 0) {
            return null;
        }
        return ((Link)collection.iterator().next()).getXMIObject();
    }

    public Collection getLinkedObjects(String string) {
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        Iterator iterator = this.getLinks(string).iterator();
        Vector<XMIObject> vector = new Vector<XMIObject>();
        while (iterator.hasNext()) {
            XMIObject xMIObject = ((Link)iterator.next()).getXMIObject();
            if (xMIObject == null) continue;
            vector.addElement(xMIObject);
        }
        return vector;
    }

    public Collection getLinks(String string) {
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        Vector<Link> vector = new Vector<Link>();
        if (this.links == null) {
            return vector;
        }
        for (int i = 0; i < this.links.size(); ++i) {
            Link link = (Link)this.links.elementAt(i);
            if (link.getXMIName() == null || !link.getXMIName().equals(string) && !this.ignoreNamespaceEquals(link.getXMIName(), string)) continue;
            vector.addElement(link);
        }
        return vector;
    }

    public XMIObject getObjectPropertyValue(String string) {
        Property property;
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        if ((property = this.getXMIProperty(string)) == null || !(property instanceof ObjectProperty)) {
            return null;
        }
        return ((ObjectProperty)property).getXMIValue();
    }

    public Collection getXMIExtensions() {
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        if (this.extensions == null) {
            return new Vector(1);
        }
        return Collections.unmodifiableCollection(this.extensions);
    }

    public String getXMIHref() {
        return this.href;
    }

    public String getXMIId() {
        return this.id;
    }

    public String getXMILabel() {
        return this.label;
    }

    public Collection getXMILinks() {
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        if (this.links == null) {
            return new Vector(1);
        }
        return Collections.unmodifiableCollection(this.links);
    }

    public Collection getXMIProperties() {
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        if (this.properties == null) {
            return new Vector(1);
        }
        return Collections.unmodifiableCollection(this.properties);
    }

    public Property getXMIProperty(String string) {
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        if (this.properties == null) {
            return null;
        }
        for (int i = 0; i < this.properties.size(); ++i) {
            Property property = (Property)this.properties.elementAt(i);
            if (property.getXMIName() == null || !property.getXMIName().equals(string) && !this.ignoreNamespaceEquals(property.getXMIName(), string)) continue;
            return property;
        }
        return null;
    }

    public Collection getXMISets() {
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        Vector vector = new Vector();
        if (this.sets == null) {
            return vector;
        }
        Enumeration enumeration = this.sets.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public Collection getXMITags(String string) {
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        Vector vector = new Vector();
        if (this.sets == null) {
            return vector;
        }
        Properties properties = (Properties)this.sets.get(string);
        if (properties == null) {
            return vector;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public String getXMITagValue(String string, String string2) {
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        if (this.sets == null) {
            return null;
        }
        Properties properties = (Properties)this.sets.get(string);
        if (properties == null) {
            return null;
        }
        return properties.getProperty(string2);
    }

    public String getXMIUUID() {
        return this.uuid;
    }

    public String getXMIValue(String string) {
        Property property;
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        if ((property = this.getXMIProperty(string)) == null || property instanceof ObjectProperty) {
            return null;
        }
        return ((BasicProperty)property).getXMIValue();
    }

    private boolean ignoreNamespaceEquals(String string, String string2) {
        int n = string.indexOf(":");
        String string3 = string;
        if (n != -1) {
            string3 = string.substring(n + 1);
        }
        return string3.equals(string2);
    }

    public boolean isXMIProxy() {
        return this.isProxy;
    }

    public Property setBasicPropertyValue(String string, String string2) {
        Property property = this.getXMIProperty(string);
        if (property != null && !(property instanceof BasicProperty)) {
            return null;
        }
        if (property == null) {
            property = FactoryRegister.getFactory().makeBasicProperty((Object)this, string, string2);
        } else {
            ((BasicProperty)property).setXMIValue(string2);
        }
        return property;
    }

    public Property setEnumPropertyValue(String string, String string2) {
        Property property = this.getXMIProperty(string);
        if (property != null && !(property instanceof EnumProperty)) {
            return null;
        }
        if (property == null) {
            property = FactoryRegister.getFactory().makeEnumProperty((Object)this, string, string2);
        } else {
            ((EnumProperty)property).setXMIValue(string2);
        }
        return property;
    }

    public Property setPropertyValue(String string, XMIObject xMIObject) {
        Property property = this.getXMIProperty(string);
        if (property != null && !(property instanceof ObjectProperty)) {
            return null;
        }
        if (property == null) {
            property = FactoryRegister.getFactory().makeObjectProperty((Object)this, string, (Object)xMIObject);
        } else {
            ((ObjectProperty)property).setXMIValue(xMIObject);
        }
        return property;
    }

    public void setXMIDefiner(Data data) throws XMIException {
        if (data != null && !(data instanceof XMIClass)) {
            throw new BadDefinitionException(data);
        }
        super.setXMIDefiner(data);
    }

    public void setXMIHref(String string) {
        this.href = string;
    }

    public void setXMIId(String string) {
        this.id = string;
    }

    public void setXMILabel(String string) {
        this.label = string;
    }

    public void setXMIProxy(boolean bl) {
        this.isProxy = bl;
    }

    public void setXMITagValue(String string, String string2, String string3) {
        Properties properties;
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        if (this.sets == null) {
            this.sets = new Hashtable(4);
        }
        if ((properties = (Properties)this.sets.get(string)) == null) {
            properties = new Properties();
            this.sets.put(string, properties);
        }
        if (string3 == null) {
            properties.remove(string2);
            if (properties.isEmpty()) {
                this.sets.remove(string);
            }
        } else {
            properties.put(string2, string3);
        }
    }

    public void setXMIUUID(String string) {
        this.uuid = string;
    }

    public String toString() {
        String string = "XMIObject " + this.getXMIName();
        if (this.getXMILabel() != null) {
            string = string + " " + this.getXMILabel();
        } else if (this.getXMIId() != null) {
            string = string + " " + this.getXMIId();
        } else if (this.getXMIUUID() != null) {
            string = string + " " + this.getXMIUUID();
        } else if (this.getXMIOwner() != null) {
            string = string + " owner: [" + this.getXMIOwner() + "]";
        }
        return string;
    }
}

