/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.AdapterFactoryRegister;
import com.ibm.xmi.framework.BasicProperty;
import com.ibm.xmi.framework.Codegen4Assolinks;
import com.ibm.xmi.framework.ContainerLink;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.DeclarationFactory;
import com.ibm.xmi.framework.Enum;
import com.ibm.xmi.framework.EnumProperty;
import com.ibm.xmi.framework.Link;
import com.ibm.xmi.framework.ObjectProperty;
import com.ibm.xmi.framework.Package;
import com.ibm.xmi.framework.Property;
import com.ibm.xmi.framework.RefLink;
import com.ibm.xmi.framework.WriterWrapper;
import com.ibm.xmi.framework.XMIClass;
import com.ibm.xmi.framework.XMIFile;
import com.ibm.xmi.framework.XMIFiles;
import com.ibm.xmi.framework.XMIObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class UML2MOF {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    FileOutputStream fs;
    FileOutputStream reportfos;
    OutputStreamWriter os;
    OutputStreamWriter reportosw;
    boolean genMOF;
    boolean isRef;
    String modelName;
    String directory;
    String topPackage;
    String currentPackage;
    String report;
    Vector duplicateFeatureNames = new Vector();
    Hashtable defsToNames = new Hashtable();
    Hashtable defsToChangedNames = new Hashtable();
    Hashtable duplicateNamesToClasses = new Hashtable();
    private Vector classes;
    private WriterWrapper wrapper = new WriterWrapper(AdapterFactoryRegister.getAdapterFactory().createWriterAdapter());

    private String abbreviation(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isUpperCase(string.charAt(i)) || string2.length() >= 2) continue;
            string2 = string2 + string.charAt(i);
        }
        if (string2.length() == 2) {
            return string2;
        }
        string2 = string.length() < 2 ? string.toUpperCase() : string.substring(0, 2).toUpperCase();
        return string2;
    }

    private void addToDuplicates(String string, XMIClass xMIClass) {
        Vector vector = this.wrapper.getAllSuperclasses(xMIClass);
        vector.addElement(xMIClass);
        Vector vector2 = new Vector(1);
        if (this.duplicateNamesToClasses.get(string) == null) {
            this.duplicateNamesToClasses.put(string, vector2);
        } else {
            vector2 = (Vector)this.duplicateNamesToClasses.get(string);
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (vector2.contains(vector.elementAt(i))) continue;
            vector2.addElement(vector.elementAt(i));
        }
    }

    private String capName(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    private boolean changeName(Data data) {
        String string = this.shortName(data);
        XMIClass xMIClass = null;
        if (data instanceof Link) {
            xMIClass = (XMIClass)((Link)data).getXMIOwner();
        } else if (data instanceof Property) {
            xMIClass = (XMIClass)((Property)data).getXMIOwner();
        }
        if (this.duplicateNamesToClasses.get(string) == null) {
            return true;
        }
        Vector vector = (Vector)this.duplicateNamesToClasses.get(string);
        return vector.contains(xMIClass);
    }

    private void computeClassNames(Vector vector) {
        Vector vector2 = (Vector)this.classes.clone();
        this.getPackages(vector, vector2);
        int n = 0;
        do {
            Vector<String> vector3 = new Vector<String>();
            Vector<String> vector4 = new Vector<String>();
            for (int i = 0; i < vector2.size(); ++i) {
                String string = this.getName((Data)vector2.elementAt(i), n);
                if (this.containsIgnoreCase(vector3, string) && !vector4.contains(string)) {
                    vector4.addElement(string);
                    continue;
                }
                vector3.addElement(string);
            }
            Vector vector5 = new Vector();
            for (int i = 0; i < vector2.size(); ++i) {
                String string = this.getName((Data)vector2.elementAt(i), n);
                if (!this.containsIgnoreCase(vector4, string)) {
                    this.defsToNames.put(vector2.elementAt(i), string.replace('.', '_'));
                    continue;
                }
                vector5.addElement(vector2.elementAt(i));
            }
            vector2 = vector5;
            ++n;
        } while (vector2.size() > 0);
    }

    private void computeFeatureConflicts() {
        for (int i = 0; i < this.classes.size(); ++i) {
            String string;
            int n;
            XMIClass xMIClass = (XMIClass)this.classes.elementAt(i);
            Vector vector = new Vector();
            Iterator iterator = this.wrapper.getAllProperties(xMIClass);
            while (iterator.hasNext()) {
                vector.addElement(iterator.next());
            }
            Vector vector2 = new Vector();
            iterator = this.wrapper.getAllLinks(xMIClass);
            while (iterator.hasNext()) {
                vector2.addElement(iterator.next());
            }
            Vector<String> vector3 = new Vector<String>();
            for (n = 0; n < vector.size(); ++n) {
                string = this.shortName((Data)vector.elementAt(n));
                if (vector3.contains(string)) {
                    this.addToDuplicates(string, xMIClass);
                }
                if (vector3.contains(string) && !this.duplicateFeatureNames.contains(string)) {
                    this.duplicateFeatureNames.addElement(string);
                    continue;
                }
                vector3.addElement(string);
            }
            for (n = 0; n < vector2.size(); ++n) {
                string = this.shortName((Data)vector2.elementAt(n));
                if (vector3.contains(string)) {
                    this.addToDuplicates(string, xMIClass);
                }
                if (vector3.contains(string) && !this.duplicateFeatureNames.contains(string)) {
                    this.duplicateFeatureNames.addElement(string);
                    continue;
                }
                vector3.addElement(string);
            }
        }
    }

    private boolean containsIgnoreCase(Vector vector, String string) {
        for (int i = 0; i < vector.size(); ++i) {
            if (!((String)vector.elementAt(i)).equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private String duplicateName(Data data) {
        if (!this.changeName(data)) {
            return this.shortName(data);
        }
        String string = data.getXMIName();
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return string;
        }
        int n2 = string.lastIndexOf(".", n - 1);
        String string2 = string.substring(n2 + 1, n);
        string2 = this.abbreviation(string2);
        string2 = string2 + this.capName(this.shortName(data));
        if (this.report != null && this.defsToChangedNames.get(data) == null) {
            this.reportOut(string + " renamed to " + string2);
            this.defsToChangedNames.put(data, data);
        }
        return string2;
    }

    private void endFile() {
        try {
            this.os.close();
            this.fs.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void getClasses(Package package_) {
        Vector vector = new Vector();
        Iterator iterator = package_.getXMIContents().iterator();
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) instanceof XMIClass) {
                this.classes.addElement(vector.elementAt(i));
                continue;
            }
            if (!(vector.elementAt(i) instanceof Package)) continue;
            this.getClasses((Package)vector.elementAt(i));
        }
    }

    private void getClasses(Vector vector) {
        this.classes = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) instanceof XMIClass) {
                this.classes.addElement(vector.elementAt(i));
                continue;
            }
            if (!(vector.elementAt(i) instanceof Package)) continue;
            this.getClasses((Package)vector.elementAt(i));
        }
    }

    private String getFullName(Data data) {
        String string = data.getXMIName();
        int n = string.indexOf(".");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        while (data.getXMIOwner() != null) {
            data = data.getXMIOwner();
            string = data.getXMIName() + "." + string;
        }
        return string;
    }

    private String getJavaType(String string) {
        if (string.equalsIgnoreCase("int") || string.equalsIgnoreCase("integer")) {
            return "int";
        }
        if (string.equalsIgnoreCase("boolean")) {
            return "boolean";
        }
        if (string.equalsIgnoreCase("float")) {
            return "float";
        }
        return "java.lang.String";
    }

    private String getMultiplicity(Link link) {
        String string = new String("1");
        XMIObject xMIObject = (XMIObject)link.getXMISource();
        Property property = (Property)this.wrapper.getProperty(xMIObject, "Foundation.Core.AssociationEnd.multiplicity");
        if (property != null) {
            string = (String)property.getXMIGenericValue();
        }
        return string;
    }

    private String getName(Data data, int n) {
        String string = data.getXMIName();
        int n2 = string.lastIndexOf(".");
        for (int i = n; i > 0 && n2 > 0; --i) {
            n2 = string.lastIndexOf(".", n2 - 1);
        }
        if (n2 > 0) {
            return string.substring(n2 + 1);
        }
        return string;
    }

    private String getNameFromProperty(XMIObject xMIObject) {
        return (String)this.wrapper.getValue(this.wrapper.getProperty(xMIObject, "Foundation.Core.ModelElement.name"));
    }

    private void getPackages(Package package_, Vector vector) {
        if (!vector.contains(package_)) {
            vector.addElement(package_);
        }
        Vector vector2 = new Vector();
        Iterator iterator = package_.getXMIContents().iterator();
        while (iterator.hasNext()) {
            vector2.addElement(iterator.next());
        }
        for (int i = 0; i < vector2.size(); ++i) {
            if (!(vector2.elementAt(i) instanceof Package)) continue;
            this.getPackages((Package)vector2.elementAt(i), vector);
        }
    }

    private void getPackages(Vector vector, Vector vector2) {
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i) instanceof Package)) continue;
            this.getPackages((Package)vector.elementAt(i), vector2);
        }
    }

    private String getUMLAttributeType(Property property) {
        String string = "java.lang.String";
        if (property instanceof EnumProperty) {
            Enum enum_ = ((EnumProperty)property).getXMIEnum();
            if (enum_ != null && enum_.getXMIName() != null && enum_.getXMIName().equalsIgnoreCase("boolean")) {
                string = "boolean";
                return string;
            }
            return "int";
        }
        return string;
    }

    private boolean isJavaType(Property property) {
        String string = this.getJavaType(this.getUMLAttributeType(property));
        return string.equals("int") || string.equals("float") || string.equals("boolean");
    }

    private boolean isMany(String string) {
        return string.equals("0..n") || string.equals("1..n") || string.equals("n..n") || string.equals("n");
    }

    private String linkType(Link link) {
        if (link instanceof RefLink) {
            return "RefLink";
        }
        if (link instanceof ContainerLink) {
            return "ContainerLink";
        }
        return "ContainLink";
    }

    private String localAttribName(String string) {
        string = "_" + string;
        return string;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0 || stringArray[0].equals("?")) {
            System.out.println("Generate MOF classes from a UML model.  The arguments are:");
            System.out.println("-model Name of UML XMI file.");
            System.out.println("-dir Directory to put code");
            System.out.println("-package Top-level Java package for code");
            System.out.println("-genMOF If present, generates the MOF package (optional)");
            System.out.println("-isRef If present, model is reflective module");
            return;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        UML2MOF uML2MOF = new UML2MOF();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-model") && i + 1 < stringArray.length) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-dir") && i + 1 < stringArray.length) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-package") && i + 1 < stringArray.length) {
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-report") && i + 1 < stringArray.length) {
                string4 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-genMOF")) {
                uML2MOF.setGenMOF(true);
                bl = true;
                continue;
            }
            if (!stringArray[i].equals("isRef")) continue;
            uML2MOF.setIsRef(true);
        }
        if (string == null) {
            System.out.println("Must specify a model file with -model option.");
            return;
        }
        if (string2 == null) {
            string2 = System.getProperty("user.dir");
        }
        try {
            XMIFiles xMIFiles = new XMIFiles();
            XMIFile xMIFile = xMIFiles.load(string, 1, false);
            DeclarationFactory declarationFactory = new DeclarationFactory();
            Vector vector = new Vector();
            Iterator iterator = declarationFactory.makeDeclarations(xMIFile.getObjects().iterator()).iterator();
            while (iterator.hasNext()) {
                vector.addElement(iterator.next());
            }
            int n = string.indexOf(46);
            if (n > 0) {
                uML2MOF.setModelName(string.substring(0, n));
            } else {
                uML2MOF.setModelName(stringArray[0]);
            }
            uML2MOF.setReport(string4);
            uML2MOF.makeMOF(string2, string3, vector);
            if (!bl) {
                Codegen4Assolinks codegen4Assolinks = new Codegen4Assolinks(string2, string3, string3 + ".impl", "", "Impl");
                codegen4Assolinks.start(xMIFile.getObjects().iterator());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void makeDataTypes(String string, Vector vector) {
        if (vector.size() < 1) {
            return;
        }
        Data data = (Data)vector.firstElement();
        XMIObject xMIObject = (XMIObject)data.getXMISource();
        XMIObject xMIObject2 = (XMIObject)this.wrapper.getLinkedObject(xMIObject, "Foundation.Core.ModelElement.namespace");
        Vector vector2 = this.wrapper.getLinkedObjects(xMIObject2, "Foundation.Core.Namespace.ownedElement");
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3;
            Object object;
            Enumeration enumeration2;
            Enumeration enumeration3;
            Object object2;
            Object object3;
            Vector vector3;
            String string4;
            XMIObject xMIObject3 = (XMIObject)enumeration.nextElement();
            if (xMIObject3.getXMIName().equals("Foundation.Core.Interface")) {
                string4 = this.getNameFromProperty(xMIObject3);
                this.makeFileByName(string, string4, true, true);
                this.makeFileByName(string, string4, true, false);
                this.makeFileByName(string, string4, false, true);
                this.makeFileByName(string, string4, false, false);
                continue;
            }
            if (xMIObject3.getXMIName().equals("Foundation.Data_Types.Enumeration")) {
                string4 = this.getNameFromProperty(xMIObject3);
                this.makeEnumFileByName(string, string4, true, true);
                this.makeEnumFileByName(string, string4, true, false);
                this.makeEnumFileByName(string, string4, false, true);
                this.makeEnumFileByName(string, string4, false, false);
                vector3 = this.wrapper.getLinkedObjects(xMIObject3, "Foundation.Core.Classifier.feature");
                int n = 0;
                object3 = vector3.elements();
                while (object3.hasMoreElements()) {
                    object2 = (XMIObject)object3.nextElement();
                    enumeration3 = string4 + this.capName(this.getNameFromProperty((XMIObject)object2));
                    this.makeEnumValueFileByName(string, string4, (String)((Object)enumeration3), "", true, true);
                    this.makeEnumValueFileByName(string, string4, (String)((Object)enumeration3), "", true, false);
                    this.makeEnumValueFileByName(string, string4, (String)((Object)enumeration3), Integer.toString(n), false, true);
                    this.makeEnumValueFileByName(string, string4, (String)((Object)enumeration3), "", false, false);
                    ++n;
                }
                continue;
            }
            if (!xMIObject3.getXMIName().equals("Foundation.Data_Types.Structure")) continue;
            string4 = this.getNameFromProperty(xMIObject3);
            if (this.genMOF) {
                this.setFile(string4);
                this.out("package " + string + ";\n");
                this.out("import " + string + ".ref.*;");
            } else {
                this.setFile(string4 + "Gen");
                this.out("package " + string + ".gen;\n");
                this.out("import " + string + ".*;");
            }
            this.out("import java.util.*;\n");
            if (this.genMOF) {
                this.out("public interface " + string4 + " {");
            } else {
                this.out("public interface " + string4 + "Gen {");
            }
            vector3 = this.wrapper.getLinkedObjects(xMIObject3, "Foundation.Core.Classifier.feature");
            Vector<String> vector4 = new Vector<String>();
            object3 = new Vector();
            object2 = vector3.elements();
            while (object2.hasMoreElements()) {
                enumeration3 = (XMIObject)object2.nextElement();
                enumeration2 = this.getNameFromProperty((XMIObject)((Object)enumeration3));
                object = (XMIObject)this.wrapper.getLinkedObject(enumeration3, "Foundation.Core.StructuralFeature.type");
                string3 = this.getNameFromProperty((XMIObject)object);
                vector4.addElement((String)((Object)enumeration2));
                ((Vector)object3).addElement(string3);
                this.out("\t" + string3 + " " + (String)((Object)enumeration2) + "();");
            }
            if (this.genMOF) {
                this.out("} // " + string4);
            } else {
                this.out("} // " + string4 + "Gen");
            }
            this.endFile();
            this.makeFileByName(string, string4, true, false);
            if (this.genMOF) {
                this.setFile(string4 + "Impl");
                this.out("package " + string + ".impl;\n");
                this.out("\nimport " + string + ".*;");
                this.out("import " + string + "extn.*;\n");
                this.out("public class " + string4 + "Impl implements " + string4 + " {\n");
            } else {
                this.setFile(string4 + "GenImpl");
                this.out("package " + string + ".gen.impl;\n");
                this.out("\nimport " + string + ".gen.*;");
                this.out("import " + string + ".*;\n");
                this.out("public class " + string4 + "GenImpl implements " + string4 + "Gen {\n");
            }
            enumeration3 = vector4.elements();
            enumeration2 = ((Vector)object3).elements();
            while (enumeration3.hasMoreElements()) {
                object = (String)enumeration3.nextElement();
                string3 = (String)enumeration2.nextElement();
                this.out("\tprivate " + string3 + " " + this.localAttribName((String)object) + ";");
            }
            if (this.genMOF) {
                this.out("\n\tpublic " + string4 + "Impl() {");
            } else {
                this.out("\n\tpublic " + string4 + "GenImpl() {");
            }
            this.out("\t\tsuper();");
            this.out("\t}");
            object = new String();
            enumeration3 = vector4.elements();
            enumeration2 = ((Vector)object3).elements();
            while (enumeration3.hasMoreElements()) {
                string3 = (String)enumeration3.nextElement();
                string2 = (String)enumeration2.nextElement();
                if (((String)object).length() > 0) {
                    object = (String)object + ", ";
                }
                object = (String)object + string2 + " " + string3;
            }
            if (this.genMOF) {
                this.out("\n\tpublic " + string4 + "Impl(" + (String)object + ") {");
            } else {
                this.out("\n\tpublic " + string4 + "GenImpl(" + (String)object + ") {");
            }
            this.out("\t\tsuper();");
            this.out("\t}");
            enumeration3 = vector4.elements();
            enumeration2 = ((Vector)object3).elements();
            while (enumeration3.hasMoreElements()) {
                string3 = (String)enumeration3.nextElement();
                string2 = (String)enumeration2.nextElement();
                this.out("\n\tpublic " + string2 + " " + string3 + "() {");
                this.out("\t\treturn " + this.localAttribName(string3) + ";");
                this.out("\t}");
            }
            if (this.genMOF) {
                this.out("} // " + string4 + "Impl");
            } else {
                this.out("} // " + string4 + "GenImpl");
            }
            this.endFile();
            this.makeFileByName(string, string4, false, false);
        }
    }

    private void makeEnumFileByName(String string, String string2, boolean bl, boolean bl2) {
        if (bl) {
            if (bl2 && this.genMOF) {
                this.setFile(string2);
                this.out("package " + string + ";\n");
                this.out("public interface " + string2 + " {");
                this.out("\n\tint toInt();");
                this.out("} // " + string2);
            } else if (bl2) {
                this.setFile(string2 + "Gen");
                this.out("package " + string + ".gen;\n");
                this.out("public interface " + string2 + "Gen {");
                this.out("\n\tint toInt();");
                this.out("} // " + string2 + "Gen");
            } else if (this.genMOF) {
                this.setFile(string2 + "Extn");
                this.out("package " + string + ".extn;\n");
                this.out("\nimport " + string + ".*;");
                this.out("public interface " + string2 + "Extn extends " + string2 + " {");
                this.out("} // " + string2 + "Extn");
            } else {
                this.setFile(string2);
                this.out("package " + string + ";\n");
                this.out("\nimport " + string + ".gen.*;");
                this.out("public interface " + string2 + " extends " + string2 + "Gen {");
                this.out("} // " + string2);
            }
        } else if (bl2 && this.genMOF) {
            this.setFile(string2 + "Impl");
            this.out("package " + string + ".impl;\n");
            this.out("\nimport " + string + ".*;\n");
            this.out("public class " + string2 + "Impl implements " + string2 + " {");
            this.out("\n\tpublic int toInt() {");
            this.out("\t\treturn -1;");
            this.out("\t}");
            this.out("} // " + string2 + "Impl");
        } else if (bl2) {
            this.setFile(string2 + "GenImpl");
            this.out("package " + string + ".gen.impl;\n");
            this.out("\nimport " + string + ".gen.*;\n");
            this.out("public class " + string2 + "GenImpl implements " + string2 + "Gen {");
            this.out("\n\tpublic int toInt() {");
            this.out("\t\treturn -1;");
            this.out("\t}");
            this.out("} // " + string2 + "GenImpl");
        } else if (this.genMOF) {
            this.setFile(string2 + "ExtnImpl");
            this.out("package " + string + ".extn.impl;\n");
            this.out("\nimport " + string + ".extn.*;");
            this.out("import  " + string + ".impl.*;\n");
            this.out("public class " + string2 + "ExtnImpl extends " + string2 + "Impl implements " + string2 + "Extn {");
            this.out("} // " + string2 + "ExtnImpl");
        } else {
            this.setFile(string2 + "Impl");
            this.out("package " + string + ".impl;\n");
            this.out("\nimport " + string + ".*;");
            this.out("import  " + string + ".gen.impl.*;\n");
            this.out("public class " + string2 + "Impl extends " + string2 + "GenImpl implements " + string2 + " {");
            this.out("} // " + string2 + "Impl");
        }
        this.endFile();
    }

    private void makeEnumValueFileByName(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        if (bl) {
            if (bl2 && this.genMOF) {
                this.setFile(string3);
                this.out("package " + string + ";\n");
                this.out("public interface " + string3 + " extends " + string2 + " {");
                this.out("} // " + string3);
            } else if (bl2) {
                this.setFile(string3 + "Gen");
                this.out("package " + string + ".gen;\n");
                this.out("public interface " + string3 + "Gen extends " + string2 + "Gen {");
                this.out("} // " + string3 + "Gen");
            } else if (this.genMOF) {
                this.setFile(string3 + "Extn");
                this.out("package " + string + ".extn;\n");
                this.out("\nimport " + string + ".*;");
                this.out("public interface " + string3 + "Extn extends " + string3 + " {");
                this.out("} // " + string3 + "Extn");
            } else {
                this.setFile(string3);
                this.out("package " + string + ";\n");
                this.out("\nimport " + string + ".gen.*;");
                this.out("public interface " + string3 + " extends " + string3 + "Gen {");
                this.out("} // " + string3);
            }
        } else if (bl2 && this.genMOF) {
            this.setFile(string3 + "Impl");
            this.out("package " + string + ".impl;\n");
            this.out("\nimport " + string + ".*;\n");
            this.out("public class " + string3 + "Impl implements " + string3 + " {");
            this.out("\n\tpublic int toInt() {");
            this.out("\t\treturn " + string4 + ";");
            this.out("\t}");
            this.out("} // " + string3 + "Impl");
        } else if (bl2) {
            this.setFile(string3 + "GenImpl");
            this.out("package " + string + ".gen.impl;\n");
            this.out("\nimport " + string + ".gen.*;\n");
            this.out("public class " + string3 + "GenImpl implements " + string3 + "Gen {");
            this.out("\n\tpublic int toInt() {");
            this.out("\t\treturn " + string4 + ";");
            this.out("\t}");
            this.out("} // " + string3 + "GenImpl");
        } else if (this.genMOF) {
            this.setFile(string3 + "ExtnImpl");
            this.out("package " + string + ".extn.impl;\n");
            this.out("\nimport " + string + ".extn.*;");
            this.out("import  " + string + ".impl.*;\n");
            this.out("public class " + string3 + "ExtnImpl extends " + string3 + "Impl implements " + string3 + "Extn {");
            this.out("} // " + string3 + "ExtnImpl");
        } else {
            this.setFile(string3 + "Impl");
            this.out("package " + string + ".impl;\n");
            this.out("\nimport " + string + ".*;");
            this.out("import  " + string + ".gen.impl.*;\n");
            this.out("public class " + string3 + "Impl extends " + string3 + "GenImpl implements " + string3 + " {");
            this.out("} // " + string3 + "Impl");
        }
        this.endFile();
    }

    private void makeExtnImplementation(XMIClass xMIClass) {
        String string;
        this.setFile(xMIClass.getXMIName() + "ExtnImpl");
        String string2 = null;
        string2 = this.topPackage != null ? this.topPackage + "." + xMIClass.getXMIName() : xMIClass.getXMIName();
        int n = string2.lastIndexOf(".");
        if (n > 0) {
            string2 = string2.substring(0, n) + ".extn.impl";
            this.out("package " + string2 + ";\n");
            this.currentPackage = string2;
        } else {
            this.currentPackage = "";
        }
        n = this.currentPackage.lastIndexOf(".extn.impl");
        if (n > 0) {
            string = this.currentPackage.substring(0, n);
            this.out("import " + string + ".extn.*;");
            this.out("import " + string + ".impl.*;\n");
        }
        string = this.shortName(xMIClass);
        this.out("public class " + string + "ExtnImpl extends " + string + "Impl implements " + string + "Extn {");
        this.out("\n\tpublic " + string + "ExtnImpl() {");
        this.out("\t\tsuper();");
        this.out("\t}\n");
        this.out("// Begin User Defined Methods\n\n");
        this.out("// End User Defined Methods");
        this.out("} // " + xMIClass.getXMIName() + "ExtnImpl");
        this.endFile();
    }

    private void makeExtnInterface(XMIClass xMIClass) {
        this.setFile(xMIClass.getXMIName() + "Extn");
        String string = null;
        string = this.topPackage != null ? this.topPackage + "." + xMIClass.getXMIName() : xMIClass.getXMIName();
        int n = string.lastIndexOf(".");
        if (n > 0) {
            string = string.substring(0, n);
            this.out("package " + string + ".extn;\n");
            this.currentPackage = string;
        } else {
            this.currentPackage = "";
        }
        this.out("import " + this.currentPackage + ".*;");
        String string2 = this.shortName(xMIClass);
        this.out("public interface " + string2 + "Extn extends " + string2 + " {");
        this.out("} // " + xMIClass.getXMIName() + "Extn");
        this.endFile();
    }

    private void makeFactory(Vector vector) {
        this.setFile("Factory");
        if (this.topPackage != null) {
            this.out("package " + this.topPackage + ";\n");
        }
        this.out("import java.util.Collection;\n");
        this.out("public interface Factory {");
        this.out("");
        this.makeFactoryMethod(vector, true);
        this.out("");
        this.out("} // Factory");
        this.endFile();
    }

    private void makeFactoryImpl(Vector vector) {
        this.setFile("FactoryImpl");
        if (this.topPackage != null) {
            this.out("package " + this.topPackage + ".impl;\n");
            this.out("import " + this.topPackage + ".*;");
        }
        this.out("import java.util.*;\n");
        this.out("public class FactoryImpl implements Factory {");
        this.out("");
        this.makeFactoryMethod(vector, false);
        this.out("");
        this.out("} // FactoryImpl");
        this.endFile();
    }

    private void makeFactoryMethod(Vector vector, boolean bl) {
        String string;
        Object object;
        Enumeration enumeration;
        if (bl) {
            this.out("\tjava.lang.Object create(java.lang.Class type);");
        } else {
            this.out("\tpublic java.lang.Object create(java.lang.Class type) {");
            enumeration = this.classes.elements();
            int n = 1;
            while (enumeration.hasMoreElements()) {
                object = (Data)enumeration.nextElement();
                if (object instanceof XMIClass) {
                    string = object.getXMIName();
                    String string2 = "";
                    string2 = new String(string);
                    if (n == 1) {
                        this.out("\t\tif (type == " + this.topPackage + "." + string2 + ".class)");
                    } else {
                        this.out("\t\telse if (type == " + this.topPackage + "." + string2 + ".class)");
                    }
                    if (this.genMOF) {
                        this.out("\t\t\treturn new " + string2 + "ExtnImpl();");
                    } else {
                        this.out("\t\t\treturn new " + string2 + "Impl();");
                    }
                }
                ++n;
            }
            this.out("\t\treturn null;");
            this.out("\t}\n");
        }
        if (bl) {
            this.out("\tCollection createCollection();");
        } else {
            this.out("\tpublic Collection createCollection() {");
            this.out("\t\treturn new Vector();");
            this.out("\t}\n");
        }
        enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            Data data = (Data)enumeration.nextElement();
            if (!(data instanceof XMIClass)) continue;
            object = data.getXMIName();
            string = "";
            string = new String((String)object);
            if (bl) {
                this.out("\t" + this.shortOrFullName(string) + " create" + string + "();");
                continue;
            }
            this.out("\tpublic " + this.shortOrFullName(string) + " create" + string + "() {");
            if (this.genMOF) {
                this.out("\t\treturn new " + string + "ExtnImpl();");
            } else {
                this.out("\t\treturn new " + string + "Impl();");
            }
            this.out("\t}\n");
        }
    }

    private void makeFactoryRegister() {
        this.setFile("FactoryRegister");
        if (this.topPackage != null) {
            this.out("package " + this.topPackage + ";\n");
        }
        this.out("import java.util.*;\n");
        this.out("public class FactoryRegister {");
        this.out("\tprivate static Factory _factory;");
        this.out("\tprivate FactoryRegister() {");
        this.out("\t}\n");
        this.out("\tpublic static Factory getFactory() {");
        this.out("\t\treturn _factory;");
        this.out("\t}\n");
        this.out("\tpublic static void registerFactory(Factory f) {");
        this.out("\t}\n");
        this.out("} // FactoryRegister");
        this.endFile();
    }

    private void makeFileByName(String string, String string2, boolean bl, boolean bl2) {
        if (bl) {
            if (bl2 && this.genMOF) {
                this.setFile(string2);
                this.out("package " + string + ";\n");
                this.out("public interface " + string2 + " {");
                this.out("} // " + string2);
            } else if (bl2) {
                this.setFile(string2 + "Gen");
                this.out("package " + string + ".gen;\n");
                this.out("public interface " + string2 + "Gen {");
                this.out("} // " + string2 + "Gen");
            } else if (this.genMOF) {
                this.setFile(string2 + "Extn");
                this.out("package " + string + ".extn;\n");
                this.out("\nimport " + string + ".*;");
                this.out("public interface " + string2 + "Extn extends " + string2 + " {");
                this.out("} // " + string2 + "Extn");
            } else {
                this.setFile(string2);
                this.out("package " + string + ";\n");
                this.out("\nimport " + string + ".gen.*;");
                this.out("public interface " + string2 + " extends " + string2 + "Gen {");
                this.out("} // " + string2);
            }
        } else if (bl2 && this.genMOF) {
            this.setFile(string2 + "Impl");
            this.out("package " + string + ".impl;\n");
            this.out("\nimport " + string + ".*;\n");
            this.out("public class " + string2 + "Impl implements " + string2 + " {");
            this.out("\n\tpublic " + string2 + "Impl() {");
            this.out("\t\tsuper();");
            this.out("\t}\n");
            this.out("} // " + string2 + "Impl");
        } else if (bl2) {
            this.setFile(string2 + "GenImpl");
            this.out("package " + string + ".gen.impl;\n");
            this.out("\nimport " + string + ".gen.*;\n");
            this.out("public class " + string2 + "GenImpl implements " + string2 + "Gen {");
            this.out("\n\tpublic " + string2 + "GenImpl() {");
            this.out("\t\tsuper();");
            this.out("\t}\n");
            this.out("} // " + string2 + "GenImpl");
        } else if (this.genMOF) {
            this.setFile(string2 + "ExtnImpl");
            this.out("package " + string + ".extn.impl;\n");
            this.out("\nimport " + string + "extn..*;");
            this.out("import  " + string + ".impl.*;\n");
            this.out("public class " + string2 + "ExtnImpl extends " + string2 + "Impl implements " + string2 + "Extn {");
            this.out("\n\tpublic " + string2 + "ExtnImpl() {");
            this.out("\t\tsuper();");
            this.out("\t}\n");
            this.out("} // " + string2 + "ExtnImpl");
        } else {
            this.setFile(string2 + "Impl");
            this.out("package " + string + ".impl;\n");
            this.out("\nimport " + string + ".*;");
            this.out("import  " + string + ".gen.impl.*;\n");
            this.out("public class " + string2 + "Impl extends " + string2 + "GenImpl implements " + string2 + " {");
            this.out("\n\tpublic " + string2 + "Impl() {");
            this.out("\t\tsuper();");
            this.out("\t}\n");
            this.out("} // " + string2 + "Impl");
        }
        this.endFile();
    }

    private String makeFileName(String string) {
        String string2 = this.topPackage != null ? this.topPackage + "." + string : string;
        String string3 = string2.replace('.', File.separatorChar);
        return this.directory + File.separatorChar + string3 + ".java";
    }

    private void makeImplementation(XMIClass xMIClass) {
        Object object;
        this.setFile(xMIClass.getXMIName() + "Impl");
        this.processDecl(xMIClass, true);
        this.processConstructors(xMIClass);
        this.processProperties(xMIClass, true);
        this.processLinks(xMIClass, true);
        Vector vector = new Vector();
        Iterator iterator = xMIClass.getXMISuperclasses().iterator();
        String string = new String();
        Vector<Object> vector2 = new Vector<Object>();
        while (iterator.hasNext()) {
            object = (Data)iterator.next();
            if (string.length() == 0) {
                string = this.shortOrFullName((Data)object);
                continue;
            }
            vector2.addElement(object);
        }
        object = vector2.elements();
        while (object.hasMoreElements()) {
            XMIClass xMIClass2 = (XMIClass)object.nextElement();
            Vector vector3 = this.wrapper.getAllSuperclasses(xMIClass2);
            Enumeration enumeration = vector3.elements();
            while (enumeration.hasMoreElements()) {
                XMIClass xMIClass3 = (XMIClass)enumeration.nextElement();
                this.processOperations(xMIClass3, true);
            }
            this.processOperations(xMIClass2, true);
        }
        this.processOperations(xMIClass, true);
        this.processEnd(xMIClass, true);
        this.endFile();
    }

    private void makeInterface(XMIClass xMIClass) {
        this.setFile(xMIClass.getXMIName());
        this.processDecl(xMIClass, false);
        this.processProperties(xMIClass, false);
        this.processLinks(xMIClass, false);
        this.processOperations(xMIClass, false);
        this.processEnd(xMIClass, false);
        this.endFile();
    }

    public void makeMOF(String string, String string2, Vector vector) {
        if (vector == null) {
            return;
        }
        if (this.report != null) {
            try {
                this.reportfos = new FileOutputStream(this.report);
                this.reportosw = new OutputStreamWriter(this.reportfos);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.directory = string;
        this.topPackage = string2;
        this.getClasses(vector);
        this.computeFeatureConflicts();
        this.computeClassNames(vector);
        this.makePackages(string2, vector);
        this.makeFactoryRegister();
        if (this.genMOF) {
            this.makeMOFFactory(vector);
            this.makeMOFFactoryImpl(vector);
        } else {
            this.makeFactory(vector);
            this.makeFactoryImpl(vector);
        }
        if (this.report != null) {
            try {
                this.reportosw.close();
                this.reportfos.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void makeMOFFactory(Vector vector) {
        this.setFile("Factory");
        if (this.topPackage != null) {
            this.out("package " + this.topPackage + ";\n");
            this.out("import " + this.topPackage + ".extn.*;");
        }
        this.out("public interface Factory {");
        this.out("");
        this.makeFactoryMethod(vector, true);
        this.out("");
        this.out("} // Factory");
        this.endFile();
        this.setFile("FactoryExtn");
        if (this.topPackage != null) {
            this.out("package " + this.topPackage + ".extn;\n");
            this.out("import " + this.topPackage + ".*;");
        }
        this.out("public interface FactoryExtn extends Factory {");
        this.out("");
        this.out("} // FactoryExtn");
        this.endFile();
    }

    private void makeMOFFactoryImpl(Vector vector) {
        this.setFile("FactoryImpl");
        if (this.topPackage != null) {
            this.out("package " + this.topPackage + ".impl;\n");
            this.out("import " + this.topPackage + ".extn.*;");
            this.out("import " + this.topPackage + ".*;");
            this.out("import " + this.topPackage + ".extn.impl.*;");
        }
        this.out("public class FactoryImpl implements Factory {");
        this.out("");
        this.makeFactoryMethod(vector, false);
        this.out("");
        this.out("} // FactoryImpl");
        this.endFile();
        this.setFile("FactoryExtnImpl");
        if (this.topPackage != null) {
            this.out("package " + this.topPackage + ".extn.impl;\n");
            this.out("import " + this.topPackage + ".extn.*;");
            this.out("import " + this.topPackage + ".impl.*;\n");
        }
        this.out("public class FactoryExtnImpl extends FactoryImpl implements FactoryExtn {");
        this.out("");
        this.out("} // FactoryExtnImpl");
        this.endFile();
    }

    private void makeMOFImplementation(XMIClass xMIClass) {
        Object object;
        this.setFile(xMIClass.getXMIName() + "Impl");
        this.processDecl(xMIClass, true);
        this.processConstructors(xMIClass);
        this.processProperties(xMIClass, true);
        this.processLinks(xMIClass, true);
        Vector vector = new Vector();
        Iterator iterator = xMIClass.getXMISuperclasses().iterator();
        String string = new String();
        Vector<Object> vector2 = new Vector<Object>();
        while (iterator.hasNext()) {
            object = (Data)iterator.next();
            if (string.length() == 0) {
                string = this.shortOrFullName((Data)object);
                continue;
            }
            vector2.addElement(object);
        }
        object = vector2.elements();
        while (object.hasMoreElements()) {
            XMIClass xMIClass2 = (XMIClass)object.nextElement();
            Vector vector3 = this.wrapper.getAllSuperclasses(xMIClass2);
            Enumeration enumeration = vector3.elements();
            while (enumeration.hasMoreElements()) {
                XMIClass xMIClass3 = (XMIClass)enumeration.nextElement();
                this.processOperations(xMIClass3, true);
            }
            this.processOperations(xMIClass2, true);
        }
        this.processOperations(xMIClass, true);
        this.processEnd(xMIClass, true);
        this.endFile();
    }

    private void makeMOFInterface(XMIClass xMIClass) {
        this.setFile(xMIClass.getXMIName());
        this.processDecl(xMIClass, false);
        this.processProperties(xMIClass, false);
        this.processLinks(xMIClass, false);
        this.processOperations(xMIClass, false);
        this.processEnd(xMIClass, false);
        this.endFile();
    }

    private void makePackages(String string, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Data data = (Data)enumeration.nextElement();
            if (data instanceof XMIClass) {
                if (this.genMOF) {
                    this.makeMOFInterface((XMIClass)data);
                    this.makeExtnInterface((XMIClass)data);
                    this.makeMOFImplementation((XMIClass)data);
                    this.makeExtnImplementation((XMIClass)data);
                    continue;
                }
                this.makeInterface((XMIClass)data);
                this.makeImplementation((XMIClass)data);
                continue;
            }
            if (!(data instanceof Package)) continue;
            Iterator iterator = ((Package)data).getXMIContents().iterator();
            Vector vector2 = new Vector();
            while (iterator.hasNext()) {
                vector2.addElement(iterator.next());
            }
            this.makePackages(string, vector2);
        }
        this.makeDataTypes(string, vector);
    }

    private void out(String string) {
        try {
            this.os.write(string, 0, string.length());
            this.os.write(10);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String packageName(String string) {
        int n = string.lastIndexOf(".");
        if (n > 0) {
            return string.substring(0, n);
        }
        return "";
    }

    private void processBasicProperty(Property property, boolean bl) {
        this.processGetSet(property, this.getJavaType(this.getUMLAttributeType(property)), true, bl);
    }

    private void processConstructors(XMIClass xMIClass) {
        if (this.genMOF) {
            this.out("\tpublic " + this.shortName(xMIClass) + "Impl() {");
        } else {
            this.out("\tpublic " + this.shortName(xMIClass) + "Impl() {");
        }
        this.out("\t\tsuper();");
        this.out("\t}\n");
        String string = new String();
        Iterator iterator = this.wrapper.getAllProperties(xMIClass);
        if (iterator != null && iterator.hasNext()) {
            String string2;
            Property property;
            while (iterator.hasNext()) {
                property = (Property)iterator.next();
                string2 = this.shortName(property);
                if (string.length() > 0) {
                    string = string + ", ";
                }
                if (property instanceof ObjectProperty) {
                    String string3 = "";
                    string3 = ((ObjectProperty)property).getXMIValue().getXMIName();
                    string = string + this.shortOrFullName(string3);
                } else if (property instanceof EnumProperty || property instanceof BasicProperty) {
                    string = string + this.getJavaType(this.getUMLAttributeType(property));
                }
                if (string2.equals("implements") || string2.equals("package") || string2.equals("interface") || string2.equals("class") || string2.equals("extends") || string2.equals("import") || string2.equals("true") || string2.equals("false")) {
                    string = string + " _" + string2;
                    continue;
                }
                string = string + " " + string2;
            }
            if (this.genMOF) {
                this.out("\tpublic " + this.shortName(xMIClass) + "Impl(" + string + ") {");
            } else {
                this.out("\tpublic " + this.shortName(xMIClass) + "Impl(" + string + ") {");
            }
            this.out("\t\tthis();");
            iterator = this.wrapper.getAllProperties(xMIClass);
            while (iterator.hasNext()) {
                property = (Property)iterator.next();
                string2 = this.shortName(property);
                if (string2.equals("implements") || string2.equals("package") || string2.equals("interface") || string2.equals("class") || string2.equals("extends") || string2.equals("import") || string2.equals("true") || string2.equals("false")) {
                    string2 = "_" + string2;
                }
                this.out("\t\tset" + this.capName(this.shortName(property)) + "(" + string2 + ");");
            }
            this.out("\t}\n");
        }
    }

    private void processDecl(XMIClass xMIClass, boolean bl) {
        Vector vector;
        String string;
        String string2 = null;
        string2 = this.topPackage != null ? this.topPackage + "." + xMIClass.getXMIName() : xMIClass.getXMIName();
        int n = string2.lastIndexOf(".");
        if (n > 0) {
            string2 = string2.substring(0, n);
            if (bl) {
                string2 = string2 + ".impl";
            }
            this.out("package " + string2 + ";\n");
            this.currentPackage = string2;
        } else {
            this.currentPackage = "";
        }
        n = this.currentPackage.lastIndexOf(".impl");
        if (n < 0) {
            n = this.currentPackage.length();
        }
        if (n > 0) {
            string = this.currentPackage.substring(0, n);
            if (this.isRef) {
                this.out("import " + string + ".*;");
            } else if (bl) {
                this.out("import com.ibm.mof.mof13.ref.extn.impl.*;");
            } else {
                this.out("import com.ibm.mof.mof13.ref.extn.*;");
            }
            if (bl && this.genMOF) {
                this.out("import " + string + ".*;");
                this.out("import " + string + ".extn.impl.*;");
            }
            if (bl) {
                this.out("import " + string + ".*;");
            }
        }
        this.out("import java.util.*;\n");
        string = this.genMOF ? this.shortName(xMIClass) : this.shortName(xMIClass);
        if (bl) {
            string = string + "Impl";
        }
        Iterator iterator = xMIClass.getXMISuperclasses().iterator();
        String string3 = new String();
        String string4 = new String();
        Vector<Data> vector2 = new Vector<Data>();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                if (string3.length() > 0) {
                    string3 = string3 + ", ";
                }
                vector = (Data)iterator.next();
                string3 = string3 + this.shortOrFullName((Data)((Object)vector));
                if (string4.length() == 0) {
                    string4 = this.shortName((Data)((Object)vector)) + "Impl";
                    continue;
                }
                vector2.addElement((Data)((Object)vector));
            }
        } else {
            string3 = "";
            string4 = "";
        }
        if (bl) {
            if (string4 == "") {
                if (this.genMOF) {
                    this.out("public class " + string + " implements " + this.shortName(xMIClass) + " {");
                } else {
                    this.out("public class " + string + " extends RefObjectExtnImpl implements " + this.shortName(xMIClass) + " {");
                }
            } else if (this.genMOF) {
                this.out("public class " + string + " extends " + string4 + " implements " + this.shortName(xMIClass) + "Gen {");
            } else {
                this.out("public class " + string + " extends " + string4 + " implements " + this.shortOrFullName(xMIClass) + " {");
            }
        } else if (string3 == "") {
            if (this.genMOF || this.isRef) {
                this.out("public interface " + string + " {");
            } else {
                this.out("public interface " + string + " extends RefObjectExtn {");
            }
        } else {
            this.out("public interface " + string + " extends " + string3 + " {");
        }
        if (bl) {
            String string5;
            Object object;
            Enumeration enumeration;
            Iterator iterator2;
            Object object2;
            vector = new Vector();
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                object2 = (XMIObject)enumeration2.nextElement();
                iterator2 = this.wrapper.getAllProperties(object2);
                while (iterator2.hasNext()) {
                    vector.addElement(iterator2.next());
                }
            }
            object2 = xMIClass.getXMIProperties().iterator();
            while (object2.hasNext()) {
                vector.addElement(object2.next());
            }
            if (vector != null) {
                iterator2 = vector.elements();
                this.out("");
                while (iterator2.hasMoreElements()) {
                    Object object3;
                    enumeration = (Property)iterator2.nextElement();
                    object = new String();
                    boolean bl2 = true;
                    if (enumeration instanceof EnumProperty || enumeration instanceof BasicProperty) {
                        object = this.getJavaType(this.getUMLAttributeType((Property)((Object)enumeration)));
                    } else if (enumeration instanceof ObjectProperty) {
                        object = ((ObjectProperty)((Object)enumeration)).getXMIValue().getXMIName();
                        bl2 = false;
                    }
                    string5 = this.shortName((Data)((Object)enumeration));
                    if (this.duplicateFeatureNames.contains(string5)) {
                        string5 = this.duplicateName((Data)((Object)enumeration));
                    }
                    if (this.topPackage != null && !bl2) {
                        object = this.topPackage + "." + (String)object;
                    }
                    if (((String)(object3 = this.shortOrFullName((String)object))).equals("String") && !((String)object3).equals(object)) {
                        object3 = object;
                    }
                    this.out("\tprotected " + (String)object3 + " " + this.localAttribName(string5) + ";");
                }
                this.out("");
            }
            vector = new Vector();
            enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                iterator2 = (XMIObject)enumeration2.nextElement();
                enumeration = this.wrapper.getAllLinks(iterator2);
                while (enumeration.hasNext()) {
                    vector.addElement(enumeration.next());
                }
            }
            iterator2 = xMIClass.getXMILinks().iterator();
            while (iterator2.hasNext()) {
                vector.addElement(iterator2.next());
            }
            if (vector != null) {
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    object = (Link)enumeration.nextElement();
                    String string6 = this.shortName((Data)object);
                    string5 = object.getXMIObject().getXMIName();
                    if (this.duplicateFeatureNames.contains(string6)) {
                        string6 = this.duplicateName((Data)object);
                    }
                    if (this.isMany(this.getMultiplicity((Link)object))) {
                        this.out("\tprotected Collection " + this.localAttribName(string6) + " = FactoryRegister.getFactory().createCollection();");
                        continue;
                    }
                    this.out("\tprotected " + this.shortOrFullName(string5) + " " + this.localAttribName(string6) + ";");
                }
                this.out("");
            }
        }
    }

    private String processDirectory(String string) {
        String string2 = new String("");
        String string3 = new String("");
        int n = string.lastIndexOf("\\");
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        if (string.endsWith("Gen.java")) {
            string = string2 + "\\gen\\" + string3;
        } else if (string.endsWith("GenImpl.java")) {
            string = string2 + "\\gen\\impl\\" + string3;
        } else if (string.endsWith("Impl.java")) {
            string = string2 + "\\impl\\" + string3;
        } else if (string.endsWith("Extn.java")) {
            string = string2 + "\\extn\\" + string3;
        } else if (string.endsWith("ExtnImpl.java")) {
            string = string2 + "\\extn\\impl\\" + string3;
        }
        File file = new File(string);
        if (file.getParent() == null) {
            return string;
        }
        File file2 = new File(file.getParent());
        if (!file2.exists()) {
            file2.mkdirs();
        }
        return string;
    }

    private void processEnd(XMIClass xMIClass, boolean bl) {
        if (bl) {
            if (this.genMOF) {
                this.out("} // " + xMIClass.getXMIName() + "Impl");
            } else {
                this.out("} // " + xMIClass.getXMIName() + "Impl");
            }
        } else if (this.genMOF) {
            this.out("} // " + xMIClass.getXMIName());
        } else {
            this.out("} // " + xMIClass.getXMIName());
        }
    }

    private void processGetSet(Property property, String string, boolean bl, boolean bl2) {
        String string2;
        String string3 = this.shortName(property);
        if (string3.equals("isRoot")) {
            // empty if block
        }
        if (this.duplicateFeatureNames.contains(string3)) {
            string3 = this.duplicateName(property);
        }
        String string4 = this.capName(string3);
        String string5 = property.getXMIName();
        String string6 = "";
        if (!string.equals("java.lang.String")) {
            string6 = this.capName(string);
        }
        if (this.topPackage != null && !bl) {
            string = this.topPackage + "." + string;
        }
        if ((string2 = this.shortOrFullName(string)).equals("String") && !string2.equals(string)) {
            string2 = string;
        }
        if (!bl2) {
            if (string2.equals("boolean") || string2.equals("Boolean")) {
                this.out("\tpublic " + string2 + " " + string3 + "();");
            } else {
                this.out("\tpublic " + string2 + " get" + string4 + "();");
            }
            if (string3.equals("implements") || string3.equals("package") || string3.equals("interface") || string3.equals("class") || string3.equals("extends") || string3.equals("import") || string3.equals("true") || string3.equals("false")) {
                this.out("\tpublic void set" + string4 + "(" + string2 + " " + "_" + string3 + ");\n");
            } else {
                this.out("\tpublic void set" + string4 + "(" + string2 + " " + string3 + ");\n");
            }
            return;
        }
        if (string2.equals("boolean") || string2.equals("Boolean")) {
            this.out("\tpublic " + this.shortOrFullName(string) + " " + string3 + "() {");
        } else {
            this.out("\tpublic " + string2 + " get" + string4 + "() {");
        }
        this.out("\t\treturn " + this.localAttribName(string3) + ";");
        this.out("\t}\n");
        if (string3.equals("implements") || string3.equals("package") || string3.equals("interface") || string3.equals("class") || string3.equals("extends") || string3.equals("import") || string3.equals("true") || string3.equals("false")) {
            this.out("\tpublic void set" + string4 + "(" + string2 + " " + this.localAttribName(string3) + ") {");
            this.out("\t\tthis." + this.localAttribName(string3) + " = " + this.localAttribName(string3) + ";");
        } else {
            this.out("\tpublic void set" + string4 + "(" + string2 + " " + string3 + ") {");
            this.out("\t\t" + this.localAttribName(string3) + " = " + string3 + ";");
        }
        this.out("\t}\n");
    }

    private void processGetSet(String string, String string2, boolean bl, boolean bl2) {
        String string3 = this.capName(string);
        String string4 = "";
        if (!string2.equals("String")) {
            string4 = this.capName(string2);
        }
        if (this.topPackage != null && !bl) {
            string2 = this.topPackage + "." + string2;
        }
        String string5 = this.shortOrFullName(string2);
        if (!bl2) {
            if (string5.equals("boolean") || string5.equals("Boolean")) {
                this.out("\tpublic " + string5 + " " + string + "();");
            } else {
                this.out("\tpublic " + string5 + " get" + string3 + "();");
            }
            this.out("\tpublic void set" + string3 + "(" + this.shortOrFullName(string2) + " " + string + ");\n");
            return;
        }
        if (string5.equals("boolean") || string5.equals("Boolean")) {
            this.out("\tpublic " + this.shortOrFullName(string2) + " " + string + "() {");
        } else {
            this.out("\tpublic " + this.shortOrFullName(string2) + " get" + string3 + "() {");
        }
        this.out("\t\treturn " + this.localAttribName(string) + ";");
        this.out("\t}\n");
        this.out("\tpublic void set" + string3 + "(" + this.shortOrFullName(string2) + " " + string + ") {");
        this.out("\t\t" + this.localAttribName(string) + " = " + string + ";");
        this.out("\t}\n");
    }

    private void processLink(Link link, boolean bl) {
        String string = this.shortName(link);
        String string2 = this.getMultiplicity(link);
        if (this.duplicateFeatureNames.contains(string)) {
            string = this.duplicateName(link);
        }
        String string3 = this.capName(string);
        String string4 = link.getXMIObject().getXMIName();
        String string5 = link.getXMIName();
        if (this.topPackage != null) {
            string4 = this.topPackage + "." + string4;
        }
        if (!bl) {
            if (this.isMany(string2)) {
                this.out("\tpublic Collection get" + string3 + "();");
                this.out("\tpublic " + this.shortOrFullName(string4) + "[] list" + string3 + "();");
                this.out("\tpublic void set" + string3 + "(Collection value);");
                this.out("\tpublic void add" + string3 + "(" + this.shortOrFullName(string4) + " newValue);");
                this.out("\tpublic void modify" + string3 + "(" + this.shortOrFullName(string4) + " oldValue, " + this.shortOrFullName(string4) + " newValue);");
                this.out("\tpublic void remove" + string3 + "(" + this.shortOrFullName(string4) + " oldValue);\n");
            } else {
                this.out("\tpublic " + this.shortOrFullName(string4) + " get" + string3 + "();");
                if (string.equals("implements") || string.equals("package") || string.equals("interface") || string.equals("class") || string.equals("extends") || string.equals("import")) {
                    this.out("\tpublic void set" + string3 + "(" + this.shortOrFullName(string4) + " _" + string + ");\n");
                } else {
                    this.out("\tpublic void set" + string3 + "(" + this.shortOrFullName(string4) + " " + string + ");\n");
                }
            }
            return;
        }
        if (this.isMany(string2)) {
            this.out("\tpublic Collection get" + string3 + "() {");
            this.out("\t\treturn " + this.localAttribName(string) + ";");
            this.out("\t}\n");
            this.out("\tpublic " + this.shortOrFullName(string4) + "[] list" + string3 + "() {");
            this.out("\t\treturn (" + this.shortOrFullName(string4) + "[])" + this.localAttribName(string) + ".toArray();");
            this.out("\t}\n");
            this.out("\tpublic void set" + string3 + "(Collection value) {");
            this.out("\t\t" + this.localAttribName(string) + " = value;");
            this.out("\t}\n");
            this.out("\tpublic void add" + string3 + "(" + this.shortOrFullName(string4) + " newValue) {");
            this.out("\t\t" + this.localAttribName(string) + ".add((Object) newValue);");
            this.out("\t}\n");
            this.out("\tpublic void modify" + string3 + "(" + this.shortOrFullName(string4) + " oldValue, " + this.shortOrFullName(string4) + " newValue) {");
            this.out("\t\t" + this.localAttribName(string) + ".remove((Object) oldValue);");
            this.out("\t\t" + this.localAttribName(string) + ".add((Object) newValue);");
            this.out("\t}\n");
            this.out("\tpublic void remove" + string3 + "(" + this.shortOrFullName(string4) + " oldValue) {");
            this.out("\t\t" + this.localAttribName(string) + ".remove((Object) oldValue);");
            this.out("\t}\n");
        } else {
            this.out("\tpublic " + this.shortOrFullName(string4) + " get" + string3 + "() {");
            this.out("\t\treturn " + this.localAttribName(string) + ";");
            this.out("\t}\n");
            if (string.equals("implements") || string.equals("package") || string.equals("interface") || string.equals("class") || string.equals("extends") || string.equals("import")) {
                this.out("\tpublic void set" + string3 + "(" + this.shortOrFullName(string4) + " " + this.localAttribName(string) + ") {");
                this.out("\t\tthis." + this.localAttribName(string) + " = " + this.localAttribName(string) + ";");
            } else {
                this.out("\tpublic void set" + string3 + "(" + this.shortOrFullName(string4) + " " + string + ") {");
                this.out("\t\t" + this.localAttribName(string) + " = " + string + ";");
            }
            this.out("\t}\n");
        }
    }

    private void processLinks(XMIClass xMIClass, boolean bl) {
        Object object;
        Object object2;
        Vector vector = new Vector();
        if (bl) {
            Object object3;
            Object object4;
            object2 = xMIClass.getXMISuperclasses().iterator();
            object = new String();
            Vector<Object> vector2 = new Vector<Object>();
            while (object2.hasNext()) {
                object4 = (Data)object2.next();
                if (((String)object).length() == 0) {
                    object = this.shortOrFullName((Data)object4);
                    continue;
                }
                vector2.addElement(object4);
            }
            object4 = vector2.elements();
            while (object4.hasMoreElements()) {
                object3 = (XMIObject)object4.nextElement();
                Iterator iterator = this.wrapper.getAllLinks(object3);
                while (iterator.hasNext()) {
                    vector.addElement(iterator.next());
                }
            }
            object3 = xMIClass.getXMILinks().iterator();
            while (object3.hasNext()) {
                vector.addElement(object3.next());
            }
        } else {
            object2 = xMIClass.getXMILinks().iterator();
            while (object2.hasNext()) {
                vector.addElement(object2.next());
            }
        }
        if (vector != null) {
            object2 = vector.elements();
            while (object2.hasMoreElements()) {
                object = (Link)object2.nextElement();
                this.processLink((Link)object, bl);
            }
            this.out("");
        }
    }

    private void processObjectProperty(ObjectProperty objectProperty, boolean bl) {
        String string = objectProperty.getXMIValue().getXMIName();
        this.processGetSet(objectProperty, string, false, bl);
    }

    private void processOperations(XMIClass xMIClass, boolean bl) {
        XMIObject xMIObject = (XMIObject)xMIClass.getXMISource();
        Vector vector = this.wrapper.getContained(xMIObject);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            XMIObject xMIObject2 = (XMIObject)enumeration.nextElement();
            if (xMIObject2.getXMIName().equals("Foundation.Core.Operation") || xMIObject2.getXMIName().equals("Foundation.Core.Method")) {
                String string;
                Object object;
                Object object2;
                String string2 = this.getNameFromProperty(xMIObject2);
                String string3 = "void";
                Vector<String> vector2 = new Vector<String>();
                Vector vector3 = this.wrapper.getContained(xMIObject2);
                Enumeration enumeration2 = vector3.elements();
                while (enumeration2.hasMoreElements()) {
                    object2 = (XMIObject)enumeration2.nextElement();
                    if (!object2.getXMIName().equals("Foundation.Core.Parameter")) continue;
                    object = (XMIObject)this.wrapper.getLinkedObject(object2, "Foundation.Core.Parameter.type");
                    string = this.getNameFromProperty((XMIObject)object);
                    string = this.shortName(string);
                    Property property = (Property)this.wrapper.getProperty(object2, "Foundation.Core.Parameter.kind");
                    String string4 = "";
                    if (property != null) {
                        string4 = (String)property.getXMIGenericValue();
                    }
                    if (string4.equals("return")) {
                        string3 = string;
                        if (!string3.equals("return")) continue;
                        string3 = "void";
                        continue;
                    }
                    vector2.addElement(new String(string + " " + this.getNameFromProperty((XMIObject)object2)));
                }
                object2 = "";
                object = vector2.elements();
                while (object.hasMoreElements()) {
                    string = (String)object.nextElement();
                    if (((String)object2).length() > 0) {
                        object2 = (String)object2 + ", ";
                    }
                    object2 = (String)object2 + string;
                }
                if (!bl) {
                    this.out("\tpublic " + string3 + " " + string2 + "(" + (String)object2 + ");");
                } else {
                    this.out("\tpublic " + string3 + " " + string2 + "(" + (String)object2 + ") {");
                    if (string3.equals("boolean")) {
                        this.out("\t\treturn false;");
                    } else if (!string3.equals("void")) {
                        this.out("\t\treturn null;");
                    }
                    this.out("\t}");
                }
            }
            this.out("");
        }
    }

    private void processProperties(XMIClass xMIClass, boolean bl) {
        Object object;
        Object object2;
        Vector vector = new Vector();
        if (bl) {
            Object object3;
            Object object4;
            object2 = xMIClass.getXMISuperclasses().iterator();
            object = new String();
            Vector<Object> vector2 = new Vector<Object>();
            while (object2.hasNext()) {
                object4 = (Data)object2.next();
                if (((String)object).length() == 0) {
                    object = this.shortOrFullName((Data)object4);
                    continue;
                }
                vector2.addElement(object4);
            }
            object4 = vector2.elements();
            while (object4.hasMoreElements()) {
                object3 = (XMIObject)object4.nextElement();
                Iterator iterator = this.wrapper.getAllProperties(object3);
                while (iterator.hasNext()) {
                    vector.addElement(iterator.next());
                }
            }
            object3 = xMIClass.getXMIProperties().iterator();
            while (object3.hasNext()) {
                vector.addElement(object3.next());
            }
        } else {
            object2 = xMIClass.getXMIProperties().iterator();
            while (object2.hasNext()) {
                vector.addElement(object2.next());
            }
        }
        if (vector != null) {
            object2 = vector.elements();
            while (object2.hasMoreElements()) {
                object = (Property)object2.nextElement();
                if (object instanceof EnumProperty || object instanceof BasicProperty) {
                    this.processBasicProperty((Property)object, bl);
                    continue;
                }
                if (!(object instanceof ObjectProperty)) continue;
                this.processObjectProperty((ObjectProperty)object, bl);
            }
        }
    }

    private void processStringProperty(Property property, boolean bl) {
        this.processGetSet(property, "String", true, bl);
    }

    private String propType(Property property) {
        if (property instanceof EnumProperty) {
            return "EnumProperty";
        }
        if (property instanceof ObjectProperty) {
            return "ObjectProperty";
        }
        return "BasicProperty";
    }

    private void reportOut(String string) {
        try {
            this.reportosw.write(string, 0, string.length());
            this.reportosw.write(10);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setFile(String string) {
        String string2 = this.makeFileName(string);
        string2 = this.processDirectory(string2);
        try {
            this.fs = new FileOutputStream(string2);
            this.os = new OutputStreamWriter(this.fs);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setGenMOF(boolean bl) {
        this.genMOF = bl;
    }

    private void setIsRef(boolean bl) {
        this.isRef = bl;
    }

    private void setModelName(String string) {
        this.modelName = string;
    }

    private void setReport(String string) {
        this.report = string;
    }

    private String shortName(Data data) {
        return this.shortName(data.getXMIName());
    }

    private String shortName(String string) {
        int n = (string = string.trim()).lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private String shortOrFullName(Data data) {
        return this.shortOrFullName(data.getXMIName());
    }

    private String shortOrFullName(String string) {
        String string2 = this.shortName(string);
        if (string2.equals("Package") || string2.equals("Object") || string2.equals("Class") || string2.equals("Enumeration") || string2.equals("Exception")) {
            if (string2.equals(string)) {
                if (this.topPackage != null) {
                    return this.topPackage + "." + string2;
                }
                return string;
            }
            return string;
        }
        return string2;
    }
}

