/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.AdapterFactoryRegister;
import com.ibm.xmi.framework.BasicProperty;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.DeclarationFactory;
import com.ibm.xmi.framework.Enum;
import com.ibm.xmi.framework.EnumProperty;
import com.ibm.xmi.framework.Link;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.ObjectProperty;
import com.ibm.xmi.framework.Package;
import com.ibm.xmi.framework.Property;
import com.ibm.xmi.framework.WriterWrapper;
import com.ibm.xmi.framework.XMIClass;
import com.ibm.xmi.framework.XMIFile;
import com.ibm.xmi.framework.XMIFiles;
import com.ibm.xmi.framework.XMIObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class UML2Java {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    FileOutputStream fs;
    FileOutputStream reportfos;
    OutputStreamWriter os;
    OutputStreamWriter reportosw;
    String modelName;
    String directory;
    String topPackage;
    String currentPackage;
    String report;
    Vector duplicateFeatureNames = new Vector();
    Vector namespaces = new Vector();
    Hashtable defsToNames = new Hashtable();
    Hashtable defsToChangedNames = new Hashtable();
    Hashtable duplicateNamesToClasses = new Hashtable();
    Hashtable namespacesToNames = new Hashtable();
    boolean interfaces = false;
    boolean ignorePackages = false;
    boolean oneConstructor = false;
    private Vector classes;
    private String mySuperClass = "XMIObjectImpl";
    private WriterWrapper wrapper = new WriterWrapper(AdapterFactoryRegister.getAdapterFactory().createWriterAdapter());

    private String abbreviation(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isUpperCase(string.charAt(i)) || string2.length() >= 2) continue;
            string2 = string2 + string.charAt(i);
        }
        if (string2.length() == 2) {
            return string2;
        }
        string2 = string.length() < 2 ? string.toUpperCase() : string.substring(0, 2).toUpperCase();
        return string2;
    }

    private void addToDuplicates(String string, XMIClass xMIClass) {
        Vector vector = this.wrapper.getAllSuperclasses(xMIClass);
        vector.addElement(xMIClass);
        Vector vector2 = new Vector(1);
        if (this.duplicateNamesToClasses.get(string) == null) {
            this.duplicateNamesToClasses.put(string, vector2);
        } else {
            vector2 = (Vector)this.duplicateNamesToClasses.get(string);
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (vector2.contains(vector.elementAt(i))) continue;
            vector2.addElement(vector.elementAt(i));
        }
    }

    private String capName(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    private boolean changeName(Data data) {
        String string = this.shortName(data);
        XMIClass xMIClass = null;
        if (data instanceof Link) {
            xMIClass = (XMIClass)((Link)data).getXMIOwner();
        } else if (data instanceof Property) {
            xMIClass = (XMIClass)((Property)data).getXMIOwner();
        }
        if (this.duplicateNamesToClasses.get(string) == null) {
            return true;
        }
        Vector vector = (Vector)this.duplicateNamesToClasses.get(string);
        return vector.contains(xMIClass);
    }

    private void computeClassNames(Vector vector) {
        Vector vector2 = (Vector)this.classes.clone();
        this.getPackages(vector, vector2);
        for (int i = 0; i < vector2.size(); ++i) {
            Data data = (Data)vector2.elementAt(i);
            String string = data.getXMIName();
            string = string.replace('.', '_');
            string = string.replace(':', '_');
            this.defsToNames.put(data, string);
        }
    }

    private void computeFeatureConflicts() {
        for (int i = 0; i < this.classes.size(); ++i) {
            String string;
            XMIClass xMIClass = (XMIClass)this.classes.elementAt(i);
            Iterator iterator = this.wrapper.getAllProperties(xMIClass);
            Iterator iterator2 = this.wrapper.getAllLinks(xMIClass);
            Vector<String> vector = new Vector<String>();
            while (iterator.hasNext()) {
                string = this.stripNamespace(this.shortName((Data)iterator.next()));
                if (vector.contains(string)) {
                    this.addToDuplicates(string, xMIClass);
                }
                if (vector.contains(string) && !this.duplicateFeatureNames.contains(string)) {
                    this.duplicateFeatureNames.addElement(string);
                    continue;
                }
                vector.addElement(string);
            }
            while (iterator2.hasNext()) {
                string = this.stripNamespace(this.shortName((Data)iterator2.next()));
                if (vector.contains(string)) {
                    this.addToDuplicates(string, xMIClass);
                }
                if (vector.contains(string) && !this.duplicateFeatureNames.contains(string)) {
                    this.duplicateFeatureNames.addElement(string);
                    continue;
                }
                vector.addElement(string);
            }
        }
    }

    private boolean containsIgnoreCase(Vector vector, String string) {
        for (int i = 0; i < vector.size(); ++i) {
            if (!((String)vector.elementAt(i)).equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private String duplicateName(Data data) {
        if (!this.changeName(data)) {
            return this.shortName(data);
        }
        String string = this.getFullName(data);
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return string;
        }
        int n2 = string.lastIndexOf(".", n - 1);
        String string2 = string.substring(n2 + 1, n);
        string2 = this.abbreviation(string2);
        string2 = string2 + this.capName(this.stripNamespace(this.shortName(data)));
        if (this.report != null && this.defsToChangedNames.get(data) == null) {
            this.reportOut(string + " renamed to " + string2);
            this.defsToChangedNames.put(data, data);
        }
        return string2;
    }

    private void endFile() {
        try {
            this.os.close();
            this.fs.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void getClasses(Package package_) {
        Iterator iterator = package_.getXMIContents().iterator();
        while (iterator.hasNext()) {
            Namespace namespace;
            Object e = iterator.next();
            if (e instanceof XMIClass) {
                namespace = ((Data)e).getXMINamespace();
                if (namespace != null && !this.namespaces.contains(namespace)) {
                    this.namespaces.addElement(namespace);
                    this.namespacesToNames.put(namespace, "ixafn" + this.namespaces.size());
                }
                this.classes.addElement(e);
                continue;
            }
            if (!(e instanceof Package)) continue;
            namespace = ((Data)e).getXMINamespace();
            if (namespace != null && !this.namespaces.contains(namespace)) {
                this.namespaces.addElement(namespace);
                this.namespacesToNames.put(namespace, "ixafn" + this.namespaces.size());
            }
            this.getClasses((Package)e);
        }
    }

    private void getClasses(Vector vector) {
        this.classes = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            Namespace namespace;
            if (vector.elementAt(i) instanceof XMIClass) {
                namespace = ((Data)vector.elementAt(i)).getXMINamespace();
                if (namespace != null && !this.namespaces.contains(namespace)) {
                    this.namespaces.addElement(namespace);
                    this.namespacesToNames.put(namespace, "ixafn" + this.namespaces.size());
                }
                this.classes.addElement(vector.elementAt(i));
                continue;
            }
            if (!(vector.elementAt(i) instanceof Package)) continue;
            namespace = ((Data)vector.elementAt(i)).getXMINamespace();
            if (namespace != null && !this.namespaces.contains(namespace)) {
                this.namespaces.addElement(namespace);
                this.namespacesToNames.put(namespace, "ixafn" + this.namespaces.size());
            }
            this.getClasses((Package)vector.elementAt(i));
        }
    }

    private String getFullName(Data data) {
        if (data.getXMIOwner() == null) {
            return this.stripNamespace(data.getXMIName());
        }
        String string = this.stripNamespace(data.getXMIName());
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        return this.getFullName(data.getXMIOwner()) + "." + string;
    }

    private String getJavaType(String string) {
        if (string.equalsIgnoreCase("int") || string.equalsIgnoreCase("integer")) {
            return "int";
        }
        if (string.equalsIgnoreCase("boolean")) {
            return "boolean";
        }
        if (string.equalsIgnoreCase("float")) {
            return "float";
        }
        return "String";
    }

    private String getName(Data data, int n) {
        String string = this.getFullName(data);
        int n2 = string.lastIndexOf(".");
        for (int i = n; i > 0 && n2 > 0; --i) {
            n2 = string.lastIndexOf(".", n2 - 1);
        }
        if (n2 > 0) {
            return string.substring(n2 + 1);
        }
        return string;
    }

    private void getPackages(Package package_, Vector vector) {
        if (!vector.contains(package_)) {
            vector.addElement(package_);
        }
        Iterator iterator = package_.getXMIContents().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Package)) continue;
            this.getPackages((Package)e, vector);
        }
    }

    private void getPackages(Vector vector, Vector vector2) {
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i) instanceof Package)) continue;
            this.getPackages((Package)vector.elementAt(i), vector2);
        }
    }

    private String getUMLAttributeType(Property property) {
        String string;
        Property property2;
        if (property.getXMISource() == null || property instanceof EnumProperty) {
            String string2;
            Enum enum_;
            String string3 = "String";
            if (property instanceof EnumProperty && (enum_ = ((EnumProperty)property).getXMIEnum()) != null && (string2 = enum_.getXMIName()) != null) {
                int n = string2.indexOf(":");
                if (n != -1) {
                    string2 = string2.substring(n + 1);
                }
                if (string2.equalsIgnoreCase("boolean")) {
                    string3 = "boolean";
                }
            }
            return string3;
        }
        XMIObject xMIObject = (XMIObject)property.getXMISource();
        Property property3 = (Property)this.wrapper.getProperty(xMIObject, "Foundation.Core.StructuralFeature.type");
        XMIObject xMIObject2 = null;
        if (property3 != null) {
            xMIObject2 = (XMIObject)property3.getXMIGenericValue();
        }
        if (xMIObject2 != null && (xMIObject2.getXMIName().equals("Foundation.Data_Types.Primitive") || this.isDatatype(xMIObject2)) && (property2 = (Property)this.wrapper.getProperty(xMIObject2, "Foundation.Core.ModelElement.name")) != null && (string = (String)property2.getXMIGenericValue()) != null) {
            if (string.equalsIgnoreCase("int") || string.equalsIgnoreCase("integer")) {
                return "int";
            }
            if (string.equalsIgnoreCase("float")) {
                return "float";
            }
        }
        return "String";
    }

    private boolean isDatatype(XMIObject xMIObject) {
        if (xMIObject.getXMIName().equals("Foundation.Core.Data_Type")) {
            return true;
        }
        Iterator iterator = this.wrapper.getProperties(xMIObject).iterator();
        while (iterator.hasNext()) {
            XMIObject xMIObject2;
            Property property;
            Property property2 = (Property)iterator.next();
            if (!property2.getXMIName().equals("Foundation.Core.ModelElement.stereotype") || (property = (Property)this.wrapper.getProperty(xMIObject2 = (XMIObject)property2.getXMIGenericValue(), "Foundation.Core.ModelElement.name")) == null || !property.getXMIGenericValue().equals("datatype")) continue;
            return true;
        }
        return false;
    }

    private boolean isJavaType(Property property) {
        String string = this.getJavaType(this.getUMLAttributeType(property));
        return string.equals("int") || string.equals("float") || string.equals("boolean");
    }

    private String linkType(Link link) {
        if (link.getXMIType() == 3) {
            return "ContainerLink";
        }
        if (link.getXMIType() == 2) {
            return "RefLink";
        }
        return "ContainLink";
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0 || stringArray[0].equals("?")) {
            System.out.println("Generate Java classes from a UML model.  The arguments are:");
            System.out.println("-model Name of UML XMI file. (required)");
            System.out.println("-dir Directory to put code (optional)");
            System.out.println("-package Top-level Java package for code (optional)");
            System.out.println("-report File that contains renamed properties and links (optional)");
            System.out.println("-namespaceName The name of the namespace for the model (optional)");
            System.out.println("-namespaceURI URI of the namespace for the model (optional)");
            System.out.println("-namespacefile XML file containing namespaces for the model (optional)");
            System.out.println("-interfaces If present, generate an interface and impl for each class in model (optinal)");
            System.out.println("-ignorePackages If present, puts all classes in one Java package, renaming if needed (optional)");
            System.out.println("-oneConstructor If present, generates one constructor with no parameters (optional)");
            System.out.println("-superClass If present, the generated implementation classes inherit from this class rather than XMIObjectImpl (optional)");
            System.out.println("-filepath File path for loading a model in multiple files (optional)");
            return;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        UML2Java uML2Java = new UML2Java();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-model") && i + 1 < stringArray.length) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-dir") && i + 1 < stringArray.length) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-package") && i + 1 < stringArray.length) {
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-report") && i + 1 < stringArray.length) {
                string4 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-namespaceName") && i + 1 < stringArray.length) {
                string5 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-namespaceURI") && i + 1 < stringArray.length) {
                string6 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-namespacefile") && i + 1 < stringArray.length) {
                string8 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-superClass") && i + 1 < stringArray.length) {
                uML2Java.setSuperClass(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-filepath") && i + 1 < stringArray.length) {
                string7 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-interfaces")) {
                uML2Java.setInterfaces(true);
                continue;
            }
            if (stringArray[i].equals("-ignorePackages")) {
                uML2Java.setIgnorePackages(true);
                continue;
            }
            if (!stringArray[i].equals("-oneConstructor")) continue;
            uML2Java.setOneConstructor(true);
        }
        if (string == null) {
            System.out.println("Must specify a model file with -model option.");
            return;
        }
        if (string2 == null) {
            string2 = System.getProperty("user.dir");
        }
        try {
            int n;
            XMIFiles xMIFiles = new XMIFiles();
            if (string7 != null) {
                xMIFiles.setFilepath(string7);
            }
            XMIFile xMIFile = xMIFiles.load(string, 1, false);
            xMIFiles.loadAll();
            DeclarationFactory declarationFactory = null;
            declarationFactory = string8 != null ? new DeclarationFactory(string8) : (string5 != null ? new DeclarationFactory(string5, string6) : new DeclarationFactory());
            Iterator iterator = declarationFactory.makeDeclarations(xMIFiles.getContainer()).iterator();
            Vector vector = new Vector();
            while (iterator.hasNext()) {
                vector.addElement(iterator.next());
            }
            int n2 = string.lastIndexOf(File.separatorChar);
            if (n2 > 0) {
                string = string.substring(n2 + 1);
            }
            if ((n = string.indexOf(46)) > 0) {
                uML2Java.setModelName(string.substring(0, n));
            } else {
                uML2Java.setModelName(stringArray[0]);
            }
            uML2Java.setReport(string4);
            uML2Java.makeJava(string2, string3, vector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void makeFactory(Vector vector) {
        if (this.topPackage == null) {
            this.setFile("UserFactory");
        } else {
            this.setFile(this.topPackage + ".UserFactory");
        }
        if (this.topPackage != null) {
            this.out("package " + this.topPackage + ";\n");
        }
        this.out("import com.ibm.xmi.framework.*;");
        this.out("import com.ibm.xmi.framework.Package;");
        this.out("import java.util.*;\n");
        this.out("public class UserFactory extends FactoryAdapter {");
        this.out("\tstatic private Model ixafm;\n");
        this.out("\tstatic private HashMap ixafntc, ixafntcn;\n");
        this.out("\tpublic UserFactory() {");
        this.out("\t\tFactoryRegister.registerFactory(this);");
        this.out("\t}\n");
        this.makeFactoryMethod(vector);
        this.makeFactoryDefs(vector);
        this.out("} // UserFactory");
        this.endFile();
    }

    private void makeFactoryDefs(Vector vector) {
        Object object;
        Iterator iterator;
        XMIClass xMIClass;
        Object object2;
        Object object3;
        Data data;
        this.out("\tpublic Model getModel() {");
        this.out("\t\tif (ixafm != null)");
        this.out("\t\t\treturn ixafm;\n");
        this.out("\t\tixafm = new Model(\"" + this.modelName + "\");\n");
        this.out("\t\ttry {");
        for (int i = 0; i < this.namespaces.size(); ++i) {
            Namespace namespace = (Namespace)this.namespaces.elementAt(i);
            if (namespace.getURI() != null) {
                this.out("\t\t\tcom.ibm.xmi.framework.Namespace ixafn" + (i + 1) + " = new com.ibm.xmi.framework.Namespace(\"" + namespace.getName() + "\", \"" + namespace.getURI() + "\");");
                continue;
            }
            this.out("\t\t\tcom.ibm.xmi.framework.Namespace ixafn" + (i + 1) + " = new com.ibm.xmi.framework.Namespace(\"" + namespace.getName() + "\", null);");
        }
        Vector vector2 = new Vector();
        this.getPackages(vector, vector2);
        for (int i = 0; i < vector2.size(); ++i) {
            data = (Data)vector2.elementAt(i);
            object3 = (String)this.defsToNames.get(data);
            if (data.getXMIOwner() != null) {
                this.out("\t\t\tPackage " + (String)object3 + " = makePackage(" + this.defsToNames.get(data.getXMIOwner()) + ", \"" + this.stripNamespace(data.getXMIName()) + "\");");
            } else {
                this.out("\t\t\tPackage " + (String)object3 + " = makePackage(null, \"" + this.stripNamespace(data.getXMIName()) + "\");");
            }
            if (data.getXMINamespace() == null) continue;
            this.out("\t\t\t" + object3 + ".setXMINamespace(" + this.namespacesToNames.get(data.getXMINamespace()) + ");");
        }
        Enumeration enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            data = (Data)enumeration.nextElement();
            if (!(data instanceof XMIClass)) continue;
            object3 = (String)this.defsToNames.get(data);
            if (data.getXMIOwner() != null) {
                this.out("\t\t\tXMIClass " + (String)object3 + " = makeXMIClass(" + this.defsToNames.get(data.getXMIOwner()) + ", \"" + this.stripNamespace(data.getXMIName()) + "\");");
            } else {
                this.out("\t\t\tXMIClass " + (String)object3 + " = makeXMIClass(null, \"" + this.stripNamespace(data.getXMIName()) + "\");");
            }
            if (data.getXMINamespace() == null) continue;
            this.out("\t\t\t" + object3 + ".setXMINamespace(" + this.namespacesToNames.get(data.getXMINamespace()) + ");");
        }
        this.out("");
        boolean bl = false;
        enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            object3 = (Data)enumeration.nextElement();
            if (!(object3 instanceof XMIClass)) continue;
            object2 = (String)this.defsToNames.get(object3);
            xMIClass = (XMIClass)object3;
            iterator = this.wrapper.getSuperclasses(xMIClass).iterator();
            while (iterator.hasNext()) {
                bl = true;
                object = (XMIClass)iterator.next();
                this.out("\t\t\t" + (String)object2 + ".addSuperclass(" + this.defsToNames.get(object) + ");");
            }
            iterator = this.wrapper.getSubclasses(xMIClass).iterator();
            while (iterator.hasNext()) {
                bl = true;
                object = (XMIClass)iterator.next();
                this.out("\t\t\t" + (String)object2 + ".addSubclass(" + this.defsToNames.get(object) + ");");
            }
        }
        if (bl) {
            this.out("");
            bl = false;
        }
        enumeration = this.classes.elements();
        if (this.namespaces.size() > 0) {
            this.out("\t\t\tcom.ibm.xmi.framework.Property ixafp;");
            this.out("\t\t\tcom.ibm.xmi.framework.Link ixafl;");
        }
        while (enumeration.hasMoreElements()) {
            Object object4;
            Object object5;
            object3 = (Data)enumeration.nextElement();
            if (!(object3 instanceof XMIClass)) continue;
            object2 = (String)this.defsToNames.get(object3);
            xMIClass = (XMIClass)object3;
            iterator = xMIClass.getXMIProperties().iterator();
            while (iterator.hasNext()) {
                object = (Property)iterator.next();
                object5 = object.getXMINamespace();
                if (object instanceof ObjectProperty) {
                    bl = true;
                    object4 = (ObjectProperty)object;
                    if (object5 == null) {
                        this.out("\t\t\tmake" + this.propType((Property)object) + "(" + (String)object2 + ", \"" + object.getXMIName() + "\", " + this.defsToNames.get(object4.getXMIValue()) + ");");
                        continue;
                    }
                    this.out("\t\t\tixafp = make" + this.propType((Property)object) + "(" + (String)object2 + ", \"" + this.stripNamespace(object.getXMIName()) + "\", " + this.defsToNames.get(object4.getXMIValue()) + ");");
                    this.out("\t\t\tixafp.setXMINamespace(" + this.namespacesToNames.get(object5) + ");");
                    continue;
                }
                bl = true;
                if (object5 == null) {
                    this.out("\t\t\tmake" + this.propType((Property)object) + "(" + (String)object2 + ", \"" + object.getXMIName() + "\");");
                    continue;
                }
                this.out("\t\t\tixafp = make" + this.propType((Property)object) + "(" + (String)object2 + ", \"" + this.stripNamespace(object.getXMIName()) + "\");");
                this.out("\t\t\tixafp.setXMINamespace(" + this.namespacesToNames.get(object5) + ");");
            }
            object = xMIClass.getXMILinks().iterator();
            while (object.hasNext()) {
                bl = true;
                object5 = (Link)object.next();
                object4 = object5.getXMINamespace();
                if (object4 == null) {
                    this.out("\t\t\tmake" + this.linkType((Link)object5) + "(" + (String)object2 + ", \"" + object5.getXMIName() + "\", " + this.defsToNames.get(object5.getXMIObject()) + ");");
                    continue;
                }
                this.out("\t\t\tixafl = make" + this.linkType((Link)object5) + "(" + (String)object2 + ", \"" + this.stripNamespace(object5.getXMIName()) + "\", " + this.defsToNames.get(object5.getXMIObject()) + ");");
                this.out("\t\t\tixafl.setXMINamespace(" + this.namespacesToNames.get(object4) + ");");
            }
            if (!bl) continue;
            this.out("");
            bl = false;
        }
        object3 = new Vector<Object>();
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Data)enumeration.nextElement();
            if (object2.getXMIOwner() != null) continue;
            ((Vector)object3).addElement(object2);
        }
        enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Data)enumeration.nextElement();
            if (object2.getXMIOwner() != null) continue;
            ((Vector)object3).addElement(object2);
        }
        enumeration = ((Vector)object3).elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Data)enumeration.nextElement();
            if (!(object2 instanceof XMIClass) && !(object2 instanceof Package)) continue;
            this.out("\t\t\tixafm.add(" + this.defsToNames.get(object2) + ");");
        }
        this.out("");
        this.out("\t\t} catch(XMIException e) {");
        this.out("\t\t\te.printStackTrace();");
        this.out("\t\t}");
        this.out("\t\treturn ixafm;");
        this.out("\t}\n");
    }

    private void makeFactoryMethod(Vector vector) {
        this.out("\tprivate void init() {");
        this.out("\t\tixafntcn = new HashMap();");
        Enumeration enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            Data data = (Data)enumeration.nextElement();
            if (!(data instanceof XMIClass)) continue;
            String string = data.getXMIName();
            String string2 = this.getFullName(data);
            String string3 = "";
            string3 = this.ignorePackages ? (String)this.defsToNames.get(data) : this.getFullName(data);
            if (this.topPackage != null) {
                string3 = this.topPackage + "." + string3;
            }
            if (this.interfaces) {
                string3 = string3 + "Impl";
            }
            this.out("\t\tixafntcn.put(\"" + string + "\", \"" + string3 + "\");");
            this.out("\t\tixafntcn.put(\"" + string2 + "\", \"" + string3 + "\");");
        }
        this.out("\t}\n");
        this.out("\tpublic XMIObject makeXMIObject(String xmiName) {");
        this.out("\t\tif (ixafntc == null)");
        this.out("\t\t\tixafntc = new HashMap();");
        this.out("");
        this.out("\t\tjava.lang.Class cls = (java.lang.Class) ixafntc.get(xmiName);");
        this.out("");
        this.out("\t\tif (cls == null) {");
        this.out("\t\t\tif (ixafntcn == null)");
        this.out("\t\t\t\tinit();");
        this.out("");
        this.out("\t\t\tString name = (String) ixafntcn.get(xmiName);");
        this.out("");
        this.out("\t\t\ttry {");
        this.out("\t\t\t\tif (name != null)");
        this.out("\t\t\t\t\tcls = java.lang.Class.forName(name);");
        this.out("\t\t\t}");
        this.out("\t\t\tcatch (ClassNotFoundException e) {}");
        this.out("");
        this.out("\t\t\tif (cls != null)");
        this.out("\t\t\t\tixafntc.put(xmiName, cls);");
        this.out("\t\t}");
        this.out("");
        this.out("\t\tif (cls == null)");
        this.out("\t\t\treturn super.makeXMIObject(xmiName);");
        this.out("\t\telse {");
        this.out("\t\t\tjava.lang.Object o = null;");
        this.out("");
        this.out("\t\t\ttry {");
        this.out("\t\t\t\to = cls.newInstance();");
        this.out("\t\t\t}");
        this.out("\t\t\tcatch (Exception e) {}");
        this.out("");
        this.out("\t\t\treturn (XMIObject) o;");
        this.out("\t\t}");
        this.out("\t}\n");
        if (this.namespaces.size() > 0) {
            this.out("\tpublic XMIObject makeXMIObject(String xmiName, com.ibm.xmi.framework.Namespace n) {");
            this.out("\t\tif (n.getName() == null || n.getName().equals(\"\"))");
            this.out("\t\t\treturn makeXMIObject(xmiName);");
            this.out("\t\telse");
            this.out("\t\t\treturn makeXMIObject(n.getName() + \":\" + xmiName);");
            this.out("\t}\n");
        }
    }

    private String makeFileName(String string) {
        String string2 = string.replace('.', File.separatorChar);
        return this.directory + File.separatorChar + string2 + ".java";
    }

    private void makeImplementation(XMIClass xMIClass) {
        String string = "";
        if (this.topPackage != null) {
            string = string + this.topPackage + ".";
        }
        string = this.ignorePackages ? string + this.defsToNames.get(xMIClass) : string + this.getFullName(xMIClass);
        if (this.interfaces) {
            string = string + "Impl";
        }
        this.setFile(string);
        this.processDecl(xMIClass, true);
        this.processConstructors(xMIClass);
        this.processProperties(xMIClass, true);
        this.processLinks(xMIClass, true);
        this.processEnd(xMIClass, true);
        this.endFile();
    }

    private void makeInterface(XMIClass xMIClass) {
        String string = "";
        if (this.topPackage != null) {
            string = string + this.topPackage + ".";
        }
        string = this.ignorePackages ? string + this.defsToNames.get(xMIClass) : string + this.getFullName(xMIClass);
        this.setFile(string);
        this.processDecl(xMIClass, false);
        this.processProperties(xMIClass, false);
        this.processLinks(xMIClass, false);
        this.processEnd(xMIClass, false);
        this.endFile();
    }

    public void makeJava(String string, String string2, Vector vector) {
        if (vector == null) {
            return;
        }
        if (this.report != null) {
            try {
                this.reportfos = new FileOutputStream(this.report);
                this.reportosw = new OutputStreamWriter(this.reportfos);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.directory = string;
        this.topPackage = string2;
        this.getClasses(vector);
        this.computeFeatureConflicts();
        this.computeClassNames(vector);
        Enumeration enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            XMIClass xMIClass = (XMIClass)enumeration.nextElement();
            if (this.interfaces) {
                this.makeInterface(xMIClass);
            }
            this.makeImplementation(xMIClass);
        }
        this.makeFactory(vector);
        if (this.report != null) {
            try {
                this.reportosw.close();
                this.reportfos.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void out(String string) {
        try {
            this.os.write(string, 0, string.length());
            this.os.write(10);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String packageName(String string) {
        int n = string.lastIndexOf(".");
        if (n > 0) {
            return string.substring(0, n);
        }
        return "";
    }

    private void processBasicProperty(Property property, boolean bl) {
        this.processGetSet(property, this.getJavaType(this.getUMLAttributeType(property)), true, bl);
    }

    private void processConstructors(XMIClass xMIClass) {
        String string = this.topPackage == null ? "UserFactory" : this.topPackage + ".UserFactory";
        this.out("\tprivate com.ibm.xmi.framework.Model getXMIModel() {");
        this.out("\t\t" + string + " f;\n");
        this.out("\t\tif (FactoryRegister.getFactory() instanceof " + string + ")");
        this.out("\t\t\tf = (" + string + ") FactoryRegister.getFactory();");
        this.out("\t\telse");
        this.out("\t\t\tf = new " + string + "();\n");
        this.out("\t\treturn f.getModel();");
        this.out("\t}\n");
        if (!this.interfaces) {
            if (this.ignorePackages) {
                this.out("\tpublic " + this.defsToNames.get(xMIClass) + "() {");
            } else {
                this.out("\tpublic " + this.stripNamespace(this.shortName(xMIClass)) + "() {");
            }
        } else if (this.ignorePackages) {
            this.out("\tpublic " + this.defsToNames.get(xMIClass) + "Impl() {");
        } else {
            this.out("\tpublic " + this.stripNamespace(this.shortName(xMIClass)) + "Impl() {");
        }
        this.out("\t\tsuper();");
        this.out("\t\ttry { setXMIName(\"" + this.stripNamespace(xMIClass.getXMIName()) + "\"); } catch (XMIException e) {}");
        this.out("\t\tcom.ibm.xmi.framework.Model m = getXMIModel();");
        Namespace namespace = xMIClass.getXMINamespace();
        if (namespace == null) {
            this.out("\t\tcom.ibm.xmi.framework.Data definer = m.getDeclaration(WriterAdapter.CLASS, \"" + this.stripNamespace(xMIClass.getXMIName()) + "\");");
        } else {
            this.out("\t\tcom.ibm.xmi.framework.Namespace n = new com.ibm.xmi.framework.Namespace(\"" + namespace.getName() + "\", \"" + namespace.getURI() + "\");");
            this.out("\t\tcom.ibm.xmi.framework.Data definer = m.getDeclaration(n, WriterAdapter.CLASS, \"" + this.stripNamespace(xMIClass.getXMIName()) + "\", false);");
        }
        this.out("\t\ttry { setXMIDefiner(definer); } catch (XMIException e) {};");
        this.out("\t}\n");
        if (!this.oneConstructor) {
            String string2 = new String();
            Iterator iterator = this.wrapper.getAllProperties(xMIClass);
            if (iterator.hasNext()) {
                Property property;
                while (iterator.hasNext()) {
                    property = (Property)iterator.next();
                    if (string2.length() > 0) {
                        string2 = string2 + ", ";
                    }
                    if (property instanceof ObjectProperty) {
                        String string3 = "";
                        string3 = this.ignorePackages ? (String)this.defsToNames.get(((ObjectProperty)property).getXMIValue()) : this.getFullName(((ObjectProperty)property).getXMIValue());
                        string2 = this.topPackage == null ? string2 + string3 : string2 + this.topPackage + "." + string3;
                    } else if (property instanceof EnumProperty && ((EnumProperty)property).getXMIEnum() != null && ((EnumProperty)property).getXMIEnum().getXMIName().equalsIgnoreCase("boolean")) {
                        string2 = string2 + "boolean";
                    } else if (property instanceof EnumProperty) {
                        string2 = string2 + "String";
                    } else if (property instanceof BasicProperty) {
                        string2 = string2 + this.getJavaType(this.getUMLAttributeType(property));
                    }
                    string2 = string2 + " " + this.stripNamespace(this.shortName(property));
                }
                if (!this.interfaces) {
                    if (this.ignorePackages) {
                        this.out("\tpublic " + this.defsToNames.get(xMIClass) + "(" + string2 + ") {");
                    } else {
                        this.out("\tpublic " + this.stripNamespace(this.shortName(xMIClass)) + "(" + string2 + ") {");
                    }
                } else if (this.ignorePackages) {
                    this.out("\tpublic " + this.defsToNames.get(xMIClass) + "Impl(" + string2 + ") {");
                } else {
                    this.out("\tpublic " + this.stripNamespace(this.shortName(xMIClass)) + "Impl(" + string2 + ") {");
                }
                this.out("\t\tthis();");
                iterator = this.wrapper.getAllProperties(xMIClass);
                while (iterator.hasNext()) {
                    property = (Property)iterator.next();
                    this.out("\t\tset" + this.capName(this.stripNamespace(this.shortName(property))) + "(" + this.stripNamespace(this.shortName(property)) + ");");
                }
                this.out("\t}\n");
            }
        }
    }

    private void processDecl(XMIClass xMIClass, boolean bl) {
        String string = null;
        if (xMIClass.getXMIOwner() != null) {
            string = this.getFullName(xMIClass.getXMIOwner());
        }
        if (this.topPackage != null && string != null) {
            string = this.topPackage + "." + string;
        } else if (this.topPackage != null) {
            string = this.topPackage;
        }
        if (this.ignorePackages) {
            if (this.topPackage != null) {
                this.out("package " + this.topPackage + ";\n");
                this.currentPackage = this.topPackage;
            } else {
                this.currentPackage = "";
            }
        } else {
            if (string != null) {
                this.out("package " + string + ";\n");
            }
            this.currentPackage = string;
        }
        this.out("import com.ibm.xmi.framework.*;");
        this.out("import java.util.*;");
        if (string != null) {
            if (this.topPackage == null) {
                this.out("import UserFactory;");
            } else {
                this.out("import " + this.topPackage + ".UserFactory;");
            }
        }
        this.out("\n");
        String string2 = this.stripNamespace(this.shortName(xMIClass));
        if (this.ignorePackages) {
            string2 = (String)this.defsToNames.get(xMIClass);
        }
        if (this.interfaces && bl) {
            string2 = string2 + "Impl";
        }
        Iterator iterator = xMIClass.getXMISuperclasses().iterator();
        String string3 = new String();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                if (string3.length() > 0) {
                    string3 = string3 + ", ";
                }
                if (this.topPackage == null) {
                    string3 = string3 + this.shortOrFullName((Data)iterator.next());
                    continue;
                }
                string3 = string3 + this.topPackage + "." + this.shortOrFullName((Data)iterator.next());
            }
        } else {
            string3 = bl ? this.mySuperClass : "XMIObject";
        }
        if (bl && !this.interfaces) {
            this.out("public class " + string2 + " extends " + string3 + " {");
        } else if (bl && this.interfaces) {
            if (this.ignorePackages) {
                this.out("public class " + string2 + " extends " + this.mySuperClass + " implements " + this.defsToNames.get(xMIClass) + " {");
            } else {
                this.out("public class " + string2 + " extends " + this.mySuperClass + " implements " + this.stripNamespace(this.shortName(xMIClass)) + " {");
            }
        } else {
            this.out("public interface " + string2 + " extends " + string3 + " {");
        }
    }

    private void processDirectory(String string) {
        File file = new File(string);
        if (file.getParent() == null) {
            return;
        }
        File file2 = new File(file.getParent());
        if (!file2.exists()) {
            file2.mkdirs();
        }
    }

    private void processEnd(XMIClass xMIClass, boolean bl) {
        if (bl && this.interfaces && this.ignorePackages) {
            this.out("} // " + this.defsToNames.get(xMIClass) + "Impl");
        } else if (bl && this.interfaces) {
            this.out("} // " + this.stripNamespace(xMIClass.getXMIName()) + "Impl");
        } else if (this.ignorePackages) {
            this.out("} // " + this.defsToNames.get(xMIClass));
        } else {
            this.out("} // " + this.stripNamespace(xMIClass.getXMIName()));
        }
    }

    private void processGetSet(Property property, String string, boolean bl, boolean bl2) {
        String string2 = this.stripNamespace(this.shortName(property));
        if (this.duplicateFeatureNames.contains(string2)) {
            string2 = this.duplicateName(property);
        }
        String string3 = this.capName(string2);
        String string4 = property.getXMIName();
        String string5 = "";
        if (!string.equals("String")) {
            string5 = this.capName(string);
        }
        if (this.topPackage != null && !bl) {
            string = this.topPackage + "." + string;
        }
        if (!bl2) {
            if (!string.equals("boolean")) {
                this.out("\tpublic " + this.shortOrFullName(string) + " get" + string3 + "();");
            } else {
                this.out("\tpublic " + this.shortOrFullName(string) + " is" + string3 + "();");
            }
            this.out("\tpublic void set" + string3 + "(" + this.shortOrFullName(string) + " value);\n");
            return;
        }
        if (!string.equals("boolean")) {
            this.out("\tpublic " + this.shortOrFullName(string) + " get" + string3 + "() {");
        } else {
            this.out("\tpublic " + this.shortOrFullName(string) + " is" + string3 + "() {");
        }
        if (bl) {
            if (string.equals("int")) {
                this.out("\t\treturn Integer.valueOf(getXMIValue(\"" + string4 + "\")).intValue();");
            } else if (string.equals("float")) {
                this.out("\t\treturn Float.valueOf(getXMIValue(\"" + string4 + "\")).floatValue();");
            } else if (string.equals("boolean")) {
                this.out("\t\treturn Boolean.valueOf(getXMIValue(\"" + string4 + "\")).booleanValue();");
            } else {
                this.out("\t\treturn getXMIValue" + string5 + "(\"" + string4 + "\");");
            }
        } else {
            this.out("\t\treturn (" + this.shortOrFullName(string) + ") getObjectPropertyValue(\"" + string4 + "\");");
        }
        this.out("\t}\n");
        this.out("\tpublic void set" + string3 + "(" + this.shortOrFullName(string) + " value) {");
        if (this.isJavaType(property) && !string.equals("String") && !string.equals("boolean")) {
            this.out("\t\tcom.ibm.xmi.framework.Property p = setBasicPropertyValue(\"" + string4 + "\", String.valueOf(value));\n");
        } else if (string.equals("String") && property instanceof EnumProperty) {
            this.out("\t\tcom.ibm.xmi.framework.Property p = setEnumPropertyValue(\"" + string4 + "\", value);\n");
        } else if (!string.equals("String") && property instanceof EnumProperty) {
            this.out("\t\tcom.ibm.xmi.framework.Property p = setEnumPropertyValue(\"" + string4 + "\", String.valueOf(value));\n");
        } else if (string.equals("String")) {
            this.out("\t\tcom.ibm.xmi.framework.Property p = setBasicPropertyValue(\"" + string4 + "\", value);\n");
        } else {
            this.out("\t\tcom.ibm.xmi.framework.Property p = setPropertyValue(\"" + string4 + "\", value);\n");
        }
        this.out("\t\tif (p.getXMIDefiner() == null) {");
        this.out("\t\t\tcom.ibm.xmi.framework.Model m = getXMIModel();");
        if (property.getXMINamespace() == null) {
            this.out("\t\t\tcom.ibm.xmi.framework.Data definer = m.getDeclaration(getXMIDefiner(), \"" + string4 + "\");");
        } else {
            this.out("\t\t\tcom.ibm.xmi.framework.Namespace n = new com.ibm.xmi.framework.Namespace(\"" + property.getXMINamespace().getName() + "\", \"" + property.getXMINamespace().getURI() + "\");");
            this.out("\t\t\tcom.ibm.xmi.framework.Data definer = m.getDeclaration(n, getXMIDefiner(), \"" + this.stripNamespace(string4) + "\", false);");
        }
        this.out("\t\t\ttry { p.setXMIDefiner(definer); } catch (XMIException e) {};");
        this.out("\t\t}");
        this.out("\t}\n");
    }

    private void processLink(Link link, boolean bl) {
        String string = this.stripNamespace(this.shortName(link));
        if (this.duplicateFeatureNames.contains(string)) {
            string = this.duplicateName(link);
        }
        String string2 = this.capName(string);
        String string3 = this.getFullName(link.getXMIObject());
        String string4 = this.stripNamespace(link.getXMIName());
        if (this.ignorePackages) {
            string3 = (String)this.defsToNames.get(link.getXMIObject());
        }
        if (this.topPackage != null) {
            string3 = this.topPackage + "." + string3;
        }
        if (!bl) {
            this.out("\tpublic Collection get" + string2 + "();");
            this.out("\tpublic void add" + string2 + "(" + this.shortOrFullName(string3) + " object);");
            this.out("\tpublic void remove" + string2 + "(" + this.shortOrFullName(string3) + " object);\n");
            return;
        }
        this.out("\tpublic Collection get" + string2 + "() {");
        this.out("\t\treturn getLinkedObjects(\"" + string4 + "\");");
        this.out("\t}\n");
        this.out("\tpublic void add" + string2 + "(" + this.shortOrFullName(string3) + " object) {");
        this.out("\t\tcom.ibm.xmi.framework.Link l = (com.ibm.xmi.framework.Link) FactoryRegister.getFactory().make" + this.linkType(link) + "(this, \"" + string4 + "\", object);\n");
        this.out("\t\tif (l.getXMIDefiner() == null) {");
        this.out("\t\t\tcom.ibm.xmi.framework.Model m = getXMIModel();");
        if (link.getXMINamespace() == null) {
            this.out("\t\t\tcom.ibm.xmi.framework.Data definer = m.getDeclaration(getXMIDefiner(), \"" + string4 + "\");");
        } else {
            this.out("\t\t\tcom.ibm.xmi.framework.Namespace n = new com.ibm.xmi.framework.Namespace(\"" + link.getXMINamespace().getName() + "\", \"" + link.getXMINamespace().getURI() + "\");");
            this.out("\t\t\tcom.ibm.xmi.framework.Data definer = m.getDeclaration(n, getXMIDefiner(), \"" + string4 + "\", false);");
        }
        this.out("\t\t\ttry { l.setXMIDefiner(definer); } catch (XMIException e) {};");
        this.out("\t\t}");
        this.out("\t}\n");
        this.out("\tpublic void remove" + string2 + "(" + this.shortOrFullName(string3) + " object) {");
        this.out("\t\tdelete(\"" + string4 + "\", object);");
        this.out("\t}\n");
    }

    private void processLinks(XMIClass xMIClass, boolean bl) {
        Object object;
        Vector vector = new Vector(5);
        if (bl && this.interfaces) {
            object = this.wrapper.getAllLinks(xMIClass);
            while (object.hasNext()) {
                vector.addElement(object.next());
            }
        } else {
            object = xMIClass.getXMILinks().iterator();
            while (object.hasNext()) {
                vector.addElement(object.next());
            }
        }
        if (vector != null) {
            object = vector.elements();
            while (object.hasMoreElements()) {
                Link link = (Link)object.nextElement();
                this.processLink(link, bl);
            }
            this.out("");
        }
    }

    private void processObjectProperty(ObjectProperty objectProperty, boolean bl) {
        String string = this.getFullName(objectProperty.getXMIValue());
        if (this.ignorePackages) {
            string = (String)this.defsToNames.get(objectProperty.getXMIValue());
        }
        this.processGetSet(objectProperty, string, false, bl);
    }

    private void processProperties(XMIClass xMIClass, boolean bl) {
        Iterator iterator = bl && this.interfaces ? this.wrapper.getAllProperties(xMIClass) : xMIClass.getXMIProperties().iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (property instanceof EnumProperty || property instanceof BasicProperty) {
                this.processBasicProperty(property, bl);
                continue;
            }
            if (!(property instanceof ObjectProperty)) continue;
            this.processObjectProperty((ObjectProperty)property, bl);
        }
    }

    private String propType(Property property) {
        if (property instanceof EnumProperty) {
            return "EnumProperty";
        }
        if (property instanceof ObjectProperty) {
            return "ObjectProperty";
        }
        return "BasicProperty";
    }

    private void reportOut(String string) {
        try {
            this.reportosw.write(string, 0, string.length());
            this.reportosw.write(10);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setFile(String string) {
        File file;
        String string2 = this.makeFileName(string);
        this.processDirectory(string2);
        File file2 = new File(string2);
        if (file2.getParent() != null && !(file = new File(file2.getParent())).exists()) {
            file.mkdirs();
        }
        try {
            this.fs = new FileOutputStream(string2);
            this.os = new OutputStreamWriter(this.fs);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setIgnorePackages(boolean bl) {
        this.ignorePackages = bl;
    }

    public void setInterfaces(boolean bl) {
        this.interfaces = bl;
    }

    private void setModelName(String string) {
        this.modelName = string;
    }

    private void setNamespaceName(String string) {
    }

    private void setNamespaceURI(String string) {
    }

    private void setOneConstructor(boolean bl) {
        this.oneConstructor = bl;
    }

    private void setReport(String string) {
        this.report = string;
    }

    private void setSuperClass(String string) {
        this.mySuperClass = string;
    }

    private String shortName(Data data) {
        return this.shortName(data.getXMIName());
    }

    private String shortName(String string) {
        int n = (string = string.trim()).lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private String shortOrFullName(Data data) {
        if (this.ignorePackages) {
            return (String)this.defsToNames.get(data);
        }
        return this.shortOrFullName(this.stripNamespace(this.getFullName(data)));
    }

    private String shortOrFullName(String string) {
        if (this.currentPackage == null || !this.currentPackage.equals("") && this.currentPackage.equals(this.packageName(string))) {
            return this.shortName(string);
        }
        return string;
    }

    private String stripNamespace(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }
}

