/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.AdapterFactoryRegister;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.EnumProperty;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.Package;
import com.ibm.xmi.framework.Property;
import com.ibm.xmi.framework.WriterWrapper;
import com.ibm.xmi.framework.XMIClass;
import com.ibm.xmi.framework.XMIException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Model {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private static Namespace noNamespace = new Namespace(null, null);
    private String name;
    private String version;
    private String file;
    private String dtd;
    private String uri;
    private ArrayList declarations;
    private ArrayList topLevel;
    private HashSet namespaces;
    private HashMap namespaceToName;
    private HashMap superclasses;
    private WriterWrapper wrapper = new WriterWrapper(AdapterFactoryRegister.getAdapterFactory().createWriterAdapter());

    public Model(String string) {
        this.name = string;
    }

    public Model(String string, String string2) {
        this(string);
        this.version = string2;
    }

    public Model(String string, String string2, String string3) {
        this(string, string2);
        this.file = string3;
    }

    public Model(String string, Iterator iterator) throws XMIException {
        this(string);
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.add((Data)iterator.next());
            }
        }
    }

    public void add(Data data) throws XMIException {
        block7: {
            block6: {
                if (this.declarations == null) {
                    this.declarations = new ArrayList();
                }
                this.declarations.add(data);
                this.addToNameHashtable(data);
                if (data.getXMIOwner() == null) {
                    if (this.topLevel == null) {
                        this.topLevel = new ArrayList();
                    }
                    this.topLevel.add(data);
                }
                if (!(data instanceof XMIClass)) break block6;
                XMIClass xMIClass = (XMIClass)data;
                Iterator iterator = xMIClass.getXMIProperties().iterator();
                while (iterator.hasNext()) {
                    this.addToNameHashtable((Data)iterator.next());
                }
                Iterator iterator2 = xMIClass.getXMILinks().iterator();
                while (iterator2.hasNext()) {
                    this.addToNameHashtable((Data)iterator2.next());
                }
                break block7;
            }
            if (!(data instanceof Package)) break block7;
            Package package_ = (Package)data;
            Iterator iterator = package_.getXMIContents().iterator();
            while (iterator.hasNext()) {
                this.add((Data)iterator.next());
            }
        }
    }

    private void addToNameHashtable(Data data) {
        Namespace namespace = data.getXMINamespace();
        if (namespace == null) {
            namespace = noNamespace;
        }
        if (this.namespaces == null) {
            this.namespaces = new HashSet();
        }
        if (!this.namespaces.contains(namespace)) {
            this.namespaces.add(namespace);
            if (this.namespaceToName == null) {
                this.namespaceToName = new HashMap();
            }
            if (this.namespaceToName.get(namespace) == null) {
                this.namespaceToName.put(namespace, new HashMap());
            }
        }
        HashMap hashMap = (HashMap)this.namespaceToName.get(namespace);
        if (data.getXMIName() != null) {
            String string = data.getXMIName();
            int n = string.indexOf(":");
            if (n > 0) {
                string = string.substring(n + 1);
            }
            if (hashMap.get(string) == null) {
                hashMap.put(string, new ArrayList(5));
            }
            ArrayList arrayList = (ArrayList)hashMap.get(string);
            arrayList.add(data);
        }
    }

    public void delete(Data data) throws XMIException {
        if (this.declarations == null) {
            return;
        }
        this.declarations.remove(data);
    }

    private Object[] getAllSuperclasses(Data data) {
        Object[] objectArray;
        if (this.superclasses == null) {
            this.superclasses = new HashMap();
        }
        if ((objectArray = (Object[])this.superclasses.get(data)) != null) {
            return objectArray;
        }
        objectArray = this.wrapper.getAllSuperclasses(data).toArray();
        this.superclasses.put(data, objectArray);
        return objectArray;
    }

    public Data getDeclaration(int n, String string) {
        return this.getDeclaration(noNamespace, n, string, false);
    }

    public Data getDeclaration(Data data, String string) {
        return this.getDeclaration(noNamespace, data, string, false);
    }

    public Data getDeclaration(Namespace namespace, int n, String string, boolean bl) {
        HashMap hashMap;
        if (this.namespaceToName == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        if (namespace == null) {
            namespace = noNamespace;
        }
        if ((hashMap = (HashMap)this.namespaceToName.get(namespace)) == null && !bl) {
            return null;
        }
        if (!bl) {
            return this.getDeclaration(hashMap, namespace, n, string, bl);
        }
        Iterator iterator = this.namespaceToName.values().iterator();
        while (iterator.hasNext()) {
            HashMap hashMap2 = (HashMap)iterator.next();
            Data data = this.getDeclaration(hashMap2, namespace, n, string, bl);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    public Data getDeclaration(Namespace namespace, Data data, String string, boolean bl) {
        HashMap hashMap;
        if (this.namespaceToName == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        if (namespace == null) {
            namespace = noNamespace;
        }
        if ((hashMap = (HashMap)this.namespaceToName.get(namespace)) == null && !bl) {
            return null;
        }
        if (!bl) {
            return this.getDeclaration(hashMap, data, string);
        }
        Iterator iterator = this.namespaceToName.values().iterator();
        while (iterator.hasNext()) {
            HashMap hashMap2 = (HashMap)iterator.next();
            Data data2 = this.getDeclaration(hashMap2, data, string);
            if (data2 == null) continue;
            return data2;
        }
        return null;
    }

    public Data getDeclaration(Namespace namespace, String string, boolean bl) {
        HashMap hashMap;
        if (this.namespaceToName == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        if (namespace == null) {
            namespace = noNamespace;
        }
        if ((hashMap = (HashMap)this.namespaceToName.get(namespace)) == null && !bl) {
            return null;
        }
        if (!bl) {
            return this.getDeclaration(hashMap, namespace, string, bl);
        }
        Iterator iterator = this.namespaceToName.values().iterator();
        while (iterator.hasNext()) {
            HashMap hashMap2 = (HashMap)iterator.next();
            Data data = this.getDeclaration(hashMap2, namespace, string, bl);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    public Data getDeclaration(String string) {
        return this.getDeclaration(noNamespace, string, false);
    }

    private Data getDeclaration(HashMap hashMap, Data data, String string) {
        ArrayList arrayList = (ArrayList)hashMap.get(string);
        if (arrayList == null && data == null) {
            return null;
        }
        if (data == null) {
            return (Data)arrayList.iterator().next();
        }
        HashSet<Object> hashSet = new HashSet<Object>(5);
        hashSet.add(data);
        ArrayList<HashMap> arrayList2 = new ArrayList<HashMap>(5);
        arrayList2.add(hashMap);
        if (data instanceof XMIClass) {
            Object[] objectArray = this.getAllSuperclasses(data);
            for (int i = 0; i < objectArray.length; ++i) {
                HashMap hashMap2;
                XMIClass xMIClass = (XMIClass)objectArray[i];
                Namespace namespace = xMIClass.getXMINamespace();
                if (namespace == null) {
                    namespace = noNamespace;
                }
                if (!arrayList2.contains(hashMap2 = (HashMap)this.namespaceToName.get(namespace))) {
                    arrayList2.add(hashMap2);
                }
                hashSet.add(objectArray[i]);
            }
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            HashMap hashMap3 = (HashMap)arrayList2.get(i);
            arrayList = (ArrayList)hashMap3.get(string);
            if (arrayList == null) continue;
            for (int j = 0; j < arrayList.size(); ++j) {
                if (!hashSet.contains(((Data)arrayList.get(j)).getXMIOwner())) continue;
                return (Data)arrayList.get(j);
            }
        }
        return null;
    }

    private Data getDeclaration(HashMap hashMap, Namespace namespace, int n, String string, boolean bl) {
        Object object;
        ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(string);
        int n2 = string.lastIndexOf(".");
        if (arrayList == null && n2 == -1) {
            return null;
        }
        if (arrayList == null && (object = this.getDeclaration(namespace, string, bl)) != null) {
            arrayList = new ArrayList<Object>(1);
            arrayList.add(object);
        }
        if (arrayList == null) {
            return null;
        }
        object = AdapterFactoryRegister.getAdapterFactory().createWriterAdapter();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (object.getType(arrayList.get(i)) != n) continue;
            return (Data)arrayList.get(i);
        }
        return null;
    }

    private Data getDeclaration(HashMap hashMap, Namespace namespace, String string, boolean bl) {
        ArrayList arrayList = (ArrayList)hashMap.get(string);
        if (arrayList != null) {
            return (Data)arrayList.iterator().next();
        }
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return null;
        }
        Collection collection = this.getDeclarations(namespace, string.substring(n + 1));
        if (collection != null && collection.size() == 1) {
            return (Data)collection.iterator().next();
        }
        Data data = this.getDeclaration(namespace, string.substring(0, n), bl);
        if (data == null) {
            return null;
        }
        return this.getDeclaration(namespace, data, string.substring(n + 1), bl);
    }

    public Collection getDeclarations() {
        if (this.declarations == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.declarations);
    }

    public Collection getDeclarations(Namespace namespace, String string) {
        HashMap hashMap;
        if (string == null) {
            return null;
        }
        if (this.namespaceToName == null) {
            return null;
        }
        if (namespace == null) {
            namespace = noNamespace;
        }
        if ((hashMap = (HashMap)this.namespaceToName.get(namespace)) == null) {
            return null;
        }
        ArrayList arrayList = (ArrayList)hashMap.get(string);
        if (arrayList == null) {
            return null;
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public Collection getDeclarations(String string) {
        return this.getDeclarations(noNamespace, string);
    }

    public String getFile() {
        return this.file;
    }

    public Collection getNamespaces() {
        return this.namespaces;
    }

    public Collection getTopLevel() {
        if (this.topLevel == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.topLevel);
    }

    public String getURI() {
        return this.uri;
    }

    public String getVersion() {
        return this.version;
    }

    public String getXMIName() {
        return this.name;
    }

    private String printClass(XMIClass xMIClass, String string) {
        Object object;
        String string2 = string + xMIClass.toString() + "\n";
        Iterator iterator = xMIClass.getXMIProperties().iterator();
        if (iterator.hasNext()) {
            string2 = string2 + string + "  Properties:\n";
        }
        while (iterator.hasNext()) {
            object = iterator.next();
            string2 = string2 + string + "    " + object + "\n";
            if (((Property)object).getXMIType() != 6) continue;
            string2 = string2 + string + "      " + ((EnumProperty)object).getXMIEnum() + "\n";
        }
        object = xMIClass.getXMILinks().iterator();
        if (object.hasNext()) {
            string2 = string2 + string + "  Links:\n";
        }
        while (object.hasNext()) {
            string2 = string2 + string + "    " + object.next() + "\n";
        }
        Iterator iterator2 = xMIClass.getXMISuperclasses().iterator();
        if (iterator2.hasNext()) {
            string2 = string2 + string + "  Superclasses:\n";
        }
        while (iterator2.hasNext()) {
            string2 = string2 + string + "    " + iterator2.next() + "\n";
        }
        Iterator iterator3 = xMIClass.getXMISubclasses().iterator();
        if (iterator3.hasNext()) {
            string2 = string2 + string + "  Subclasses:\n";
        }
        while (iterator3.hasNext()) {
            string2 = string2 + string + "    " + iterator3.next() + "\n";
        }
        return string2;
    }

    private String printPackage(Package package_, String string) {
        String string2 = string + package_;
        if (package_.getXMIOwner() != null) {
            string2 = string2 + " owner: [" + package_.getXMIOwner() + "]";
        }
        string2 = string2 + "\n";
        Iterator iterator = package_.getXMIContents().iterator();
        if (iterator.hasNext()) {
            string2 = string2 + string + "  Contents:\n";
        }
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof XMIClass) {
                string2 = string2 + this.printClass((XMIClass)e, string + "    ");
                continue;
            }
            if (e instanceof Package) {
                string2 = string2 + this.printPackage((Package)e, string + "    ");
                continue;
            }
            string2 = string2 + string + "    " + e + "\n";
        }
        return string2;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setURI(String string) {
        this.uri = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String toString() {
        String string = "Model: \n";
        string = string + "name: " + this.getXMIName() + " version: " + this.getVersion() + " file: " + this.getFile() + "\n";
        if (this.topLevel == null) {
            return "empty";
        }
        for (int i = 0; i < this.topLevel.size(); ++i) {
            string = this.topLevel.get(i) instanceof XMIClass ? string + this.printClass((XMIClass)this.topLevel.get(i), "") : (this.topLevel.get(i) instanceof Package ? string + this.printPackage((Package)this.topLevel.get(i), "") : string + this.topLevel.get(i) + "\n");
        }
        return string;
    }
}

